/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.utils;

import io.inversion.utils.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamBuffer
extends OutputStream {
    String contentType = null;
    long bufferSize = 262144L;
    ByteArrayOutputStream memOut = new ByteArrayOutputStream();
    BufferedOutputStream fileOut = null;
    int length = 0;
    File tempFile = null;
    boolean closed = false;
    byte[] bytes = null;

    public StreamBuffer() {
    }

    public StreamBuffer(InputStream in) {
        try {
            Utils.pipe(new BufferedInputStream(in), this);
        }
        catch (Exception ex) {
            throw Utils.ex("Error buffering stream", new Object[0]);
        }
    }

    OutputStream getOut(int toWrite) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        this.length += toWrite;
        if (this.fileOut != null) {
            return this.fileOut;
        }
        if ((long)this.length >= this.bufferSize) {
            this.tempFile = File.createTempFile(this.getClass().getSimpleName() + "-" + System.currentTimeMillis(), ".tmp");
            this.tempFile.deleteOnExit();
            this.fileOut = new BufferedOutputStream(new FileOutputStream(this.tempFile));
            if (this.memOut != null) {
                this.memOut.flush();
                this.memOut.close();
                byte[] bytes = this.memOut.toByteArray();
                this.memOut = null;
                Utils.pipe(new ByteArrayInputStream(bytes), this.fileOut, true, false);
            }
            return this.fileOut;
        }
        return this.memOut;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.getOut(b.length).write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.getOut(len).write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.getOut(1).write(b);
    }

    @Override
    public void flush() throws IOException {
        this.getOut(0).flush();
    }

    @Override
    public void close() throws IOException {
        OutputStream out = this.getOut(0);
        out.flush();
        out.close();
        this.closed = true;
    }

    public InputStream getInputStream() throws IOException {
        this.closed = true;
        if (this.memOut != null) {
            try {
                this.memOut.flush();
                this.memOut.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.bytes = this.memOut.toByteArray();
            this.memOut = null;
        }
        if (this.bytes != null) {
            return new ByteArrayInputStream(this.bytes);
        }
        if (this.fileOut != null) {
            try {
                this.fileOut.flush();
                this.fileOut.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fileOut = null;
        }
        if (this.tempFile != null) {
            FileInputStream in = new FileInputStream(this.tempFile){
                StreamBuffer referenceHolder;
                {
                    this.referenceHolder = StreamBuffer.this;
                }
            };
            return in;
        }
        throw new IOException("InputStream has already been retrieved");
    }

    public void finalize() throws Throwable {
        try {
            this.tempFile.delete();
        }
        catch (Exception exception) {
        }
        finally {
            this.tempFile = null;
        }
        super.finalize();
    }

    public String getContentType() {
        return this.contentType;
    }

    public StreamBuffer withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public int getLength() {
        return this.length;
    }

    public long getBufferSize() {
        return this.bufferSize;
    }

    public StreamBuffer withBufferSize(long bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public File getTempFile() {
        return this.tempFile;
    }

    public String toString() {
        return "StreamBuffer[" + this.length + "]";
    }
}

