/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.utils;

import io.inversion.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class Path
implements Comparable<Path> {
    List<String> parts = new ArrayList<String>();
    List<String> lc = new ArrayList<String>();

    public String getTemplate() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            Object part = this.get(i).toLowerCase();
            if (this.isVar(i)) {
                part = "{}";
                String regex = this.getRegex(i);
                if (regex != null) {
                    part = "{" + regex + "}";
                }
            }
            if (b.length() > 0) {
                b.append("/");
            }
            b.append((String)part);
        }
        return b.toString();
    }

    public Path() {
    }

    public Path(Path path) {
        this.copyFrom(path);
    }

    public Path(String ... part) {
        for (String s : part) {
            this.add(s);
        }
    }

    public Path(List<String> parts) {
        this(parts.toArray(new String[0]));
    }

    public static List<Path> expandOptionals(List<Path> paths) {
        ArrayList<Path> allPaths = new ArrayList<Path>();
        for (Path path : paths) {
            allPaths.addAll(path.getSubPaths());
        }
        return allPaths;
    }

    public static List<Path> filterDuplicates(List<Path> paths) {
        ArrayList<Path> allPaths = new ArrayList<Path>();
        for (Path path : paths) {
            allPaths.addAll(path.getSubPaths());
        }
        for (int i = 0; i < allPaths.size(); ++i) {
            for (int j = i + 1; j < allPaths.size(); ++j) {
                Path p1 = (Path)allPaths.get(i);
                Path p2 = (Path)allPaths.get(j);
                if (p1.size() != p2.size()) continue;
                boolean same = true;
                for (int k = 0; same && k < p1.size(); ++k) {
                    String part2;
                    String part1;
                    if (p1.isVar(k) && p2.isVar(k) || p1.isWildcard(k) && p2.isWildcard(k) || (part1 = p1.get(k)).equalsIgnoreCase(part2 = p2.get(k))) continue;
                    same = false;
                }
                if (!same) continue;
                allPaths.remove(j);
                --j;
            }
        }
        return allPaths;
    }

    public static List<Path> materializeTrivialRegexes(List<Path> paths) {
        ArrayList<Path> fixed = new ArrayList<Path>();
        for (int j = 0; j < paths.size(); ++j) {
            Path p = paths.get(j);
            boolean swapped = false;
            for (int i = 0; i < p.size(); ++i) {
                String regex = p.getRegex(i);
                if (regex == null) continue;
                boolean allSimple = true;
                List<String> parts = Utils.split(regex, '|', new char[0]);
                for (String s : parts) {
                    if (!Utils.isRegex(s)) continue;
                    allSimple = false;
                    break;
                }
                if (allSimple) {
                    swapped = true;
                    paths.remove(j);
                    --j;
                    ArrayList<Path> updated = new ArrayList<Path>();
                    for (String part : parts) {
                        Path copy = p.copy();
                        copy.set(i, part);
                        updated.add(copy);
                    }
                    paths.addAll(j + 1, updated);
                    break;
                }
                p.set(i, p.getVarName(i));
            }
            if (swapped) continue;
            fixed.add(p);
        }
        return fixed;
    }

    public Path copyFrom(Path path) {
        if (path == null) {
            return this;
        }
        this.parts.clear();
        this.lc.clear();
        this.parts.addAll(path.parts);
        this.lc.addAll(path.lc);
        return this;
    }

    public Path copy() {
        Path copy = new Path();
        copy.parts.addAll(this.parts);
        copy.lc.addAll(this.lc);
        return copy;
    }

    public List<String> parts() {
        return new ArrayList<String>(this.parts);
    }

    public String first() {
        if (this.parts.size() > 0) {
            return this.parts.get(0);
        }
        return null;
    }

    public String last() {
        if (this.parts.size() > 0) {
            return this.parts.get(this.parts.size() - 1);
        }
        return null;
    }

    public String get(int index) {
        if (index < this.parts.size()) {
            return this.parts.get(index);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Path add(String parts) {
        String debug;
        String string = debug = this.size() == 0 ? parts : Utils.implode("/", this.toString(), parts);
        if (!Utils.empty(parts)) {
            for (String string2 : Utils.explode("/", parts)) {
                void var4_4;
                void var4_13;
                boolean isRegx;
                String string3;
                void var4_10;
                boolean isOptional = string2.startsWith("[");
                if (isOptional) {
                    void var4_8;
                    String string4 = string2.substring(1);
                    if (string4.endsWith("]")) {
                        String string5 = string4.substring(0, string4.length() - 1);
                    }
                    String string6 = var4_8.trim();
                }
                if ("*".equals(var4_10) && this.endsWithWildcard()) continue;
                if (var4_10.startsWith(":") || var4_10.startsWith("$")) {
                    throw Utils.ex("A path part may not start with a ':' or '$'.", new Object[0]);
                }
                boolean isVar = var4_10.startsWith("{");
                if (isVar && (string3 = var4_10.substring(1)).endsWith("}")) {
                    String string7 = string3.substring(0, string3.length() - 1);
                }
                boolean bl = isRegx = isVar && var4_13.contains(":");
                if (isRegx) {
                    String name = var4_13.substring(0, var4_13.indexOf(":"));
                    String regex = var4_13.substring(var4_13.indexOf(":"));
                    if (name.contains("[") || name.contains("{") || name.contains("]") || name.contains("}")) {
                        throw Utils.ex("Invalid path segment '{}'.", parts);
                    }
                }
                if (isVar) {
                    String string8 = "{" + (String)var4_13 + "}";
                }
                if (isOptional) {
                    void var4_15;
                    String string9 = "[" + (String)var4_15 + "]";
                }
                if (this.size() > 0 && this.isWildcard(this.size() - 1)) {
                    throw Utils.ex("Invalid path '{}'.  Wildcards can only be used as the last segment in a path.", debug);
                }
                this.parts.add((String)var4_4);
                this.lc.add(var4_4.toLowerCase());
            }
        }
        return this;
    }

    public Path set(int index, String part) {
        this.parts.set(index, part);
        this.lc.set(index, part.toLowerCase());
        return this;
    }

    public Path chop() {
        if (this.size() > 0) {
            return this.subpath(0, this.size() - 1);
        }
        return this;
    }

    public String remove(int index) {
        if (index < this.parts.size()) {
            this.lc.remove(index);
            return this.parts.remove(index);
        }
        return null;
    }

    public Path removeLast() {
        this.remove(this.size() - 1);
        return this;
    }

    public boolean removeTrailingWildcard() {
        if (this.size() > 0 && this.isWildcard(this.size() - 1)) {
            this.remove(this.size() - 1);
            return true;
        }
        return false;
    }

    public boolean endsWithWildcard() {
        return this.size() > 0 && this.isWildcard(this.size() - 1);
    }

    public boolean startsWith(List<String> partsToMatch) {
        if (partsToMatch.size() > this.parts.size()) {
            return false;
        }
        for (int i = 0; i < partsToMatch.size(); ++i) {
            if (partsToMatch.get(i).equalsIgnoreCase(this.parts.get(i))) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.parts.size();
    }

    public String toString() {
        return Utils.implode("/", this.parts);
    }

    public int hashCode() {
        return this.toString().toLowerCase().hashCode();
    }

    @Override
    public int compareTo(Path o) {
        if (o == null) {
            return 1;
        }
        return this.toString().toLowerCase().compareTo(o.toString().toLowerCase());
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Path)) {
            return false;
        }
        return this.toString().equalsIgnoreCase(o.toString());
    }

    public static String unwrapOptional(String part) {
        while (part.startsWith("[")) {
            part = part.substring(1);
        }
        while (part.endsWith("]")) {
            part = part.substring(0, part.length() - 1);
        }
        return part;
    }

    public Path subpath(int fromIndex, int toIndex) {
        return new Path(this.parts.subList(fromIndex, toIndex));
    }

    public boolean isStatic(int index) {
        return !this.isWildcard(index) && !this.isVar(index) && !this.isOptional(index);
    }

    public boolean isWildcard(int index) {
        return Path.isWildcard(this.get(index));
    }

    public static boolean isWildcard(String part) {
        return "*".equals(part);
    }

    public boolean isWildcard() {
        return this.size() == 1 && this.endsWithWildcard();
    }

    public boolean isVar(int index) {
        String part = this.get(index);
        return Path.isVar(part);
    }

    public static boolean isVar(String part) {
        if (part != null) {
            char c;
            if (part.startsWith("[")) {
                part = part.substring(1).trim();
            }
            return (c = part.charAt(0)) == '{';
        }
        return false;
    }

    public String getVarName(int index) {
        String part = this.get(index);
        if (part != null) {
            if (part.startsWith("[")) {
                part = part.substring(1, part.length() - 1);
            }
            if (part.startsWith("{")) {
                int colon = part.indexOf(":");
                if (colon > 0) {
                    return part.substring(1, colon).trim();
                }
                return part.substring(1, part.lastIndexOf("}"));
            }
        }
        return null;
    }

    public String getRegex(int index) {
        String part = this.get(index);
        return Path.getRegex(part);
    }

    public static String getRegex(String part) {
        int colon = part.indexOf(":");
        if (colon > 0) {
            return part.substring(colon + 1, part.lastIndexOf("}")).trim();
        }
        return null;
    }

    public boolean isOptional(int index) {
        String part = this.get(index);
        return Path.isOptional(part);
    }

    public static boolean isOptional(String part) {
        if (part != null) {
            return part.startsWith("[") && part.endsWith("]");
        }
        return false;
    }

    public void setOptional(int index, boolean optional) {
        if (index < this.size()) {
            Object part = this.get(index);
            part = Path.unwrapOptional((String)part);
            if (optional) {
                part = "[" + (String)part + "]";
            }
            this.set(index, (String)part);
        }
    }

    public boolean matches(String toMatch) {
        return this.matches(new Path(toMatch));
    }

    public boolean matches(Path toMatch) {
        return this.matches(toMatch, false);
    }

    public boolean matches(Path toMatch, boolean bidirectional) {
        int len = Math.max(this.size(), toMatch.size());
        Path a = this;
        Path b = toMatch;
        boolean aOptional = false;
        boolean bOptional = false;
        for (int i = 0; i < len; ++i) {
            Pattern pattern;
            String value;
            String regex;
            String aVal = a.get(i);
            String bVal = b.get(i);
            if ("*".equals(aVal) || "*".equals(bVal)) {
                return true;
            }
            aOptional = aOptional || aVal != null && aVal.startsWith("[");
            boolean bl = bOptional = bOptional || bVal != null && bVal.startsWith("[");
            if (aVal == null || bVal == null) {
                return aOptional || bOptional;
            }
            if (a.isVar(i) && b.isVar(i)) continue;
            if (a.isVar(i)) {
                regex = a.getRegex(i);
                if (regex == null) continue;
                value = b.get(i);
                value = !value.startsWith("[") ? value : value.substring(1, value.length() - 1);
                pattern = Pattern.compile(regex, 2);
                if (pattern.matcher(value).matches()) continue;
                return false;
            }
            if (bidirectional && b.isVar(i)) {
                regex = b.getRegex(i);
                if (regex == null) continue;
                value = a.get(i);
                value = !value.startsWith("[") ? value : value.substring(1, value.length() - 1);
                pattern = Pattern.compile(regex, 2);
                if (pattern.matcher(value).matches()) continue;
                return false;
            }
            aVal = !aVal.startsWith("[") ? aVal : aVal.substring(1, aVal.length() - 1);
            String string = bVal = !bVal.startsWith("[") ? bVal : bVal.substring(1, bVal.length() - 1);
            if (aVal.equalsIgnoreCase(bVal)) continue;
            return false;
        }
        return true;
    }

    public Path extract(Map params, Path toMatch) {
        return this.extract(params, toMatch, false);
    }

    public Path extract(Map params, Path matchingConcretePath, boolean greedy) {
        int i;
        Path matchedPath = new Path();
        boolean restOptional = false;
        int nextOptional = 0;
        for (i = 0; i < this.size() && matchingConcretePath.size() > 0; ++i) {
            String theirPart;
            boolean partOptional;
            String myPart = this.get(i);
            boolean bl = partOptional = myPart.startsWith("[") && myPart.endsWith("]");
            if (partOptional) {
                restOptional = true;
                myPart = myPart.substring(1, myPart.length() - 1);
            }
            if (myPart.equals("*")) break;
            if (greedy || !restOptional) {
                theirPart = matchingConcretePath.remove(0);
                matchedPath.add(theirPart);
            } else {
                theirPart = matchingConcretePath.get(nextOptional++);
            }
            if (this.isVar(i)) {
                Pattern pattern;
                String name = this.getVarName(i);
                String regex = this.getRegex(i);
                if (regex != null && !(pattern = Pattern.compile(regex, 2)).matcher(theirPart).matches()) {
                    throw Utils.ex("Attempting to extract values from an unmatched path: '{}', '{}'", this, matchingConcretePath.toString());
                }
                params.put(name, theirPart);
                continue;
            }
            if (myPart.equalsIgnoreCase(theirPart)) continue;
            throw Utils.ex("Attempting to extract values from an unmatched path: '{}', '{}'", this, matchingConcretePath.toString());
        }
        while (i < this.size()) {
            String var = this.getVarName(i);
            if (var != null) {
                params.put(var, null);
            }
            ++i;
        }
        return matchedPath;
    }

    public int getVarIndex(String varName) {
        if (varName == null) {
            return -1;
        }
        for (int i = 0; i < this.size(); ++i) {
            String temp = this.getVarName(i);
            if (!varName.equalsIgnoreCase(temp)) continue;
            return i;
        }
        return -1;
    }

    public boolean hasVars() {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.isVar(i)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAllVars(String ... vars) {
        for (int i = 0; i < vars.length; ++i) {
            boolean has = false;
            for (int j = 0; j < this.size(); ++j) {
                if (!vars[i].toString().equalsIgnoreCase(this.getVarName(j))) continue;
                has = true;
                break;
            }
            if (has) continue;
            return false;
        }
        return true;
    }

    public boolean hasAnyVars(String ... vars) {
        for (int i = 0; i < vars.length; ++i) {
            for (int j = 0; j < this.size(); ++j) {
                if (!vars[i].toString().equalsIgnoreCase(this.getVarName(j))) continue;
                return true;
            }
        }
        return false;
    }

    public List<Path> getSubPaths() {
        ArrayList<Path> paths = new ArrayList<Path>();
        Path subpath = new Path();
        for (int i = 0; i < this.size(); ++i) {
            boolean optional = false;
            String part = this.get(i);
            if (part.startsWith("[")) {
                optional = true;
                part = part.substring(1, part.length() - 1);
            }
            if (optional) {
                paths.add(new Path(subpath));
            }
            subpath.add(part);
            if (this.isWildcard(i)) break;
        }
        paths.add(new Path(subpath));
        return paths;
    }
}

