/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.utils;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class LimitInputStream
extends FilterInputStream {
    long left = -1L;
    boolean exact = false;

    public LimitInputStream(InputStream in, long limit, boolean exact) {
        super(in);
        this.left = limit;
    }

    @Override
    public int read() throws IOException {
        int result = this.in.read();
        if (result != -1) {
            --this.left;
        } else if (this.exact && this.left != 0L) {
            throw new IOException("The input stream is less than its expected size, you should have " + this.left + " bytes remaining");
        }
        if (this.left < 0L) {
            throw new IOException("The input stream has exceeded it maximum allowed size");
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.in.read(b, off, len);
        if (result != -1) {
            this.left -= (long)result;
        } else if (this.exact && this.left != 0L) {
            throw new IOException("The input stream is less than its expected size, you should have " + this.left + " bytes remaining");
        }
        if (this.left < 0L) {
            throw new IOException("The input stream has exceeded it maximum allowed size");
        }
        return result;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("Mark not supported");
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.left - n < 0L) {
            throw new IOException("The input stream has exceeded it maximum allowed size");
        }
        long skipped = this.in.skip(n);
        this.left -= skipped;
        return skipped;
    }
}

