/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.context.codec;

import io.inversion.context.codec.ToStringCodec;
import io.inversion.utils.Utils;
import java.lang.reflect.Type;
import org.apache.commons.text.StringEscapeUtils;

public class PrimitiveCodec
extends ToStringCodec {
    public PrimitiveCodec() {
        this.withTypes(String.class, Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class);
    }

    @Override
    public String toString(Object bean) {
        if (bean == null) {
            return "null";
        }
        return StringEscapeUtils.escapeJava((String)bean.toString());
    }

    @Override
    public Object fromString(Type type, String encoded) {
        if ("null".equalsIgnoreCase(encoded.trim())) {
            return null;
        }
        Class clazz = (Class)type;
        if (String.class.isAssignableFrom(clazz)) {
            return StringEscapeUtils.unescapeJava((String)encoded);
        }
        encoded = encoded.trim();
        if (Boolean.TYPE.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz)) {
            return (encoded = encoded.toLowerCase()).equals("true") || encoded.equals("t") || encoded.equals("1");
        }
        if (Byte.TYPE.isAssignableFrom(clazz) || Byte.class.isAssignableFrom(clazz)) {
            return Byte.parseByte(encoded);
        }
        if (Character.TYPE.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz)) {
            if (encoded.length() > 1) {
                throw Utils.ex((String)"You are trying to assign more than one Character to a {} field", (Object[])new Object[]{clazz.getSimpleName()});
            }
            return Character.valueOf(encoded.charAt(0));
        }
        if (Short.TYPE.isAssignableFrom(clazz) || Short.class.isAssignableFrom(clazz)) {
            return Short.parseShort(encoded);
        }
        if (Integer.TYPE.isAssignableFrom(clazz) || Integer.class.isAssignableFrom(clazz)) {
            return Integer.parseInt(encoded);
        }
        if (Long.TYPE.isAssignableFrom(clazz) || Long.class.isAssignableFrom(clazz)) {
            return Long.parseLong(encoded);
        }
        if (Float.TYPE.isAssignableFrom(clazz) || Float.class.isAssignableFrom(clazz)) {
            return Float.valueOf(Float.parseFloat(encoded));
        }
        if (Double.TYPE.isAssignableFrom(clazz) || Double.class.isAssignableFrom(clazz)) {
            return Double.parseDouble(encoded);
        }
        return super.fromString(type, encoded);
    }
}

