/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.context.codec;

import io.inversion.context.Codec;
import io.inversion.context.CodecPath;
import io.inversion.context.Context;
import io.inversion.context.Escaper;
import io.inversion.utils.Utils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MapCodec
implements Codec {
    @Override
    public List<Class> getTypes() {
        return (List)Utils.add(new ArrayList(), (Object[])new Object[]{Map.class});
    }

    @Override
    public String encode(Context context, CodecPath codecPath, LinkedHashMap<String, String> props, Set<Object> encoded) {
        Map map = (Map)codecPath.getBean();
        try {
            for (CodecPath parent = codecPath.getParent(); parent != null; parent = parent.getParent()) {
                if (parent.getBean() != map) continue;
                throw Utils.ex((String)"You have an unsupported circular reference within your map: {}", (Object[])new Object[0]);
            }
            if (codecPath.getType() == null) {
                throw Utils.ex((String)"Unknowable type. You can not encode a Map that is not referenced by a Field.  During decoding, a referencing Field's generic type definition is required to determine the key and value instance types.", (Object[])new Object[0]);
            }
            Type keyType = ((ParameterizedType)codecPath.getType()).getActualTypeArguments()[0];
            Type valueType = ((ParameterizedType)codecPath.getType()).getActualTypeArguments()[1];
            LinkedHashMap<String, String> encodedMap = new LinkedHashMap<String, String>();
            int i = 0;
            for (Object key : map.keySet()) {
                Object value = map.get(key);
                String encodedKey = Escaper.escape(context.getEncoder().encode0(context, new CodecPath(codecPath, keyType, "" + i, key), props, encoded));
                String encodedValue = Escaper.escape(context.getEncoder().encode0(context, new CodecPath(codecPath, valueType, "" + (i + 1), value), props, encoded));
                encodedMap.put(encodedKey, encodedValue);
                i += 2;
            }
            String encodedStr = encodedMap.toString();
            return encodedStr;
        }
        catch (Exception ex) {
            throw new RuntimeException("Error decoding path '" + codecPath + "'", ex);
        }
    }

    @Override
    public Object decode(Context context, Type type, String encoded) {
        try {
            Class rawType = (Class)((ParameterizedType)type).getRawType();
            Type keyType = ((ParameterizedType)type).getActualTypeArguments()[0];
            Type valueType = ((ParameterizedType)type).getActualTypeArguments()[1];
            Map map = (Map)rawType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Map<String, String> encodedMap = MapCodec.parseMap(encoded);
            for (String encodedKey : encodedMap.keySet()) {
                String encodedValue = encodedMap.get(encodedKey);
                Object key = context.getDecoder().decode(context, keyType, encodedKey);
                Object value = context.getDecoder().decode(context, valueType, encodedValue);
                map.put(key, value);
            }
            return map;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Map<String, String> parseMap(String string) {
        if (string.startsWith("{")) {
            string = string.substring(1);
        }
        if (string.endsWith("}")) {
            string = string.substring(0, string.length() - 1);
        }
        List<String> list = Escaper.unescape(string);
        for (int i = 1; i < list.size(); ++i) {
            String part = list.get(i);
            if (!part.startsWith(" ")) continue;
            part = part.substring(1);
            list.set(i, part);
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < list.size() - 1; i += 2) {
            map.put(list.get(i), list.get(i + 1));
        }
        return map;
    }
}

