/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.context;

import io.inversion.context.Context;
import io.inversion.utils.Utils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class Includer {
    Set<String> excludePackages = new LinkedHashSet<String>();
    Set<Field> excludeFields = new LinkedHashSet<Field>();
    Set<Class> excludeClasses = (Set)Utils.add(new LinkedHashSet(), (Object[])new Object[]{Logger.class, Context.class});

    public boolean includeBean(Object bean) {
        return !this.exclude(bean.getClass());
    }

    public boolean includeField(Context context, Field field) {
        if (this.exclude(field)) {
            return false;
        }
        if (context.getCodec(field.getType()) != null) {
            return true;
        }
        Class<?> type = field.getType();
        if (Collection.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type)) {
            Type genericType = field.getGenericType();
            return this.includeType(genericType);
        }
        return true;
    }

    private boolean includeType(Type genericType) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)genericType;
            Type[] types = pt.getActualTypeArguments();
            for (int i = 0; types != null && i < types.length; ++i) {
                if (this.includeType(types[0])) continue;
                return false;
            }
            return true;
        }
        if (genericType instanceof TypeVariable) {
            return true;
        }
        if (genericType instanceof Class) {
            return !this.exclude((Class)genericType);
        }
        Context.log.warn("Unsupported Type " + genericType.getTypeName());
        return false;
    }

    private boolean exclude(Field field) {
        if (field.getName().equals("name")) {
            return true;
        }
        if (field.getName().indexOf("$") > -1) {
            return true;
        }
        if (Modifier.isStatic(field.getModifiers())) {
            return true;
        }
        if (Modifier.isTransient(field.getModifiers())) {
            return true;
        }
        if (Modifier.isPrivate(field.getModifiers())) {
            return true;
        }
        if (this.excludeFields.contains(field)) {
            return true;
        }
        return this.exclude(field.getType());
    }

    private boolean exclude(Class type) {
        boolean exclude = this.excludeClasses.contains(type);
        if (!exclude) {
            String packageName = type.getName();
            if (packageName.lastIndexOf(".") > 0) {
                packageName = packageName.substring(0, packageName.lastIndexOf("."));
            }
            for (String excludedPackage : this.excludePackages) {
                if (!packageName.matches(excludedPackage)) continue;
                exclude = true;
                break;
            }
        }
        return exclude;
    }

    public Includer withExcludePackages(String ... packages) {
        for (int i = 0; packages != null && i < packages.length; ++i) {
            if (packages[i] == null || packages[i].length() <= 0) continue;
            this.excludePackages.add(packages[i]);
        }
        return this;
    }

    public Set<String> getExcludePackages() {
        return new LinkedHashSet<String>(this.excludePackages);
    }

    public void setExcludePackages(Set<String> excludePackages) {
        this.excludePackages.clear();
        if (excludePackages != null) {
            this.excludePackages.addAll(excludePackages);
        }
    }

    public Set<Field> getExcludeFields() {
        return new LinkedHashSet<Field>(this.excludeFields);
    }

    public void setExcludeFields(Set<Field> excludeFields) {
        this.excludeFields.clear();
        if (excludeFields != null) {
            this.excludeFields.addAll(excludeFields);
        }
    }

    public Includer withExcludePackages(Field ... fields) {
        for (int i = 0; fields != null && i < fields.length; ++i) {
            if (fields[i] == null) continue;
            this.excludeFields.add(fields[i]);
        }
        return this;
    }

    public Set<Class> getExcludeClasses() {
        return new LinkedHashSet<Class>(this.excludeClasses);
    }

    public void setExcludeClasses(Set<Class> excludeClasses) {
        this.excludeClasses.clear();
        if (excludeClasses != null) {
            this.excludeClasses.addAll(excludeClasses);
        }
    }

    public Includer withExcludePackages(Class ... classes) {
        for (int i = 0; classes != null && i < classes.length; ++i) {
            if (classes[i] == null) continue;
            this.excludeClasses.add(classes[i]);
        }
        return this;
    }
}

