/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.context.codec;

import io.inversion.context.Codec;
import io.inversion.context.CodecPath;
import io.inversion.context.Context;
import io.inversion.utils.Utils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

public class ToStringCodec
implements Codec {
    List<Class> types = new ArrayList<Class>();

    public ToStringCodec() {
    }

    public ToStringCodec(Class ... classes) {
        this.withTypes(classes);
    }

    public Codec withTypes(Class ... classes) {
        for (int i = 0; classes != null && i < classes.length; ++i) {
            Class clazz = classes[i];
            if (clazz == null || this.types.contains(clazz)) continue;
            this.types.add(clazz);
        }
        return this;
    }

    @Override
    public List<Class> getTypes() {
        return Collections.unmodifiableList(this.types);
    }

    @Override
    public final String encode(Context context, CodecPath path, LinkedHashMap<String, String> props, Set<Object> encoded) {
        return this.toString(path.getBean());
    }

    @Override
    public final Object decode(Context context, Type type, String encoded) {
        return this.fromString(type, encoded);
    }

    public String toString(Object bean) {
        return "" + bean;
    }

    public Object fromString(Type type, String encoded) {
        try {
            Class<?> cl = Class.forName(type.getTypeName());
            Constructor<?> cons = cl.getConstructor(String.class);
            return cons.newInstance(encoded);
        }
        catch (Exception ex) {
            throw Utils.ex((String)"Unable to instantiate/decode type {}", (Object[])new Object[]{type});
        }
    }
}

