/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.context.codec;

import io.inversion.context.Codec;
import io.inversion.context.CodecPath;
import io.inversion.context.Context;
import io.inversion.context.Escaper;
import io.inversion.utils.Utils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class CollectionCodec
implements Codec {
    @Override
    public List<Class> getTypes() {
        return (List)Utils.add(new ArrayList(), (Object[])new Object[]{Collection.class});
    }

    @Override
    public String encode(Context context, CodecPath codecPath, LinkedHashMap<String, String> props, Set<Object> encoded) {
        Collection collection = (Collection)codecPath.getBean();
        for (CodecPath parent = codecPath.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getBean() != collection) continue;
            throw Utils.ex((String)"You have an unsupported circular reference within your collection: {}", (Object[])new Object[0]);
        }
        if (codecPath.getType() == null) {
            throw Utils.ex((String)"Unknowable type. You can not encode a Collection that is not referenced by a Field because the Decoder will not be able to determine the class type during decoding.", (Object[])new Object[0]);
        }
        Type valueType = ((ParameterizedType)codecPath.getType()).getActualTypeArguments()[0];
        ArrayList<String> encodedList = new ArrayList<String>();
        int i = 0;
        for (Object child : collection) {
            String childKey = context.getEncoder().encode0(context, new CodecPath(codecPath, valueType, "" + i, child), props, encoded);
            encodedList.add(Escaper.escape(childKey));
            ++i;
        }
        String encodedStr = ((Object)encodedList).toString();
        return encodedStr;
    }

    @Override
    public Object decode(Context context, Type type, String encoded) {
        try {
            Type subtype = ((ParameterizedType)type).getActualTypeArguments()[0];
            Collection collection = this.instantiateCollection(type);
            for (String part : CollectionCodec.parseList(encoded)) {
                Object value = context.getDecoder().decode(context, subtype, part);
                collection.add(value);
            }
            return collection;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public Collection instantiateCollection(Type type) {
        Class clazz = null;
        clazz = type instanceof ParameterizedType ? (Class)((ParameterizedType)type).getRawType() : (Class)type;
        try {
            return (Collection)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            if (List.class.isAssignableFrom(clazz)) {
                return new ArrayList();
            }
            if (Set.class.isAssignableFrom(clazz)) {
                return new LinkedHashSet();
            }
            throw Utils.ex((String)"Unable to instantiate type: {}", (Object[])new Object[]{type});
        }
    }

    public static List<String> parseList(String string) {
        if (string.startsWith("[")) {
            string = string.substring(1);
        }
        if (string.endsWith("]")) {
            string = string.substring(0, string.length() - 1);
        }
        List<String> list = Escaper.unescape(string);
        for (int i = 1; i < list.size(); ++i) {
            String part = list.get(i);
            if (!part.startsWith(" ")) continue;
            part = part.substring(1);
            list.set(i, part);
        }
        return list;
    }
}

