/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.context;

import io.inversion.context.Codec;
import io.inversion.context.CodecPath;
import io.inversion.context.Context;
import io.inversion.context.Includer;
import io.inversion.context.codec.ToStringCodec;
import io.inversion.utils.Utils;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Encoder {
    static final Logger log = LoggerFactory.getLogger(Encoder.class);
    static MultiKeyMap<Object, String> defaults = new MultiKeyMap();
    protected Includer includer = new Includer();

    public LinkedHashMap<String, String> encode(Context context, Object ... beans) {
        HashSet<Object> encoded = new HashSet<Object>();
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        for (Object bean : beans) {
            this.encode0(context, new CodecPath(null, null, null, bean), props, encoded);
        }
        return props;
    }

    public String encode0(Context context, CodecPath codecPath, LinkedHashMap<String, String> props, Set<Object> encoded) {
        Object bean = codecPath.getBean();
        try {
            if (bean == null) {
                return null;
            }
            if (bean.getClass().isEnum()) {
                String val = bean.toString();
                return val;
            }
            Codec codec = context.getCodec(bean.getClass());
            if (codec != null) {
                return codec.encode(context, codecPath, props, encoded);
            }
            if (encoded.contains(bean)) {
                return context.makeName(bean);
            }
            encoded.add(bean);
            String name = context.makeName(bean);
            props.put(name + ".class", bean.getClass().getName());
            List fields = Utils.getFields(bean.getClass());
            if (!defaults.containsKey(bean.getClass())) {
                Object clean = null;
                try {
                    clean = bean.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    defaults.put(bean.getClass(), (Object)"__none", (Object)"__none");
                }
                if (clean != null) {
                    for (Field field : fields) {
                        Object defaultCodec;
                        if (!this.includer.includeField(context, field)) continue;
                        try {
                            Object defaultValue = field.get(clean);
                            if (defaultValue == null) continue;
                            defaultCodec = context.getCodec(defaultValue.getClass());
                            if (defaultCodec != null && defaultCodec instanceof ToStringCodec) {
                                String encodedDefault = ((ToStringCodec)defaultCodec).toString(defaultValue);
                                defaults.put(bean.getClass(), (Object)field.getName(), (Object)encodedDefault);
                                continue;
                            }
                            if (defaultValue instanceof Map && ((Map)defaultValue).size() == 0) {
                                defaults.put(bean.getClass(), (Object)field.getName(), (Object)"{}");
                                continue;
                            }
                            if (!(defaultValue instanceof Collection) || ((Collection)defaultValue).size() != 0) continue;
                            defaults.put(bean.getClass(), (Object)field.getName(), (Object)"[]");
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            log.error("Unable to determine default value for {}: ", (Object)field, (Object)ex);
                            defaultCodec = field.get(clean);
                        }
                    }
                }
            }
            for (Field field : fields) {
                Object defaultProp;
                Object fieldValue;
                if (!this.includer.includeField(context, field) || (fieldValue = field.get(bean)) == null) continue;
                String fieldKey = name + "." + field.getName();
                String encodedProp = this.encode0(context, new CodecPath(codecPath, field.getGenericType(), field.getName(), fieldValue), props, encoded);
                if (Utils.equal((Object)encodedProp, (Object)(defaultProp = defaults.get(bean.getClass(), (Object)field.getName())))) continue;
                props.put(fieldKey, encodedProp);
            }
            return name;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            log.error("Error encoding bean path: " + codecPath, ex);
            Context.dump("PROPERTIES THROUGH ERROR:", props);
            ex = Utils.getCause((Throwable)ex);
            throw Utils.ex((Throwable)ex, (String)"Error encoding class {}", (Object[])new Object[]{bean.getClass().getName()});
        }
    }

    public Includer getIncluder() {
        return this.includer;
    }

    public void setIncluder(Includer includer) {
        this.includer = includer;
    }
}

