/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.context;

import io.inversion.context.Codec;
import io.inversion.context.Context;
import io.inversion.utils.Utils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Decoder {
    static final Logger log = LoggerFactory.getLogger(Decoder.class);

    public static List<String> sort(Collection<String> keys) {
        ArrayList<String> sorted = new ArrayList<String>(keys);
        sorted.sort((o1, o2) -> {
            int count2;
            int count1 = o1.length() - o1.replace(".", "").length();
            if (count1 != (count2 = o2.length() - o2.replace(".", "").length())) {
                return count1 > count2 ? 1 : -1;
            }
            return o1.compareTo((String)o2);
        });
        return sorted;
    }

    public LinkedHashMap<String, String> decode(Context context, Map<String, String> propsToDecode) {
        try {
            return this.decode0(context, propsToDecode);
        }
        catch (Exception ex) {
            throw Utils.ex((Throwable)ex);
        }
    }

    public Object decode(Context context, Type type, String encoded) {
        Class clazz = type instanceof Class ? (Class)type : (Class)((ParameterizedType)type).getRawType();
        Codec codec = context.getCodec(clazz);
        if (codec != null) {
            return codec.decode(context, type, encoded);
        }
        Object bean = context.getBean(encoded);
        if (bean == null) {
            throw Utils.ex((String)"Unable to find a codec or value for {}", (Object[])new Object[]{encoded});
        }
        return bean;
    }

    LinkedHashMap<String, String> decode0(Context context, Map<String, String> propsToDecode) throws Exception {
        LinkedHashMap<String, String> applied = new LinkedHashMap<String, String>();
        TreeMap<String, String> sortedPropsToDecode = new TreeMap<String, String>(propsToDecode);
        LinkedHashMap loaded = new LinkedHashMap();
        for (String p : propsToDecode.keySet()) {
            String key = p;
            if (!key.endsWith(".class") && !key.endsWith(".className")) continue;
            String name = key.substring(0, key.lastIndexOf("."));
            String cn = propsToDecode.get(key);
            if (context.hasName(name)) {
                throw new RuntimeException("Your configuration declared a class with a name that already exists '{} = {}'");
            }
            try {
                Object obj = Class.forName(cn).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Field nameField = Utils.getField((String)"name", obj.getClass());
                if (nameField != null) {
                    nameField.set(obj, name);
                }
                applied.put(key, cn);
                context.putBean(name, obj);
            }
            catch (Exception ex) {
                System.err.println("Error instantiating class: '" + cn + "'");
                throw new RuntimeException(ex);
            }
            loaded.put(name, new HashMap());
        }
        List<String> beanNames = new ArrayList<String>(context.getNames());
        beanNames = Decoder.sort(beanNames);
        for (String beanName : beanNames) {
            Object bean = context.getBean(beanName);
            List<FieldToSet> propertiesToSet = this.getFieldsToSet(bean, beanName, sortedPropsToDecode);
            for (FieldToSet propToSet : propertiesToSet) {
                Field field = propToSet.getField();
                Class<?> clazz = field.getType();
                Type type = field.getGenericType();
                String strValue = propToSet.getStringVal();
                if (context.getCodec(clazz) != null) {
                    Object value = null;
                    if (strValue != null) {
                        value = context.getCodec(clazz).decode(context, type, strValue);
                    }
                    propToSet.getField().set(bean, value);
                    applied.put(propToSet.getKey(), propToSet.getStringVal());
                    continue;
                }
                if (context.getBean(strValue) != null) {
                    propToSet.getField().set(bean, context.getBean(strValue));
                    applied.put(propToSet.getKey(), propToSet.getStringVal());
                    continue;
                }
                throw Utils.ex((String)"Unable to decode property {}", (Object[])new Object[]{propToSet.getKey()});
            }
        }
        return applied;
    }

    public List<FieldToSet> getFieldsToSet(Object bean, String beanName, TreeMap<String, String> propsToDecode) {
        ArrayList<FieldToSet> propertiesToSet = new ArrayList<FieldToSet>();
        List<String> keys = this.getKeys(beanName, propsToDecode);
        for (String key : keys) {
            Field field;
            if (key.endsWith(".class") || key.endsWith(".className")) continue;
            String strValue = propsToDecode.get(key);
            String fieldName = key.substring(key.lastIndexOf(".") + 1);
            if (strValue != null) {
                strValue = strValue.trim();
            }
            if ("null".equalsIgnoreCase(strValue)) {
                strValue = null;
            }
            if ((field = Utils.getField((String)fieldName, bean.getClass())) == null) {
                log.debug("Skipping unknown bean property: '" + beanName + "." + fieldName + "'");
                continue;
            }
            propertiesToSet.add(new FieldToSet(bean, key, field, strValue));
        }
        return propertiesToSet;
    }

    protected Class getArrayElementClass(Class arrayClass) {
        try {
            String typeStr = arrayClass.toString();
            Class<Serializable> subtype = typeStr.startsWith("class [Z") ? Boolean.TYPE : (typeStr.startsWith("class [B") ? Byte.TYPE : (typeStr.startsWith("class [C") ? Character.TYPE : (typeStr.startsWith("class [I") ? Integer.TYPE : (typeStr.startsWith("class [J") ? Long.TYPE : (typeStr.startsWith("class [F") ? Float.TYPE : (typeStr.startsWith("class [D") ? Double.TYPE : Class.forName(typeStr.substring(typeStr.indexOf("[") + 2, typeStr.indexOf(";")))))))));
            return subtype;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected List<String> getKeys(String beanName, TreeMap<String, String> props) {
        HashSet<String> keys = new HashSet<String>();
        String beanPrefix = beanName + ".";
        Set<String> keySet = props.tailMap(beanPrefix).keySet();
        for (String key : keySet) {
            if (!key.startsWith(beanPrefix)) break;
            if (key.endsWith(".class") || key.endsWith(".className") || keys.contains(beanName)) continue;
            keys.add(key);
        }
        return new ArrayList<String>(keys);
    }

    class FieldToSet {
        Object bean = null;
        String key = null;
        Field field = null;
        String stringVal = null;

        public FieldToSet(Object bean, String key, Field field, String stringVal) {
            this.bean = bean;
            this.key = key;
            this.field = field;
            this.stringVal = stringVal;
        }

        public Object getBean() {
            return this.bean;
        }

        public FieldToSet withBean(Object bean) {
            this.bean = bean;
            return this;
        }

        public String getKey() {
            return this.key;
        }

        public FieldToSet withKey(String key) {
            this.key = key;
            return this;
        }

        public Field getField() {
            return this.field;
        }

        public FieldToSet withField(Field field) {
            this.field = field;
            return this;
        }

        public String getStringVal() {
            return this.stringVal;
        }

        public FieldToSet withStringVal(String strVal) {
            this.stringVal = strVal;
            return this;
        }
    }
}

