/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.context;

import io.inversion.context.Codec;
import io.inversion.context.Decoder;
import io.inversion.context.Encoder;
import io.inversion.context.Listener;
import io.inversion.context.Namer;
import io.inversion.context.codec.CollectionCodec;
import io.inversion.context.codec.MapCodec;
import io.inversion.context.codec.PrimitiveCodec;
import io.inversion.utils.ListMap;
import io.inversion.utils.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Context {
    public static final String[] MASKED_FIELDS = new String[]{"pass", "password", "credentials", "secret", "secretkey"};
    static final Pattern[] MASKED_FIELDS_REGEX = new Pattern[MASKED_FIELDS.length];
    public static final String MASK = "**************";
    static Logger log;
    String nameRegex = "^[a-zA-Z0-9_]*$";
    ListMap<Class, Codec> codecs = new ListMap();
    Encoder encoder = new Encoder();
    Decoder decoder = new Decoder();
    Namer namer = null;
    Map<Class, Codec> codecCache = new HashMap<Class, Codec>();
    IdentityHashMap<Object, String> beansToNames = new IdentityHashMap();
    TreeMap<String, Object> namesToBeans = new TreeMap();
    TreeMap<String, String> properties = new TreeMap();

    public Context() {
        this.withCodec(new PrimitiveCodec());
        this.withCodec(new CollectionCodec());
        this.withCodec(new MapCodec());
    }

    public void clear() {
        this.codecCache.clear();
        this.beansToNames.clear();
        this.namesToBeans.clear();
        this.properties.clear();
    }

    public Set<String> getNames() {
        return new HashSet<String>(this.namesToBeans.keySet());
    }

    public String getName(Object bean) {
        return this.beansToNames.get(bean);
    }

    public boolean hasName(String name) {
        return this.namesToBeans.containsKey(name);
    }

    public Object getBean(String name) {
        return this.namesToBeans.get(name);
    }

    public void putBean(String name, Object bean) {
        this.beansToNames.put(bean, name);
        this.namesToBeans.put(name, bean);
    }

    public <T> List<T> getBeans(Class<T> type) {
        ArrayList<Object> matches = new ArrayList<Object>();
        for (Object bean : this.beansToNames.keySet()) {
            Class<?> beanClass = bean.getClass();
            if (!type.isAssignableFrom(beanClass)) continue;
            matches.add(bean);
        }
        return matches;
    }

    public Context withProperties(Map<String, String> properties) {
        this.properties.putAll(properties);
        return this;
    }

    public Context withProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public Map<String, String> getProperties() {
        return new TreeMap<String, String>((SortedMap<String, String>)this.properties);
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public synchronized LinkedHashMap<String, String> wire(Map<String, String> configuration, Object ... beans) {
        LinkedHashMap<String, String> primaryEncoderProps = this.encode(beans);
        LinkedHashMap<String, String> appliedPrimaryDecoder = this.decode(configuration);
        List<Listener> listeners = this.getBeans(Listener.class);
        listeners.forEach(l -> l.wiringComplete(this));
        return appliedPrimaryDecoder;
    }

    public synchronized LinkedHashMap<String, String> encode(Object ... beans) {
        LinkedHashMap<String, String> primaryEncoderProps = this.encoder.encode(this, beans);
        Context.dump("properties found by encoding initial model", primaryEncoderProps);
        return primaryEncoderProps;
    }

    public synchronized LinkedHashMap<String, String> decode(Map<String, String> configuration) {
        TreeMap<String, String> configProps = this.filterConfigProps(configuration);
        LinkedHashMap<String, String> appliedPrimaryDecoder = this.decoder.decode(this, configProps);
        Context.dump("properties applied in primary decoding", appliedPrimaryDecoder);
        return appliedPrimaryDecoder;
    }

    public String makeName(Object object) {
        try {
            Object n;
            Object name = this.getName(object);
            if (name != null) {
                return name;
            }
            Object object2 = name = this.namer != null ? this.namer.name(this, object) : name;
            if (name == null) {
                Field nameField = null;
                try {
                    nameField = Utils.getField((String)"name", object.getClass());
                }
                catch (Exception ex) {
                    System.err.println("Unable to make name for " + object.getClass());
                    ex.printStackTrace();
                }
                if (nameField != null && (n = nameField.get(object)) != null) {
                    name = n.toString();
                }
            }
            if (name == null) {
                Method getter = null;
                try {
                    getter = Utils.getMethod(object.getClass(), (String)"getName");
                    if (getter != null && getter.getParameterCount() == 0 && (n = getter.invoke(object, new Object[0])) != null) {
                        name = n.toString();
                    }
                }
                catch (Throwable ex) {
                    throw Utils.ex((Throwable)ex, (String)"Unable to determine name for class '{}' with getName method {}", (Object[])new Object[]{object.getClass(), getter});
                }
            }
            if (name == null || ((String)name).trim().length() == 0) {
                String simpleName;
                List<?> ofType = this.getBeans(object.getClass());
                int i = ofType.size();
                do {
                    simpleName = object.getClass().getSimpleName();
                } while (this.namesToBeans.containsKey(name = "_anonymous_" + (simpleName = simpleName.replaceAll("[^A-Za-z0-9]", "_")) + "_" + ++i));
            }
            if (!this.isValidName((String)name) && !this.isValidName((String)(name = ((String)name).replace(" ", "")))) {
                throw Utils.ex((String)"You have an invalid object name in your configuration: '{}'.  Object names must match the regex '{}'", (Object[])new Object[]{name, this.nameRegex});
            }
            if (this.hasName((String)name)) {
                throw Utils.ex((String)"You have an invalid object name in your configuration: '{}'.  Multiple objects have been given the name '{}'.  All object names are required to be unique if they are not null.", (Object[])new Object[]{object.getClass().getName(), name});
            }
            this.putBean((String)name, object);
            return name;
        }
        catch (Exception ex) {
            throw Utils.ex((Throwable)ex);
        }
    }

    public boolean isValidName(String s) {
        return s.matches(this.nameRegex);
    }

    public String getNameRegex() {
        return this.nameRegex;
    }

    public Context withNameRegex(String nameRegex) {
        this.nameRegex = nameRegex;
        return this;
    }

    public Namer getNamer() {
        return this.namer;
    }

    public Context withNamer(Namer namer) {
        this.namer = namer;
        return this;
    }

    public Encoder getEncoder() {
        return this.encoder;
    }

    public Context withEncoder(Encoder encoder) {
        this.encoder = encoder;
        return this;
    }

    public Decoder getDecoder() {
        return this.decoder;
    }

    public Context withDecoder(Decoder decoder) {
        this.decoder = decoder;
        return this;
    }

    public ListMap<Class, Codec> getCodecs() {
        return this.codecs;
    }

    public Context withCodec(Codec codec) {
        if (codec == null) {
            return this;
        }
        this.codecCache.clear();
        for (Class type : codec.getTypes()) {
            this.codecs.put((Object)type, (Object)codec);
        }
        return this;
    }

    public Codec getCodec(Class type) {
        if (Codec.class.isAssignableFrom(type)) {
            try {
                return (Codec)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw Utils.ex((String)"Unable to instantiate class {} as a codec.  You are probably missing a no arg constructor in your class.", (Object[])new Object[]{type});
            }
        }
        Class inType = type;
        Codec codec = this.codecCache.get(type);
        if (codec == null) {
            List matches = this.codecs.get((Object)type);
            if (matches != null && matches.size() > 0) {
                codec = (Codec)matches.get(0);
                this.codecCache.put(inType, codec);
                return codec;
            }
            if (codec == null) {
                for (Class clazz : this.codecs.keySet()) {
                    if (!clazz.isAssignableFrom(inType)) continue;
                    codec = (Codec)this.codecs.get((Object)clazz).get(0);
                    this.codecCache.put(inType, codec);
                    return codec;
                }
            }
            while (type != null && type.getSuperclass() != null && !type.getSuperclass().getName().equals(Object.class.getName())) {
                matches = this.codecs.get((Object)type);
                if (matches != null && matches.size() > 0) {
                    codec = (Codec)matches.get(0);
                    this.codecCache.put(inType, codec);
                    return codec;
                }
                type = type.getSuperclass();
            }
        }
        return codec;
    }

    TreeMap<String, String> filterConfigProps(Map<String, String> configuration) {
        TreeSet<Object> keepPrefixes = new TreeSet<Object>();
        for (String name : this.getNames()) {
            if (name.startsWith("_anonymous_")) continue;
            keepPrefixes.add(name + ".");
        }
        HashMap<String, String> tempConfigProps = new HashMap<String, String>();
        List<String> excludes = Arrays.asList("java.", "javax.");
        for (String key : configuration.keySet()) {
            boolean skip = false;
            if (!key.contains(".")) {
                skip = true;
            }
            if (key.indexOf(".") != key.lastIndexOf(".")) {
                skip = true;
            }
            if (!skip) {
                for (String exclude : excludes) {
                    if (!key.startsWith(exclude)) continue;
                    skip = true;
                    break;
                }
            }
            if (skip) continue;
            if ((key.endsWith(".class") || key.endsWith(".className")) && key.indexOf(".") == key.lastIndexOf(".")) {
                String name = key.substring(0, key.indexOf("."));
                if (!this.isValidName(name)) {
                    skip = true;
                    log.warn("Ignoring configuration property with an invalid name '{}'", (Object)name);
                }
                if (!skip) {
                    keepPrefixes.add(key.substring(0, key.indexOf(".") + 1));
                }
            }
            if (skip) continue;
            tempConfigProps.put(key, configuration.get(key));
        }
        TreeMap<String, String> configProps = new TreeMap<String, String>();
        for (String key : tempConfigProps.keySet()) {
            String prefix = key.substring(0, key.indexOf(".") + 1);
            if (!keepPrefixes.contains(prefix)) continue;
            configProps.put(key, (String)tempConfigProps.get(key));
        }
        Context.dump("all config properties", configProps);
        return configProps;
    }

    public static void dump(String title, Map<String, String> properties) {
        Context.dump(title, properties, null);
    }

    public static void dump(String title, Map<String, String> properties, String outputFilePath) {
        try {
            PrintStream fileOut = null;
            if (outputFilePath != null) {
                File file = new File(outputFilePath);
                fileOut = new PrintStream(new FileOutputStream(file));
            }
            List<String> keys = Decoder.sort(properties.keySet());
            String startTitle = "-- START: " + title + " -";
            Object endTitle = "--";
            while (startTitle.length() < 80) {
                startTitle = startTitle + "-";
            }
            while (((String)endTitle).length() < 80) {
                endTitle = (String)endTitle + "-";
            }
            Context.log("\r\n" + startTitle);
            for (String key : keys) {
                String value = properties.get(key);
                if (fileOut != null) {
                    fileOut.println(key + " = " + value);
                }
                Context.log("   > " + Context.maskOutput(key, value));
            }
            Context.log((String)endTitle + "\r\n");
            if (fileOut != null) {
                fileOut.flush();
                fileOut.close();
            }
        }
        catch (Exception ex) {
            Utils.rethrow((Throwable)ex);
        }
    }

    static void log(String msg) {
        log.debug(msg);
    }

    public static String maskOutput(String key, String value) {
        String field = Utils.substringAfter((String)key, (String)".").toLowerCase();
        for (int i = 0; i < MASKED_FIELDS_REGEX.length; ++i) {
            Matcher m = MASKED_FIELDS_REGEX[i].matcher(field);
            if (!m.find()) continue;
            value = MASK;
            break;
        }
        return key + " = " + value;
    }

    static {
        for (int i = 0; i < MASKED_FIELDS.length; ++i) {
            Context.MASKED_FIELDS_REGEX[i] = Pattern.compile(MASKED_FIELDS[i], 2);
        }
        log = LoggerFactory.getLogger(Context.class);
    }
}

