/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.query;

import io.inversion.ApiException;
import io.inversion.Collection;
import io.inversion.Index;
import io.inversion.Relationship;
import io.inversion.query.Builder;
import io.inversion.query.Query;
import io.inversion.rql.Term;
import io.inversion.utils.Utils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Where<T extends Where, P extends Query>
extends Builder<T, P> {
    final Set<String> existsFunctions = Utils.asSet((Object[])new Object[]{"eq", "nn", "gt", "ge", "lt", "le", "like", "sw", "ew", "in", "w"});
    final Set<String> notExistsFunctions = Utils.asSet((Object[])new Object[]{"ne", "n", "out", "wo", "emp"});
    final Map<String, String> notExistsMap = Utils.asMap((Object[])new Object[]{"ne", "eq", "n", "nn", "out", "in", "wo", "w", "emp", "nemp"});

    public Where(P query) {
        super(query);
        this.withFunctions("_key", "_exists", "_notexists", "and", "or", "not", "eq", "ne", "n", "nn", "like", "sw", "ew", "lt", "le", "gt", "ge", "in", "out", "if", "w", "wo", "emp", "nemp");
    }

    @Override
    protected boolean addTerm(String token, Term term) {
        String function = term.getToken();
        if (!term.isLeaf() && this.functions.contains(function)) {
            List unknownCols = (term = this.transform(term)).stream().filter(this::isInvalidColumn).collect(Collectors.toList());
            if (unknownCols.size() > 0) {
                return true;
            }
            if (term.getParent() == null && term.hasToken(new String[]{"and"})) {
                for (Term t : term.getTerms()) {
                    t.withParent(null);
                    super.addTerm(t.getToken(), t);
                }
            } else {
                super.addTerm(term.getToken(), term);
            }
            return true;
        }
        return super.addTerm(token, term);
    }

    protected boolean isInvalidColumn(Term t) {
        if (t.isLeaf() || !t.getTerm(0).isLeaf()) {
            return false;
        }
        Collection collection = ((Query)this.getParent()).getCollection();
        String function = t.getToken();
        String column = t.getToken(0);
        if (function.equalsIgnoreCase("_key")) {
            return false;
        }
        if (column.indexOf(".") > 0 && collection != null) {
            String relName = Utils.substringBefore((String)column, (String)".");
            Relationship relationship = collection.getRelationship(relName);
            if (relationship != null) {
                collection = relationship.getRelated();
                column = Utils.substringAfter((String)column, (String)".");
            } else {
                return false;
            }
        }
        return this.isInvalidColumn(collection, column);
    }

    protected boolean isInvalidColumn(Collection collection, String column) {
        if (collection == null) {
            return column.startsWith("_") || !column.matches("^[a-zA-Z0-9_]+$");
        }
        return collection.getPropertyByColumnName(column) == null;
    }

    protected Term transform(Term parent) {
        Term transformed = parent;
        for (Term child : parent.getTerms()) {
            if (child.isLeaf()) continue;
            if (!this.functions.contains(child.getToken())) {
                throw ApiException.new400BadRequest("Invalid where function token '{}' : {}", child.getToken(), parent);
            }
            this.transform(child);
        }
        if (!parent.isLeaf() && parent.getTerm(0).isLeaf() && parent.getToken(0).indexOf(".") > 0 && !parent.hasToken(new String[]{"_key"})) {
            String rel = parent.getToken(0);
            rel = rel.substring(0, rel.indexOf("."));
            if (((Query)this.getParent()).getCollection().getRelationship(rel) != null) {
                Term relCol = parent.getTerm(0);
                relCol.withToken("~~relTbl_" + relCol.getToken());
                String token = parent.getToken().toLowerCase();
                if (this.existsFunctions.contains(token)) {
                    transformed = Term.term((Term)parent.getParent(), (String)"_exists", (Object[])new Object[]{parent});
                } else if (this.notExistsFunctions.contains(token)) {
                    parent.withToken(this.notExistsMap.get(token));
                    transformed = Term.term((Term)parent.getParent(), (String)"_notexists", (Object[])new Object[]{parent});
                }
                return transformed;
            }
        }
        if (parent.hasToken(new String[]{"_key"})) {
            String indexName = parent.getToken(0);
            Index index = ((Query)this.getParent()).getCollection().getIndex(indexName);
            if (index == null) {
                throw ApiException.new400BadRequest("You can't use the _key() function unless your table has a unique index", new Object[0]);
            }
            if (index.size() == 1) {
                Term t = Term.term(null, (String)"in", (Object[])new Object[]{index.getProperty(0).getColumnName()});
                List children = parent.getTerms();
                for (int i = 1; i < children.size(); ++i) {
                    Term child = (Term)children.get(i);
                    t.withTerm(child);
                }
                if (t.getNumTerms() == 2) {
                    t.withToken("eq");
                }
                transformed = t;
            } else {
                Term or = Term.term(null, (String)"or", (Object[])new Object[0]);
                List children = parent.getTerms();
                transformed = or;
                for (int i = 1; i < children.size(); ++i) {
                    Term child = (Term)children.get(i);
                    if (!child.isLeaf()) {
                        throw ApiException.new400BadRequest("Resource key value is not a leaf node: {}", child);
                    }
                    Map<String, Object> keyParts = ((Query)this.getParent()).getCollection().decodeKeyToColumnNames(index, child.getToken());
                    Term and = Term.term((Term)or, (String)"and", (Object[])new Object[0]);
                    for (String key : keyParts.keySet()) {
                        and.withTerm(Term.term((Term)and, (String)"eq", (Object[])new Object[]{key, keyParts.get(key).toString()}));
                    }
                }
                if (or.getNumTerms() == 1) {
                    transformed = or.getTerm(0);
                    transformed.withParent(null);
                }
            }
        }
        if (parent.getParent() != null && transformed != parent) {
            parent.getParent().replaceTerm(parent, transformed);
        }
        return transformed;
    }

    public List<Term> getFilters() {
        return this.getTerms();
    }
}

