/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.query;

import io.inversion.rql.Rql;
import io.inversion.rql.Term;
import io.inversion.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Builder<T, P extends Builder> {
    protected final List<Term> terms = new ArrayList<Term>();
    protected final Set<String> functions = new HashSet<String>();
    protected P parent = null;
    protected List<Builder> builders = null;

    public Builder() {
    }

    public Builder(P parent) {
        this.withParent(parent);
    }

    protected boolean addTerm(String token, Term term) {
        for (Builder builder : this.getBuilders()) {
            if (!builder.addTerm(token, term)) continue;
            return true;
        }
        if (this.functions.contains(token)) {
            this.terms.add(term);
            return true;
        }
        return false;
    }

    protected T r() {
        return (T)this;
    }

    public Builder getRoot() {
        Builder<T, P> root = this;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root;
    }

    public P getParent() {
        return this.parent;
    }

    public T withParent(P parent) {
        if (this.parent != parent) {
            if (this.parent != null) {
                ((Builder)this.parent).removeBuilder(this);
            }
            this.parent = parent;
            if (this.parent != null) {
                ((Builder)this.parent).withBuilder(this);
            }
        }
        return this.r();
    }

    public List<Builder> getBuilders() {
        if (this.builders == null) {
            this.builders = new ArrayList<Builder>();
        }
        return this.builders;
    }

    public T withBuilder(Builder builder) {
        if (!this.getBuilders().contains(builder)) {
            this.getBuilders().add(builder);
            builder.withParent(this);
        }
        return this.r();
    }

    public T removeBuilder(Builder builder) {
        this.getBuilders().remove(builder);
        return this.r();
    }

    public T withFunctions(Collection<String> tokens) {
        for (String token : tokens) {
            this.functions.add(token.trim().toLowerCase());
        }
        return this.r();
    }

    public T withFunctions(String ... tokens) {
        for (int i = 0; tokens != null && i < tokens.length; ++i) {
            String token = tokens[i];
            if (Utils.empty((Object[])new Object[]{token})) continue;
            this.functions.add(token.trim().toLowerCase());
        }
        return this.r();
    }

    public boolean isFunction(String token) {
        if (this.functions.contains(token = token.toLowerCase())) {
            return true;
        }
        for (Builder builder : this.getBuilders()) {
            if (!builder.isFunction(token)) continue;
            return true;
        }
        return false;
    }

    public T clearFunctions() {
        this.functions.clear();
        return this.r();
    }

    public T withTerm(String token, Object ... terms) {
        this.withTerm(Term.term(null, (String)token, (Object[])terms));
        return this.r();
    }

    public T withTerm(Term term) {
        String childToken;
        Term child;
        if (this.terms.contains(term)) {
            return this.r();
        }
        if (term.isQuoted()) {
            return this.r();
        }
        String token = term.getToken().toLowerCase();
        if ("eq".equals(token) && (child = term.getTerm(0)) != null && !child.isQuoted() && child.isLeaf() && this.isFunction(child.getToken()) && !"eq".equals(childToken = child.getToken().toLowerCase())) {
            term.withToken(childToken);
            term.removeTerm(child);
            if (this.addTerm(childToken, term)) {
                return this.r();
            }
            term.withToken(token);
            term.withTerm(0, child);
        }
        this.addTerm(token, term);
        return this.r();
    }

    public List<Term> getTerms() {
        return new ArrayList<Term>(this.terms);
    }

    public final T withTerms(Object ... rqlTerms) {
        for (Object term : rqlTerms) {
            if (term instanceof Term) {
                this.withTerm((Term)term);
                continue;
            }
            if (term instanceof Collection) {
                for (Object t : (Collection)term) {
                    this.withTerms(t);
                }
                continue;
            }
            if (term instanceof Map) {
                Map map = (Map)term;
                for (String key : map.keySet()) {
                    if (Utils.empty((Object[])new Object[]{key})) continue;
                    String value = (String)map.get(key);
                    term = Utils.empty((Object[])new Object[]{value}) && key.contains("(") ? key : "eq(" + key + "," + value + ")";
                    this.withTerm((String)term);
                }
                continue;
            }
            this.withTerm(term.toString());
        }
        return this.r();
    }

    public final T withTerm(String rql) {
        List<Term> terms = this.parse(rql);
        for (Term term : terms) {
            this.withTerm(term);
        }
        return this.r();
    }

    protected List<Term> parse(Object ... rqlTerms) {
        ArrayList<Term> terms = new ArrayList<Term>();
        for (Object term : rqlTerms) {
            String[] parts;
            if (Utils.empty((Object[])new Object[]{term})) continue;
            if (term instanceof Term) {
                terms.add((Term)term);
                continue;
            }
            for (String part : parts = term.toString().split("\\&")) {
                if (part == null || part.length() == 0) continue;
                Term parsed = Rql.parse((String)part);
                terms.add(parsed);
            }
        }
        return terms;
    }

    public int findInt(String token, int childToken, int defaultValue) {
        Object found = this.find(token, childToken);
        if (found != null) {
            return Integer.parseInt(found.toString());
        }
        return defaultValue;
    }

    public Object find(String token, int childToken) {
        Term term = this.find(token);
        if (term != null && (term = term.getTerm(childToken)) != null) {
            return term.getToken();
        }
        return null;
    }

    public List<Term> findAll(Collection<String> tokens) {
        ArrayList<Term> found = new ArrayList<Term>();
        for (String token : tokens) {
            this.findAll(token, found);
        }
        return found;
    }

    public List<Term> findAll(String ... tokens) {
        return this.findAll(Arrays.asList(tokens));
    }

    List<Term> findAll(String token, List<Term> found) {
        for (Term term : this.terms) {
            if (!term.hasToken(new String[]{token})) continue;
            found.add(term);
        }
        for (Builder builder : this.getBuilders()) {
            builder.findAll(token, found);
        }
        return found;
    }

    public Term find(String ... tokens) {
        for (Term term : this.terms) {
            Term found = this.find(term, tokens);
            if (found == null) continue;
            return found;
        }
        for (Builder builder : this.getBuilders()) {
            Term term = builder.find(tokens);
            if (term == null) continue;
            return term;
        }
        return null;
    }

    Term find(Term term, String ... tokens) {
        if (term.hasToken(tokens)) {
            return term;
        }
        for (Term child : term.getTerms()) {
            if (!child.hasToken(tokens)) continue;
            return child;
        }
        return null;
    }

    public Term findTerm(String childToken, String ... parentFunctions) {
        if (childToken == null) {
            return null;
        }
        for (Term term : this.getTerms()) {
            if (parentFunctions != null && parentFunctions.length != 0 && !term.hasToken(parentFunctions)) continue;
            for (Term child : term.getTerms()) {
                if (!child.hasToken(new String[]{childToken}) || !child.isLeaf()) continue;
                return term;
            }
        }
        for (Builder builder : this.getBuilders()) {
            Term t = builder.findTerm(childToken, parentFunctions);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public String toString() {
        return this.toString(this.terms);
    }

    protected String toString(List<Term> terms) {
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < terms.size(); ++i) {
            buff.append(terms.get(i));
            if (i >= terms.size() - 1) continue;
            buff.append("&");
        }
        for (Builder builder : this.getBuilders()) {
            String rql = builder.toString();
            if (Utils.empty((Object[])new Object[]{rql})) continue;
            if (buff.length() > 0) {
                buff.append("&");
            }
            buff.append(rql);
        }
        return buff.toString();
    }
}

