/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.action.security;

import io.inversion.Chain;
import io.inversion.Request;
import io.inversion.Rule;
import io.inversion.utils.Utils;
import java.util.ArrayList;

public class AclRule
extends Rule<AclRule> {
    protected final ArrayList<String> permissions = new ArrayList();
    protected final ArrayList<String> roles = new ArrayList();
    protected final ArrayList<String> scopes = new ArrayList();
    protected boolean allow = true;
    protected boolean info = false;
    protected boolean allRolesMustMatch = false;
    protected boolean allPermissionsMustMatch = false;
    protected boolean allScopesMustMatch = false;

    public static AclRule allowAll(String includedOn) {
        AclRule rule = new AclRule();
        rule.withIncludeOn(includedOn);
        return rule;
    }

    public static AclRule requireAllPerms(String permissions, String ... includedOn) {
        AclRule rule = new AclRule();
        rule.withAllPermissionsMustMatch(true);
        rule.withPermissions(permissions);
        rule.withIncludeOn(includedOn);
        return rule;
    }

    public static AclRule requireOnePerm(String permissions, String ... includedOn) {
        AclRule rule = new AclRule();
        rule.withAllPermissionsMustMatch(false);
        rule.withPermissions(permissions);
        rule.withIncludeOn(includedOn);
        return rule;
    }

    public static AclRule requireAllRoles(String roles, String ... includedOn) {
        AclRule rule = new AclRule();
        rule.withAllRolesMustMatch(true);
        rule.withRoles(roles);
        rule.withIncludeOn(includedOn);
        return rule;
    }

    public static AclRule requireOneRole(String roles, String ... includedOn) {
        AclRule rule = new AclRule();
        rule.withAllRolesMustMatch(false);
        rule.withRoles(roles);
        rule.withIncludeOn(includedOn);
        return rule;
    }

    public static AclRule requireAllScopes(String scopes, String ... includedOn) {
        AclRule rule = new AclRule();
        rule.withAllScopesMustMatch(true);
        rule.withScopes(scopes);
        rule.withIncludeOn(includedOn);
        return rule;
    }

    public static AclRule requireOneScope(String scopes, String ... includedOn) {
        AclRule rule = new AclRule();
        rule.withAllScopesMustMatch(false);
        rule.withScopes(scopes);
        rule.withIncludeOn(includedOn);
        return rule;
    }

    public boolean ruleMatches(Request req) {
        boolean matched;
        if (this.match(req.getMethod(), req.getPath()) == null) {
            return false;
        }
        if (Chain.getUser() == null && (this.roles.size() > 0 || this.permissions.size() > 0 || this.scopes.size() > 0)) {
            return false;
        }
        int matches = 0;
        for (String requiredRole : this.roles) {
            matched = Chain.getUser().hasRoles(requiredRole);
            if (matched) {
                ++matches;
                if (this.allRolesMustMatch) continue;
                break;
            }
            if (!this.allRolesMustMatch) continue;
            break;
        }
        for (String requiredPerm : this.permissions) {
            matched = Chain.getUser().hasPermissions(requiredPerm);
            if (matched) {
                ++matches;
                if (this.allPermissionsMustMatch) continue;
                break;
            }
            if (!this.allPermissionsMustMatch) continue;
            break;
        }
        for (String requiredScope : this.scopes) {
            matched = Chain.getUser().hasScope(requiredScope);
            if (matched) {
                ++matches;
                if (this.allScopesMustMatch) continue;
                break;
            }
            if (!this.allScopesMustMatch) continue;
            break;
        }
        boolean hasRoles = this.roles.size() == 0 || this.allRolesMustMatch && matches == this.roles.size() || !this.allRolesMustMatch && matches > 0;
        boolean hasPermissions = this.permissions.size() == 0 || this.allPermissionsMustMatch && matches == this.permissions.size() || !this.allPermissionsMustMatch && matches > 0;
        boolean hasScopes = this.scopes.size() == 0 || this.allScopesMustMatch && matches == this.scopes.size() || !this.allScopesMustMatch && matches > 0;
        return hasRoles || hasPermissions || hasScopes;
    }

    public ArrayList<String> getRoles() {
        return new ArrayList<String>(this.roles);
    }

    public AclRule withRoles(String ... roles) {
        if (roles != null) {
            for (String role : Utils.explode((String)",", (String[])roles)) {
                if (this.roles.contains(role)) continue;
                this.roles.add(role);
            }
        }
        return this;
    }

    public ArrayList<String> getPermissions() {
        return new ArrayList<String>(this.permissions);
    }

    public AclRule withPermissions(String ... permissions) {
        if (permissions != null) {
            for (String permission : Utils.explode((String)",", (String[])permissions)) {
                if (this.permissions.contains(permission)) continue;
                this.permissions.add(permission);
            }
        }
        return this;
    }

    public ArrayList<String> getScopes() {
        return new ArrayList<String>(this.scopes);
    }

    public AclRule withScopes(String ... scopes) {
        if (scopes != null) {
            for (String scope : Utils.explode((String)",", (String[])scopes)) {
                if (this.scopes.contains(scope)) continue;
                this.scopes.add(scope);
            }
        }
        return this;
    }

    public boolean isAllow() {
        return this.allow;
    }

    public AclRule withAllow(boolean allow) {
        this.allow = allow;
        return this;
    }

    public boolean isInfo() {
        return this.info;
    }

    public AclRule withInfo(boolean info) {
        this.info = info;
        return this;
    }

    public boolean isAllRolesMustMatch() {
        return this.allRolesMustMatch;
    }

    public AclRule withAllRolesMustMatch(boolean allRolesMustMatch) {
        this.allRolesMustMatch = allRolesMustMatch;
        return this;
    }

    public boolean isAllPermissionsMustMatch() {
        return this.allPermissionsMustMatch;
    }

    public AclRule withAllPermissionsMustMatch(boolean allPermissionsMustMatch) {
        this.allPermissionsMustMatch = allPermissionsMustMatch;
        return this;
    }

    public boolean isAllScopesMustMatch() {
        return this.allScopesMustMatch;
    }

    public AclRule withAllScopesMustMatch(boolean allScopesMustMatch) {
        this.allScopesMustMatch = allScopesMustMatch;
        return this;
    }
}

