/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.action.hateoas;

import io.inversion.Chain;
import io.inversion.Collection;
import io.inversion.Filter;
import io.inversion.Relationship;
import io.inversion.json.JSMap;
import io.inversion.json.JSNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class HATEOASFilter<T extends HATEOASFilter>
extends Filter<T> {
    public void addLinks(Collection coll, JSMap entityNode) {
        String resourceKey = coll.encodeKeyFromJsonNames((Map<String, Object>)entityNode);
        LinkedHashMap<String, String> toAdd = new LinkedHashMap<String, String>();
        if (coll != null && resourceKey != null) {
            for (Relationship rel : coll.getRelationships()) {
                Object value = entityNode.get((Object)rel.getName());
                if (value instanceof JSNode) {
                    ((JSNode)value).asMapList().forEach(child -> this.addLinks(rel.getRelated(), (JSMap)child));
                    continue;
                }
                String link = null;
                if (rel.isManyToOne()) {
                    Map<String, Object> primaryKey = rel.buildPrimaryKeyFromForeignKey((Map<String, Object>)entityNode);
                    String key = primaryKey == null ? null : Collection.encodeKey(primaryKey, rel.getRelated().getResourceIndex(), true);
                    if (key == null) continue;
                    link = Chain.buildLink(rel.getRelated(), key);
                } else {
                    link = Chain.buildLink(coll, resourceKey, rel.getName());
                }
                toAdd.put(rel.getName(), link);
            }
        }
        if (toAdd.size() > 0) {
            ArrayList keys = new ArrayList(toAdd.keySet());
            Collections.reverse(keys);
            for (String key : keys) {
                this.addLink(entityNode, key, (String)toAdd.get(key));
            }
        }
        String link = Chain.buildLink(coll, resourceKey, null);
        this.addSelfLink(entityNode, link);
    }

    public void addSelfLink(JSMap entityNode, String link) {
        this.addLink(entityNode, "self", link);
    }

    public void addLink(JSMap entityNode, String name, String link) {
        entityNode.putFirst(name, (Object)link);
    }
}

