/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.action.db;

import io.inversion.Action;
import io.inversion.ApiException;
import io.inversion.Chain;
import io.inversion.Change;
import io.inversion.Collection;
import io.inversion.Index;
import io.inversion.Relationship;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.Rule;
import io.inversion.json.JSList;
import io.inversion.json.JSMap;
import io.inversion.json.JSNode;
import io.inversion.json.JSParser;
import io.inversion.rql.Term;
import io.inversion.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.apache.commons.collections4.map.MultiKeyMap;

class DbPostAction<A extends DbPostAction>
extends Action<A> {
    protected boolean collapseAll = false;
    protected boolean strictRest = false;
    protected boolean getResponse = true;

    DbPostAction() {
    }

    @Override
    protected List<Rule.RuleMatcher> getDefaultIncludeMatchers() {
        return Utils.asList((Object[])new Object[]{new Rule.RuleMatcher("POST", "{_collection}")});
    }

    public static String nextPath(String path, String next) {
        return Utils.empty((Object[])new Object[]{path}) ? next : path + "." + next;
    }

    @Override
    public void run(Request req, Response res) throws ApiException {
        if (req.isMethod("PUT", "POST")) {
            this.upsert(req, res);
        } else if (req.isMethod("PATCH")) {
            this.patch(req, res);
        } else {
            throw ApiException.new400BadRequest("Method '%' is not supported by RestPostHandler", new Object[0]);
        }
    }

    public void patch(Request req, Response res) throws ApiException {
        List<String> resourceKeys;
        JSNode body = req.getJson();
        if (body == null) {
            throw ApiException.new400BadRequest("You must pass a JSON body on a {}", req.getMethod());
        }
        if (body.find("meta") instanceof JSNode && body.find("data") instanceof JSList) {
            body = body.findMap("data");
        }
        if (body instanceof JSList && ((JSList)body).size() == 1 && ((JSList)body).get(0) instanceof JSNode) {
            body = ((JSList)body).getNode((Object)0);
        }
        if (body.isList()) {
            if (!Utils.empty((Object[])new Object[]{req.getResourceKey()})) {
                throw ApiException.new400BadRequest("You can't batch '{}' an array of objects to a specific resource url.  You must '{}' them to a collection.", req.getMethod(), req.getMethod());
            }
        } else {
            String href = body.getString((Object)"href");
            if (req.getResourceKey() != null) {
                if (href == null) {
                    body.put((Object)"href", (Object)Utils.substringBefore((String)req.getUrl().toString(), (String)"?"));
                } else if (!req.getUrl().toString().startsWith(href)) {
                    throw ApiException.new400BadRequest("You are PATCHING-ing an resource with a different href property than the resource URL you are PATCHING-ing to.", new Object[0]);
                }
            }
        }
        if ((resourceKeys = req.getCollection().getDb().patch(req.getCollection(), req.getJson().asMapList())).size() == req.getJson().asMapList().size()) {
            res.withStatus("201 Created");
            String location = Chain.buildLink(req.getCollection(), Utils.implode((String)",", (Object[])new Object[]{resourceKeys}));
            res.withHeader("Location", location);
            if (this.isGetResponse()) {
                Response getResponse = req.getChain().getEngine().service("GET", location);
                res.getJson().put((Object)"data", (Object)getResponse.data());
            }
        } else {
            throw ApiException.new404NotFound("One or more of the requested resource could not be found.", new Object[0]);
        }
    }

    public void upsert(Request req, Response res) throws ApiException {
        List<String> resourceKeys;
        HashSet collapses;
        if (this.strictRest) {
            if (req.isPost() && req.getResourceKey() != null) {
                throw ApiException.new404NotFound("You are trying to POST to a specific resource url.  Set 'strictRest' to false to interpret PUT vs POST intention based on presense of 'href' property in passed in JSON", new Object[0]);
            }
            if (req.isPut() && req.getResourceKey() == null) {
                throw ApiException.new404NotFound("You are trying to PUT to a collection url.  Set 'strictRest' to false to interpret PUT vs POST intention based on presense of 'href' property in passed in JSON", new Object[0]);
            }
        }
        Collection collection = req.getCollection();
        ArrayList<Change> changes = new ArrayList<Change>();
        JSNode body = req.getJson();
        this.swapRefsWithActualReferences(body);
        JSList bodyArr = body.asList();
        HashMap<Collection, Map<String, JSNode>> visited = new HashMap<Collection, Map<String, JSNode>>();
        for (int i = 0; i < bodyArr.size(); ++i) {
            this.swapLogicalDuplicateReferences(collection, (JSNode)bodyArr.get(i), (JSNode)bodyArr, i + "0", visited);
        }
        if (body.find("meta") instanceof JSNode && body.find("data") instanceof JSList) {
            body = body.findNode("data");
        }
        if (body instanceof JSList && ((JSList)body).size() == 1 && ((JSList)body).get(0) instanceof JSNode) {
            body = ((JSList)body).getNode((Object)0);
        }
        boolean collapseAll = "true".equalsIgnoreCase(req.getUrl().getParam("collapseAll"));
        String collapseStr = req.getUrl().getParam("collapse");
        HashSet hashSet = collapses = collapseStr == null ? new HashSet() : Utils.asSet((Object[])new Object[]{Utils.explode((String)",", (String[])new String[]{collapseStr})});
        if (collapseAll || collapses.size() > 0) {
            body = JSParser.asJSNode((String)body.toString());
            DbPostAction.collapse(body, collapseAll, collapses, "");
        }
        if (body instanceof JSList) {
            if (!Utils.empty((Object[])new Object[]{req.getResourceKey()})) {
                throw ApiException.new400BadRequest("You can't batch '{}' an array of objects to a specific resource url.  You must '{}' them to a collection.", req.getMethod(), req.getMethod());
            }
            resourceKeys = this.upsert(req, collection, (JSList)body);
        } else {
            String href = body.getString((Object)"href");
            if (req.isPut() && href != null && req.getResourceKey() != null && !req.getUrl().toString().startsWith(href)) {
                throw ApiException.new400BadRequest("You are PUT-ing an resource with a different href property than the resource URL you are PUT-ing to.", new Object[0]);
            }
            resourceKeys = this.upsert(req, collection, new JSList(new Object[]{body}));
        }
        res.withChanges(changes);
        StringBuilder buff = new StringBuilder();
        for (String key : resourceKeys) {
            String resourceKey = key;
            String href = Chain.buildLink(collection, resourceKey);
            if (href == null) continue;
            res.data().add((Object)new JSMap(new Object[]{"href", href}));
            String nextId = href.substring(href.lastIndexOf("/") + 1);
            buff.append(",").append(nextId);
        }
        if (buff.length() > 0) {
            res.withStatus("201 Created");
            String location = Chain.buildLink(collection, buff.substring(1, buff.length()));
            res.withHeader("Location", location);
            if (this.isGetResponse()) {
                Response getResponse = req.getChain().getEngine().service("GET", location);
                if (getResponse.isSuccess()) {
                    res.getJson().put((Object)"data", (Object)getResponse.data());
                } else {
                    getResponse.getJson();
                    res.withBody(getResponse.getBody());
                    res.withStatus(getResponse.getStatus());
                    res.withError(getResponse.getError());
                }
            }
        } else {
            res.withStatus("204 No Content");
        }
    }

    protected List<String> upsert(Request req, Collection collection, JSList nodes) {
        Map<String, Object> foreignKey;
        List<String> returnList = collection.getDb().upsert(collection, (List<Map<String, Object>>)nodes);
        for (int i = 0; i < nodes.size(); ++i) {
            JSMap node = (JSMap)nodes.get(i);
            Map<String, Object> row = collection.decodeKeyToJsonNames(returnList.get(i));
            for (String string : row.keySet()) {
                node.put(string, row.get(string));
            }
            for (Relationship relationship : collection.getRelationships()) {
                if (!relationship.isOneToMany() || !(node.get((Object)relationship.getName()) instanceof JSList)) continue;
                foreignKey = relationship.getInverse().buildForeignKeyFromPrimaryKey((Map<String, Object>)node);
                node.getList((Object)relationship.getName()).asMapList().forEach(child -> child.putAll(foreignKey));
            }
        }
        for (Relationship rel : collection.getRelationships()) {
            Relationship inverse = rel.getInverse();
            Iterator childMap = new LinkedHashMap();
            for (JSNode node : nodes.asMapList()) {
                Object value = node.get((Object)rel.getName());
                if (value instanceof JSNode) {
                    for (JSMap child2 : ((JSNode)value).asMapList()) {
                        String resourceKey = rel.getRelated().encodeKeyFromJsonNames((Map<String, Object>)child2);
                        Object hashKey = resourceKey != null ? resourceKey : "_child:" + ((HashMap)((Object)childMap)).size();
                        if (((HashMap)((Object)childMap)).containsKey(hashKey)) continue;
                        ((HashMap)((Object)childMap)).put(hashKey, child2);
                    }
                }
                if (((HashMap)((Object)childMap)).size() <= 0) continue;
                String path = Chain.buildLink(rel.getRelated());
                JSList childArr = new JSList(new Object[0]);
                for (String key : ((LinkedHashMap)((Object)childMap)).keySet()) {
                    childArr.add(((LinkedHashMap)((Object)childMap)).get(key));
                }
                Response res = req.getEngine().post(path, (JSNode)childArr);
                if (!res.isSuccess()) {
                    res.rethrow();
                }
                if (res.data().size() != ((HashMap)((Object)childMap)).size()) {
                    throw new ApiException("Can not determine if all children submitted were updated.  Request size = {}.  Response size = {}", ((HashMap)((Object)childMap)).size(), res.data().size());
                }
                int i = -1;
                HashMap<String, JSMap> updatedKeys = new HashMap<String, JSMap>();
                HashMap<JSMap, String> updatedNodes = new HashMap<JSMap, String>();
                for (Object childKey : ((LinkedHashMap)((Object)childMap)).keySet()) {
                    JSMap newChild = res.data().getMap((Object)(++i));
                    String newKey = rel.getRelated().encodeKeyFromJsonNames((Map<String, Object>)newChild);
                    if (newKey == null) {
                        throw new ApiException("New child key was null {}", newChild);
                    }
                    JSMap oldChild = (JSMap)((LinkedHashMap)((Object)childMap)).get(childKey);
                    oldChild.clear();
                    oldChild.putAll((Map)newChild);
                    updatedNodes.put(oldChild, newKey);
                    updatedKeys.put(newKey, oldChild);
                }
            }
        }
        for (Relationship rel : collection.getRelationships()) {
            ArrayList<Map<String, Object>> patches = new ArrayList<Map<String, Object>>();
            if (!rel.isManyToOne()) continue;
            for (JSNode jSNode : nodes.asMapList()) {
                Object childObj = jSNode.get((Object)rel.getName());
                if (!(childObj instanceof JSNode)) continue;
                Map<String, Object> foreignKey2 = rel.buildForeignKeyFromPrimaryKey((Map<String, Object>)((JSMap)childObj));
                if (foreignKey2 == null) {
                    throw new ApiException("Foreign key should not be null at this point", new Object[0]);
                }
                LinkedHashMap<String, Object> primaryKey = new LinkedHashMap<String, Object>();
                for (String name : collection.getResourceIndex().getJsonNames()) {
                    Object value = jSNode.get((Object)name);
                    if (value == null) {
                        throw new ApiException("Primary key field should not be null at this point", new Object[0]);
                    }
                    primaryKey.put(name, value);
                }
                LinkedHashMap<String, Object> patch = new LinkedHashMap<String, Object>();
                patch.putAll(primaryKey);
                patch.putAll(foreignKey2);
                patches.add(patch);
            }
            if (patches.size() <= 0) continue;
            collection.getDb().patch(collection, patches);
        }
        MultiKeyMap keepRels = new MultiKeyMap();
        for (Relationship rel : collection.getRelationships()) {
            if (rel.isManyToOne()) continue;
            for (JSNode jSNode : nodes.asMapList()) {
                if (!(jSNode.get((Object)rel.getName()) instanceof JSList)) continue;
                foreignKey = this.buildKey(jSNode, collection.getResourceIndex(), rel.getFkIndex1());
                keepRels.put((Object)rel, foreignKey, new ArrayList());
                JSList childNodes = jSNode.getList((Object)rel.getName());
                for (int i = 0; childNodes != null && i < childNodes.size(); ++i) {
                    JSNode child2 = (JSNode)childNodes.get(i);
                    if (rel.isOneToMany()) {
                        LinkedHashMap<String, Object> childKey = this.buildKey(child2, rel.getRelated().getResourceIndex());
                        ((ArrayList)keepRels.get((Object)rel, foreignKey)).add(childKey);
                        continue;
                    }
                    if (!rel.isManyToMany()) continue;
                    LinkedHashMap<String, Object> nodeFk = this.buildKey(jSNode, collection.getResourceIndex(), rel.getFkIndex1());
                    LinkedHashMap<String, Object> childFk = this.buildKey(child2, rel.getRelated().getResourceIndex(), rel.getFkIndex2());
                    LinkedHashMap<String, Object> linkKey = new LinkedHashMap<String, Object>();
                    linkKey.putAll(nodeFk);
                    linkKey.putAll(childFk);
                    ((ArrayList)keepRels.get((Object)rel, foreignKey)).add(linkKey);
                }
            }
        }
        block14: for (Map.Entry entry : keepRels.entrySet()) {
            Response toUnlink;
            Collection coll;
            Relationship rel = (Relationship)((MultiKey)entry.getKey()).getKey(0);
            Map map = (Map)((MultiKey)entry.getKey()).getKey(1);
            List childKeys = (List)keepRels.get((Object)rel, (Object)map);
            System.out.println("rel: " + rel.getName());
            System.out.println("parentKey: " + map);
            System.out.println("child keys: " + childKeys);
            HashSet<Object> includesKeys = new HashSet<Object>();
            includesKeys.addAll(map.keySet());
            includesKeys.addAll(rel.getRelated().getResourceIndex().getJsonNames());
            Term childNot = Term.term(null, (String)"not", (Object[])new Object[0]);
            Term childOr = Term.term((Term)childNot, (String)"or", (Object[])new Object[0]);
            ArrayList<Map<String, Object>> upserts = new ArrayList<Map<String, Object>>();
            for (Map childKey : childKeys) {
                includesKeys.addAll(childKey.keySet());
                childOr.withTerm(this.asTerm(childKey));
                upserts.add(childKey);
            }
            Collection collection2 = coll = rel.isOneToMany() ? rel.getRelated() : rel.getFk1Col1().getCollection();
            if (rel.isManyToMany()) {
                System.out.println("updating relationship: " + rel + " -> " + coll + " -> " + upserts);
                coll.getDb().upsert(coll, upserts);
            }
            HashMap<String, String> queryTerms = new HashMap<String, String>();
            queryTerms.put("limit", "100");
            queryTerms.put("include", Utils.implode((String)",", (Object[])new Object[]{includesKeys}));
            for (Object parentKeyProp : map.keySet()) {
                queryTerms.put(parentKeyProp.toString(), map.get(parentKeyProp).toString());
            }
            if (childOr.size() > 0) {
                queryTerms.put(childNot.toString(), null);
            }
            String next = Chain.buildLink(coll);
            do {
                Object node22;
                this.log.warn("...looking for one-to-many and many-to-many foreign keys: " + rel + " -> " + queryTerms);
                toUnlink = req.getEngine().get(next, queryTerms).assertOk(new String[0]);
                if (toUnlink.data().size() == 0) continue block14;
                toUnlink.dump();
                if (rel.isOneToMany()) {
                    for (Object node22 : toUnlink.data().asMapList()) {
                        for (String prop : rel.getFkIndex1().getJsonNames()) {
                            node22.put((Object)prop, null);
                        }
                    }
                    req.getEngine().patch(Chain.buildLink(coll), (JSNode)toUnlink.data()).assertOk(new String[0]);
                    continue;
                }
                if (!rel.isManyToMany()) continue;
                ArrayList<String> resourceKeys = new ArrayList<String>();
                node22 = toUnlink.data().asMapList().iterator();
                while (node22.hasNext()) {
                    JSMap node3 = (JSMap)node22.next();
                    String key = coll.encodeKeyFromJsonNames((Map<String, Object>)node3);
                    if (key == null) {
                        throw new ApiException("Unable to determine the key for a MANY_TO_MANY relationship deletion.", new Object[0]);
                    }
                    resourceKeys.add(key);
                }
                String url = Chain.buildLink(coll) + "/" + Utils.implode((String)",", (Object[])new Object[]{resourceKeys});
                req.getEngine().delete(url);
            } while (toUnlink.data().size() >= 100);
        }
        return returnList;
    }

    LinkedHashMap<String, Object> buildKey(JSNode node, Index index) {
        LinkedHashMap<String, Object> key = new LinkedHashMap<String, Object>();
        for (int i = 0; i < index.size(); ++i) {
            Object value = node.get((Object)index.getJsonName(i));
            if (value == null) {
                throw new ApiException("Foreign key component can not be null.", new Object[0]);
            }
            key.put(index.getJsonName(i), value);
        }
        return key;
    }

    LinkedHashMap<String, Object> buildKey(JSNode node, Index fromIndex, Index toIndex) {
        if (fromIndex == null || toIndex == null) {
            throw new ApiException("You can't map an index when one of them is null.", new Object[0]);
        }
        LinkedHashMap<String, Object> foreignKey = new LinkedHashMap<String, Object>();
        for (int i = 0; i < fromIndex.size(); ++i) {
            Object value = node.get((Object)fromIndex.getJsonName(i));
            if (value == null) {
                throw new ApiException("Foreign key component can not be null.", new Object[0]);
            }
            foreignKey.put(toIndex.getJsonName(i), value);
        }
        return foreignKey;
    }

    protected void swapRefsWithActualReferences(JSNode root) {
        root.visit(path -> {
            String ref;
            JSNode node = path.getNode();
            Object refObj = node.get((Object)"$ref");
            if (refObj instanceof String && (ref = (String)refObj).startsWith("#")) {
                Object found = root.find(ref);
                if (found == null) {
                    throw ApiException.new400BadRequest("Unable to find $ref ''", ref);
                }
                path.getParent().getNode().put(path.getProperty(), found);
            }
            return true;
        });
    }

    protected void swapLogicalDuplicateReferences(Collection childColl, JSNode child, JSNode parent, String parentProp, Map<Collection, Map<String, JSNode>> visited) {
        if (child == null) {
            return;
        }
        String resourceKey = childColl.encodeKeyFromColumnNames((Map<String, Object>)((JSMap)child));
        if (resourceKey != null) {
            JSNode existing;
            Map<String, JSNode> keys = visited.get(childColl);
            if (keys == null) {
                keys = new HashMap<String, JSNode>();
                visited.put(childColl, keys);
            }
            if ((existing = keys.get(resourceKey)) != null) {
                parent.put((Object)parentProp, (Object)existing);
                return;
            }
            keys.put(resourceKey, child);
        }
        for (Relationship rel : childColl.getRelationships()) {
            Object grandchild = child.get((Object)rel.getName());
            if (grandchild instanceof JSList) {
                JSList arr = (JSList)grandchild;
                for (int i = 0; i < arr.size(); ++i) {
                    this.swapLogicalDuplicateReferences(rel.getRelated(), (JSNode)arr.getMap((Object)i), (JSNode)arr, "" + i, visited);
                }
                continue;
            }
            if (!(grandchild instanceof JSMap)) continue;
            this.swapLogicalDuplicateReferences(rel.getRelated(), (JSNode)((JSMap)grandchild), child, rel.getName(), visited);
        }
    }

    Term asTerm(Map row) {
        Term t = null;
        for (Object key : row.keySet()) {
            Object value = row.get(key);
            if (t == null) {
                t = Term.term(null, (String)"eq", (Object[])new Object[]{key, value});
                continue;
            }
            if (!t.hasToken(new String[]{"and"})) {
                t = Term.term(null, (String)"and", (Object[])new Object[]{t});
            }
            t.withTerm(Term.term((Term)t, (String)"eq", (Object[])new Object[]{key, value}));
        }
        return t;
    }

    public boolean isCollapseAll() {
        return this.collapseAll;
    }

    public DbPostAction withCollapseAll(boolean collapseAll) {
        this.collapseAll = collapseAll;
        return this;
    }

    public boolean isStrictRest() {
        return this.strictRest;
    }

    public DbPostAction withStrictRest(boolean strictRest) {
        this.strictRest = strictRest;
        return this;
    }

    public boolean isGetResponse() {
        return this.getResponse;
    }

    public DbPostAction withGetResponse(boolean expandResponse) {
        this.getResponse = expandResponse;
        return this;
    }

    public static void collapse(JSNode parent, boolean collapseAll, Set collapses, String path) {
    }
}

