/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.context;

import io.inversion.ApiException;
import io.inversion.Collection;
import io.inversion.Endpoint;
import io.inversion.Index;
import io.inversion.Property;
import io.inversion.Relationship;
import io.inversion.context.Context;
import io.inversion.context.Namer;

public class InversionNamer
implements Namer {
    public String name(Context context, Object object) {
        try {
            Relationship rel;
            String name = null;
            if (object instanceof Endpoint) {
                Endpoint ep = (Endpoint)object;
                if (ep.getApi() != null && ep.getName() != null) {
                    name = this.makeName(context, ep.getApi(), "_endpoints_", ep.getName(), new String[0]);
                }
            } else if (object instanceof Collection) {
                Collection coll = (Collection)object;
                if (coll.getDb() != null && coll.getName() != null) {
                    name = this.makeName(context, coll.getDb(), "_collections_", coll.getName(), new String[0]);
                }
            } else if (object instanceof Property) {
                Property prop = (Property)object;
                if (prop.getCollection() != null && prop.getName() != null) {
                    name = this.makeName(context, prop.getCollection(), "_properties_", prop.getName(), new String[0]);
                }
            } else if (object instanceof Index) {
                Index index = (Index)object;
                if (index.getCollection() != null && index.getName() != null) {
                    name = this.makeName(context, index.getCollection(), "_indexes_", index.getName(), new String[0]);
                }
            } else if (object instanceof Relationship && (rel = (Relationship)object).getCollection() != null && rel.getName() != null) {
                name = this.makeName(context, rel.getCollection(), "_relationships_", rel.getName(), new String[0]);
            }
            if (name != null) {
                name = name.replaceAll("[^A-Za-z0-9]", "_");
            }
            return name;
        }
        catch (Exception ex) {
            throw new ApiException(ex);
        }
    }

    public String makeName(Context context, Object parent, String prefix, String name, String ... choices) {
        String parentName = context.makeName(parent);
        if (name.startsWith(parentName + prefix)) {
            return name;
        }
        return parentName + prefix + name;
    }
}

