/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.action.hateoas;

import io.inversion.ApiException;
import io.inversion.Chain;
import io.inversion.Op;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.action.hateoas.HATEOASFilter;
import io.inversion.json.JSList;
import io.inversion.json.JSMap;
import io.inversion.json.JSNode;

public class SdkFilter
extends HATEOASFilter<SdkFilter> {
    @Override
    public void run(Request req, Response res) throws ApiException {
        if (Chain.isRoot() && req.getCollection() != null) {
            req.getChain().go();
            if (res.isSuccess() && res.getJson() != null) {
                if (req.getOp().getFunction() == Op.OpFunction.FIND) {
                    this.updateFindResponse(req, res);
                } else {
                    this.removeMetaAndCollapseData(req, res);
                }
            }
        }
    }

    void removeMetaAndCollapseData(Request req, Response res) {
        res.getJson().remove(new Object[]{"meta"});
        JSNode json = res.getJson();
        JSList data = res.data();
        if (data != json) {
            if (data.size() == 1 && data.get(0) instanceof JSMap) {
                res.withJson(data.getNode((Object)0));
            } else {
                res.withJson((JSNode)new JSMap(new Object[]{"items", data}));
            }
        }
    }

    void updateFindResponse(Request req, Response res) {
        JSList data = res.data();
        System.out.println(res.getMeta());
        String next = res.getNext();
        int totalCount = res.getFoundRows();
        int itemCount = res.data() != null ? res.data().size() : 0;
        String lastKey = res.getLastKey();
        int pageSize = res.getPageSize();
        int pageCount = res.getPageCount();
        int pageNumber = res.getPageNum();
        JSMap page = res.findMap("page");
        if (page == null) {
            page = new JSMap();
        }
        if (next != null) {
            page.put("next", (Object)next);
        }
        if (totalCount > -1) {
            page.put("totalCount", (Object)totalCount);
        }
        if (itemCount > -1) {
            page.put("itemCount", (Object)itemCount);
        }
        if (lastKey != null) {
            page.put("lastKey", (Object)lastKey);
        }
        if (pageSize > -1) {
            page.put("pageSize", (Object)pageSize);
        }
        if (pageCount > -1) {
            page.put("pageCount", (Object)pageCount);
        }
        if (pageNumber > -1) {
            page.put("pageNumber", (Object)pageNumber);
        }
        JSMap newJson = new JSMap();
        newJson.put("page", (Object)page);
        newJson.put("items", (Object)data);
        res.withJson((JSNode)newJson);
    }
}

