/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.action.db;

import io.inversion.Action;
import io.inversion.Api;
import io.inversion.ApiException;
import io.inversion.Chain;
import io.inversion.Collection;
import io.inversion.Db;
import io.inversion.Index;
import io.inversion.Op;
import io.inversion.Param;
import io.inversion.Property;
import io.inversion.Relationship;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.Results;
import io.inversion.Rule;
import io.inversion.Url;
import io.inversion.json.JSList;
import io.inversion.json.JSMap;
import io.inversion.json.JSNode;
import io.inversion.query.Page;
import io.inversion.rql.Term;
import io.inversion.utils.KeyValue;
import io.inversion.utils.ListMap;
import io.inversion.utils.Task;
import io.inversion.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.map.MultiKeyMap;

public class DbGetAction<A extends DbGetAction>
extends Action<A> {
    protected int maxRows = 100;

    public DbGetAction() {
        Param page = new Param();
        page.withDescription("An optional value used to compute the 'offset' of the first item returned as 'offset'='pageNumber'*'pageSize'.  If an 'offset' parameter is also supplied it will be used instead of the 'pageNumber' parameter.");
        page.withKey("pageNumber");
        page.withIn(Param.In.QUERY);
        this.withParam(page);
        Param size = new Param();
        size.withDescription("An optional number of items to return.  Unless overridden by other configuration the default value is '100'");
        size.withKey("pageSize");
        size.withIn(Param.In.QUERY);
        this.withParam(size);
        Param offset = new Param();
        offset.withDescription("An optional value used to compute the offset.  This value overrides the 'pageNumber' parameters.");
        offset.withKey("offset");
        offset.withIn(Param.In.QUERY);
        this.withParam(offset);
        Param sort = new Param();
        sort.withDescription("An optional comma separated list of json property names used to order the results.  Each property may optionally be prefixed with '-' to specify descending order.");
        sort.withKey("sort");
        sort.withIn(Param.In.QUERY);
        this.withParam(sort);
        Param q = new Param();
        String desc = "An RQL formatted filter statement that allows you to retrieve only the specific resources you require.  See 'Overview->Querying' for more documentation on available functions and syntax.";
        q.withDescription(desc);
        q.withKey("q");
        q.withIn(Param.In.QUERY);
        this.withParam(q);
    }

    @Override
    public void configureOp(Task task, Op op) {
        if (Op.OpFunction.FIND == op.getFunction()) {
            this.getParams().forEach(p -> op.withParam((Param)p));
        }
    }

    @Override
    protected List<Rule.RuleMatcher> getDefaultIncludeMatchers() {
        return Utils.asList((Object[])new Object[]{new Rule.RuleMatcher("GET", "{_collection}/[{_resource}]/[{_relationship}]")});
    }

    protected static String getForeignKey(Relationship rel, JSMap node) {
        Index idx = rel.getFkIndex1();
        if (idx.size() == 1 && node.get((Object)idx.getJsonName(0)) != null) {
            return node.getString((Object)idx.getJsonName(0));
        }
        String key = rel.getCollection().encodeKeyFromJsonNames((Map<String, Object>)node, rel.getFkIndex1());
        return key;
    }

    protected static String getResourceKey(Collection collection, JSMap node) {
        String key = collection.encodeKeyFromJsonNames((Map<String, Object>)node);
        if (key == null) {
            throw ApiException.new500InternalServerError("The primary key '{}' could not be constructed from the data provided.", collection.getResourceIndex());
        }
        return key;
    }

    public static String stripTerms(String url, String ... tokens) {
        Url u = new Url(url);
        u.clearParams(tokens);
        return u.toString();
    }

    protected static String expandPath(String path, Object next) {
        if (Utils.empty((Object[])new Object[]{path})) {
            return "" + next;
        }
        return path + "." + next;
    }

    protected static boolean shouldExpand(Set<String> expands, String path, Relationship rel) {
        boolean expand = false;
        path = path.length() == 0 ? rel.getName() : path + "." + rel.getName();
        path = path.toLowerCase();
        for (String ep : expands) {
            if (!(ep = ep.toLowerCase()).startsWith(path) || ep.length() != path.length() && ep.charAt(path.length()) != '.') continue;
            expand = true;
            break;
        }
        return expand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run(Request req, Response res) throws ApiException {
        Results results;
        if (req.getRelationshipKey() != null) {
            String resourceKey = req.getResourceKey();
            Collection collection = req.getCollection();
            Relationship rel = collection.getRelationship(req.getRelationshipKey());
            if (rel == null) {
                throw ApiException.new400BadRequest("'{}' is not a valid relationship", req.getRelationshipKey());
            }
            StringBuilder newHref = null;
            if (rel.isOneToMany()) {
                Collection relatedCollection = rel.getRelated();
                newHref = new StringBuilder(Chain.buildLink(relatedCollection) + "?");
                Map<String, Object> resourceKeyRow = collection.decodeKeyToJsonNames(req.getResourceKey());
                if (rel.getFkIndex1().size() != collection.getResourceIndex().size() && rel.getFkIndex1().size() == 1) {
                    String propName = rel.getFk1Col1().getJsonName();
                    newHref.append(propName).append("=").append(resourceKey);
                } else {
                    Index fkIdx = rel.getFkIndex1();
                    Index pkIdx = collection.getResourceIndex();
                    for (int i = 0; i < fkIdx.size(); ++i) {
                        Property fk = fkIdx.getProperty(i);
                        String pkName = pkIdx.getJsonName(i);
                        Object pkVal = resourceKeyRow.get(pkName);
                        if (pkVal == null) {
                            throw ApiException.new400BadRequest("Missing parameter for foreign key property '{}'", fk.getJsonName());
                        }
                        newHref.append(fk.getJsonName()).append("=").append(pkVal).append("&");
                    }
                    newHref = new StringBuilder(newHref.substring(0, newHref.length() - 1));
                }
            } else if (rel.isManyToMany()) {
                List<KeyValue<String, String>> rows = this.getRelatedKeys(rel, rel.getFkIndex1(), rel.getFkIndex2(), Collections.singletonList(resourceKey));
                if (rows.size() <= 0) return;
                ArrayList foreignKeys = new ArrayList();
                rows.forEach(k -> foreignKeys.add((String)k.getValue()));
                Collection relatedCollection = rel.getRelated();
                String resourceKeys = Utils.implode((String)",", (Object[])foreignKeys.toArray());
                newHref = new StringBuilder(Chain.buildLink(relatedCollection, resourceKeys));
            } else {
                String url = req.getUrl().getOriginal();
                if ((url = Utils.substringBefore((String)url, (String)"?")).endsWith("/")) {
                    url = url.substring(0, url.length() - 1);
                }
                url = url.substring(0, url.lastIndexOf("/"));
                Response tempRes = res.getEngine().get(url).assertOk(new String[0]);
                JSMap node = tempRes.getFirstRecordAsMap();
                String link = Chain.buildLink(node, rel);
                newHref = new StringBuilder(link);
                if (newHref == null) {
                    throw ApiException.new500InternalServerError("Unable to locate foreign key value for relationship '{}'", rel.getName());
                }
            }
            Map<String, String> params = req.getUrl().getParams();
            Utils.filter(params, (String[])new String[]{"_collection", "_resource", "_relationship"});
            if (params.size() > 0) {
                String queryString = Url.toQueryString(params);
                if (!newHref.toString().contains("?")) {
                    newHref.append("?");
                } else {
                    newHref.append("&");
                }
                newHref.append(queryString);
            }
            Response included = req.getEngine().get(newHref.toString());
            res.withStatus(included.getStatus());
            res.withJson(included.getJson());
            return;
        }
        if (req.getCollection() != null && !Utils.empty((Object[])new Object[]{req.getResourceKey()})) {
            List resourceKeys = Utils.explode((String)",", (String[])new String[]{req.getResourceKey()});
            Term term = Term.term(null, (String)"_key", (Object[])new Object[]{req.getCollection().getResourceIndex().getName(), resourceKeys.toArray()});
            req.getUrl().withParams(term.toString(), null);
        }
        if ((results = this.select(req, req.getCollection(), req.getApi())).size() == 0 && req.getResourceKey() != null && req.getCollectionKey() != null) {
            res.withJson((JSNode)null);
            res.withStatus("404 Not Found");
            return;
        } else {
            res.withRecords(results.getRows());
            if (res.data().size() > 0) {
                String lastKey;
                Collection coll = null;
                if (req.getOp().getFunction() == Op.OpFunction.RELATED) {
                    if (req.getRelationship() != null) {
                        coll = req.getRelationship().getCollection();
                    }
                } else if (req.getOp().getFunction() == Op.OpFunction.FIND && req.getCollection() != null) {
                    coll = req.getCollection();
                }
                if (coll != null && (lastKey = coll.encodeKeyFromJsonNames((Map<String, Object>)((JSMap)res.data().last()))) != null) {
                    res.withLastKey(lastKey);
                }
            }
            Object page = results.getQuery().getPage();
            res.withPageSize(((Page)page).getPageSize());
            res.withPageNum(((Page)page).getPageNum());
            int offest = ((Page)page).getOffset();
            int limit = ((Page)page).getLimit();
            int foundRows = results.getFoundRows();
            if (foundRows < 0 && results.size() >= 0 && offest <= 0 && results.size() < limit) {
                foundRows = results.size();
            }
            if (foundRows >= 0) {
                res.withFoundRows(foundRows);
            }
            if (results.size() <= 0 || results.size() < limit || req.getCollection() == null || req.getResourceKey() != null) return;
            List<Term> nextTerms = results.getNext();
            if (nextTerms != null && !nextTerms.isEmpty()) {
                Object next = req.getUrl().getOriginal();
                for (Term nextTerm : nextTerms) {
                    String toStrip = nextTerm.getToken();
                    if (!((String)(next = DbGetAction.stripTerms((String)next, toStrip))).contains("?")) {
                        next = (String)next + "?";
                    }
                    if (!((String)next).endsWith("?")) {
                        next = (String)next + "&";
                    }
                    next = (String)next + nextTerm;
                }
                res.withNext((String)next);
                return;
            } else {
                if (results.size() != limit || foundRows >= 0 && offest + limit >= foundRows) return;
                Object next = req.getUrl().getOriginal();
                if (!((String)(next = DbGetAction.stripTerms((String)next, "offset", "page", "pageNum", "pageNumber", "after"))).contains("?")) {
                    next = (String)next + "?";
                }
                if (!((String)next).endsWith("?")) {
                    next = (String)next + "&";
                }
                next = (String)next + "pageNumber=" + (((Page)page).getPageNum() + 1);
                res.withNext((String)next);
            }
        }
    }

    protected Results select(Request req, Collection collection, Api api) throws ApiException {
        Results results;
        if (collection == null) {
            Db db = api.getDb((String)Chain.peek().get("db"));
            if (db == null) {
                List<Db> dbs = api.getDbs();
                for (Db candidate : dbs) {
                    if (!candidate.matches(req.getMethod(), req.getPath())) continue;
                    db = candidate;
                    break;
                }
            }
            if (db == null) {
                throw ApiException.new400BadRequest("Unable to find collection for url '{}'", req.getUrl());
            }
            results = db.select(null, req.getUrl().getParams());
        } else {
            results = collection.getDb().select(collection, req.getUrl().getParams());
        }
        if (results.size() > 0 && collection != null) {
            this.expand(req, collection, results.getRows(), null, null, null);
        }
        return results;
    }

    protected void expand(Request request, Collection collection, List<JSMap> parentObjs, Set expands, String expandsPath, MultiKeyMap pkCache) {
        if (parentObjs.size() == 0) {
            return;
        }
        if (expands == null) {
            String expandsStr = request.getUrl().getParam("expand");
            if (expandsStr == null) {
                return;
            }
            expands = new LinkedHashSet(Utils.explode((String)",", (String[])new String[]{expandsStr}));
        }
        if (expandsPath == null) {
            expandsPath = "";
        }
        for (Relationship rel : collection.getRelationships()) {
            JSMap parentObj22;
            String parentEk;
            boolean shouldExpand = DbGetAction.shouldExpand(expands, expandsPath, rel);
            if (!shouldExpand) continue;
            if (pkCache == null) {
                pkCache = new MultiKeyMap();
                for (JSMap node : parentObjs) {
                    pkCache.put((Object)collection, (Object)DbGetAction.getResourceKey(collection, node), (Object)node);
                }
            }
            Collection relatedCollection = rel.getRelated();
            Index idxToMatch = null;
            Index idxToRetrieve = null;
            List<Object> relatedEks = null;
            if (rel.isManyToOne()) {
                idxToMatch = collection.getResourceIndex();
                idxToRetrieve = rel.getFkIndex1();
                relatedEks = new ArrayList();
                for (JSMap jSMap : parentObjs) {
                    parentEk = DbGetAction.getResourceKey(collection, jSMap);
                    String string = DbGetAction.getForeignKey(rel, jSMap);
                    if (string == null) continue;
                    relatedEks.add(new KeyValue((Object)parentEk, (Object)string));
                }
            } else if (rel.isOneToMany()) {
                idxToMatch = rel.getFkIndex1();
                idxToRetrieve = rel.getRelated().getResourceIndex();
            } else if (rel.isManyToMany()) {
                idxToMatch = rel.getFkIndex1();
                idxToRetrieve = rel.getFkIndex2();
            } else if (rel.isOneToOneParent()) {
                relatedEks = new ArrayList();
                for (JSMap jSMap : parentObjs) {
                    parentEk = DbGetAction.getResourceKey(collection, jSMap);
                    String string = parentEk;
                    if (string == null) continue;
                    relatedEks.add(new KeyValue((Object)parentEk, (Object)string));
                }
            } else if (rel.isOneToOneChild()) {
                relatedEks = new ArrayList();
                for (JSMap jSMap : parentObjs) {
                    parentEk = DbGetAction.getResourceKey(collection, jSMap);
                    String string = parentEk;
                    if (string == null) continue;
                    relatedEks.add(new KeyValue((Object)parentEk, (Object)string));
                }
            }
            if (relatedEks == null) {
                ArrayList<String> toMatchEks = new ArrayList<String>();
                for (JSMap parentObj22 : parentObjs) {
                    String string = DbGetAction.getResourceKey(collection, parentObj22);
                    if (toMatchEks.contains(string)) continue;
                    if (parentObj22.get((Object)rel.getName()) instanceof JSList) {
                        throw ApiException.new500InternalServerError("This relationship seems to have already been expanded.", new Object[0]);
                    }
                    toMatchEks.add(string);
                    if (rel.isManyToOne()) {
                        parentObj22.remove((Object)rel.getName());
                        continue;
                    }
                    parentObj22.put(rel.getName(), (Object)new JSList(new Object[0]));
                }
                relatedEks = this.getRelatedKeys(rel, idxToMatch, idxToRetrieve, toMatchEks);
            }
            ArrayList<String> unfetchedChildEks = new ArrayList<String>();
            ListMap listMap = new ListMap();
            parentObj22 = relatedEks.iterator();
            while (parentObj22.hasNext()) {
                KeyValue keyValue = (KeyValue)parentObj22.next();
                String string = (String)keyValue.getKey();
                String relatedEk = (String)keyValue.getValue();
                listMap.put((Object)relatedEk, (Object)string);
                if (pkCache.containsKey((Object)relatedCollection, (Object)relatedEk)) continue;
                unfetchedChildEks.add(relatedEk);
            }
            List<JSMap> newChildObjs = this.recursiveGet(pkCache, relatedCollection, unfetchedChildEks, DbGetAction.expandPath(expandsPath, rel.getName()));
            for (KeyValue keyValue : relatedEks) {
                String parentEk4 = (String)keyValue.getKey();
                String relatedEk = (String)keyValue.getValue();
                JSNode parentObj = (JSNode)pkCache.get((Object)collection, (Object)parentEk4);
                JSNode childObj = (JSNode)pkCache.get((Object)relatedCollection, (Object)relatedEk);
                if (rel.isManyToOne() || rel.isOneToOneParent() || rel.isOneToOneChild()) {
                    parentObj.put((Object)rel.getName(), (Object)childObj);
                    continue;
                }
                if (childObj == null) continue;
                parentObj.getList((Object)rel.getName()).add((Object)childObj);
            }
            if (newChildObjs.size() <= 0) continue;
            this.expand(request, relatedCollection, newChildObjs, expands, DbGetAction.expandPath(expandsPath, rel.getName()), pkCache);
        }
    }

    protected List<KeyValue<String, String>> getRelatedKeys(Relationship rel, Index idxToMatch, Index idxToRetrieve, List<String> toMatchEks) throws ApiException {
        if (idxToMatch.getCollection() != idxToRetrieve.getCollection()) {
            throw ApiException.new400BadRequest("You can only retrieve related index keys from the same Collection.", new Object[0]);
        }
        ArrayList<KeyValue<String, String>> related = new ArrayList<KeyValue<String, String>>();
        LinkedHashSet<String> columns = new LinkedHashSet<String>();
        columns.addAll(idxToMatch.getColumnNames());
        columns.addAll(idxToRetrieve.getColumnNames());
        Term termKeys = Term.term(null, (String)"_key", (Object[])new Object[]{idxToMatch.getName(), toMatchEks});
        Term includes = Term.term(null, (String)"include", (Object[])new Object[]{columns});
        Term sort = Term.term(null, (String)"sort", (Object[])new Object[]{columns});
        Term notNull = Term.term(null, (String)"nn", (Object[])new Object[]{columns});
        String link = Chain.buildLink(idxToRetrieve.getCollection());
        Response res = Chain.peek().getEngine().get(link, Arrays.asList(termKeys, includes, sort, notNull)).assertOk(new String[0]);
        for (JSNode node : res.data().asMapList()) {
            ArrayList<Object> idxToMatchVals = new ArrayList<Object>();
            for (String string : idxToMatch.getJsonNames()) {
                Object propVal = node.get((Object)string);
                if (propVal instanceof String && ((String)(propVal = Utils.substringAfter((String)propVal.toString(), (String)"/"))).contains("~")) {
                    idxToMatchVals.addAll(Utils.explode((String)"~", (String[])new String[]{(String)propVal}));
                    continue;
                }
                idxToMatchVals.add(propVal);
            }
            ArrayList<Object> idxToRetrieveVals = new ArrayList<Object>();
            for (String property3 : idxToRetrieve.getJsonNames()) {
                Object propVal = node.get((Object)property3);
                if (((String)(propVal = Utils.substringAfter((String)propVal.toString(), (String)"/"))).contains("~")) {
                    idxToRetrieveVals.addAll(Utils.explode((String)"~", (String[])new String[]{(String)propVal}));
                    continue;
                }
                idxToRetrieveVals.add(propVal);
            }
            String string = Collection.encodeKey(idxToMatchVals);
            String relatedEk = Collection.encodeKey(idxToRetrieveVals);
            related.add((KeyValue<String, String>)new KeyValue((Object)string, (Object)relatedEk));
        }
        return related;
    }

    protected List<JSMap> recursiveGet(MultiKeyMap pkCache, Collection collection, java.util.Collection resourceKeys, String expandsPath) throws ApiException {
        if (resourceKeys.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        String url = Chain.buildLink(collection, Utils.implode((String)",", (Object[])new Object[]{resourceKeys}));
        Response res = Chain.peek().getEngine().get(url);
        int sc = res.getStatusCode();
        if (sc == 401 || sc == 403) {
            return null;
        }
        if (sc == 404) {
            return Collections.EMPTY_LIST;
        }
        if (sc == 500) {
            res.rethrow();
        } else if (sc == 200) {
            List nodes = res.data().asMapList();
            for (JSMap node : nodes) {
                String resourceKey = DbGetAction.getResourceKey(collection, node);
                if (pkCache.containsKey((Object)collection, (Object)resourceKey)) {
                    throw ApiException.new500InternalServerError("The requested resource has already been retrieved.", new Object[0]);
                }
                pkCache.put((Object)collection, (Object)resourceKey, (Object)node);
            }
            return nodes;
        }
        res.rethrow();
        return null;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public DbGetAction withMaxRows(int maxRows) {
        this.maxRows = maxRows;
        return this;
    }
}

