/*
 * Decompiled with CFR 0.152.
 */
package io.inversion;

import io.inversion.ApiException;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.json.JSList;
import io.inversion.json.JSNode;
import io.inversion.json.JSParser;
import io.inversion.utils.Utils;
import java.util.regex.Pattern;

public class Validation {
    final String customErrorMessage;
    final String propOrPath;
    Object value;

    public Validation(Request req, String propOrPath, String customErrorMessage) {
        this.value = req.getUrl().getParam(propOrPath);
        if (this.value == null && req.getJson() != null) {
            this.value = req.getJson().find(propOrPath);
        }
        this.propOrPath = null;
        this.customErrorMessage = customErrorMessage;
    }

    public Validation(Response res, String jsonPath, String customErrorMessage) {
        this.value = res.find(jsonPath);
        this.propOrPath = null;
        this.customErrorMessage = customErrorMessage;
    }

    public Validation required(String ... childProps) {
        if (Utils.empty((Object[])new Object[]{this.value})) {
            this.fail("Required field '" + this.propOrPath + "' is missing.");
        }
        if (childProps != null && this.value instanceof JSNode && !((JSNode)this.value).isList()) {
            for (String childProp : childProps) {
                if (!Utils.empty((Object[])new Object[]{((JSNode)this.value).get((Object)childProp)})) continue;
                this.fail("Required field '" + this.propOrPath + "." + childProp + "' is missing.");
            }
        }
        return this;
    }

    public Validation matches(Pattern regex) {
        if (this.value == null || !regex.matcher(this.value.toString()).matches()) {
            this.fail("Field '" + this.propOrPath + "' does not match the required pattern.");
        }
        return this;
    }

    public Validation matches(String regex) {
        if (this.value == null) {
            return this;
        }
        if (!this.value.toString().matches(regex)) {
            this.fail("Field '" + this.propOrPath + "' does not match the required pattern.");
        }
        return this;
    }

    public Validation in(Object ... possibleValues) {
        if (this.value == null) {
            return this;
        }
        if (!Utils.in((Object)this.value, (Object[])possibleValues)) {
            this.fail("Field '" + this.propOrPath + "' is not one of the possible values.");
        }
        return this;
    }

    public Validation out(Object ... excludedValues) {
        if (this.value == null) {
            return this;
        }
        if (Utils.in((Object)this.value, (Object[])excludedValues)) {
            this.fail("Field '" + this.propOrPath + "' has a restricted value.");
        }
        return this;
    }

    protected int compareTo(Object compareTo) {
        Object value = this.value;
        if (compareTo instanceof Number) {
            try {
                value = Double.parseDouble(value.toString());
                compareTo = Double.parseDouble(compareTo.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (value instanceof Comparable) {
            return ((Comparable)value).compareTo(compareTo);
        }
        return ("" + value).compareTo("" + compareTo);
    }

    public Validation gt(Object compareTo) {
        if (this.value == null) {
            return this;
        }
        if (this.compareTo(compareTo) < 1) {
            this.fail("Field '" + this.propOrPath + "' is less than the required value.");
        }
        return this;
    }

    public Validation ge(Object compareTo) {
        if (this.value == null) {
            return this;
        }
        if (this.compareTo(compareTo) < 0) {
            this.fail("Field '" + this.propOrPath + "' is less than the required value.");
        }
        return this;
    }

    public Validation lt(Object compareTo) {
        if (this.value == null) {
            return this;
        }
        if (this.compareTo(compareTo) > -1) {
            this.fail("Field '" + this.propOrPath + "' is greater than the required value.");
        }
        return this;
    }

    public Validation le(Object compareTo) {
        if (this.value == null) {
            return this;
        }
        if (this.compareTo(compareTo) > 0) {
            this.fail("Field '" + this.propOrPath + "' is greater than the required value.");
        }
        return this;
    }

    public Validation eq(Object compareTo) {
        if (this.value == null) {
            return this;
        }
        if (this.compareTo(compareTo) != 0) {
            this.fail("Field '" + this.propOrPath + "' is not equal to the required value.");
        }
        return this;
    }

    public Validation ne(Object compareTo) {
        if (this.value == null) {
            return this;
        }
        if (this.compareTo(compareTo) != 0) {
            this.fail("Field '" + this.propOrPath + "' is equal to a restricted value.");
        }
        return this;
    }

    public Validation length(int max) {
        if (this.value == null) {
            return this;
        }
        if (this.value.toString().length() > max) {
            this.fail("Field '" + this.propOrPath + "' is longer than the max allowed length of '" + max + "'.");
        }
        return this;
    }

    public Validation length(int min, int max) {
        if (this.value == null) {
            return this;
        }
        int length = this.value.toString().length();
        if (length > max) {
            this.fail("Field '" + this.propOrPath + "' is longer than the maximum allowed length of '" + max + "'.");
        }
        if (length < min) {
            this.fail("Field '" + this.propOrPath + "' is shorter than the minimum allowed length of '" + max + "'.");
        }
        return this;
    }

    public Validation minMax(Number min, Number max) {
        if (this.value == null) {
            return this;
        }
        this.max(max);
        this.min(min);
        return this;
    }

    public Validation max(Number max) {
        if (this.value == null) {
            return this;
        }
        if (Double.parseDouble(max.toString()) < Double.parseDouble(this.value.toString())) {
            this.fail("Field '" + this.propOrPath + "' is greater than the required maximum of '" + max + "'.");
        }
        return this;
    }

    public Validation min(Number min) {
        if (this.value == null) {
            return this;
        }
        if (Double.parseDouble(min.toString()) > Double.parseDouble(this.value.toString())) {
            this.fail("Field '" + this.propOrPath + "' is less than the required minimum of '" + min + "'.");
        }
        return this;
    }

    public Object value() {
        return this.value;
    }

    public JSNode asNode() {
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof String) {
            this.value = JSParser.parseJson((String)this.value.toString());
        }
        return (JSNode)this.value;
    }

    public JSList asArray() {
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof String) {
            this.value = JSParser.asJSList((String)this.value.toString());
        }
        return (JSList)this.value;
    }

    public String asString() {
        if (this.value == null) {
            return null;
        }
        return this.value.toString();
    }

    public int asInt() {
        if (this.value == null) {
            return -1;
        }
        try {
            return Integer.parseInt("" + this.value);
        }
        catch (Exception ex) {
            this.fail("Field '" + this.propOrPath + "' must be an integer.");
            return -1;
        }
    }

    public double asDouble() {
        if (this.value == null) {
            return -1.0;
        }
        try {
            return Double.parseDouble("" + this.value);
        }
        catch (Exception ex) {
            this.fail("Field '" + this.propOrPath + "' must be an number.");
            return -1.0;
        }
    }

    public boolean asBoolean() {
        try {
            return Boolean.parseBoolean("" + this.value);
        }
        catch (Exception ex) {
            this.fail("Field '" + this.propOrPath + "' must be a boolean.");
            return false;
        }
    }

    protected void fail(String defaultErrorMessage) throws ApiException {
        String message = this.customErrorMessage != null ? this.customErrorMessage : defaultErrorMessage;
        throw ApiException.new400BadRequest(message, new Object[0]);
    }
}

