/*
 * Decompiled with CFR 0.152.
 */
package io.inversion;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.inversion.utils.Utils;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class User {
    protected String issuer = null;
    protected String account = null;
    protected String subject = null;
    protected Set<String> audiences = new LinkedHashSet<String>();
    protected Set<String> groups = new LinkedHashSet<String>();
    protected Set<String> roles = new LinkedHashSet<String>();
    protected Set<String> permissions = new LinkedHashSet<String>();
    protected Set<String> scopes = new LinkedHashSet<String>();
    protected final Map<String, Object> claims = new HashMap<String, Object>();

    public User() {
    }

    public User(String username, String roles, String permissions) {
        this.setSubject(username);
        this.withRoles(roles);
        this.withPermissions(permissions);
    }

    @JsonAnyGetter
    public Map<String, Object> getClaims() {
        return this.claims;
    }

    @JsonAnySetter
    public User withClaim(String name, Object value) {
        if ("iss".equalsIgnoreCase(name)) {
            name = "issuer";
        } else if ("aud".equalsIgnoreCase(name)) {
            name = "audiences";
        } else if ("sub".equalsIgnoreCase(name)) {
            name = "subject";
        } else if ("scp".equalsIgnoreCase(name)) {
            name = "scopes";
        } else if ("rol".equalsIgnoreCase(name)) {
            name = "roles";
        } else if ("prm".equalsIgnoreCase(name)) {
            name = "permissions";
        }
        String lc = name.toLowerCase();
        if (value instanceof List && Utils.in((Object)name, (Object[])new Object[]{"audience", "group", "role", "permission", "scope", "audiences", "groups", "roles", "permissions", "scopes"})) {
            Collection list = (Collection)value;
            for (Object listVal : list) {
                this.withClaim(name, listVal);
            }
            return this;
        }
        switch (lc) {
            case "group": 
            case "groups": {
                this.withGroups((String)value);
                return this;
            }
            case "role": 
            case "roles": {
                this.withRoles((String)value);
                return this;
            }
            case "permission": 
            case "permissions": {
                this.withPermissions((String)value);
                return this;
            }
            case "scope": 
            case "scopes": {
                this.withScopes((String)value);
                return this;
            }
            case "audiences": {
                this.withAudiences((String)value);
                return this;
            }
        }
        Field f = Utils.getField((String)name, this.getClass());
        if (f != null) {
            try {
                f.set(this, value.toString());
                return this;
            }
            catch (Exception ex) {
                Utils.rethrow((Throwable)ex);
            }
        }
        this.claims.put(name, value);
        return this;
    }

    public Object getClaim(String name) {
        if ("iss".equalsIgnoreCase(name)) {
            name = "issuer";
        } else if ("aud".equalsIgnoreCase(name)) {
            name = "audiences";
        } else if ("sub".equalsIgnoreCase(name)) {
            name = "subject";
        } else if ("scp".equalsIgnoreCase(name)) {
            name = "scopes";
        } else if ("rol".equalsIgnoreCase(name)) {
            name = "roles";
        } else if ("prm".equalsIgnoreCase(name)) {
            name = "permissions";
        }
        Field f = Utils.getField((String)name, this.getClass());
        if (f != null) {
            try {
                Object claim = f.get(this);
                if (claim instanceof Set) {
                    claim = this.toString((Set)claim);
                }
                return claim;
            }
            catch (Exception ex) {
                Utils.rethrow((Throwable)ex);
            }
        }
        return this.claims.get(name);
    }

    @JsonProperty(value="iss")
    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    @JsonProperty(value="sub")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getAccount() {
        return this.account;
    }

    public User withAccount(String account) {
        this.account = account;
        return this;
    }

    @JsonProperty(value="aud")
    public String getAudiences() {
        return this.toString(this.audiences);
    }

    public void setAudiences(String audiences) {
        this.audiences = this.fromString(audiences);
    }

    public boolean hasAudience(String ... audiences) {
        if (audiences == null) {
            return true;
        }
        for (String audience : Utils.explode((String)",", (String[])audiences)) {
            if (this.audiences.contains(audience)) continue;
            return false;
        }
        return true;
    }

    public User withAudiences(String ... audiences) {
        if (audiences != null) {
            this.audiences.addAll(Utils.explode((String)",", (String[])audiences));
        }
        return this;
    }

    @JsonProperty(value="prm")
    public String getPermissions() {
        return this.toString(this.permissions);
    }

    public void setPermissions(String permissions) {
        this.permissions = this.fromString(permissions);
    }

    public boolean hasPermissions(String ... permissions) {
        if (permissions == null) {
            return true;
        }
        for (String permission : Utils.explode((String)",", (String[])permissions)) {
            if (this.permissions.contains(permission)) continue;
            return false;
        }
        return true;
    }

    public User withPermissions(String ... permissions) {
        if (permissions != null) {
            this.permissions.addAll(Utils.explode((String)",", (String[])permissions));
        }
        return this;
    }

    @JsonIgnore
    public String getGroups() {
        return this.toString(this.groups);
    }

    public void setGroups(String groups) {
        this.groups = this.fromString(groups);
    }

    public boolean hasGroups(String ... groups) {
        if (groups == null) {
            return true;
        }
        for (String group : groups) {
            if (this.groups.contains(group)) continue;
            return false;
        }
        return true;
    }

    public User withGroups(String ... groups) {
        if (groups != null) {
            this.groups.addAll(Utils.explode((String)",", (String[])groups));
        }
        return this;
    }

    @JsonProperty(value="rol")
    public String getRoles() {
        return this.toString(this.roles);
    }

    public void setRoles(String roles) {
        this.roles = this.fromString(roles);
    }

    public boolean hasRoles(String ... roles) {
        if (roles == null) {
            return true;
        }
        for (String role : roles) {
            if (this.roles.contains(role)) continue;
            return false;
        }
        return true;
    }

    public User withRoles(String ... roles) {
        if (roles != null) {
            Collections.addAll(this.roles, roles);
        }
        return this;
    }

    public String getScopes() {
        return this.toString(this.scopes);
    }

    @JsonProperty(value="scp")
    public void setScopes(String scopes) {
        this.scopes = this.fromString(scopes);
    }

    public boolean hasScope(String ... scopes) {
        if (scopes == null) {
            return true;
        }
        for (String permission : Utils.explode((String)",", (String[])scopes)) {
            if (this.scopes.contains(scopes)) continue;
            return false;
        }
        return true;
    }

    public User withScopes(String ... scopes) {
        if (scopes != null) {
            this.scopes.addAll(Utils.explode((String)",", (String[])scopes));
        }
        return this;
    }

    String toString(Set<String> c) {
        StringBuilder builder = new StringBuilder();
        c.forEach(str -> builder.append((String)str).append(" "));
        return builder.toString().trim();
    }

    LinkedHashSet<String> fromString(String str) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String part : str.split(" ")) {
            set.add(part.trim());
        }
        return set;
    }
}

