/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.utils;

import io.inversion.ApiException;
import io.inversion.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class Path {
    List<String> parts = new ArrayList<String>();
    List<String> lc = new ArrayList<String>();

    public Path() {
    }

    public Path(Path path) {
        this.parts.addAll(path.parts);
        this.lc.addAll(path.lc);
    }

    public Path(String ... part) {
        this.parts = Utils.explode("/", part);
        this.lc = new ArrayList<String>(this.parts.size());
        for (String s : this.parts) {
            this.lc.add(s.toLowerCase());
        }
    }

    public Path(List<String> parts) {
        this(parts.toArray(new String[0]));
    }

    public List<String> parts() {
        return new ArrayList<String>(this.parts);
    }

    public String first() {
        if (this.parts.size() > 0) {
            return this.parts.get(0);
        }
        return null;
    }

    public String last() {
        if (this.parts.size() > 0) {
            return this.parts.get(this.parts.size() - 1);
        }
        return null;
    }

    public String get(int index) {
        if (index < this.parts.size()) {
            return this.parts.get(index);
        }
        return null;
    }

    public void add(String parts) {
        if (!Utils.empty(parts)) {
            for (String part : Utils.explode("/", parts)) {
                this.parts.add(part);
                this.lc.add(part.toLowerCase());
            }
        }
    }

    public String remove(int index) {
        if (index < this.parts.size()) {
            this.lc.remove(index);
            return this.parts.remove(index);
        }
        return null;
    }

    public boolean startsWith(List<String> partsToMatch) {
        if (partsToMatch.size() > this.parts.size()) {
            return false;
        }
        for (int i = 0; i < partsToMatch.size(); ++i) {
            if (partsToMatch.get(i).equalsIgnoreCase(this.parts.get(i))) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.parts.size();
    }

    public String toString() {
        return Utils.implode("/", this.parts);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Path)) {
            return false;
        }
        return o.toString().equals(this.toString());
    }

    public Path subpath(int fromIndex, int toIndex) {
        return new Path(this.parts.subList(fromIndex, toIndex));
    }

    public boolean isStatic(int index) {
        return !this.isWildcard(index) && !this.isVar(index) && !this.isOptional(index);
    }

    public boolean isWildcard(int index) {
        return "*".equals(this.get(index));
    }

    public boolean isVar(int index) {
        String part = this.get(index);
        if (part != null) {
            char c;
            if (part.startsWith("[")) {
                part = part.substring(1).trim();
            }
            return (c = part.charAt(0)) == '$' || c == ':' || c == '{';
        }
        return false;
    }

    public String getVarName(int index) {
        String part = this.get(index);
        if (part != null) {
            int colon;
            if (part.startsWith("[")) {
                part = part.substring(1, part.length() - 1).trim();
            }
            if ((colon = part.indexOf(":")) == 0) {
                return part.substring(1).trim();
            }
            if (part.startsWith("{") && colon > 1) {
                return part.substring(1, colon).trim();
            }
        }
        return null;
    }

    public boolean isOptional(int index) {
        String part = this.get(index);
        if (part != null) {
            return part.startsWith("[") && part.endsWith("]");
        }
        return false;
    }

    public boolean matches(String toMatch) {
        return this.matches(new Path(toMatch));
    }

    public boolean matches(Path concretePath) {
        Path matchedPath = new Path();
        if (this.size() < concretePath.size() && !"*".equals(this.last())) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            boolean optional;
            String myPart = this.get(i);
            if (i == this.size() - 1 && myPart.equals("*")) {
                return true;
            }
            boolean bl = optional = myPart.startsWith("[") && myPart.endsWith("]");
            if (i == concretePath.size()) {
                return optional;
            }
            if (optional) {
                myPart = myPart.substring(1, myPart.length() - 1);
            }
            String theirPart = concretePath.get(i);
            matchedPath.add(theirPart);
            if (myPart.startsWith(":")) continue;
            if ((myPart.startsWith("{") || myPart.startsWith("${")) && myPart.endsWith("}")) {
                String regex;
                Pattern pattern;
                int nameStart = myPart.indexOf("{") + 1;
                int endName = myPart.indexOf(":");
                if (endName < 0) {
                    endName = myPart.length() - 1;
                }
                String name = myPart.substring(nameStart, endName).trim();
                if (endName >= myPart.length() - 1 || (pattern = Pattern.compile(regex = myPart.substring(endName + 1, myPart.length() - 1), 2)).matcher(theirPart).matches()) continue;
                return false;
            }
            if (myPart.equalsIgnoreCase(theirPart)) continue;
            return false;
        }
        return true;
    }

    public Path extract(Map params, Path toMatch) {
        return this.extract(params, toMatch, false);
    }

    public Path extract(Map params, Path matchingConcretePath, boolean greedy) {
        int i;
        Path matchedPath = new Path();
        boolean restOptional = false;
        int nextOptional = 0;
        for (i = 0; i < this.size() && matchingConcretePath.size() > 0; ++i) {
            String theirPart;
            boolean partOptional;
            String myPart = this.get(i);
            boolean bl = partOptional = myPart.startsWith("[") && myPart.endsWith("]");
            if (partOptional) {
                restOptional = true;
                myPart = myPart.substring(1, myPart.length() - 1);
            }
            if (myPart.equals("*")) break;
            if (greedy || !restOptional) {
                theirPart = matchingConcretePath.remove(0);
                matchedPath.add(theirPart);
            } else {
                theirPart = matchingConcretePath.get(nextOptional++);
            }
            if (myPart.startsWith(":")) {
                String name = myPart.substring(1).trim();
                params.put(name, theirPart);
                continue;
            }
            if ((myPart.startsWith("{") || myPart.startsWith("${")) && myPart.endsWith("}")) {
                String regex;
                Pattern pattern;
                int nameStart = myPart.indexOf("{") + 1;
                int endName = myPart.indexOf(":");
                if (endName < 0) {
                    endName = myPart.length() - 1;
                }
                String name = myPart.substring(nameStart, endName).trim();
                if (endName < myPart.length() - 1 && !(pattern = Pattern.compile(regex = myPart.substring(endName + 1, myPart.length() - 1), 2)).matcher(theirPart).matches()) {
                    throw ApiException.new500InternalServerError("Attempting to extract values from an unmatched path: '{}', '{}'", this.parts.toString(), matchingConcretePath.toString());
                }
                params.put(name, theirPart);
                continue;
            }
            if (myPart.equalsIgnoreCase(theirPart)) continue;
            throw ApiException.new500InternalServerError("Attempting to extract values from an unmatched path: '{}', '{}'", this.parts.toString(), matchingConcretePath.toString());
        }
        while (i < this.size()) {
            String var = this.getVarName(i);
            if (var != null) {
                params.put(var, null);
            }
            ++i;
        }
        return matchedPath;
    }
}

