/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.rql;

import io.inversion.rql.RqlTokenizer;
import io.inversion.rql.Term;
import io.inversion.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public class RqlParser {
    private RqlParser() {
    }

    public static Term parse(String paramName, String paramValue) {
        String termStr;
        if (Utils.empty(paramValue) && paramName.contains("(")) {
            termStr = paramName;
        } else {
            if (Utils.empty(paramValue)) {
                paramValue = "true";
            }
            termStr = "eq(" + paramName + "," + paramValue + ")";
        }
        Term term = RqlParser.parse(termStr);
        return term;
    }

    public static Term parse(String clause) {
        String token;
        TermBuilder tb = new TermBuilder();
        RqlTokenizer t = new RqlTokenizer(clause);
        while ((token = t.next()) != null) {
            String func;
            String lc = token.toLowerCase();
            String string = func = lc.endsWith("(") ? lc.substring(0, lc.length() - 1) : null;
            if (func != null) {
                tb.push(Term.term(null, func, new Object[0]));
                continue;
            }
            if (")".equals(lc)) {
                tb.pop();
                continue;
            }
            if ("=".equals(lc)) {
                Term top = tb.top();
                List<Term> children = top.getTerms();
                if ("eq".equalsIgnoreCase(top.getToken()) && children.size() == 2) {
                    top.withToken(children.get(1).getToken());
                    top.removeTerm(children.get(1));
                    continue;
                }
                tb.top().withToken("eq");
                continue;
            }
            tb.top().withTerm(Term.term(null, token, new Object[0]));
        }
        Term root = tb.root();
        if ("NULL".equals(root.getToken())) {
            Term child = root.getTerm(0);
            child.withParent(null);
            root = child;
        }
        return root;
    }

    static class TermBuilder {
        final List<Term> terms = new ArrayList<Term>();
        Term root = null;

        TermBuilder() {
        }

        public Term top() {
            if (this.terms.size() == 0) {
                if (this.root == null) {
                    this.root = Term.term(null, null, new Object[0]);
                }
                this.terms.add(this.root);
            }
            return this.terms.get(this.terms.size() - 1);
        }

        public void push(Term term) {
            if (this.root == null) {
                this.root = term;
            } else {
                this.top().withTerm(term);
            }
            this.terms.add(term);
        }

        public void push(String token) {
            this.top().withToken(token);
        }

        public void pop() {
            if (this.terms.size() > 0) {
                this.terms.remove(this.terms.size() - 1);
            }
        }

        public Term root() {
            return this.root;
        }
    }
}

