/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.action.db;

import io.inversion.Action;
import io.inversion.ApiException;
import io.inversion.Chain;
import io.inversion.Change;
import io.inversion.Collection;
import io.inversion.Index;
import io.inversion.Relationship;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.rql.Term;
import io.inversion.utils.JSArray;
import io.inversion.utils.JSNode;
import io.inversion.utils.Rows;
import io.inversion.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.apache.commons.collections4.map.MultiKeyMap;

public class DbPostAction
extends Action<DbPostAction> {
    protected boolean collapseAll = false;
    protected boolean strictRest = false;
    protected boolean getResponse = true;

    public static String nextPath(String path, String next) {
        return Utils.empty(path) ? next : path + "." + next;
    }

    @Override
    public void run(Request req, Response res) throws ApiException {
        if (req.isMethod("PUT", "POST")) {
            this.upsert(req, res);
        } else if (req.isMethod("PATCH")) {
            this.patch(req, res);
        } else {
            throw ApiException.new400BadRequest("Method '%' is not supported by RestPostHandler", new Object[0]);
        }
    }

    public void patch(Request req, Response res) throws ApiException {
        List<String> resourceKeys;
        JSNode body = req.getJson();
        if (body == null) {
            throw ApiException.new400BadRequest("You must pass a JSON body on a {}", req.getMethod());
        }
        if (body.find("meta") instanceof JSNode && body.find("data") instanceof JSArray) {
            body = body.findNode("data");
        }
        if (body instanceof JSArray && ((JSArray)body).length() == 1 && ((JSArray)body).get(0) instanceof JSNode) {
            body = ((JSArray)body).getNode(0);
        }
        if (body.isArray()) {
            if (!Utils.empty(req.getResourceKey())) {
                throw ApiException.new400BadRequest("You can't batch '{}' an array of objects to a specific resource url.  You must '{}' them to a collection.", req.getMethod(), req.getMethod());
            }
        } else {
            String href = body.getString("href");
            if (req.getResourceKey() != null) {
                if (href == null) {
                    body.put("href", (Object)Utils.substringBefore(req.getUrl().toString(), "?"));
                } else if (!req.getUrl().toString().startsWith(href)) {
                    throw ApiException.new400BadRequest("You are PATCHING-ing an resource with a different href property than the resource URL you are PATCHING-ing to.", new Object[0]);
                }
            }
        }
        if ((resourceKeys = req.getCollection().getDb().patch(req.getCollection(), req.getJson().asNodeList())).size() > 0) {
            res.withStatus("201 Created");
            String location = Chain.buildLink(req.getCollection(), Utils.implode(",", resourceKeys), null);
            res.withHeader("Location", location);
            if (this.isGetResponse()) {
                Response getResponse = req.getChain().getEngine().service("GET", location);
                res.getJson().put("data", (Object)getResponse.getData());
            }
        } else {
            res.withStatus("404 Not Found");
        }
    }

    public void upsert(Request req, Response res) throws ApiException {
        List<String> resourceKeys;
        if (this.strictRest) {
            if (req.isPost() && req.getResourceKey() != null) {
                throw ApiException.new404NotFound("You are trying to POST to a specific resource url.  Set 'strictRest' to false to interpret PUT vs POST intention based on presense of 'href' property in passed in JSON", new Object[0]);
            }
            if (req.isPut() && req.getResourceKey() == null) {
                throw ApiException.new404NotFound("You are trying to PUT to a collection url.  Set 'strictRest' to false to interpret PUT vs POST intention based on presense of 'href' property in passed in JSON", new Object[0]);
            }
        }
        Collection collection = req.getCollection();
        ArrayList<Change> changes = new ArrayList<Change>();
        JSNode body = req.getJson();
        if (body.find("meta") instanceof JSNode && body.find("data") instanceof JSArray) {
            body = body.findNode("data");
        }
        if (body instanceof JSArray && ((JSArray)body).length() == 1 && ((JSArray)body).get(0) instanceof JSNode) {
            body = ((JSArray)body).getNode(0);
        }
        boolean collapseAll = "true".equalsIgnoreCase(req.getChain().getConfig("collapseAll", this.collapseAll + ""));
        Set<String> collapses = req.getChain().mergeEndpointActionParamsConfig("collapses");
        if (collapseAll || collapses.size() > 0) {
            body = JSNode.parseJsonNode(body.toString());
            DbPostAction.collapse(body, collapseAll, collapses, "");
        }
        if (body instanceof JSArray) {
            if (!Utils.empty(req.getResourceKey())) {
                throw ApiException.new400BadRequest("You can't batch '{}' an array of objects to a specific resource url.  You must '{}' them to a collection.", req.getMethod(), req.getMethod());
            }
            resourceKeys = this.upsert(req, collection, (JSArray)body);
        } else {
            String href = body.getString("href");
            if (req.isPut() && href != null && req.getResourceKey() != null && !req.getUrl().toString().startsWith(href)) {
                throw ApiException.new400BadRequest("You are PUT-ing an resource with a different href property than the resource URL you are PUT-ing to.", new Object[0]);
            }
            resourceKeys = this.upsert(req, collection, new JSArray(new Object[]{body}));
        }
        res.withChanges(changes);
        StringBuilder buff = new StringBuilder();
        for (String key : resourceKeys) {
            String resourceKey = key + "";
            String href = Chain.buildLink(collection, resourceKey, null);
            res.data().add(new JSNode("href", href));
            String nextId = href.substring(href.lastIndexOf("/") + 1);
            buff.append(",").append(nextId);
        }
        if (buff.length() > 0) {
            res.withStatus("201 Created");
            String location = Chain.buildLink(collection, buff.substring(1, buff.length()), null);
            res.withHeader("Location", location);
            if (this.isGetResponse()) {
                Response getResponse = req.getChain().getEngine().service("GET", location);
                res.getJson().put("data", (Object)getResponse.getData());
            }
        } else {
            res.withStatus("204 No Content");
        }
    }

    protected List<String> upsert(Request req, Collection collection, JSArray nodes) {
        System.out.println("UPSERT: " + collection.getName() + ":\r\n" + nodes);
        List<String> returnList = collection.getDb().upsert(collection, nodes.asList());
        for (int i = 0; i < nodes.length(); ++i) {
            if (nodes.getNode(i).get("href") != null) continue;
            String newHref = Chain.buildLink(collection, returnList.get(i) + "", null);
            nodes.getNode(i).put("href", (Object)newHref);
        }
        for (Relationship rel : collection.getRelationships()) {
            Relationship inverse = rel.getInverse();
            Iterator<JSNode> childNodes = new ArrayList();
            for (JSNode node : nodes.asNodeList()) {
                Object value = node.get(rel.getName());
                if (value instanceof JSArray) {
                    JSArray childArr = (JSArray)value;
                    for (int i = 0; i < childArr.size(); ++i) {
                        Object child = childArr.get(i);
                        if (child == null) continue;
                        if (child instanceof String && rel.isOneToMany()) {
                            child = new JSArray(child);
                            childArr.set(i, child);
                        }
                        if (!(child instanceof JSNode)) continue;
                        JSNode childNode = (JSNode)child;
                        if (rel.isOneToMany()) {
                            childNode.put(inverse.getName(), (Object)node.getString("href"));
                        }
                        childNodes.add(childNode);
                    }
                    continue;
                }
                if (!(value instanceof JSNode)) continue;
                JSNode childNode = (JSNode)value;
                childNodes.add(childNode);
            }
            if (childNodes.size() <= 0) continue;
            String path = Chain.buildLink(rel.getRelated(), null, null);
            Response res = req.getEngine().post(path, new JSArray(childNodes));
            if (!res.isSuccess() || res.getData().length() != childNodes.size()) {
                res.rethrow();
            }
            JSArray data = res.getData();
            for (int i = 0; i < data.length(); ++i) {
                String childHref = ((JSNode)data.get(i)).getString("href");
                ((JSNode)childNodes.get(i)).put("href", (Object)childHref);
            }
        }
        for (Relationship rel : collection.getRelationships()) {
            ArrayList<Map<String, Object>> updatedRows = new ArrayList<Map<String, Object>>();
            if (!rel.isManyToOne()) continue;
            for (JSNode node : nodes.asNodeList()) {
                Map<String, Object> primaryKey = collection.getDb().getKey(collection, node);
                Map<String, Object> foreignResourceKey = collection.getDb().getKey(rel.getRelated(), node.get(rel.getName()));
                Index foreignIdx = rel.getFkIndex1();
                Index relatedPrimaryIdx = rel.getRelated().getPrimaryIndex();
                Object docChild = node.get(rel.getName());
                if (!(docChild instanceof JSNode)) continue;
                HashMap<String, Object> updatedRow = new HashMap<String, Object>();
                updatedRows.add(updatedRow);
                updatedRow.putAll(primaryKey);
                if (foreignIdx.size() != relatedPrimaryIdx.size() && foreignIdx.size() == 1) {
                    updatedRow.put(foreignIdx.getProperty(0).getColumnName(), rel.getRelated().encodeResourceKey(foreignResourceKey));
                    continue;
                }
                Map<String, Object> foreignKey = collection.getDb().mapTo(foreignResourceKey, rel.getRelated().getPrimaryIndex(), rel.getFkIndex1());
                updatedRow.putAll(foreignKey);
            }
            if (updatedRows.size() <= 0) continue;
            collection.getDb().doPatch(collection, updatedRows);
        }
        MultiKeyMap keepRels = new MultiKeyMap();
        for (Relationship rel : collection.getRelationships()) {
            if (rel.isManyToOne()) continue;
            for (JSNode node : nodes.asNodeList()) {
                if (!node.hasProperty(rel.getName()) || node.get(rel.getName()) instanceof String) continue;
                String href = node.getString("href");
                if (href == null) {
                    throw ApiException.new500InternalServerError("The child href should not be null at this point, this looks like an algorithm error.", new Object[0]);
                }
                Rows.Row parentPk = collection.decodeResourceKey(href);
                Map<String, Object> parentKey = collection.getDb().mapTo(parentPk, collection.getPrimaryIndex(), rel.getFkIndex1());
                keepRels.put((Object)rel, parentKey, new ArrayList());
                JSArray childNodes = node.getArray(rel.getName());
                for (int i = 0; childNodes != null && i < childNodes.length(); ++i) {
                    Object childHref = childNodes.get(i);
                    Object object = childHref = childHref instanceof JSNode ? ((JSNode)childHref).get("href") : childHref;
                    if (Utils.empty(childHref)) continue;
                    String childEk = (String)Utils.last(Utils.explode("/", childHref.toString()));
                    Rows.Row childPk = rel.getRelated().decodeResourceKey(childEk);
                    if (rel.isOneToMany()) {
                        ((ArrayList)keepRels.get((Object)rel, parentKey)).add(childPk);
                        continue;
                    }
                    if (!rel.isManyToMany()) continue;
                    Map<String, Object> childFk = collection.getDb().mapTo(childPk, rel.getRelated().getPrimaryIndex(), rel.getFkIndex2());
                    ((ArrayList)keepRels.get((Object)rel, parentKey)).add(childFk);
                }
            }
        }
        block10: for (Map.Entry entry : keepRels.entrySet()) {
            Response toUnlink;
            Collection coll;
            Relationship rel = (Relationship)((MultiKey)entry.getKey()).getKey(0);
            Map parentKey = (Map)((MultiKey)entry.getKey()).getKey(1);
            List childKeys = (List)keepRels.get((Object)rel, (Object)parentKey);
            ArrayList<Map<String, Object>> upserts = new ArrayList<Map<String, Object>>();
            HashSet<Object> includesKeys = new HashSet<Object>();
            includesKeys.addAll(parentKey.keySet());
            includesKeys.addAll(rel.getRelated().getPrimaryIndex().getColumnNames());
            Term childNot = Term.term(null, "not", new Object[0]);
            Term childOr = Term.term(childNot, "or", new Object[0]);
            for (Map childKey : childKeys) {
                HashMap upsert = new HashMap();
                upsert.putAll(parentKey);
                upsert.putAll(childKey);
                upserts.add(upsert);
                includesKeys.addAll(childKey.keySet());
                childOr.withTerm(this.asTerm(childKey));
            }
            Collection collection2 = coll = rel.isOneToMany() ? rel.getRelated() : rel.getFk1Col1().getCollection();
            if (rel.isOneToMany()) {
                this.log.debug("updating relationship: " + rel + " -> " + coll + " -> " + upserts);
                coll.getDb().doPatch(coll, upserts);
            } else if (rel.isManyToMany()) {
                this.log.debug("updating relationship: " + rel + " -> " + coll + " -> " + upserts);
                coll.getDb().doUpsert(coll, upserts);
            }
            HashMap<String, String> queryTerms = new HashMap<String, String>();
            queryTerms.put("limit", "100");
            queryTerms.put("includes", Utils.implode(",", includesKeys));
            for (Object parentKeyProp : parentKey.keySet()) {
                queryTerms.put(parentKeyProp.toString(), parentKey.get(parentKeyProp).toString());
            }
            if (childOr.size() > 0) {
                queryTerms.put(childNot.toString(), null);
            }
            String next = Chain.buildLink(coll);
            do {
                this.log.debug("...looking for one-to-many and many-to-many foreign keys: " + rel + " -> " + queryTerms);
                toUnlink = req.getEngine().get(next, queryTerms).assertOk(new String[0]);
                if (toUnlink.data().length() == 0) continue block10;
                if (rel.isOneToMany()) {
                    for (JSNode jSNode : toUnlink.data().asNodeList()) {
                        for (String prop : rel.getFkIndex1().getJsonNames()) {
                            jSNode.put(prop, (Object)null);
                        }
                    }
                    req.getEngine().patch(Chain.buildLink(coll), toUnlink.data());
                    continue;
                }
                if (!rel.isManyToMany()) continue;
                ArrayList<String> resourceKeys = new ArrayList<String>();
                for (JSNode node3 : toUnlink.data().asNodeList()) {
                    resourceKeys.add(Utils.substringAfter(node3.getString("href"), "/"));
                }
                String string = Chain.buildLink(coll) + "/" + Utils.implode(",", resourceKeys);
                req.getEngine().delete(string);
            } while (toUnlink.data().size() >= 100);
        }
        return returnList;
    }

    Term asTerm(Map row) {
        Term t = null;
        for (Object key : row.keySet()) {
            Object value = row.get(key);
            if (t == null) {
                t = Term.term(null, "eq", key, value);
                continue;
            }
            if (!t.hasToken("and")) {
                t = Term.term(null, "and", t);
            }
            t.withTerm(Term.term(t, "eq", key, value));
        }
        return t;
    }

    public boolean isCollapseAll() {
        return this.collapseAll;
    }

    public DbPostAction withCollapseAll(boolean collapseAll) {
        this.collapseAll = collapseAll;
        return this;
    }

    public boolean isStrictRest() {
        return this.strictRest;
    }

    public DbPostAction withStrictRest(boolean strictRest) {
        this.strictRest = strictRest;
        return this;
    }

    public boolean isGetResponse() {
        return this.getResponse;
    }

    public DbPostAction withGetResponse(boolean expandResponse) {
        this.getResponse = expandResponse;
        return this;
    }

    public static void collapse(JSNode parent, boolean collapseAll, Set collapses, String path) {
        for (String key : parent.keySet()) {
            int i;
            JSArray children;
            Object value = parent.get(key);
            if (collapseAll || collapses.contains(DbPostAction.nextPath(path, key))) {
                if (value instanceof JSArray) {
                    children = (JSArray)value;
                    if (children.length() == 0) {
                        parent.remove(key);
                    }
                    for (i = 0; i < children.length(); ++i) {
                        if (children.get(i) == null) {
                            children.remove(i);
                            --i;
                            continue;
                        }
                        if (children.get(i) instanceof JSArray || !(children.get(i) instanceof JSNode)) {
                            children.remove(i);
                            --i;
                            continue;
                        }
                        JSNode child = children.getNode(i);
                        for (String key2 : child.keySet()) {
                            if (key2.equalsIgnoreCase("href")) continue;
                            child.remove(key2);
                        }
                        if (child.keySet().size() != 0) continue;
                        children.remove(i);
                        --i;
                    }
                    if (children.length() != 0) continue;
                    parent.remove(key);
                    continue;
                }
                if (!(value instanceof JSNode)) continue;
                JSNode child = (JSNode)value;
                for (String key2 : child.keySet()) {
                    if (key2.equalsIgnoreCase("href")) continue;
                    child.remove(key2);
                }
                if (child.keySet().size() != 0) continue;
                parent.remove(key);
                continue;
            }
            if (value instanceof JSArray) {
                children = (JSArray)value;
                for (i = 0; i < children.length(); ++i) {
                    if (!(children.get(i) instanceof JSNode) || children.get(i) instanceof JSArray) continue;
                    DbPostAction.collapse(children.getNode(i), collapseAll, collapses, DbPostAction.nextPath(path, key));
                }
                continue;
            }
            if (!(value instanceof JSNode)) continue;
            DbPostAction.collapse((JSNode)value, collapseAll, collapses, DbPostAction.nextPath(path, key));
        }
    }
}

