/*
 * Decompiled with CFR 0.152.
 */
package io.inversion;

import io.inversion.Action;
import io.inversion.Api;
import io.inversion.ApiException;
import io.inversion.Collection;
import io.inversion.Endpoint;
import io.inversion.Engine;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.User;
import io.inversion.utils.JSArray;
import io.inversion.utils.JSNode;
import io.inversion.utils.Path;
import io.inversion.utils.Url;
import io.inversion.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.collections4.map.CaseInsensitiveMap;

public class Chain {
    static ThreadLocal<Stack<Chain>> chainLocal = new ThreadLocal();
    protected final Engine engine;
    protected final List<ActionMatch> actions = new ArrayList<ActionMatch>();
    protected final Request request;
    protected final Response response;
    protected final CaseInsensitiveMap<String, Object> vars = new CaseInsensitiveMap();
    protected int next = 0;
    protected boolean canceled = false;
    protected User user = null;
    protected Chain parent = null;
    protected Map<String, String> pathParams = new HashMap<String, String>();
    protected Set<String> pathParamsToRemove = new HashSet<String>();

    private Chain(Engine engine, Request req, Response res) {
        this.engine = engine;
        this.request = req;
        this.response = res;
    }

    public static void resetAll() {
        chainLocal = new ThreadLocal();
    }

    protected static Stack<Chain> get() {
        Stack<Chain> stack = chainLocal.get();
        if (stack == null) {
            stack = new Stack();
            chainLocal.set(stack);
        }
        return stack;
    }

    public static int getDepth() {
        return Chain.get().size();
    }

    public static Chain first() {
        Stack<Chain> stack = Chain.get();
        if (!stack.empty()) {
            return (Chain)stack.get(0);
        }
        return null;
    }

    public static Chain top() throws ApiException {
        Stack<Chain> stack = Chain.get();
        if (!stack.empty()) {
            return stack.peek();
        }
        throw ApiException.new500InternalServerError("Attempting to call Chain.top() when there is no Chain on the ThreadLocal.", new Object[0]);
    }

    public static Chain peek() {
        Stack<Chain> stack = Chain.get();
        if (!stack.empty()) {
            return stack.peek();
        }
        return null;
    }

    public static Chain push(Engine engine, Request req, Response res) {
        Chain child = new Chain(engine, req, res);
        Chain parent = Chain.peek();
        if (parent != null) {
            child.setParent(parent);
        }
        req.withChain(child);
        Chain.get().push(child);
        return child;
    }

    public static Chain pop() {
        return Chain.get().pop();
    }

    public static User getUser() {
        Chain chain = Chain.peek();
        if (chain != null) {
            do {
                if (chain.user == null) continue;
                return chain.user;
            } while ((chain = chain.parent) != null);
        }
        return null;
    }

    public static int size() {
        return Chain.get().size();
    }

    public static void debug(Object ... msgs) {
        Stack<Chain> stack = Chain.get();
        if (stack.size() < 1) {
            return;
        }
        StringBuilder prefix = new StringBuilder("[" + stack.size() + "]: ");
        for (int i = 1; i < stack.size(); ++i) {
            prefix.append("   ");
        }
        if (msgs != null && msgs.length == 1 && msgs[0].toString().trim().length() == 0) {
            return;
        }
        Chain root = (Chain)stack.get(0);
        root.response.debug(prefix.toString(), msgs);
    }

    public static String buildLink(Collection collection) {
        return Chain.buildLink(collection, null, null);
    }

    public static String buildLink(Collection collection, Object resourceKey, String subCollectionKey) {
        String proto;
        StringBuilder url;
        Request req = Chain.top().getRequest();
        String collectionKey = collection.getName();
        if (req.getCollection() == collection) {
            collectionKey = req.getCollectionKey();
        }
        if (!Utils.endsWith(url = new StringBuilder(Utils.empty(req.getApiUrl()) ? "" : req.getApiUrl()), "/")) {
            url.append("/");
        }
        if (req.getCollection() != null && (collection == req.getCollection() || collection.getDb() == req.getCollection().getDb())) {
            Path epp = req.getEndpointPath();
            if (epp != null && epp.size() > 0) {
                url.append(epp).append("/");
            }
        } else if (collection.getDb().getEndpointPath() != null) {
            Path epP = collection.getDb().getEndpointPath();
            for (int i = 0; i < epP.size() && !epP.isWildcard(i); ++i) {
                if (epP.isVar(i)) {
                    String value;
                    String name = epP.getVarName(i);
                    switch (name.toLowerCase()) {
                        case "collection": {
                            value = collection.getName();
                            break;
                        }
                        case "resource": {
                            value = resourceKey + "";
                            break;
                        }
                        case "relationship": {
                            value = subCollectionKey;
                            break;
                        }
                        default: {
                            value = req.getUrl().getParam(name);
                        }
                    }
                    if (value == null) {
                        throw ApiException.new500InternalServerError("Unable to determine path for link to collection '{}', resource '{}', relationship '{}'", collection.getName(), resourceKey + "", subCollectionKey + "");
                    }
                    url.append(epP.get(i)).append("/");
                    continue;
                }
                url.append(epP.get(i)).append("/");
            }
            url.append(collection.getDb().getEndpointPath()).append("/");
        }
        if (!Utils.empty(collectionKey)) {
            if (!Utils.endsWith(url, "/")) {
                url.append("/");
            }
            url.append(collectionKey);
        }
        if (!Utils.empty(resourceKey)) {
            url.append("/").append(resourceKey.toString());
        }
        if (!Utils.empty(subCollectionKey)) {
            url.append("/").append(subCollectionKey);
        }
        if (req.getApi().getUrl() != null && !Utils.startsWith(url, req.getApi().getUrl())) {
            String newUrl = req.getApi().getUrl();
            while (newUrl.endsWith("/")) {
                newUrl = newUrl.substring(0, newUrl.length() - 1);
            }
            url = new StringBuilder(newUrl).append(url.substring(url.indexOf("/", 8)));
        }
        if (req.getApi() != null && Utils.empty(req.getApi().getUrl()) && !Utils.empty(proto = req.getHeader("x-forwarded-proto"))) {
            url = new StringBuilder(proto).append(url.substring(url.indexOf(":")));
        }
        return url.toString();
    }

    public Chain withUser(User user) {
        this.user = user;
        return this;
    }

    public Chain getParent() {
        return this.parent;
    }

    public void setParent(Chain parent) {
        this.parent = parent;
    }

    public void put(String key, Object value) {
        this.vars.put((Object)key, value);
    }

    public boolean isDebug() {
        if (this.parent != null) {
            return this.parent.isDebug();
        }
        return this.request.isDebug();
    }

    public Object get(String key) {
        if (this.vars.containsKey((Object)key)) {
            return this.vars.get((Object)key);
        }
        String value = this.getConfig(key);
        if (value != null) {
            return value;
        }
        if (this.parent != null) {
            return this.parent.get(key);
        }
        return null;
    }

    public Object remove(String key) {
        if (this.vars.containsKey((Object)key)) {
            return this.vars.remove((Object)key);
        }
        return this.getConfig(key + "");
    }

    public Set<String> mergeEndpointActionParamsConfig(String key) {
        int i;
        LinkedList<String> values = new LinkedList<String>();
        String value = this.request.getEndpoint().getConfig(key);
        if (value != null) {
            value = value.toLowerCase();
            values.addAll(Utils.explode(",", value));
        }
        for (i = this.next - 1; i >= 0; --i) {
            value = this.actions.get((int)i).action.getConfig(key);
            if (value == null) continue;
            value = value.toLowerCase();
            values.addAll(Utils.explode(",", value));
        }
        value = this.request.getUrl().getParam(key);
        if (value != null) {
            value = value.toLowerCase();
            values.addAll(Utils.explode(",", value));
        }
        for (i = 0; i < values.size(); ++i) {
            value = (String)values.get(i);
            value = Utils.dequote(value);
            values.set(i, value);
        }
        return new LinkedHashSet<String>(values);
    }

    public Map<String, String> getConfig() {
        HashMap<String, String> config = new HashMap<String, String>();
        for (String key : this.getConfigKeys()) {
            config.put(key, this.getConfig(key));
        }
        return config;
    }

    public Set<String> getConfigKeys() {
        Set<String> keys = this.request.getEndpoint().getConfigKeys();
        for (int i = this.next - 1; i >= 0; --i) {
            keys.addAll(this.actions.get((int)i).action.getConfigKeys());
        }
        return keys;
    }

    public int getConfig(String key, int defaultValue) {
        return Integer.parseInt(this.getConfig(key, defaultValue + ""));
    }

    public boolean getConfig(String key, boolean defaultValue) {
        return Boolean.parseBoolean(this.getConfig(key, defaultValue + ""));
    }

    public String getConfig(String key) {
        return this.getConfig(key, null);
    }

    public String getConfig(String key, String defaultValue) {
        String value;
        if (this.request == null) {
            System.out.println("The Request on the Chain is null, this should never happen");
        } else if (this.request.getEndpoint() == null) {
            System.out.println("The Endpoint on the Request is null, this should never happen");
            System.out.println(" -- Chain stack starting with this chain and then every parent after");
            for (Chain tempChain = this; tempChain != null; tempChain = tempChain.getParent()) {
                System.out.println(" ----  " + tempChain + " ::: " + tempChain.getRequest() + " ::: " + tempChain.getRequest().getUrl());
            }
        }
        for (int i = this.next - 1; i >= 0; --i) {
            value = this.actions.get((int)i).action.getConfig(key);
            if (Utils.empty(value)) continue;
            return value;
        }
        value = this.request.getEndpoint().getConfig(key);
        if (!Utils.empty(value)) {
            return value;
        }
        return defaultValue;
    }

    public void go() throws ApiException {
        boolean root;
        boolean bl = root = this.next == 0;
        if (root && this.pathParams.size() > 0) {
            this.applyPathParams(this.pathParams, this.request.getUrl(), this.request.getJson());
        }
        try {
            while (this.next()) {
            }
        }
        finally {
            if (root) {
                JSNode json = this.response.getJson();
                this.filterPathParams(json);
            }
        }
    }

    public Chain filterPathParams(JSNode json) {
        if (json != null && this.pathParams.size() > 0) {
            json.streamAll().filter(node -> node instanceof JSNode && !(node instanceof JSArray)).forEach(node -> this.pathParamsToRemove.forEach(key -> ((JSNode)node).remove(key)));
        }
        return this;
    }

    public Chain doNext(Action ... newActions) {
        for (int i = 0; newActions != null && i < newActions.length; ++i) {
            Action action = newActions[i];
            if (action == null) continue;
            ActionMatch am = new ActionMatch(new Path("*"), new Path("*"), action);
            this.actions.add(this.next + i, am);
        }
        return this;
    }

    public Chain skipNext() {
        ++this.next;
        return this;
    }

    public Action getNext() {
        if (this.hasNext()) {
            return this.actions.get((int)this.next).action;
        }
        return null;
    }

    public boolean next() throws ApiException {
        if (!this.isCanceled() && this.next < this.actions.size()) {
            ActionMatch actionMatch = this.actions.get(this.next);
            ++this.next;
            HashMap<String, String> pathParams = new HashMap<String, String>();
            actionMatch.rule.extract(pathParams, new Path(actionMatch.path));
            this.applyPathParams(pathParams, this.request.getUrl(), this.request.getJson());
            actionMatch.action.run(this.request, this.response);
            return true;
        }
        return false;
    }

    public Chain withPathParams(Map<String, String> pathParams) {
        this.pathParams.putAll(pathParams);
        return this;
    }

    public void applyPathParams(Map<String, String> pathParamsToAdd, Url url, JSNode json) {
        pathParamsToAdd.keySet().forEach(xva$0 -> url.clearParams((String)xva$0));
        pathParamsToAdd.entrySet().stream().filter(e -> e.getValue() != null).forEach(e -> url.withParam((String)e.getKey(), (String)e.getValue()));
        if (json != null) {
            json.stream().filter(node -> node instanceof JSNode && !(node instanceof JSArray)).forEach(node -> pathParamsToAdd.entrySet().stream().filter(e -> e.getValue() != null && !((String)e.getKey()).startsWith("_")).forEach(e -> ((JSNode)node).put((String)e.getKey(), e.getValue())));
        }
        this.pathParamsToRemove.addAll(pathParamsToAdd.keySet());
    }

    public boolean hasNext() {
        return !this.isCanceled() && this.next < this.actions.size();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void cancel() {
        this.canceled = true;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public Api getApi() {
        return this.request.getApi();
    }

    public Endpoint getEndpoint() {
        return this.request.getEndpoint();
    }

    public List<ActionMatch> getActions() {
        return new ArrayList<ActionMatch>(this.actions);
    }

    public Chain withActions(List<ActionMatch> actions) {
        for (ActionMatch action : actions) {
            this.withAction(action);
        }
        return this;
    }

    public Chain withAction(ActionMatch action) {
        if (action != null && !this.actions.contains(action)) {
            this.actions.add(action);
        }
        return this;
    }

    public Request getRequest() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }

    static class ActionMatch
    implements Comparable<ActionMatch> {
        final Path rule;
        final Path path;
        final Action action;

        public ActionMatch(Path rule, Path path, Action action) {
            this.rule = rule;
            this.path = path;
            this.action = action;
        }

        @Override
        public int compareTo(ActionMatch o) {
            return this.action.compareTo(o.action);
        }

        public String toString() {
            return this.rule + " " + this.path + " " + this.action;
        }
    }
}

