/*
 * Decompiled with CFR 0.152.
 */
package io.inversion;

import io.inversion.Action;
import io.inversion.Collection;
import io.inversion.Db;
import io.inversion.Endpoint;
import io.inversion.Property;
import io.inversion.Relationship;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.Rule;
import io.inversion.utils.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Api
extends Rule<Api> {
    protected final List<Db> dbs = new ArrayList<Db>();
    protected final List<Endpoint> endpoints = new ArrayList<Endpoint>();
    protected final List<Action> actions = new ArrayList<Action>();
    protected final List<Collection> collections = new ArrayList<Collection>();
    protected final transient List<ApiListener> listeners = new ArrayList<ApiListener>();
    protected transient String hash = null;
    protected boolean debug = false;
    protected String url = null;
    volatile transient boolean started = false;
    volatile transient boolean starting = false;
    transient long loadTime = 0L;

    public Api() {
    }

    public Api(String name) {
        this.withName(name);
    }

    @Override
    protected Rule.RuleMatcher getDefaultIncludeMatch() {
        ArrayList<String> parts = new ArrayList<String>();
        if (this.name != null) {
            parts.add(this.name);
        }
        parts.add("*");
        return new Rule.RuleMatcher(null, new Path(parts));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Api startup() {
        if (this.started || this.starting) {
            return this;
        }
        this.starting = true;
        try {
            for (Db db : this.dbs) {
                db.startup(this);
            }
            this.removeExcludes();
            this.started = true;
            for (ApiListener listener : this.listeners) {
                try {
                    listener.onStartup(this);
                }
                catch (Exception ex) {
                    this.log.warn("Error notifing api startup listener: " + listener, (Throwable)ex);
                }
            }
            Api api = this;
            return api;
        }
        finally {
            this.starting = false;
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    void shutdown() {
        for (Db db : this.dbs) {
            db.shutdown(this);
        }
    }

    public void removeExcludes() {
        for (Db db : this.getDbs()) {
            for (Collection coll : db.getCollections()) {
                if (coll.isExclude()) {
                    db.removeCollection(coll);
                } else {
                    for (Property col : coll.getProperties()) {
                        if (!col.isExclude()) continue;
                        coll.removeProperty(col);
                    }
                }
                for (Relationship rel : coll.getRelationships()) {
                    if (!rel.isExclude()) continue;
                    coll.removeRelationship(rel);
                }
            }
        }
    }

    public String getHash() {
        return this.hash;
    }

    public Api withHash(String hash) {
        this.hash = hash;
        return this;
    }

    public Api withCollection(Collection coll) {
        if (coll.isExclude()) {
            return this;
        }
        if (!this.collections.contains(coll)) {
            this.collections.add(coll);
        }
        return this;
    }

    public List<Collection> getCollections() {
        return Collections.unmodifiableList(this.collections);
    }

    public Collection getCollection(String name) {
        for (Collection coll : this.collections) {
            if (!name.equalsIgnoreCase(coll.getName())) continue;
            return coll;
        }
        return null;
    }

    public Db getDb(String name) {
        if (name == null) {
            return null;
        }
        for (Db db : this.dbs) {
            if (!name.equalsIgnoreCase(db.getName())) continue;
            return db;
        }
        return null;
    }

    public List<Db> getDbs() {
        return new ArrayList<Db>(this.dbs);
    }

    public Api withDbs(Db ... dbs) {
        for (Db db : dbs) {
            this.withDb(db);
        }
        return this;
    }

    public <T extends Db> Api withDb(Db<T> db) {
        if (!this.dbs.contains(db)) {
            this.dbs.add(db);
            for (Collection coll : db.getCollections()) {
                this.withCollection(coll);
            }
        }
        return this;
    }

    public long getLoadTime() {
        return this.loadTime;
    }

    public void setLoadTime(long loadTime) {
        this.loadTime = loadTime;
    }

    public List<Endpoint> getEndpoints() {
        return new ArrayList<Endpoint>(this.endpoints);
    }

    public Api withEndpoint(String methods, String includePaths, Action ... actions) {
        Endpoint endpoint = new Endpoint(methods, includePaths, actions);
        this.withEndpoint(endpoint);
        return this;
    }

    public Api withEndpoint(Endpoint ... endpoints) {
        for (Endpoint endpoint : endpoints) {
            if (this.endpoints.contains(endpoint)) continue;
            boolean inserted = false;
            for (int i = 0; i < this.endpoints.size(); ++i) {
                if (endpoint.getOrder() >= this.endpoints.get(i).getOrder()) continue;
                this.endpoints.add(i, endpoint);
                inserted = true;
                break;
            }
            if (inserted) continue;
            this.endpoints.add(endpoint);
        }
        return this;
    }

    public Api withRelationship(String parentCollectionName, String parentPropertyName, String childCollectionName, String childPropertyName, String ... childFkProps) {
        Collection parentCollection = this.getCollection(parentCollectionName);
        Collection childCollection = this.getCollection(childCollectionName);
        parentCollection.withOneToManyRelationship(parentPropertyName, childCollection, childPropertyName, childFkProps);
        return this;
    }

    public Api withRelationship(Collection parentCollection, String parentPropertyName, Collection childCollection, String childPropertyName, Property ... childFkProps) {
        parentCollection.withOneToManyRelationship(parentPropertyName, childCollection, childPropertyName, childFkProps);
        return this;
    }

    public List<Action> getActions() {
        return new ArrayList<Action>(this.actions);
    }

    public synchronized Api withActions(Action ... actions) {
        for (Action action : actions) {
            if (this.actions.contains(action)) continue;
            this.actions.add(action);
        }
        return this;
    }

    public Api withAction(Action action) {
        if (!this.actions.contains(action)) {
            this.actions.add(action);
        }
        return this;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getUrl() {
        return this.url;
    }

    public Api withUrl(String url) {
        this.url = url;
        return this;
    }

    public Api withApiListener(ApiListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
        return this;
    }

    public List<ApiListener> getApiListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public static interface ApiListener {
        default public void onStartup(Api api) {
        }

        default public void onShutdown(Api api) {
        }

        default public void afterRequest(Request req, Response res) {
        }

        default public void afterError(Request req, Response res) {
        }

        default public void beforeFinally(Request req, Response res) {
        }
    }
}

