/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.utils;

import io.inversion.Api;
import io.inversion.ApiException;
import io.inversion.Collection;
import io.inversion.Db;
import io.inversion.Endpoint;
import io.inversion.Engine;
import io.inversion.Index;
import io.inversion.Property;
import io.inversion.Relationship;
import io.inversion.Rule;
import io.inversion.action.db.DbAction;
import io.inversion.utils.JSNode;
import io.inversion.utils.Path;
import io.inversion.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.configuration2.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configurator {
    public static final Object[] MASKED_FIELDS = new Object[]{"pass", "password", "credentials", "secret", "secretkey"};
    public static final String MASK = "**************";
    static final Logger log = LoggerFactory.getLogger(Configurator.class);
    static final String ROOT_BEAN_NAME = "inversion";

    public synchronized void configure(Engine engine, Configuration configuration) {
        try {
            HashMap<String, String> configProps = new HashMap<String, String>();
            Iterator keys = configuration.getKeys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                configProps.put(key, configuration.getString(key));
            }
            Configurator.dump("all config properties", configProps);
            Encoder primaryEncoder = new Encoder();
            primaryEncoder.encode(engine);
            Configurator.dump("properties found by encoding initial model", primaryEncoder.props);
            HashMap<String, Object> beans = new HashMap<String, Object>();
            for (Object object : primaryEncoder.names.keySet()) {
                beans.put(primaryEncoder.names.get(object), object);
            }
            Decoder primaryDecoder = new Decoder();
            primaryDecoder.beans.putAll(beans);
            primaryDecoder.decode(configProps);
            Configurator.dump("properties applied in primary decoding", primaryDecoder.applied);
            if (primaryDecoder.findBeans(Api.class).size() == 0) {
                primaryDecoder.beans.put("api", new Api());
            }
            for (Api api : primaryDecoder.findBeans(Api.class)) {
                if (engine.getApis().contains(api)) continue;
                engine.withApi(api);
            }
            for (Api api : engine.getApis()) {
                if (api.getDbs().size() <= 0 || api.getActions().size() != 0 || api.getEndpoints().size() != 0) continue;
                DbAction dbAction = new DbAction();
                Endpoint ep = new Endpoint().withAction(dbAction);
                if (primaryDecoder.getBean("endpoint") == null) {
                    primaryDecoder.beans.put("endpoint", ep);
                    ep.withName("endpoint");
                }
                if (primaryDecoder.getBean("action") == null) {
                    primaryDecoder.beans.put("action", dbAction);
                    dbAction.withName("acton");
                }
                api.withEndpoint(ep);
            }
            for (Api api : primaryDecoder.getBeans(Api.class)) {
                for (Db db : api.getDbs()) {
                    db.startup(api);
                }
            }
            Encoder encoder = new Encoder();
            encoder.encode(engine);
            Configurator.dump("re-encoded properties after db startup", encoder.props);
            beans = new HashMap();
            for (Object object : encoder.names.keySet()) {
                beans.put(encoder.names.get(object), object);
            }
            for (String string : primaryDecoder.applied.keySet()) {
                configProps.remove(string);
            }
            Decoder decoder = new Decoder();
            decoder.beans.putAll(beans);
            decoder.decode(configProps);
            for (Rule rule : decoder.getBeans(Rule.class)) {
                rule.checkLazyConfig();
            }
            Configurator.dump("properties applied on second decoding after db startup", decoder.applied);
        }
        catch (Exception e) {
            throw ApiException.new500InternalServerError(e, "Error loading configuration.", new Object[0]);
        }
    }

    static <T> T cast(String key, String stringVal, Class<T> type, Field field, Map<String, Object> beans) throws Exception {
        if (String.class.isAssignableFrom(type)) {
            return (T)stringVal;
        }
        if (Path.class.isAssignableFrom(type)) {
            return (T)new Path(stringVal);
        }
        if (Boolean.TYPE.isAssignableFrom(type)) {
            return (T)Boolean.valueOf((stringVal = stringVal.toLowerCase()).equals("true") || stringVal.equals("t") || stringVal.equals("1"));
        }
        if (Byte.TYPE.isAssignableFrom(type)) {
            return (T)Byte.valueOf(Byte.parseByte(stringVal));
        }
        if (Character.TYPE.isAssignableFrom(type)) {
            return (T)Character.valueOf(stringVal.charAt(0));
        }
        if (Integer.TYPE.isAssignableFrom(type)) {
            return (T)Integer.valueOf(Integer.parseInt(stringVal));
        }
        if (Long.TYPE.isAssignableFrom(type)) {
            return (T)Long.valueOf(Long.parseLong(stringVal));
        }
        if (Float.TYPE.isAssignableFrom(type)) {
            return (T)Float.valueOf(Float.parseFloat(stringVal));
        }
        if (Double.TYPE.isAssignableFrom(type)) {
            return (T)Double.valueOf(Double.parseDouble(stringVal));
        }
        if (type.isArray() || java.util.Collection.class.isAssignableFrom(type)) {
            String[] parts;
            Class subtype = null;
            if (type.isArray()) {
                subtype = Configurator.getArrayElementClass(type);
            }
            if (subtype == null && field != null) {
                subtype = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
            }
            AbstractCollection list = Set.class.isAssignableFrom(type) ? new HashSet() : new ArrayList();
            for (String part : parts = stringVal.split(",")) {
                Object val = beans.getOrDefault(part = part.trim(), part);
                if (val != null && subtype != null && !subtype.isAssignableFrom(val.getClass())) {
                    val = Configurator.cast(key, val + "", subtype, null, beans);
                }
                list.add(val);
            }
            if (type.isArray()) {
                return (T)list.toArray((Object[])Array.newInstance(subtype, list.size()));
            }
            return (T)list;
        }
        if (Map.class.isAssignableFrom(type)) {
            String[] parts;
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String part : parts = stringVal.split(",")) {
                Object val = beans.get(part);
                map.put(part, val);
            }
            return (T)map;
        }
        Object o = beans.get(stringVal);
        if (o != null && type.isAssignableFrom(o.getClass())) {
            return (T)o;
        }
        if (stringVal != null) {
            throw new RuntimeException("Error setting '" + key + "=" + stringVal + "'.  You must add support for type " + type + " into the Configurator");
        }
        return null;
    }

    static Class getArrayElementClass(Class arrayClass) throws ClassNotFoundException {
        String typeStr = arrayClass.toString();
        Class<Serializable> subtype = typeStr.startsWith("class [Z") ? Boolean.TYPE : (typeStr.startsWith("class [B") ? Byte.TYPE : (typeStr.startsWith("class [C") ? Character.TYPE : (typeStr.startsWith("class [I") ? Integer.TYPE : (typeStr.startsWith("class [J") ? Long.TYPE : (typeStr.startsWith("class [F") ? Float.TYPE : (typeStr.startsWith("class [D") ? Double.TYPE : Class.forName(typeStr.substring(typeStr.indexOf("[") + 2, typeStr.indexOf(";")))))))));
        return subtype;
    }

    static void dump(String title, Map<String, String> properties) {
        List<String> keys = Decoder.sort(properties.keySet());
        log.debug("-- START: " + title + " ----------------------------------------------");
        for (String key : keys) {
            String value;
            if (key.startsWith("_anonymous_") || (value = properties.get(key)) != null && value.startsWith("_anonymous_")) continue;
            log.debug("   > " + Configurator.maskOutput(key, value));
        }
        log.debug("-- END: " + title + " ----------------------------------------------");
    }

    static String maskOutput(String key, String value) {
        String field = Utils.substringAfter(key, ".").toLowerCase();
        if (Utils.in(field, MASKED_FIELDS)) {
            value = MASK;
        }
        return key + " = " + value;
    }

    static class Decoder {
        final Map<String, String> props = new HashMap<String, String>();
        final TreeSet<String> propKeys = new TreeSet();
        final Map<String, Object> beans = new HashMap<String, Object>();
        final Map<String, String> applied = new HashMap<String, String>();

        Decoder() {
        }

        public static List<String> sort(java.util.Collection keys) {
            ArrayList<String> sorted = new ArrayList<String>(keys);
            sorted.sort((o1, o2) -> {
                int count2;
                int count1 = o1.length() - o1.replace(".", "").length();
                if (count1 != (count2 = o2.length() - o2.replace(".", "").length())) {
                    return count1 > count2 ? 1 : -1;
                }
                return o1.compareTo((String)o2);
            });
            return sorted;
        }

        public void add(Map props) {
            this.props.putAll(props);
            this.propKeys.addAll(props.keySet());
        }

        public void add(String propsStr) {
            Properties props = new Properties();
            try {
                props.load(new ByteArrayInputStream(propsStr.getBytes()));
            }
            catch (Exception ex) {
                Utils.rethrow(ex);
            }
            this.add(props);
        }

        public void add(String key, String value) {
            this.props.put(key, value);
            this.propKeys.add(key);
        }

        public void decode(Map<String, String> props) throws Exception {
            this.add(props);
            this.decode();
        }

        List<String> getKeys(String beanName) {
            String key;
            HashSet<String> keys = new HashSet<String>();
            String beanPrefix = beanName + ".";
            SortedSet<String> keySet = this.propKeys.tailSet(beanPrefix);
            Iterator iterator = keySet.iterator();
            while (iterator.hasNext() && (key = (String)iterator.next()).startsWith(beanPrefix)) {
                if (key.endsWith(".class") || key.endsWith(".className") || keys.contains(beanName)) continue;
                keys.add(key);
            }
            return new ArrayList<String>(keys);
        }

        public void decode() throws Exception {
            LinkedHashMap loaded = new LinkedHashMap();
            for (String p : this.props.keySet()) {
                String key = p;
                if (key.endsWith(".class") || key.endsWith(".className")) {
                    Object obj;
                    String name = key.substring(0, key.lastIndexOf("."));
                    String cn = this.props.get(key);
                    this.applied.put(key, cn);
                    if (this.beans.containsKey(name)) {
                        obj = this.beans.get(name);
                    } else {
                        try {
                            obj = Class.forName(cn).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            Field nameField = Utils.getField("name", obj.getClass());
                            if (nameField != null) {
                                nameField.set(obj, name);
                            }
                        }
                        catch (Exception ex) {
                            System.err.println("Error instantiating class: '" + cn + "'");
                            throw ex;
                        }
                        this.beans.put(name, obj);
                    }
                    loaded.put(name, new HashMap());
                }
                if (key.lastIndexOf(".") >= 0) continue;
                this.beans.put(key, this.cast0(this.props.get(key)));
            }
            List<String> keys = new ArrayList<String>(this.beans.keySet());
            keys = Decoder.sort(keys);
            for (int i = 0; i <= 1; ++i) {
                boolean isFirstPassSoLoadOnlyPrimitives = i == 0;
                for (String beanName : keys) {
                    Object bean = this.beans.get(beanName);
                    List<String> beanKeys = this.getKeys(beanName);
                    for (String p : beanKeys) {
                        boolean valueIsBean;
                        String key = p;
                        if (key.endsWith(".class") || key.endsWith(".className") || !key.startsWith(beanName + ".") || key.lastIndexOf(".") != beanName.length()) continue;
                        String prop = key.substring(key.lastIndexOf(".") + 1);
                        String valueStr = this.props.get(key);
                        if (valueStr != null) {
                            valueStr = valueStr.trim();
                        }
                        if ("null".equalsIgnoreCase(valueStr)) {
                            valueStr = null;
                        }
                        Object value = valueStr;
                        if (!Utils.empty(valueStr) && this.beans.containsKey(valueStr)) {
                            value = this.beans.get(valueStr);
                        }
                        boolean bl = valueIsBean = value != null && !valueStr.equals("") && !valueStr.equals("null") && (this.beans.containsKey(value) || this.beans.containsKey(Utils.explode(",", valueStr).get(0)));
                        if (isFirstPassSoLoadOnlyPrimitives && valueIsBean || !isFirstPassSoLoadOnlyPrimitives && !valueIsBean) continue;
                        Field field = Utils.getField(prop, bean.getClass());
                        if (field != null) {
                            this.applied.put(key, valueStr);
                            Class<?> type = field.getType();
                            if (value == null || type.isAssignableFrom(value.getClass())) {
                                if (value == null) {
                                    if (valueStr == null || valueStr.trim().equals("") || valueStr.trim().toLowerCase().equals("null")) {
                                        field.set(bean, null);
                                        continue;
                                    }
                                    log.warn("Unable to determine value for property '{}={}'", (Object)prop, (Object)valueStr);
                                    continue;
                                }
                                field.set(bean, value);
                                continue;
                            }
                            if (java.util.Collection.class.isAssignableFrom(type)) {
                                java.util.Collection list = (java.util.Collection)Configurator.cast(key, valueStr, type, field, this.beans);
                                ((java.util.Collection)field.get(bean)).addAll(list);
                                continue;
                            }
                            if (Map.class.isAssignableFrom(type)) {
                                Map map = (Map)Configurator.cast(key, valueStr, type, null, this.beans);
                                ((Map)field.get(bean)).putAll(map);
                                continue;
                            }
                            field.set(bean, Configurator.cast(key, valueStr, type, null, this.beans));
                            continue;
                        }
                        log.debug("Can't map: " + Configurator.maskOutput(key, value + ""));
                    }
                }
            }
            for (String beanName : keys) {
                Object obj = this.beans.get(beanName);
                int count = beanName.length() - beanName.replace(".", "").length();
                if (count <= 0) continue;
                String parentKey = beanName.substring(0, beanName.lastIndexOf("."));
                String propKey = beanName.substring(beanName.lastIndexOf(".") + 1);
                if (this.beans.containsKey(parentKey) || count <= 1) continue;
                String mapKey = propKey;
                propKey = parentKey.substring(parentKey.lastIndexOf(".") + 1);
                Object parent = this.beans.get(parentKey = parentKey.substring(0, parentKey.lastIndexOf(".")));
                if (parent != null) {
                    Field field = Utils.getField(propKey, parent.getClass());
                    if (field != null) {
                        if (Map.class.isAssignableFrom(field.getType())) {
                            Map map = (Map)field.get(parent);
                            if (map.containsKey(mapKey)) continue;
                            map.put(mapKey, obj);
                            continue;
                        }
                        if (java.util.Collection.class.isAssignableFrom(field.getType())) {
                            java.util.Collection list = (java.util.Collection)field.get(parent);
                            if (list.contains(obj)) continue;
                            list.add(obj);
                            continue;
                        }
                        log.warn("Unable to set nested value: '" + beanName + "'");
                        continue;
                    }
                    log.warn("Field is not a mapped: '" + beanName + "'");
                    continue;
                }
                log.debug("Missing parent for map compression: '" + beanName + "'");
            }
        }

        public void putBean(String key, Object bean) {
            this.beans.put(key, bean);
        }

        public Object getBean(String key) {
            return this.beans.get(key);
        }

        public <T> List<T> getBeans(Class<T> type) {
            ArrayList<Object> found = new ArrayList<Object>();
            for (Object bean : this.beans.values()) {
                if (!type.isAssignableFrom(bean.getClass())) continue;
                found.add(bean);
            }
            return found;
        }

        public <T> T getBean(Class<T> type) {
            for (Object bean : this.beans.values()) {
                if (!type.isAssignableFrom(bean.getClass())) continue;
                return (T)bean;
            }
            return null;
        }

        public List findBeans(Class type) {
            ArrayList<Object> matches = new ArrayList<Object>();
            for (Object bean : this.beans.values()) {
                if (!type.isAssignableFrom(bean.getClass())) continue;
                matches.add(bean);
            }
            return matches;
        }

        protected Object cast0(String str) {
            if ("true".equalsIgnoreCase(str)) {
                return true;
            }
            if ("false".equalsIgnoreCase(str)) {
                return true;
            }
            if (str.matches("\\d+")) {
                try {
                    return Integer.parseInt(str);
                }
                catch (Exception ex) {
                    try {
                        return Long.parseLong(str);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return str;
        }
    }

    static class Encoder {
        static List<Field> excludeFields = new ArrayList<Field>();
        static List excludeTypes = Utils.asList(Logger.class, Configurator.class);
        static MultiKeyMap<String, String> defaults = new MultiKeyMap();
        private static final Set<Class<?>> STRINGIFIED_TYPES = new HashSet();
        Map<String, String> props = new HashMap<String, String>();
        Map<Object, String> names = new HashMap<Object, String>();
        Set<String> encoded = new HashSet<String>();

        Encoder() {
        }

        public String encode(Object object) throws Exception {
            return Encoder.encode0(object, this.props, this.names, defaults, this.encoded);
        }

        static String encode0(Object object, Map<String, String> props, Map<Object, String> names, MultiKeyMap defaults, Set encoded) throws Exception {
            try {
                if (object == null) {
                    return null;
                }
                if (STRINGIFIED_TYPES.contains(object.getClass())) {
                    return object + "";
                }
                String name = Encoder.getName(object, names);
                if (!encoded.contains(object)) {
                    encoded.add(object);
                    List<Field> fields = Utils.getFields(object.getClass());
                    if (!defaults.containsKey(object.getClass())) {
                        Object clean = null;
                        try {
                            for (Field field : fields) {
                                Object encodedDefault;
                                if (!Encoder.include(field)) continue;
                                if (clean == null) {
                                    clean = object.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                                }
                                try {
                                    Object defaultValue = field.get(clean);
                                    encodedDefault = new Encoder().encode(defaultValue);
                                    defaults.put(object.getClass(), (Object)field.getName(), encodedDefault);
                                }
                                catch (Exception ex) {
                                    log.debug("Unable to determine default value for {}: ", (Object)field, (Object)ex);
                                    encodedDefault = field.get(clean);
                                }
                            }
                        }
                        catch (Exception ex) {
                            defaults.put(object.getClass(), (Object)"__none", (Object)"__none");
                        }
                    }
                    for (Field field : fields) {
                        try {
                            Object defaultProp;
                            Object defaultVal;
                            if (!Encoder.include(field)) continue;
                            Object value = field.get(object);
                            String fieldKey = name + "." + field.getName();
                            if (value == null) continue;
                            if (value.getClass().isArray()) {
                                value = Utils.asList(value);
                            }
                            if (value instanceof java.util.Collection) {
                                Object defaultProp2;
                                if (((java.util.Collection)value).size() == 0) continue;
                                ArrayList<String> values = new ArrayList<String>();
                                for (Object child : (java.util.Collection)value) {
                                    String childKey = Encoder.encode0(child, props, names, defaults, encoded);
                                    values.add(childKey);
                                }
                                String encodedProp = Utils.implode(",", values);
                                if (Utils.equal(encodedProp, defaultProp2 = defaults.get(object.getClass(), (Object)field.getName()))) continue;
                                props.put(fieldKey, encodedProp);
                                continue;
                            }
                            if (value instanceof Map) {
                                Map map = (Map)value;
                                if (map.size() == 0) continue;
                                for (Object mapKey : map.keySet()) {
                                    String encodedKey = Encoder.encode0(mapKey, props, names, defaults, encoded);
                                    String encodedValue = Encoder.encode0(map.get(mapKey), props, names, defaults, encoded);
                                    props.put(fieldKey + "." + encodedKey, encodedValue);
                                }
                                continue;
                            }
                            if (!STRINGIFIED_TYPES.contains(value.getClass()) ? !Encoder.include(field) : (defaultVal = defaults.get(object.getClass(), (Object)field.getName())) != null && defaultVal.equals(value)) continue;
                            String encodedProp = Encoder.encode0(value, props, names, defaults, encoded);
                            if (Utils.equal(encodedProp, defaultProp = defaults.get(object.getClass(), (Object)field.getName()))) continue;
                            props.put(fieldKey, encodedProp);
                        }
                        catch (Exception fieldEx) {
                            log.warn("Skipping field encoding due to error: " + field, (Throwable)fieldEx);
                        }
                    }
                }
                return name;
            }
            catch (Exception ex) {
                log.warn("Error encoding " + object.getClass().getName(), (Throwable)ex);
                throw ex;
            }
        }

        static String getName(Object object, Map<Object, String> names) throws Exception {
            if (names.containsKey(object)) {
                return names.get(object);
            }
            String name = Encoder.getName(object);
            if (name != null) {
                names.put(object, name);
                return name;
            }
            name = "";
            Field nameField = Utils.getField("name", object.getClass());
            if (nameField != null) {
                name = nameField.get(object) + "";
            }
            name = "_anonymous_" + object.getClass().getSimpleName() + "_" + name + "_" + names.size();
            names.put(object, name);
            return name;
        }

        static String getName(Object o) throws Exception {
            Relationship rel;
            Object name = null;
            Class<?> clazz = o.getClass();
            if (o instanceof Engine) {
                name = "engine";
            } else if (o instanceof Api) {
                name = ((Api)o).getName();
            } else if (o instanceof Db) {
                name = Utils.getField("name", clazz).get(o);
            } else if (o instanceof Collection) {
                Collection t = (Collection)o;
                if (t.getDb() != null) {
                    name = t.getDb().getName() + ".collections." + t.getTableName();
                }
            } else if (o instanceof Property) {
                Property col = (Property)o;
                if (col.getCollection() != null && col.getCollection().getDb() != null) {
                    name = col.getCollection().getDb().getName() + ".collections." + col.getCollection().getTableName() + ".properties." + col.getColumnName();
                }
            } else if (o instanceof Index) {
                Index index = (Index)o;
                if (index.getCollection() != null && index.getCollection().getDb() != null) {
                    name = index.getCollection().getDb().getName() + ".collections." + index.getCollection().getTableName() + ".indexes." + index.getName();
                }
            } else if (o instanceof Relationship && (rel = (Relationship)o).getCollection() != null) {
                name = Encoder.getName(rel.getCollection()) + ".relationships." + rel.getName();
            }
            if (name == null) {
                try {
                    name = Utils.getBeanProperty("name", o);
                }
                catch (Throwable ex) {
                    System.err.println("Unable to determine name for bean: " + o);
                }
            }
            if (name != null) {
                return name.toString();
            }
            return null;
        }

        static boolean excludeField(Field field) {
            if (field.getName().equals("name")) {
                return true;
            }
            if (field.getName().indexOf("$") > -1) {
                return true;
            }
            if (Modifier.isStatic(field.getModifiers())) {
                return true;
            }
            if (Modifier.isTransient(field.getModifiers())) {
                return true;
            }
            if (Modifier.isPrivate(field.getModifiers())) {
                return true;
            }
            return excludeFields.contains(field) || excludeTypes.contains(field.getType());
        }

        static boolean excludeType(Class type) {
            boolean exclude = excludeTypes.contains(type);
            if (!exclude && type.getName().indexOf("org.springframework") > -1) {
                exclude = true;
            }
            return exclude;
        }

        static boolean include(Field field) {
            if (Encoder.excludeField(field)) {
                return false;
            }
            Class c = field.getType();
            if (java.util.Collection.class.isAssignableFrom(c)) {
                Type t = field.getGenericType();
                if (t instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)t;
                    if (pt.getActualTypeArguments()[0] instanceof TypeVariable) {
                        return true;
                    }
                    if (pt.getActualTypeArguments()[0] instanceof ParameterizedType) {
                        return false;
                    }
                    c = (Class)pt.getActualTypeArguments()[0];
                }
                boolean inc = !Encoder.excludeType(c);
                return inc;
            }
            if (Properties.class.isAssignableFrom(c)) {
                return true;
            }
            if (JSNode.class.isAssignableFrom(c)) {
                return true;
            }
            if (Map.class.isAssignableFrom(c)) {
                Type t = field.getGenericType();
                if (t instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)t;
                    if (!(pt.getActualTypeArguments()[0] instanceof Class) || !(pt.getActualTypeArguments()[1] instanceof Class)) {
                        System.out.println("Skipping : " + field);
                        return false;
                    }
                    Class keyType = (Class)pt.getActualTypeArguments()[0];
                    Class valueType = (Class)pt.getActualTypeArguments()[1];
                    return !Encoder.excludeType(keyType) && !Encoder.excludeType(valueType);
                }
                throw new RuntimeException("You need to parameterize this object: " + field);
            }
            boolean inc = !Encoder.excludeType(c);
            return inc;
        }

        static {
            STRINGIFIED_TYPES.add(Boolean.class);
            STRINGIFIED_TYPES.add(Character.class);
            STRINGIFIED_TYPES.add(Byte.class);
            STRINGIFIED_TYPES.add(Short.class);
            STRINGIFIED_TYPES.add(Integer.class);
            STRINGIFIED_TYPES.add(Long.class);
            STRINGIFIED_TYPES.add(Float.class);
            STRINGIFIED_TYPES.add(Double.class);
            STRINGIFIED_TYPES.add(Void.class);
            STRINGIFIED_TYPES.add(String.class);
            STRINGIFIED_TYPES.add(Path.class);
        }
    }
}

