/*
 * Decompiled with CFR 0.152.
 */
package io.inversion;

import io.inversion.ApiException;
import io.inversion.Chain;
import io.inversion.Change;
import io.inversion.Engine;
import io.inversion.Request;
import io.inversion.utils.JSArray;
import io.inversion.utils.JSNode;
import io.inversion.utils.Utils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;

public class Response {
    protected long startAt = System.currentTimeMillis();
    protected long endAt = -1L;
    protected Request request = null;
    protected final ArrayListValuedHashMap<String, String> headers = new ArrayListValuedHashMap();
    protected final List<Change> changes = new ArrayList<Change>();
    protected final StringBuilder debug = new StringBuilder();
    protected String url = null;
    protected Chain chain = null;
    protected int statusCode = 200;
    protected String statusMesg = "OK";
    protected String redirect = null;
    protected String contentType = null;
    protected StringBuilder out = new StringBuilder();
    protected JSNode json = new JSNode("meta", new JSNode("createdOn", Utils.formatIso8601(new Date())), "data", new JSArray(new Object[0]));
    protected String text = null;
    protected String fileName = null;
    protected File file = null;
    protected Throwable error = null;
    protected String contentRangeUnit = null;
    protected long contentRangeStart = -1L;
    protected long contentRangeEnd = -1L;
    protected long contentRangeSize = -1L;

    public Response() {
    }

    public Response(String url) {
        this.withUrl(url);
    }

    public long getStartAt() {
        return this.startAt;
    }

    public Response withStartAt(long startAt) {
        this.startAt = startAt;
        return this;
    }

    public long getEndAt() {
        return this.endAt;
    }

    public Response withEndAt(long endAt) {
        this.endAt = endAt;
        return this;
    }

    public boolean hasStatus(int ... statusCodes) {
        for (int statusCode : statusCodes) {
            if (this.statusCode != statusCode) continue;
            return true;
        }
        return false;
    }

    public Response withMeta(String key, String value) {
        this.getJson().getNode("meta").put(key, (Object)value);
        return this;
    }

    public void write(StringBuilder buff, Object ... msgs) {
        this.write0(buff, msgs);
        buff.append("\r\n");
    }

    protected void write0(StringBuilder buff, Object ... msgs) {
        if (msgs != null && msgs.length == 0) {
            return;
        }
        if (msgs != null && msgs.length == 1 && msgs[0] != null && msgs[0].getClass().isArray()) {
            msgs = (Object[])msgs[0];
        }
        for (int i = 0; msgs != null && i < msgs.length; ++i) {
            Object msg = msgs[i];
            if (msg == null) continue;
            if (msg instanceof byte[]) {
                msg = new String((byte[])msg);
            }
            if (msg.getClass().isArray()) {
                this.write0(buff, (Object[])msg);
                continue;
            }
            if (i > 0) {
                buff.append(" ");
            }
            buff.append(msg);
        }
    }

    public Response withStatus(String status) {
        this.statusMesg = status;
        try {
            this.statusCode = Integer.parseInt(status.substring(0, 3));
            if (this.statusMesg.length() > 4) {
                this.statusMesg = status.substring(4);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public String getStatus() {
        return this.statusCode + " " + this.statusMesg;
    }

    public Response withStatusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public Response withStatusMesg(String statusMesg) {
        this.statusMesg = statusMesg;
        return this;
    }

    public Chain getChain() {
        return this.chain;
    }

    public Engine getEngine() {
        return this.chain != null ? this.chain.getEngine() : null;
    }

    public Response withChain(Chain chain) {
        this.chain = chain;
        return this;
    }

    public Response debug(String format, Object ... args) {
        this.write(this.debug, Utils.format(format, args));
        return this;
    }

    public Response out(Object ... msgs) {
        this.debug(Utils.format(null, msgs), new Object[0]);
        this.write(this.out, msgs);
        return this;
    }

    public Response withOutput(String output) {
        this.out = new StringBuilder(output);
        return this;
    }

    public String getOutput() {
        return this.out.toString();
    }

    public Response dump() {
        System.out.println(this.getDebug());
        return this;
    }

    public String getDebug() {
        return this.debug.toString();
    }

    public String getHeader(String key) {
        List vals = this.headers.get((Object)key);
        if (vals != null && vals.size() > 0) {
            return (String)vals.get(0);
        }
        return null;
    }

    public ArrayListValuedHashMap<String, String> getHeaders() {
        return this.headers;
    }

    public void withHeaders(ArrayListValuedHashMap headers) {
        this.headers.putAll((MultiValuedMap)headers);
    }

    public void withHeader(String key, String value) {
        if (!this.headers.containsMapping((Object)key, (Object)value)) {
            this.headers.put((Object)key, (Object)value);
        }
    }

    public Response withJson(JSNode json) {
        this.json = json;
        return this;
    }

    public String findString(String path) {
        return this.getJson().findString(path);
    }

    public int findInt(String path) {
        return this.getJson().findInt(path);
    }

    public boolean findBoolean(String path) {
        return this.getJson().findBoolean(path);
    }

    public JSNode findNode(String path) {
        return this.getJson().findNode(path);
    }

    public JSArray findArray(String path) {
        return this.getJson().findArray(path);
    }

    public Object find(String path) {
        return this.getJson().find(path);
    }

    public Request.Validation validate(String jsonPath) {
        return this.validate(jsonPath, null);
    }

    public Request.Validation validate(String jsonPath, String customErrorMessage) {
        return new Request.Validation(this, jsonPath, customErrorMessage);
    }

    public JSArray data() {
        return this.getData();
    }

    public JSArray getData() {
        JSNode json = this.getJson();
        if (json != null) {
            return json.getArray("data");
        }
        return null;
    }

    public Response withData(JSArray data) {
        this.getJson().put("data", (Object)data);
        return this;
    }

    public Response withRecord(Object record) {
        this.getData().add(record);
        return this;
    }

    public Response withRecords(List records) {
        for (Object record : records) {
            this.getData().add(record);
        }
        return this;
    }

    public JSNode getMeta() {
        return this.getJson().getNode("meta");
    }

    public Response withMeta(String key, Object value) {
        this.getMeta().put(key, value);
        return this;
    }

    public Response withFoundRows(int foundRows) {
        this.withMeta("foundRows", foundRows);
        this.updatePageCount();
        return this;
    }

    public int getFoundRows() {
        return this.findInt("meta.foundRows");
    }

    public Response withPageSize(int pageSize) {
        this.withMeta("pageSize", pageSize);
        return this;
    }

    public Response withPageNum(int pageNum) {
        this.withMeta("pageNum", pageNum);
        this.updatePageCount();
        return this;
    }

    public Response withPageCount(int pageCount) {
        this.withMeta("pageCount", pageCount);
        return this;
    }

    public int getPageSize() {
        Object arr;
        int pageSize = this.getJson().findInt("meta.pageSize");
        if (pageSize < 0 && (arr = this.getJson().find("data.0.name")) instanceof JSArray) {
            pageSize = ((JSArray)arr).size();
        }
        return pageSize;
    }

    protected void updatePageCount() {
        int ps = this.getPageSize();
        int fr = this.getFoundRows();
        if (ps > 0 && fr > 0) {
            int pageCount = fr / ps + (fr % ps == 0 ? 0 : 1);
            this.withPageCount(pageCount);
        }
    }

    public int getPageCount() {
        return this.getJson().findInt("meta.pageCount");
    }

    public String next() {
        return this.findString("meta.next");
    }

    public Response withNext(String nextPageUrl) {
        this.withMeta("next", nextPageUrl);
        return this;
    }

    public String getStatusMesg() {
        return this.statusMesg;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Response withText(String text) {
        this.json = null;
        this.text = text;
        return this;
    }

    public String getResourceKey() {
        String href;
        JSNode json = this.getJson();
        if (json != null && (href = json.getString("href")) != null) {
            String[] parts = href.split("/");
            return parts[parts.length - 1];
        }
        return null;
    }

    public String getRedirect() {
        return this.redirect;
    }

    public Response withRedirect(String redirect) {
        this.redirect = redirect;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Response withContentType(String contentType) {
        this.headers.remove((Object)"Content-Type");
        this.headers.put((Object)"Content-Type", (Object)contentType);
        this.contentType = contentType;
        return this;
    }

    public List<Change> getChanges() {
        return this.changes;
    }

    public Response withChanges(Collection<Change> changes) {
        this.changes.addAll(changes);
        return this;
    }

    public Response withChange(String method, String collectionKey, Object resourceKey) {
        if (resourceKey instanceof List) {
            List deletedIds = (List)resourceKey;
            for (Object id : deletedIds) {
                this.changes.add(new Change(method, collectionKey, id));
            }
        } else {
            this.changes.add(new Change(method, collectionKey, resourceKey));
        }
        return this;
    }

    public Response withChange(String method, String collectionKey, String ... resourceKeys) {
        for (int i = 0; resourceKeys != null && i < resourceKeys.length; ++i) {
            this.withChange(method, collectionKey, (Object)resourceKeys[i]);
        }
        return this;
    }

    public boolean isSuccess() {
        return this.statusCode >= 200 && this.statusCode <= 300 && this.error == null;
    }

    public Throwable getError() {
        return this.error;
    }

    public InputStream getInputStream() throws IOException {
        if (this.file != null) {
            return new BufferedInputStream(new FileInputStream(this.file));
        }
        return null;
    }

    public JSNode getJson() {
        if (this.json == null) {
            this.getContent();
        }
        return this.json;
    }

    public String getText() {
        if (this.text == null) {
            this.getContent();
        }
        return this.text;
    }

    public String getContent() {
        try {
            String string;
            if (this.text == null && this.json == null && this.file != null && this.file.length() > 0L && (string = Utils.read(this.getInputStream())) != null) {
                try {
                    this.json = JSNode.parseJsonNode(string);
                }
                catch (Exception ex) {
                    this.text = string;
                }
            }
            if (this.text != null) {
                return this.text;
            }
            if (this.json != null) {
                return this.json.toString();
            }
        }
        catch (Exception ex) {
            Utils.rethrow(ex);
        }
        return null;
    }

    public String getErrorContent() {
        if (!this.isSuccess() && this.error != null) {
            return Utils.getShortCause(this.error);
        }
        try {
            if (!this.isSuccess()) {
                String message = this.findString("message");
                return this.getStatus() + (!Utils.empty(message) ? " - " + message : "");
            }
        }
        catch (Exception ex) {
            Utils.rethrow(ex);
        }
        return this.getStatus();
    }

    public long getFileLength() {
        if (this.file != null) {
            return this.file.length();
        }
        return -1L;
    }

    public Response withFile(File file) {
        this.json = null;
        this.file = file;
        return this;
    }

    public File getFile() {
        return this.file;
    }

    public long getContentLength() {
        String length = this.getHeader("Content-Length");
        if (length != null) {
            return Long.parseLong(length);
        }
        return 0L;
    }

    public String getContentRangeUnit() {
        this.parseContentRange();
        return this.contentRangeUnit;
    }

    public long getContentRangeStart() {
        this.parseContentRange();
        return this.contentRangeStart;
    }

    public long getContentRangeEnd() {
        this.parseContentRange();
        return this.contentRangeEnd;
    }

    public long getContentRangeSize() {
        this.parseContentRange();
        return this.contentRangeSize;
    }

    private void parseContentRange() {
        String range;
        if (this.contentRangeUnit == null && (range = this.getHeader("Content-Range")) != null) {
            String[] parts = range.split(" ");
            this.contentRangeUnit = parts[0];
            parts = parts[1].split("/");
            this.contentRangeSize = Long.parseLong(parts[1]);
            if ((parts = parts[0].split("-")).length == 2) {
                this.contentRangeStart = Long.parseLong(parts[0]);
                this.contentRangeEnd = Long.parseLong(parts[1]);
            }
        }
    }

    public Response withUrl(String url) {
        if (!Utils.empty(url)) {
            url = url.trim();
            url = url.replaceAll(" ", "%20");
        }
        this.url = url;
        if (Utils.empty(this.fileName)) {
            try {
                this.fileName = new URL(url).getFile();
                if (Utils.empty(this.fileName)) {
                    this.fileName = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this;
    }

    public Response withError(Throwable ex) {
        this.error = ex;
        return this;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getUrl() {
        return this.url;
    }

    public Response withRequest(Request request) {
        this.request = request;
        return this;
    }

    public Request getRequest() {
        return this.request;
    }

    public String toString() {
        return this.debug.toString();
    }

    public void finalize() throws Throwable {
        if (this.file != null) {
            try {
                File tempFile = this.file;
                this.file = null;
                tempFile.delete();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        super.finalize();
    }

    public Response assertOk(String ... messages) {
        if (this.statusCode < 200 || this.statusCode > 299) {
            this.rethrow(this.statusCode, messages);
        }
        return this;
    }

    public void rethrow() {
        this.rethrow(this.statusCode);
    }

    public void rethrow(int statusCode) {
        this.rethrow(statusCode, (String[])null);
    }

    public void rethrow(String ... messages) {
        this.rethrow(this.statusCode, messages);
    }

    public void rethrow(int statusCode, String ... messages) {
        if (this.error != null) {
            Utils.rethrow(this.error);
        }
        statusCode = statusCode > 399 ? statusCode : 500;
        StringBuilder msg = new StringBuilder();
        for (int i = 0; messages != null && i < messages.length; ++i) {
            msg.append(messages[i]).append("\r\n ");
        }
        String message = this.getText();
        try {
            while (message != null && message.startsWith("{") && message.contains("\\\"message\\\"")) {
                message = JSNode.parseJsonNode(message).getString("message");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (message != null) {
            msg.append(" ").append(message.trim());
        }
        throw new ApiException(statusCode + "", null, msg.toString(), new Object[0]);
    }

    public Response assertStatus(int ... statusCodes) {
        return this.assertStatus(null, statusCodes);
    }

    public Response assertStatus(String message, int ... statusCodes) {
        boolean matched = false;
        for (int statusCode : statusCodes) {
            if (statusCode != this.statusCode) continue;
            matched = true;
            break;
        }
        if (!matched) {
            Object[] args = null;
            if (message == null) {
                message = "The returned status '{}' was not in the approved list '{}'";
                ArrayList<Integer> debugList = new ArrayList<Integer>();
                for (int code : statusCodes) {
                    debugList.add(code);
                }
                args = new Object[]{this.statusCode, debugList};
            }
            throw ApiException.new500InternalServerError(message, args);
        }
        return this;
    }

    public Response assertDebug(String lineMatch, String ... matches) {
        if (matches == null || matches.length == 0) {
            matches = new String[]{lineMatch.substring(lineMatch.indexOf(" ") + 1)};
            lineMatch = lineMatch.substring(0, lineMatch.indexOf(" "));
        }
        String debug = this.getDebug();
        int idx = (debug = debug.substring(0, debug.indexOf("<< response"))).indexOf(" " + lineMatch + " ");
        if (idx < 0) {
            System.err.println("SKIPPING DEBUG MATCH: " + lineMatch + " " + Arrays.asList(matches));
            return this;
        }
        String debugLine = debug.substring(idx, debug.indexOf("\n", idx)).trim();
        for (String match : matches) {
            List<String> matchTokens = Utils.split(match, ' ', '\'', '\"', '{', '}');
            for (String matchToken : matchTokens) {
                if (debugLine.contains(matchToken)) continue;
                String msg = "ERROR: Can't find match token in debug line";
                msg = msg + "\r\n  - debug line    : " + debugLine;
                msg = msg + "\r\n  - missing token : " + matchToken;
                msg = msg + "\r\n" + debug;
                System.err.println(msg);
                Utils.error(msg);
            }
        }
        return this;
    }
}

