/*
 * Decompiled with CFR 0.152.
 */
package io.inversion;

import io.inversion.Status;
import io.inversion.utils.Utils;

public class ApiException
extends RuntimeException
implements Status {
    protected String status = "500 Internal Server Error";

    public ApiException() throws ApiException {
        this("500 Internal Server Error", null, null, new Object[0]);
    }

    public ApiException(Throwable cause) throws ApiException {
        this("500 Internal Server Error", cause, null, new Object[0]);
    }

    public ApiException(String httpStatus) throws ApiException {
        this(httpStatus, null, null, new Object[0]);
    }

    public ApiException(String messageFormat, Object ... args) throws ApiException {
        this("500 Internal Server Error", null, messageFormat, args);
    }

    public ApiException(String httpStatus, Throwable cause, String messageFormat, Object ... args) throws ApiException {
        super(ApiException.getMessage(httpStatus, cause, messageFormat, args), cause != null ? Utils.getCause(cause) : null);
        if (httpStatus == null && messageFormat != null) {
            httpStatus = messageFormat;
        }
        if (httpStatus != null && httpStatus.matches("\\d\\d\\d .*")) {
            this.withStatus(httpStatus);
        }
    }

    public static String getMessage(String httpStatus, Throwable cause, String messageFormat, Object ... args) {
        String msg;
        String string = msg = httpStatus != null ? httpStatus : "";
        if (messageFormat != null || args != null && args.length > 0) {
            msg = msg + " - " + Utils.format(messageFormat, args);
        }
        if (cause != null) {
            String causeStr = Utils.getShortCause(cause);
            msg = msg.length() > 0 ? msg + "\r\n" + causeStr : causeStr;
        }
        return msg;
    }

    public static void throwEx(Throwable cause) throws ApiException {
        ApiException.throwEx("500 Internal Server Error", cause, null, new Object[0]);
    }

    public static void throwEx(String messageFormat, Object ... args) throws ApiException {
        ApiException.throwEx("500 Internal Server Error", null, messageFormat, args);
    }

    public static void throwEx(String status, Throwable cause, String messageFormat, Object ... args) throws ApiException {
        throw new ApiException(status, cause, messageFormat, args);
    }

    public static ApiException new400BadRequest() throws ApiException {
        return new ApiException("400 Bad Request", null, null, new Object[0]);
    }

    public static ApiException new400BadRequest(Throwable cause) throws ApiException {
        return new ApiException("400 Bad Request", cause, null, new Object[0]);
    }

    public static ApiException new400BadRequest(String messageFormat, Object ... messages) throws ApiException {
        return new ApiException("400 Bad Request", null, messageFormat, messages);
    }

    public static ApiException new400BadRequest(Throwable cause, String messageFormat, Object ... messages) throws ApiException {
        return new ApiException("400 Bad Request", cause, messageFormat, messages);
    }

    public static ApiException new401Unauthroized() throws ApiException {
        return new ApiException("401 Unauthorized", null, null, new Object[0]);
    }

    public static ApiException new401Unauthroized(Throwable cause) throws ApiException {
        return new ApiException("401 Unauthorized", cause, null, new Object[0]);
    }

    public static ApiException new401Unauthroized(String messageFormat, Object ... messages) throws ApiException {
        return new ApiException("401 Unauthorized", null, messageFormat, messages);
    }

    public static ApiException new401Unauthroized(Throwable cause, String messageFormat, Object ... messages) throws ApiException {
        return new ApiException("401 Unauthorized", cause, messageFormat, messages);
    }

    public static ApiException new403Forbidden() throws ApiException {
        return new ApiException("403 Forbidden", null, null, new Object[0]);
    }

    public static ApiException new403Forbidden(Throwable cause) throws ApiException {
        return new ApiException("403 Forbidden", cause, null, new Object[0]);
    }

    public static ApiException new403Forbidden(String messageFormat, Object ... messages) throws ApiException {
        return new ApiException("403 Forbidden", null, messageFormat, messages);
    }

    public static ApiException new403Forbidden(Throwable cause, String messageFormat, Object ... messages) throws ApiException {
        return new ApiException("403 Forbidden", cause, messageFormat, messages);
    }

    public static ApiException new404NotFound() throws ApiException {
        return new ApiException("404 Not Found", null, null, new Object[0]);
    }

    public static ApiException new404NotFound(Throwable cause) throws ApiException {
        return new ApiException("404 Not Found", cause, null, new Object[0]);
    }

    public static ApiException new404NotFound(String messageFormat, Object ... messages) throws ApiException {
        return new ApiException("404 Not Found", null, messageFormat, messages);
    }

    public static ApiException new404NotFound(Throwable cause, String messageFormat, Object ... messages) throws ApiException {
        return new ApiException("404 Not Found", cause, messageFormat, messages);
    }

    public static ApiException new429TooManyRequests() throws ApiException {
        return new ApiException("429 Too Many Requests", null, null, new Object[0]);
    }

    public static ApiException new429TooManyRequests(Throwable cause) throws ApiException {
        return new ApiException("429 Too Many Requests", cause, null, new Object[0]);
    }

    public static ApiException new429TooManyRequests(String messageFormat, Object ... messages) throws ApiException {
        return new ApiException("429 Too Many Requests", null, messageFormat, messages);
    }

    public static ApiException new429TooManyRequests(Throwable cause, String messageFormat, Object ... messages) throws ApiException {
        return new ApiException("429 Too Many Requests", cause, messageFormat, messages);
    }

    public static ApiException new500InternalServerError() throws ApiException {
        return new ApiException("500 Internal Server Error", null, null, new Object[0]);
    }

    public static ApiException new500InternalServerError(Throwable cause) throws ApiException {
        return new ApiException("500 Internal Server Error", cause, null, new Object[0]);
    }

    public static ApiException new500InternalServerError(String messageFormat, Object ... args) throws ApiException {
        return new ApiException("500 Internal Server Error", null, messageFormat, args);
    }

    public static ApiException new500InternalServerError(Throwable cause, String messageFormat, Object ... args) throws ApiException {
        return new ApiException("500 Internal Server Error", cause, messageFormat, args);
    }

    public static ApiException new501NotImplemented() throws ApiException {
        return new ApiException("501 Not Implemented", null, null, new Object[0]);
    }

    public static ApiException new501NotImplemented(Throwable cause) throws ApiException {
        return new ApiException("501 Not Implemented", cause, null, new Object[0]);
    }

    public static ApiException new501NotImplemented(String messageFormat, Object ... args) throws ApiException {
        return new ApiException("501 Not Implemented", null, messageFormat, args);
    }

    public static ApiException new501NotImplemented(Throwable cause, String messageFormat, Object ... args) throws ApiException {
        return new ApiException("501 Not Implemented", cause, messageFormat, args);
    }

    public String getStatus() {
        return this.status;
    }

    public ApiException withStatus(String status) {
        this.status = status;
        return this;
    }

    public boolean hasStatus(int ... statusCodes) {
        for (int statusCode : statusCodes) {
            if (!this.status.startsWith(statusCode + " ")) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static void throw400BadRequest() throws ApiException {
        ApiException.throwEx("400 Bad Request", null, null, new Object[0]);
    }

    @Deprecated
    public static void throw400BadRequest(Throwable cause) throws ApiException {
        ApiException.throwEx("400 Bad Request", cause, null, new Object[0]);
    }

    @Deprecated
    public static void throw400BadRequest(String messageFormat, Object ... messages) throws ApiException {
        ApiException.throwEx("400 Bad Request", null, messageFormat, messages);
    }

    @Deprecated
    public static void throw400BadRequest(Throwable cause, String messageFormat, Object ... messages) throws ApiException {
        ApiException.throwEx("400 Bad Request", cause, messageFormat, messages);
    }

    @Deprecated
    public static void throw401Unauthroized() throws ApiException {
        ApiException.throwEx("401 Unauthorized", null, null, new Object[0]);
    }

    @Deprecated
    public static void throw401Unauthroized(Throwable cause) throws ApiException {
        ApiException.throwEx("401 Unauthorized", cause, null, new Object[0]);
    }

    @Deprecated
    public static void throw401Unauthroized(String messageFormat, Object ... messages) throws ApiException {
        ApiException.throwEx("401 Unauthorized", null, messageFormat, messages);
    }

    @Deprecated
    public static void throw401Unauthroized(Throwable cause, String messageFormat, Object ... messages) throws ApiException {
        ApiException.throwEx("401 Unauthorized", cause, messageFormat, messages);
    }

    @Deprecated
    public static void throw403Forbidden() throws ApiException {
        ApiException.throwEx("403 Forbidden", null, null, new Object[0]);
    }

    @Deprecated
    public static void throw403Forbidden(Throwable cause) throws ApiException {
        ApiException.throwEx("403 Forbidden", cause, null, new Object[0]);
    }

    @Deprecated
    public static void throw403Forbidden(String messageFormat, Object ... messages) throws ApiException {
        ApiException.throwEx("403 Forbidden", null, messageFormat, messages);
    }

    @Deprecated
    public static void throw403Forbidden(Throwable cause, String messageFormat, Object ... messages) throws ApiException {
        ApiException.throwEx("403 Forbidden", cause, messageFormat, messages);
    }

    @Deprecated
    public static void throw404NotFound() throws ApiException {
        ApiException.throwEx("404 Not Found", null, null, new Object[0]);
    }

    @Deprecated
    public static void throw404NotFound(Throwable cause) throws ApiException {
        ApiException.throwEx("404 Not Found", cause, null, new Object[0]);
    }

    @Deprecated
    public static void throw404NotFound(String messageFormat, Object ... messages) throws ApiException {
        ApiException.throwEx("404 Not Found", null, messageFormat, messages);
    }

    @Deprecated
    public static void throw404NotFound(Throwable cause, String messageFormat, Object ... messages) throws ApiException {
        ApiException.throwEx("404 Not Found", cause, messageFormat, messages);
    }

    @Deprecated
    public static void throw429TooManyRequests() throws ApiException {
        ApiException.throwEx("429 Too Many Requests", null, null, new Object[0]);
    }

    @Deprecated
    public static void throw429TooManyRequests(Throwable cause) throws ApiException {
        ApiException.throwEx("429 Too Many Requests", cause, null, new Object[0]);
    }

    @Deprecated
    public static void throw429TooManyRequests(String messageFormat, Object ... messages) throws ApiException {
        ApiException.throwEx("429 Too Many Requests", null, messageFormat, messages);
    }

    @Deprecated
    public static void throw429TooManyRequests(Throwable cause, String messageFormat, Object ... messages) throws ApiException {
        ApiException.throwEx("429 Too Many Requests", cause, messageFormat, messages);
    }

    @Deprecated
    public static void throw500InternalServerError() throws ApiException {
        ApiException.throwEx("500 Internal Server Error", null, null, new Object[0]);
    }

    @Deprecated
    public static void throw500InternalServerError(Throwable cause) throws ApiException {
        ApiException.throwEx("500 Internal Server Error", cause, null, new Object[0]);
    }

    @Deprecated
    public static void throw500InternalServerError(String messageFormat, Object ... args) throws ApiException {
        ApiException.throwEx("500 Internal Server Error", null, messageFormat, args);
    }

    @Deprecated
    public static void throw500InternalServerError(Throwable cause, String messageFormat, Object ... args) throws ApiException {
        ApiException.throwEx("500 Internal Server Error", cause, messageFormat, args);
    }

    @Deprecated
    public static void throw501NotImplemented() throws ApiException {
        ApiException.throwEx("501 Not Implemented", null, null, new Object[0]);
    }

    @Deprecated
    public static void throw501NotImplemented(Throwable cause) throws ApiException {
        ApiException.throwEx("501 Not Implemented", cause, null, new Object[0]);
    }

    @Deprecated
    public static void throw501NotImplemented(String messageFormat, Object ... args) throws ApiException {
        ApiException.throwEx("501 Not Implemented", null, messageFormat, args);
    }

    @Deprecated
    public static void throw501NotImplemented(Throwable cause, String messageFormat, Object ... args) throws ApiException {
        ApiException.throwEx("501 Not Implemented", cause, messageFormat, args);
    }
}

