/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.utils;

import io.inversion.ApiException;
import io.inversion.Chain;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.utils.Config;
import io.inversion.utils.JSNode;
import io.inversion.utils.Url;
import io.inversion.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;

public class RestClient {
    static final Log log = LogFactory.getLog(RestClient.class);
    protected final Set includeForwardHeaders = Utils.add(new TreeSet(String.CASE_INSENSITIVE_ORDER), "authorization", "cookie", "x-forwarded-for", "x-forwarded-host", " x-forwarded-proto", "x-request-id", "x-correlation-id", "traceparent", "request-id", "trace-id", "x-ms-request-id", "x-ms-request-root-id", "request-context", "X-Amzn-Trace-Id");
    protected final Set excludeForwardHeaders = Utils.add(new TreeSet(String.CASE_INSENSITIVE_ORDER), "content-length", "content-type", "content-encoding", "content-language", "content-location", "content-md5", "host");
    protected final ArrayListValuedHashMap<String, String> forcedHeaders = new ArrayListValuedHashMap();
    protected final Set<String> includeParams = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    protected final Set<String> excludeParams = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    protected final List<RequestListener> requestListeners = new ArrayList<RequestListener>();
    protected final List<Consumer<Response>> responseListeners = new ArrayList<Consumer<Response>>();
    protected String name = null;
    protected boolean forwardHeaders = true;
    protected String url = null;
    protected boolean useCompression = true;
    protected int compressionMinSize = 1024;
    protected boolean forwardParams = false;
    protected Executor executor = null;
    protected int retryMax = 0;
    protected int retryTimeoutMin = 10;
    protected int retryTimeoutMax = 1000;
    protected int socketTimeout = 30000;
    protected int connectTimeout = 30000;
    protected int requestTimeout = 30000;
    protected HttpClient httpClient = null;
    protected int threadsMax = 5;
    Timer timer = null;

    public RestClient() {
    }

    public RestClient(String name) {
        this.withName(name);
    }

    public FutureResponse get(String fullUrlOrRelativePath) {
        return this.get(fullUrlOrRelativePath, (String)null);
    }

    public FutureResponse get(String fullUrlOrRelativePath, String queryString) {
        return this.call("GET", fullUrlOrRelativePath, Utils.parseQueryString(queryString), null, this.retryMax, null);
    }

    public FutureResponse get(String fullUrlOrRelativePath, Map<String, String> params) {
        return this.call("GET", fullUrlOrRelativePath, params, null, this.retryMax, null);
    }

    public FutureResponse get(String fullUrlOrRelativePath, String ... queryStringNameValuePairs) {
        return this.call("GET", fullUrlOrRelativePath, Utils.addToMap(new HashMap(), queryStringNameValuePairs), null, this.retryMax, null);
    }

    public FutureResponse post(String fullUrlOrRelativePath, JSNode body) {
        return this.call("POST", fullUrlOrRelativePath, null, body, this.retryMax, null);
    }

    public FutureResponse put(String fullUrlOrRelativePath, JSNode body) {
        return this.call("PUT", fullUrlOrRelativePath, null, body, this.retryMax, null);
    }

    public FutureResponse patch(String fullUrlOrRelativePath, JSNode body) {
        return this.call("PATCH", fullUrlOrRelativePath, null, body, this.retryMax, null);
    }

    public FutureResponse delete(String fullUrlOrRelativePath) {
        return this.call("DELETE", fullUrlOrRelativePath, null, null, this.retryMax, null);
    }

    public FutureResponse call(String method, String fullUrlOrRelativePath, Map<String, String> params, JSNode body, int retryMax, ArrayListValuedHashMap<String, String> headers) {
        Request request = this.buildRequest(method, fullUrlOrRelativePath, params, body, headers, retryMax);
        return this.call(request);
    }

    public FutureResponse call(Request request) {
        FutureResponse future = this.buildFuture(request);
        this.submit(future);
        return future;
    }

    public Request buildRequest(String method, String fullUrlOrRelativePath, Map<String, String> params, JSNode body, ArrayListValuedHashMap<String, String> headers, int retryMax) {
        Map<String, String> origionalParams;
        Request originalInboundRequest;
        Object inboundHeaders;
        Object chain;
        String url = this.buildUrl(fullUrlOrRelativePath);
        String queryString = StringUtils.substringAfter((String)url, (String)"?");
        if (!Utils.empty(queryString)) {
            url = Utils.substringBefore(url, "?");
            LinkedHashMap<String, String> newParams = Utils.parseQueryString(queryString);
            if (params != null) {
                newParams.putAll(params);
            }
            params = newParams;
        }
        Request request = new Request(method, url, body == null ? null : body.toString(), params, headers, retryMax > -1 ? retryMax : this.retryMax);
        if (this.forwardHeaders && (chain = Chain.first()) != null && (inboundHeaders = (originalInboundRequest = ((Chain)chain).getRequest()).getHeaders()) != null) {
            for (String key : inboundHeaders.keySet()) {
                if (!this.shouldForwardHeader(key) || request.getHeader(key) != null) continue;
                for (String header : inboundHeaders.get((Object)key)) {
                    request.withHeader(key, header);
                }
            }
        }
        if (this.forcedHeaders.size() > 0) {
            chain = this.forcedHeaders.keySet().iterator();
            while (chain.hasNext()) {
                String key = (String)chain.next();
                request.removeHeader(key);
                for (String value : this.forcedHeaders.get((Object)key)) {
                    request.withHeader(key, value);
                }
            }
        }
        if (this.forwardParams && (chain = Chain.first()) != null && (origionalParams = (originalInboundRequest = ((Chain)chain).getRequest()).getUrl().getParams()).size() > 0) {
            for (String key : origionalParams.keySet()) {
                if (!this.shouldForwardParam(key) || request.getUrl().getParam(key) != null) continue;
                request.getUrl().withParam(key, origionalParams.get(key));
            }
        }
        return request;
    }

    FutureResponse buildFuture(Request request) {
        FutureResponse future = new FutureResponse(request){

            @Override
            public void run() {
                Response response = RestClient.this.doRequest(this.request);
                if (RestClient.this.shouldRetry(this.request, response)) {
                    this.request.incrementRetryCount();
                    long timeout = RestClient.this.computeTimeout(this.request, response);
                    RestClient.this.submitLater(this, timeout);
                } else {
                    response.withEndAt(System.currentTimeMillis());
                    this.setResponse(response);
                }
            }
        };
        return future;
    }

    protected Response doRequest(Request request) {
        return this.doRequest0(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response doRequest0(Request request) {
        String m = request.getMethod();
        Object req = null;
        File tempFile = null;
        String url = request.getUrl().toString();
        Response response = new Response(url);
        response.withRequest(request);
        for (RequestListener l : this.requestListeners) {
            Response replacementResponse = l.onRequest(request);
            if (replacementResponse == null) continue;
            if (replacementResponse.getUrl() == null) {
                replacementResponse.withUrl(url);
            }
            if (replacementResponse.getRequest() != null) continue;
            replacementResponse.withRequest(request);
        }
        try {
            HttpEntity e;
            HttpClient h = this.getHttpClient();
            response.debug("--request header------", new Object[0]);
            response.debug(m + " " + url, new Object[0]);
            if ("post".equalsIgnoreCase(m)) {
                req = new HttpPost(url);
            }
            if ("put".equalsIgnoreCase(m)) {
                req = new HttpPut(url);
            } else if ("get".equalsIgnoreCase(m)) {
                req = new HttpGet(url);
                if (request.getRetryFile() != null && request.getRetryFile().length() > 0L) {
                    long range = request.getRetryFile().length();
                    request.getHeaders().remove((Object)"Range");
                    request.getHeaders().put((Object)"Range", (Object)("bytes=" + range + "-"));
                    log.debug((Object)("RANGE REQUEST HEADER ** " + range));
                }
            } else if ("delete".equalsIgnoreCase(m)) {
                req = request.getBody() != null ? new HttpDeleteWithBody(url) : new HttpDelete(url);
            } else if ("patch".equalsIgnoreCase(m)) {
                req = new HttpPatch(url);
            }
            for (String key : request.getHeaders().keySet()) {
                List values = request.getHeaders().get((Object)key);
                for (String value : values) {
                    req.setHeader(key, value);
                    response.debug(key, value);
                }
            }
            if (request.getBody() != null && req instanceof HttpEntityEnclosingRequestBase) {
                response.debug("\r\n--request body--------", new Object[0]);
                byte[] bytes = request.getBody().getBytes(StandardCharsets.UTF_8);
                if (this.useCompression && bytes.length >= this.compressionMinSize) {
                    req.setHeader("Content-Encoding", "gzip");
                    Header[] obj = new ByteArrayOutputStream();
                    GZIPOutputStream gzip = new GZIPOutputStream((OutputStream)obj);
                    gzip.write(bytes);
                    gzip.flush();
                    gzip.close();
                    bytes = obj.toByteArray();
                }
                ((HttpEntityEnclosingRequestBase)req).setEntity((HttpEntity)new ByteArrayEntity(bytes));
            }
            if (Utils.empty(request.getHeader("Accept-Encoding"))) {
                req.setHeader("Accept-Encoding", "gzip");
            }
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.socketTimeout).setConnectTimeout(this.connectTimeout).setConnectionRequestTimeout(this.requestTimeout).build();
            req.setConfig(requestConfig);
            HttpResponse hr = h.execute((HttpUriRequest)req);
            response.withStatusMesg(hr.getStatusLine().toString());
            response.withStatusCode(hr.getStatusLine().getStatusCode());
            response.debug("-response headers -----", new Object[0]);
            response.debug("status: " + response.getStatus(), new Object[0]);
            for (Header header : hr.getAllHeaders()) {
                response.debug("\r\n" + header.getName() + ": " + header.getValue(), new Object[0]);
                response.withHeader(header.getName(), header.getValue());
            }
            log.debug((Object)("RESPONSE CODE ** " + response.getStatusCode() + "   (" + response.getStatus() + ")"));
            log.debug((Object)("CONTENT RANGE RESPONSE HEADER ** " + response.getHeader("Content-Range")));
            Url u = new Url(url);
            String fileName = u.getFile();
            if (fileName == null) {
                fileName = Utils.slugify(u.toString());
            }
            boolean skip = false;
            if (response.getStatusCode() == 404 || response.getStatusCode() == 204) {
                skip = true;
            } else if (request.getRetryFile() != null && request.getRetryFile().length() == response.getContentRangeStart() && "bytes".equalsIgnoreCase(response.getContentRangeUnit())) {
                tempFile = request.getRetryFile();
                log.debug((Object)("## Using existing file .. " + tempFile));
            } else {
                if (response.getStatusCode() == 206) {
                    throw new Exception("Partial content without valid values, aborting this request");
                }
                if (fileName.length() < 3) {
                    fileName = fileName + "_ext";
                }
                tempFile = Utils.createTempFile(fileName);
                tempFile.deleteOnExit();
                log.debug((Object)("## Creating temp file .. " + tempFile));
            }
            if (!skip && (e = hr.getEntity()) != null) {
                InputStream is = e.getContent();
                Utils.pipe(is, new FileOutputStream(tempFile, true));
                response.withFile(tempFile);
                if (response.getContentRangeSize() > 0L && tempFile.length() > response.getContentRangeSize()) {
                    throw new Exception("Downloaded file is larger than the server says it should be, aborting this request");
                }
            }
        }
        catch (Exception ex) {
            response.withError(ex);
            response.withStatus("500 Internal Server Error");
        }
        finally {
            if (req != null) {
                try {
                    req.releaseConnection();
                }
                catch (Exception ex) {
                    log.info((Object)"Exception trying to release the request connection", (Throwable)ex);
                }
            }
        }
        return response;
    }

    public RestClient onRequest(RequestListener requestListener) {
        this.requestListeners.add(requestListener);
        return this;
    }

    public RestClient onResponse(Consumer<Response> responseListener) {
        this.responseListeners.add(responseListener);
        return this;
    }

    protected long computeTimeout(Request request, Response response) {
        long timeout = this.retryTimeoutMin * request.getRetryCount() * request.getRetryCount() + (int)((double)this.retryTimeoutMin * Math.random() * (double)request.getRetryCount());
        if (this.retryTimeoutMax > 0 && timeout > (long)this.retryTimeoutMax) {
            timeout = this.retryTimeoutMax;
        }
        return timeout;
    }

    protected boolean shouldRetry(Request request, Response response) {
        return response != null && !response.isSuccess() && request.getRetryCount() < request.getRetryMax() && this.isNetworkException(response.getError());
    }

    boolean isNetworkException(Throwable ex) {
        if (ex == null) {
            return false;
        }
        return ex instanceof ConnectException || ex instanceof SocketTimeoutException || ex instanceof ConnectTimeoutException || ex instanceof NoHttpResponseException;
    }

    synchronized void submit(FutureResponse future) {
        this.getExecutor().submit(future);
    }

    synchronized void submitLater(final FutureResponse future, long delay) {
        if (this.timer == null) {
            this.timer = new Timer();
        }
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                RestClient.this.submit(future);
            }
        }, delay);
    }

    protected HttpClient buildHttpClient() throws Exception {
        if (this.httpClient == null) {
            HttpClientBuilder b = HttpClientBuilder.create();
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (arg0, arg1) -> true).build();
            b.setSslcontext(sslContext);
            X509HostnameVerifier hostnameVerifier = SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
            PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build());
            b.setConnectionManager((HttpClientConnectionManager)connMgr);
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.socketTimeout).setConnectTimeout(this.connectTimeout).setConnectionRequestTimeout(this.requestTimeout).build();
            b.setDefaultRequestConfig(requestConfig);
            this.httpClient = b.build();
        }
        return this.httpClient;
    }

    String buildUrl(String callerSuppliedFullUrlOrRelativePath) {
        String url = callerSuppliedFullUrlOrRelativePath;
        if (url == null || !url.startsWith("http://") && !url.startsWith("https://")) {
            String prefix;
            url = url != null ? url : "";
            String string = prefix = this.url != null ? this.url : Config.getString(this.getName() + ".url");
            if (!Utils.empty(prefix)) {
                url = url.length() > 0 && !url.startsWith("/") && !prefix.endsWith("/") ? prefix + "/" + url : prefix + url;
            }
        }
        if (url == null) {
            throw ApiException.new500InternalServerError("Unable to determine url for RestClient.buildUrl().  Either pass the desired url in on your call or set configuration property {}.url=${url}.", this.getName());
        }
        String protocol = "";
        if (url.startsWith("http://") || url.startsWith("https://")) {
            protocol = url.substring(0, url.indexOf(":"));
            url = url.substring(url.indexOf(":") + 1);
        }
        if (Chain.peek() != null && url.indexOf(58) > 0) {
            Request request = Chain.top().getRequest();
            url = request.buildPath(url);
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return protocol + ":" + url;
    }

    public RestClient withUrl(String url) {
        this.url = url;
        return this;
    }

    public ArrayListValuedHashMap<String, String> getForcedHeaders() {
        return this.forcedHeaders;
    }

    public RestClient withForcedHeader(String name, String value) {
        this.forcedHeaders.put((Object)name, (Object)value);
        return this;
    }

    public RestClient withForcedHeaders(String ... headers) {
        for (int i = 0; i < headers.length - 1; i += 2) {
            this.withForcedHeader(headers[i], headers[i + 1]);
        }
        return this;
    }

    public RestClient withForwardedHeaders(boolean forwardHeaders) {
        this.forwardHeaders = forwardHeaders;
        return this;
    }

    public RestClient withForwardedParams(boolean forwardParams) {
        this.forwardParams = forwardParams;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public RestClient withName(String name) {
        this.name = name;
        return this;
    }

    public boolean isUseCompression() {
        return this.useCompression;
    }

    public RestClient withUseCompression(boolean useCompression) {
        this.useCompression = useCompression;
        return this;
    }

    public int getCompressionMinSize() {
        return this.compressionMinSize;
    }

    public RestClient withCompressionMinSize(int compressionMinSize) {
        this.compressionMinSize = compressionMinSize;
        return this;
    }

    public int getRetryMax() {
        return this.retryMax;
    }

    public RestClient withRetryMax(int retryMax) {
        this.retryMax = retryMax;
        return this;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public RestClient withSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public RestClient withConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public RestClient withRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public RestClient withHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpClient getHttpClient() {
        if (this.httpClient == null) {
            RestClient restClient = this;
            synchronized (restClient) {
                if (this.httpClient == null) {
                    try {
                        this.httpClient = this.buildHttpClient();
                    }
                    catch (Exception ex) {
                        Utils.rethrow(ex);
                    }
                }
            }
        }
        return this.httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Executor getExecutor() {
        if (this.executor == null) {
            RestClient restClient = this;
            synchronized (restClient) {
                if (this.executor == null) {
                    this.executor = this.buildExecutor();
                }
            }
        }
        return this.executor;
    }

    public RestClient withExecutor(Executor executor) {
        this.executor = executor;
        return this;
    }

    protected Executor buildExecutor() {
        return new Executor().withThreadsMax(this.threadsMax);
    }

    public boolean isForwardHeaders() {
        return this.forwardHeaders;
    }

    protected boolean shouldForwardHeader(String headerKey) {
        if (headerKey == null) {
            return false;
        }
        headerKey = headerKey.trim();
        return this.forwardHeaders && (this.includeForwardHeaders.size() == 0 || this.includeForwardHeaders.contains(headerKey)) && !this.excludeForwardHeaders.contains(headerKey);
    }

    public RestClient withForwardHeaders(boolean forwardHeaders) {
        this.forwardHeaders = forwardHeaders;
        return this;
    }

    public Set<String> getIncludeForwardHeaders() {
        return new HashSet<String>(this.includeForwardHeaders);
    }

    public RestClient withIncludeForwardHeaders(String ... headerKeys) {
        for (int i = 0; headerKeys != null && i < headerKeys.length; ++i) {
            this.includeForwardHeaders.add(headerKeys[i]);
        }
        return this;
    }

    public RestClient removeIncludeForwardHeader(String headerKey) {
        if (headerKey != null) {
            this.includeForwardHeaders.remove(headerKey);
        }
        return this;
    }

    public Set getExcludeForwardHeaders() {
        return new HashSet(this.excludeForwardHeaders);
    }

    public RestClient withExcludeForwardHeaders(String ... headerKeys) {
        for (int i = 0; headerKeys != null && i < headerKeys.length; ++i) {
            this.excludeForwardHeaders.add(headerKeys[i]);
        }
        return this;
    }

    public RestClient removeExcludeForwardHeader(String headerKey) {
        if (headerKey != null) {
            this.excludeForwardHeaders.remove(headerKey);
        }
        return this;
    }

    public boolean isForwardParams() {
        return this.forwardParams;
    }

    protected boolean shouldForwardParam(String param) {
        return this.forwardParams && !param.startsWith("_") && !param.equalsIgnoreCase("explain") && !param.equalsIgnoreCase("debug") && (this.includeParams.size() == 0 || this.includeParams.contains(param)) && !this.excludeParams.contains(param);
    }

    public RestClient withForwardParams(boolean forwardParams) {
        this.forwardParams = forwardParams;
        return this;
    }

    public Set getIncludeParams() {
        return new HashSet<String>(this.includeParams);
    }

    public RestClient withIncludeParams(String ... paramNames) {
        for (int i = 0; paramNames != null && i < paramNames.length; ++i) {
            this.includeParams.add(paramNames[i]);
        }
        return this;
    }

    public RestClient removeIncludeParam(String param) {
        if (param != null) {
            this.includeParams.remove(param);
        }
        return this;
    }

    public Set getExcludeParams() {
        return new HashSet<String>(this.excludeParams);
    }

    public RestClient withExcludeParams(String ... paramNames) {
        for (int i = 0; paramNames != null && i < paramNames.length; ++i) {
            this.excludeParams.add(paramNames[i]);
        }
        return this;
    }

    public RestClient removeExcludeParam(String param) {
        if (param != null) {
            this.excludeParams.remove(param);
        }
        return this;
    }

    public int getRetryTimeoutMin() {
        return this.retryTimeoutMin;
    }

    public RestClient withRetryTimeoutMin(int retryTimeoutMin) {
        this.retryTimeoutMin = retryTimeoutMin;
        return this;
    }

    public int getRetryTimeoutMax() {
        return this.retryTimeoutMax;
    }

    public RestClient getRetryTimeoutMax(int retryTimeoutMax) {
        this.retryTimeoutMax = retryTimeoutMax;
        return this;
    }

    public int getThreadsMax() {
        return this.threadsMax;
    }

    public RestClient withThreadsMax(int threadsMax) {
        this.threadsMax = threadsMax;
        if (this.executor != null) {
            this.executor.withThreadsMax(threadsMax);
        }
        return this;
    }

    public abstract class FutureResponse
    implements RunnableFuture<Response> {
        final List<Consumer<Response>> successListeners = new ArrayList<Consumer<Response>>();
        final List<Consumer<Response>> failureListeners = new ArrayList<Consumer<Response>>();
        final List<Consumer<Response>> responseListeners = new ArrayList<Consumer<Response>>();
        final Request request;
        Response response = null;

        FutureResponse(Request request) {
            this.request = request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FutureResponse onSuccess(Consumer<Response> handler) {
            boolean done;
            FutureResponse futureResponse = this;
            synchronized (futureResponse) {
                done = this.isDone();
                if (!done) {
                    this.successListeners.add(handler);
                }
            }
            if (done && this.isSuccess()) {
                try {
                    handler.accept(this.response);
                }
                catch (Throwable ex) {
                    log.error((Object)"Error handling onSuccess", ex);
                }
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FutureResponse onFailure(Consumer<Response> handler) {
            boolean done;
            FutureResponse futureResponse = this;
            synchronized (futureResponse) {
                done = this.isDone();
                if (!done) {
                    this.failureListeners.add(handler);
                }
            }
            if (done && !this.isSuccess()) {
                try {
                    handler.accept(this.response);
                }
                catch (Throwable ex) {
                    log.error((Object)"Error handling onFailure", ex);
                }
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FutureResponse onResponse(Consumer<Response> handler) {
            boolean done;
            FutureResponse futureResponse = this;
            synchronized (futureResponse) {
                done = this.isDone();
                if (!done) {
                    this.responseListeners.add(handler);
                }
            }
            if (done) {
                try {
                    handler.accept(this.response);
                }
                catch (Throwable ex) {
                    log.error((Object)"Error handling onResponse", ex);
                }
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setResponse(Response response) {
            FutureResponse futureResponse = this;
            synchronized (futureResponse) {
                this.response = response;
                for (Consumer<Response> h : RestClient.this.responseListeners) {
                    h.accept(response);
                }
                if (this.isSuccess()) {
                    for (Consumer<Response> h : this.successListeners) {
                        try {
                            h.accept(response);
                        }
                        catch (Throwable ex) {
                            log.error((Object)"Error handling success callbacks in setResponse", ex);
                        }
                    }
                } else {
                    for (Consumer<Response> h : this.failureListeners) {
                        try {
                            h.accept(response);
                        }
                        catch (Throwable ex) {
                            log.error((Object)"Error handling failure callbacks in setResponse", ex);
                        }
                    }
                }
                for (Consumer<Response> h : this.responseListeners) {
                    try {
                        h.accept(response);
                    }
                    catch (Throwable ex) {
                        log.error((Object)"Error handling callbacks in setResponse", ex);
                    }
                }
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Response get() {
            while (this.response == null) {
                FutureResponse futureResponse = this;
                synchronized (futureResponse) {
                    if (this.response == null) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            return this.response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Response get(long timeout, TimeUnit unit) throws TimeoutException {
            long start = System.currentTimeMillis();
            while (this.response == null) {
                FutureResponse futureResponse = this;
                synchronized (futureResponse) {
                    if (this.response == null) {
                        try {
                            timeout = TimeUnit.MILLISECONDS.convert(timeout, unit);
                            if ((timeout -= System.currentTimeMillis() - start) < 1L) {
                                break;
                            }
                            this.wait(timeout);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            return this.response;
        }

        public boolean isSuccess() {
            return this.response != null && this.response.isSuccess();
        }

        public Request getRequest() {
            return this.request;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean cancel(boolean arg0) {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.response != null;
        }
    }

    public static class Executor {
        final LinkedList<RunnableFuture> queue = new LinkedList();
        final Vector<Thread> threads = new Vector();
        final String threadPrefix = "executor";
        protected int threadsMin = 1;
        protected int threadsMax = 5;
        protected int queueMax = 500;

        public synchronized Future submit(final Runnable task) {
            return this.submit(new RunnableFuture(){
                boolean started = false;
                boolean canceled = false;
                boolean done = false;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (this.canceled || this.done) {
                            return;
                        }
                        this.started = true;
                        task.run();
                    }
                    finally {
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            this.done = true;
                            this.notifyAll();
                        }
                    }
                }

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    this.canceled = true;
                    return !this.started;
                }

                @Override
                public boolean isCancelled() {
                    return this.canceled;
                }

                @Override
                public boolean isDone() {
                    return false;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object get() throws InterruptedException, ExecutionException {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        while (!this.done) {
                            this.wait();
                        }
                    }
                    return null;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                    1 var4_3 = this;
                    synchronized (var4_3) {
                        while (!this.done) {
                            this.wait(unit.toMillis(timeout));
                        }
                    }
                    return null;
                }
            });
        }

        public synchronized RunnableFuture submit(RunnableFuture task) {
            if (this.getThreadsMax() < 1) {
                task.run();
            } else {
                this.put(task);
                this.checkStartThread();
            }
            return task;
        }

        synchronized boolean checkStartThread() {
            if (this.queue.size() > 0 && this.threads.size() < this.threadsMax) {
                Thread t = new Thread(this::processQueue, "executor worker");
                t.setDaemon(true);
                this.threads.add(t);
                t.start();
                return true;
            }
            return false;
        }

        synchronized boolean checkEndThread() {
            if (this.queue.size() == 0 && this.threads.size() > this.threadsMin) {
                this.threads.remove(Thread.currentThread());
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int queued() {
            LinkedList<RunnableFuture> linkedList = this.queue;
            synchronized (linkedList) {
                return this.queue.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void put(RunnableFuture task) {
            LinkedList<RunnableFuture> linkedList = this.queue;
            synchronized (linkedList) {
                while (this.queue.size() >= this.queueMax) {
                    try {
                        this.queue.wait();
                    }
                    catch (Exception exception) {}
                }
                this.queue.add(task);
                this.queue.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        RunnableFuture take() {
            RunnableFuture t;
            LinkedList<RunnableFuture> linkedList = this.queue;
            synchronized (linkedList) {
                while (this.queue.size() == 0) {
                    try {
                        this.queue.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                t = this.queue.removeFirst();
                this.queue.notifyAll();
            }
            return t;
        }

        void processQueue() {
            try {
                while (!this.checkEndThread()) {
                    do {
                        RunnableFuture task = this.take();
                        task.run();
                    } while (this.queue.size() > 0);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public int getThreadsMin() {
            return this.threadsMin;
        }

        public Executor withThreadsMin(int threadsMin) {
            this.threadsMin = threadsMin;
            return this;
        }

        public int getThreadsMax() {
            return this.threadsMax;
        }

        public Executor withThreadsMax(int threadsMax) {
            this.threadsMax = threadsMax;
            return this;
        }

        public int getQueueMax() {
            return this.queueMax;
        }

        public Executor withQueueMax(int queueMax) {
            this.queueMax = queueMax;
            return this;
        }
    }

    static class HttpDeleteWithBody
    extends HttpEntityEnclosingRequestBase {
        static final String methodName = "DELETE";

        public HttpDeleteWithBody(String url) {
            this.setURI(URI.create(url));
        }

        public String getMethod() {
            return methodName;
        }
    }

    public static interface RequestListener {
        public Response onRequest(Request var1);
    }
}

