/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.rql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;

public class Term
implements Comparable<Term> {
    public final List<Term> terms = new ArrayList<Term>();
    public Term parent = null;
    public char quote = '\u0000';
    public String token = null;

    protected Term() {
    }

    protected Term(Term parent, String token) {
        this.withParent(parent);
        this.withToken(token);
    }

    public static Term term(Term parent, String token, Object ... terms) {
        Term newTerm = new Term(parent, token);
        List deconstructed = Term.deconstructed(new ArrayList(), terms);
        for (Object aTerm : deconstructed) {
            if (aTerm instanceof Term) {
                newTerm.withTerm((Term)aTerm);
                continue;
            }
            newTerm.withTerm(new Term(newTerm, aTerm.toString()));
        }
        return newTerm;
    }

    static List deconstructed(List found, Object ... terms) {
        if (terms.length == 1 && terms[0].getClass().isArray()) {
            terms = (Object[])terms[0];
        }
        for (Object o : terms) {
            if (o instanceof Collection) {
                ((Collection)o).forEach(o2 -> Term.deconstructed(found, o2));
                continue;
            }
            if (o.getClass().isArray()) {
                Object[] arr;
                for (Object o22 : arr = (Object[])o) {
                    Term.deconstructed(found, o22);
                }
                continue;
            }
            found.add(o);
        }
        return found;
    }

    public Term copy() {
        Term copy = new Term();
        copy.quote = this.quote;
        copy.token = this.token;
        this.terms.forEach(child -> copy.withTerm(child.copy()));
        return copy;
    }

    @Override
    public int compareTo(Term o) {
        int val = this.token.compareTo(o.token);
        if (val == 0) {
            for (int i = 0; i < this.terms.size(); ++i) {
                if (o.terms.size() <= i) {
                    return 1;
                }
                val = this.terms.get(i).compareTo(o.terms.get(i));
                if (val != 0) break;
            }
        }
        return val;
    }

    public String getToken(int childIndex) {
        if (this.terms.size() > childIndex) {
            return this.terms.get(childIndex).getToken();
        }
        return null;
    }

    public String getToken() {
        if (this.token == null) {
            return "NULL";
        }
        return this.token;
    }

    public boolean hasToken(String ... tokens) {
        if (this.token == null) {
            return false;
        }
        for (int i = 0; tokens != null && i < tokens.length; ++i) {
            if (!this.token.equalsIgnoreCase(tokens[i])) continue;
            return true;
        }
        return false;
    }

    public boolean hasChildLeafToken(String ... tokens) {
        if (this.token == null) {
            return false;
        }
        for (Term child : this.terms) {
            if (!child.isLeaf() || !child.hasToken(tokens)) continue;
            return true;
        }
        return false;
    }

    public Term withToken(String token) {
        this.quote = '\u0000';
        if (token != null && (token = token.trim()).length() > 1) {
            char start = token.charAt(0);
            if (token.charAt(token.length() - 1) == start && (start == '\'' || start == '\"' || start == '`')) {
                this.quote = start;
                token = token.substring(1, token.length() - 1);
            }
        }
        if (this.quote == '`') {
            this.quote = (char)34;
        }
        this.token = token;
        return this;
    }

    public Term getParent() {
        return this.parent;
    }

    public Term withParent(Term parent) {
        if (this.parent != parent) {
            this.parent = parent;
            if (parent != null) {
                parent.withTerm(this);
            }
        }
        this.parent = parent;
        return this;
    }

    public boolean isLeaf() {
        return this.terms.size() == 0;
    }

    public boolean isLeaf(int childIndex) {
        if (childIndex >= this.terms.size()) {
            return false;
        }
        return this.getTerm(childIndex).isLeaf();
    }

    public int size() {
        return this.terms.size();
    }

    public int indexOf(Term child) {
        return this.terms.indexOf(child);
    }

    public int getNumTerms() {
        return this.terms.size();
    }

    public List<Term> getTerms() {
        return this.terms;
    }

    public Term getTerm(int index) {
        if (this.terms.size() > index) {
            return this.terms.get(index);
        }
        return null;
    }

    public Term replaceTerm(Term oldTerm, Term newTerm) {
        this.terms.remove(newTerm);
        int idx = this.terms.indexOf(oldTerm);
        if (idx < 0) {
            this.terms.add(newTerm);
        } else {
            this.terms.set(idx, newTerm);
        }
        return this;
    }

    public Term withTerms(Term ... terms) {
        for (Term term : terms) {
            this.withTerm(term);
        }
        return this;
    }

    public Term withTerm(Term term) {
        if (term == this) {
            throw new RuntimeException("A term can not be a child of itself");
        }
        if (!this.terms.contains(term)) {
            this.terms.add(term);
            if (term.getParent() != this) {
                term.withParent(this);
            }
        }
        return this;
    }

    public Term withTerm(String token, Object ... terms) {
        this.withTerm(Term.term(this, token, terms));
        return this;
    }

    public Term withTerm(int index, Term term) {
        if (term == this) {
            throw new RuntimeException("A term can not be a child of itself");
        }
        this.terms.remove(term);
        this.terms.add(index, term);
        if (term.getParent() != this) {
            term.withParent(this);
        }
        return this;
    }

    public void removeTerm(Term term) {
        this.terms.remove(term);
    }

    public void clear() {
        this.terms.clear();
    }

    public boolean isQuoted() {
        return this.quote != '\u0000';
    }

    public char getQuote() {
        return this.quote;
    }

    public String toString() {
        StringBuilder buff = this.quote > '\u0000' ? new StringBuilder().append(this.quote).append(this.getToken()).append(this.quote) : new StringBuilder(this.getToken());
        if (this.terms.size() > 0) {
            buff.append("(");
            for (int i = 0; i < this.terms.size(); ++i) {
                buff.append(this.terms.get(i).toString());
                if (i >= this.terms.size() - 1) continue;
                buff.append(",");
            }
            buff.append(")");
        }
        return buff.toString();
    }

    public Stream<Term> stream() {
        ArrayList list = new ArrayList();
        this.collect(list);
        return list.stream();
    }

    void collect(List list) {
        list.add(this);
        for (Term child : this.terms) {
            child.collect(list);
        }
    }
}

