/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.utils;

import io.inversion.utils.JSNode;
import io.inversion.utils.Path;
import io.inversion.utils.Utils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;

public class Url {
    protected final String original;
    protected String protocol = "http";
    protected String host = null;
    protected int port = 0;
    protected Path path = null;
    protected JSNode params = new JSNode();

    public Url(String url) {
        if (url.indexOf(":/") > 0 && !url.contains("://")) {
            url = url.replaceAll(":/", "://");
        }
        if (!(url = url.replace("&amp;", "&")).startsWith("http://") && !url.startsWith("https://")) {
            url = "http://localhost" + (!url.startsWith("/") ? "/" : "") + url;
        }
        this.original = url;
        try {
            String path;
            int potocolEnd;
            int queryIndex = url.indexOf(63);
            if (queryIndex >= 0) {
                String query = url.substring(queryIndex + 1);
                url = url.substring(0, queryIndex);
                this.withQueryString(query);
            }
            if ((potocolEnd = (url = url.replace('\\', '/')).indexOf("://")) < 0) {
                path = url;
            } else {
                int nextSlash;
                int nextColon;
                this.protocol = url.substring(0, url.indexOf(58));
                int hostStart = url.indexOf(47) + 2;
                int hostEnd = url.indexOf(58, hostStart);
                if (hostEnd < 0 || hostEnd > url.indexOf(47, hostStart)) {
                    hostEnd = url.indexOf(47, hostStart);
                }
                if (hostEnd < 0) {
                    url = url + "/";
                    hostEnd = url.indexOf(47, hostStart);
                }
                this.host = url.substring(hostStart, hostEnd);
                String rest = url.substring(hostEnd);
                if (rest.indexOf(58) > -1 && (nextColon = rest.indexOf(58)) < (nextSlash = rest.indexOf(47))) {
                    String portString = rest.substring(nextColon + 1, nextSlash);
                    this.port = Integer.parseInt(portString);
                    rest = rest.substring(nextSlash);
                }
                path = rest;
            }
            if (path.length() == 0) {
                path = "/";
            } else if (path.charAt(0) != '/') {
                path = '/' + url;
            }
            if (!Utils.empty(path)) {
                this.path = new Path(path);
            }
        }
        catch (Exception ex) {
            System.err.println("Error parsing url \"" + url + "\"");
            ex.printStackTrace();
        }
    }

    public static String toQueryString(Map params) {
        StringBuilder query = new StringBuilder();
        if (params != null) {
            for (Object o : params.keySet()) {
                String key = o.toString();
                try {
                    if (params.get(key) != null) {
                        query.append(URLEncoder.encode(key, "UTF-8")).append("=").append(URLEncoder.encode(params.get(key).toString(), "UTF-8")).append("&");
                        continue;
                    }
                    query.append(URLEncoder.encode(key, "UTF-8")).append("&");
                }
                catch (UnsupportedEncodingException e) {
                    Utils.rethrow(e);
                }
            }
            if (query.length() > 0) {
                query = new StringBuilder(query.substring(0, query.length() - 1));
            }
        }
        String str = query.toString();
        str = str.replace("%28", "(");
        str = str.replace("%29", ")");
        str = str.replace("%2C", ",");
        return str;
    }

    public String toString() {
        String url = this.protocol + "://" + this.host;
        if (!(this.port <= 0 || this.port == 80 && "http".equalsIgnoreCase(this.protocol) || this.port == 443 && "https".equalsIgnoreCase(this.protocol))) {
            url = url + ":" + this.port;
        }
        if (this.path != null && this.path.size() > 0) {
            url = url + "/" + this.path;
        }
        if (this.params.size() > 0) {
            while (url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
            url = url + "?";
            url = url + Url.toQueryString(this.params.asMap());
        }
        return url;
    }

    public boolean equals(Object url) {
        if (url instanceof Url) {
            return this.toString().equals(url.toString());
        }
        return false;
    }

    public String getDomain() {
        String domain = this.host;
        if (domain.lastIndexOf(46) > domain.indexOf(46)) {
            domain = domain.substring(domain.indexOf(46) + 1);
        }
        return domain;
    }

    public String getQueryString() {
        if (this.params.size() == 0) {
            return "";
        }
        return Url.toQueryString(this.params.asMap());
    }

    public String getHost() {
        return this.host;
    }

    public Url withHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public Url withPort(int port) {
        this.port = port;
        return this;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Url withProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public Path getPath() {
        return this.path;
    }

    public Url withPath(Path path) {
        this.path = path;
        return this;
    }

    public String getFile() {
        if (this.path != null) {
            return this.path.last();
        }
        return null;
    }

    public Url withQueryString(String queryString) {
        this.params = new JSNode(Utils.parseQueryString(queryString));
        return this;
    }

    public Url withParams(Map<String, String> newParams) {
        if (newParams != null) {
            this.params.putAll((Map<? extends String, ? extends Object>)newParams);
        }
        return this;
    }

    public Url withParam(String name, String value) {
        this.params.put(name, (Object)value);
        return this;
    }

    public Url withParams(String ... nvpairs) {
        if (nvpairs != null) {
            for (int i = 0; i < nvpairs.length - 1; i += 2) {
                this.withParam(nvpairs[i], nvpairs[i + 1]);
            }
            if (nvpairs.length % 2 == 1) {
                this.withParam(nvpairs[nvpairs.length - 1], null);
            }
        }
        return this;
    }

    public void replaceParam(String key, String value) {
        for (String existing : new ArrayList<String>(this.params.keySet())) {
            if (!Utils.containsToken(key, existing)) continue;
            this.params.remove(existing);
        }
        this.withParam(key, value);
    }

    public String clearParams(String ... tokens) {
        String oldValue = null;
        for (String token : tokens) {
            for (String existing : this.params.keySet()) {
                if (!Utils.containsToken(token, existing)) continue;
                String removed = (String)this.params.remove(existing);
                if (oldValue != null) continue;
                oldValue = removed;
            }
        }
        return oldValue;
    }

    public String findKey(String ... tokens) {
        for (String token : tokens) {
            for (String key : this.params.keySet()) {
                if (!Utils.containsToken(token, key)) continue;
                return key;
            }
        }
        return null;
    }

    public String findKeyValue(String ... tokens) {
        String key = this.findKey(tokens);
        if (key != null) {
            return this.params.getString(key);
        }
        return null;
    }

    public String getParam(String key) {
        return (String)this.params.get(key);
    }

    public Map<String, String> getParams() {
        return this.params.asMap();
    }

    public String getOriginal() {
        return this.original;
    }
}

