/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.rql;

import io.inversion.rql.Builder;
import io.inversion.rql.Query;
import io.inversion.rql.Term;

public class Page<T extends Page, P extends Query>
extends Builder<T, P> {
    public static final int DEFAULT_LIMIT = 100;

    public Page(P query) {
        super(query);
        this.withFunctions("offset", "limit", "page", "pageNum", "pageSize", "after");
    }

    public int getOffset() {
        int limit;
        int offset = this.findInt("offset", 0, -1);
        if (offset < 0) {
            offset = this.findInt("limit", 1, -1);
        }
        if (offset < 0 && (limit = this.getLimit()) > 0) {
            int page = this.findInt("page", 0, -1);
            if (page < 0) {
                page = this.findInt("pageNum", 0, -1);
            }
            if (page >= 0) {
                offset = Math.max(0, page - 1) * limit;
            }
        }
        if (offset < 0) {
            offset = 0;
        }
        return offset;
    }

    public Term getAfter() {
        return this.find("after");
    }

    public int getLimit() {
        int limit = this.findInt("limit", 0, -1);
        if (limit < 0) {
            limit = this.findInt("offset", 1, -1);
        }
        if (limit < 0) {
            limit = this.findInt("pageSize", 0, -1);
        }
        if (limit < 0) {
            limit = this.findInt("page", 1, -1);
        }
        if (limit < 0) {
            limit = 100;
        }
        return limit;
    }

    public int getPageSize() {
        return this.getLimit();
    }

    public int getPage() {
        int limit;
        int page = -1;
        int offset = this.getOffset();
        if (offset > -1 && (limit = this.getLimit()) > -1) {
            page = offset / limit + 1;
        }
        return Math.max(page, 1);
    }

    public int getPageNum() {
        return this.getPage();
    }
}

