/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.action.security;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTCreationException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import io.inversion.Action;
import io.inversion.ApiException;
import io.inversion.Chain;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.User;
import io.inversion.utils.Config;
import io.inversion.utils.JSArray;
import io.inversion.utils.JSNode;
import io.inversion.utils.Utils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections4.map.LRUMap;

public class AuthAction
extends Action<AuthAction> {
    public static final int AUTH_ACTION_DEFAULT_ORDER_IS_100 = 100;
    protected String collection = null;
    protected String authenticatedPerm = null;
    protected SessionDao sessionDao = null;
    protected UserDao userDao = null;

    public AuthAction() {
        this.withOrder(100);
    }

    @Override
    public void run(Request req, Response resp) throws ApiException {
        User user = Chain.getUser();
        if (user != null && !req.isDelete()) {
            return;
        }
        String apiName = req.getApi().getName();
        String tenant = req.getUrl().getParam("tenant");
        long now = System.currentTimeMillis();
        String username = null;
        String password = null;
        boolean sessionReq = this.collection != null && this.collection.equalsIgnoreCase(req.getCollectionKey());
        String url = req.getUrl().toString().toLowerCase();
        while (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        String token = req.getHeader("authorization");
        if (token == null) {
            token = req.getHeader("x-auth-token");
        }
        if (token != null) {
            if ((token = token.trim()).toLowerCase().startsWith("bearer ")) {
                token = token.substring(token.indexOf(" ") + 1).trim();
                user = this.userDao.getUser(this, token, apiName, tenant);
            } else if (token.toLowerCase().startsWith("basic ")) {
                token = token.substring(token.indexOf(" ") + 1);
                token = new String(Base64.decodeBase64((String)token));
                username = token.substring(0, token.indexOf(":"));
                password = token.substring(token.indexOf(":") + 1);
                user = this.userDao.getUser(this, username, password, apiName, tenant);
            } else if (token.toLowerCase().startsWith("session ")) {
                if (this.sessionDao == null) {
                    throw ApiException.new400BadRequest("AuthAction has not been configured to support session authorization", new Object[0]);
                }
                token = token.substring(8).trim();
                if (sessionReq && req.isDelete()) {
                    String resourceKey = req.getResourceKey();
                    if (!Utils.equal(token, resourceKey)) {
                        throw ApiException.new401Unauthroized("Logout requires a session authroization or x-auth-token header that matches the url resourceKey", new Object[0]);
                    }
                    this.sessionDao.delete(token);
                    return;
                }
                user = this.sessionDao.get(token);
            } else {
                throw ApiException.new400BadRequest("Authorization token format must be bearer,basic or session. {} ", token);
            }
            if (user == null) {
                throw ApiException.new401Unauthroized();
            }
        } else {
            if (req.isPost() && sessionReq) {
                username = req.getJson().getString("username");
                password = req.getJson().getString("password");
            }
            if (Utils.empty(username, password)) {
                username = req.getHeader("x-auth-username");
                password = req.getHeader("x-auth-password");
            }
            if (Utils.empty(username, password)) {
                username = req.getHeader("username");
                password = req.getHeader("password");
            }
            if (Utils.empty(username, password)) {
                username = req.getUrl().clearParams("username");
                password = req.getUrl().clearParams("password");
            }
            if (!Utils.empty(username, password) && (user = this.userDao.getUser(this, username, password, apiName, tenant)) == null) {
                throw ApiException.new401Unauthroized();
            }
        }
        if (user == null) {
            if (sessionReq) {
                throw ApiException.new401Unauthroized();
            }
            user = this.userDao.getGuest(apiName, tenant);
        }
        if (user == null || tenant != null && !tenant.equalsIgnoreCase(user.getTenant())) {
            throw ApiException.new401Unauthroized();
        }
        user.withRequestAt(now);
        Chain.peek().withUser(user);
        if (this.sessionDao != null && sessionReq && req.isPost()) {
            String sessionKey = this.sessionDao.post(user);
            resp.withHeader("x-auth-token", "Session " + sessionKey);
            JSNode obj = new JSNode();
            obj.put("id", (Object)user.getId());
            obj.put("username", (Object)username);
            obj.put("displayname", (Object)user.getDisplayName());
            JSArray perms = new JSArray(new Object[0]);
            for (String perm : user.getPermissions()) {
                perms.add(perm);
            }
            obj.put("perms", (Object)perms);
            JSArray roles = new JSArray(new Object[0]);
            for (String role : user.getRoles()) {
                roles.add(role);
            }
            obj.put("roles", (Object)roles);
            resp.withJson(new JSNode("data", obj));
        }
    }

    public AuthAction withCollection(String collection) {
        this.collection = collection;
        return this;
    }

    public AuthAction withAuthenticatedPerm(String authenticatedPerm) {
        this.authenticatedPerm = authenticatedPerm;
        return this;
    }

    public AuthAction withSessionDao(SessionDao sessionDao) {
        this.sessionDao = sessionDao;
        return this;
    }

    public AuthAction withUserDao(UserDao dao) {
        this.userDao = dao;
        return this;
    }

    public UserDao getUserDao() {
        return this.userDao;
    }

    public static interface SessionDao {
        public User get(String var1);

        public String post(User var1);

        public void put(String var1, User var2);

        public void delete(String var1);
    }

    public static interface UserDao {
        public User getUser(AuthAction var1, String var2, String var3, String var4) throws ApiException;

        public User getUser(AuthAction var1, String var2, String var3, String var4, String var5) throws ApiException;

        default public User getGuest(String apiName, String tenant) {
            User user = new User();
            user.withUsername("Anonymous");
            user.withRoles("guest");
            user.withTenant(tenant);
            return user;
        }
    }

    public static class JwtUserDao
    implements UserDao {
        RevokedTokenCache revokedTokenCache = new InMemoryRevokedTokenCache();

        @Override
        public User getUser(AuthAction action, String username, String password, String apiName, String tenant) throws ApiException {
            throw ApiException.new403Forbidden();
        }

        @Override
        public User getUser(AuthAction action, String token, String apiName, String tenant) throws ApiException {
            if (this.revokedTokenCache != null && this.revokedTokenCache.isRevoked(token)) {
                throw ApiException.new401Unauthroized();
            }
            DecodedJWT jwt = null;
            for (String secret : this.getJwtSecrets(action, apiName, tenant)) {
                try {
                    JWTVerifier verifier = JWT.require((Algorithm)Algorithm.HMAC256((String)secret)).acceptLeeway(1L).build();
                    jwt = verifier.verify(token);
                    break;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (jwt == null) {
                throw ApiException.new401Unauthroized();
            }
            return this.createUserFromValidJwt(jwt);
        }

        protected User createUserFromValidJwt(DecodedJWT jwt) {
            String tenant;
            User user = new User();
            user.withUsername(jwt.getSubject());
            Claim c = jwt.getClaim("groups");
            if (c != null && !c.isNull()) {
                List groups = c.asList(String.class);
                user.withRoles(groups.toArray(new String[0]));
            }
            if ((c = jwt.getClaim("roles")) != null && !c.isNull()) {
                List roles = c.asList(String.class);
                user.withRoles(roles.toArray(new String[0]));
            }
            if ((c = jwt.getClaim("tenantId")) != null && !c.isNull()) {
                tenant = c.asString();
                user.withTenant(tenant);
            }
            if ((c = jwt.getClaim("tenantCode")) != null && !c.isNull()) {
                tenant = c.asString();
                user.withTenant(tenant);
            }
            if ((c = jwt.getClaim("tenant")) != null && !c.isNull()) {
                tenant = c.asString();
                user.withTenant(tenant);
            }
            this.addPermsToUser(user, jwt.getClaim("perms"));
            this.addPermsToUser(user, jwt.getClaim("actions"));
            return user;
        }

        protected void addPermsToUser(User user, Claim c) {
            if (c != null && !c.isNull()) {
                List perms = c.asList(String.class);
                user.withPermissions(perms.toArray(new String[0]));
            }
        }

        protected List<String> getJwtSecrets(AuthAction action, String apiName, String tenant) {
            LinkedHashSet<String> secrets = new LinkedHashSet<String>();
            for (int i = 10; i >= 0; --i) {
                for (int j = 2; j >= 0; --j) {
                    String secret;
                    String key = (action.getName() != null ? action.getName() : "") + ".jwt" + (i == 0 ? "" : "." + i);
                    if (j > 1 && apiName != null) {
                        key = key + "." + apiName;
                    }
                    if (j > 2 && tenant != null) {
                        key = key + "." + tenant;
                    }
                    if ((secret = Config.getString(key = key + ".secret")) == null) continue;
                    secrets.add(secret);
                }
            }
            return new ArrayList<String>(secrets);
        }

        public String signJwt(JWTCreator.Builder jwtBuilder, AuthAction action, String apiName, String tenant) throws IllegalArgumentException, JWTCreationException, UnsupportedEncodingException {
            String secret = this.getJwtSecrets(action, apiName, tenant).get(0);
            return jwtBuilder.sign(Algorithm.HMAC256((String)secret));
        }

        public RevokedTokenCache getRevokedTokenCache() {
            return this.revokedTokenCache;
        }

        public JwtUserDao withRevokedTokenCache(RevokedTokenCache revokedTokenCache) {
            this.revokedTokenCache = revokedTokenCache;
            return this;
        }

        public static interface RevokedTokenCache {
            public boolean isRevoked(String var1);
        }
    }

    public static class InMemoryRevokedTokenCache
    implements JwtUserDao.RevokedTokenCache {
        final Set<String> revoked = new HashSet<String>();

        public void addRevokedToken(String token) {
            this.revoked.add(token.toLowerCase());
        }

        @Override
        public boolean isRevoked(String token) {
            return this.revoked.contains(token);
        }
    }

    public static class InMemorySessionDao
    implements SessionDao {
        protected long sessionExp = 1800000L;
        protected long sessionUpdate = 10000L;
        protected int sessionMax = 10000;
        protected Map<String, User> cache;

        protected InMemorySessionDao() {
        }

        public InMemorySessionDao(int sessionMax) {
            this.cache = new LRUMap(sessionMax);
        }

        @Override
        public User get(String sessionKey) {
            long now = System.currentTimeMillis();
            User user = this.doGet(sessionKey);
            if (this.sessionExp > 0L) {
                long lastRequest = user.getRequestAt();
                if (now - lastRequest > this.sessionExp) {
                    this.delete(sessionKey);
                    throw ApiException.new401Unauthroized("The session has expired.", new Object[0]);
                }
                if (now - lastRequest > this.sessionUpdate) {
                    this.put(sessionKey, user);
                }
            }
            return this.cache.get(sessionKey);
        }

        protected User doGet(String sessionKey) {
            return this.cache.get(sessionKey);
        }

        @Override
        public String post(User user) {
            String sessionKey = this.newSessionId();
            this.put(sessionKey, user);
            return sessionKey;
        }

        @Override
        public void put(String sessionKey, User user) {
            this.doPut(sessionKey, user);
        }

        protected void doPut(String sessionKey, User user) {
            this.cache.put(sessionKey, user);
        }

        @Override
        public void delete(String sessionKey) {
            this.doDelete(sessionKey);
        }

        protected void doDelete(String sessionKey) {
            this.cache.remove(sessionKey);
        }

        protected String newSessionId() {
            String id = UUID.randomUUID().toString();
            id = id.replace("-", "");
            return id;
        }

        public SessionDao withSessionUpdate(long sessionUpdate) {
            this.sessionUpdate = sessionUpdate;
            return this;
        }

        public SessionDao withSessionMax(int sessionMax) {
            this.sessionMax = sessionMax;
            return this;
        }

        public SessionDao withSessionExp(long sessionExp) {
            this.sessionExp = sessionExp;
            return this;
        }
    }
}

