/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.action.db;

import io.inversion.Action;
import io.inversion.Api;
import io.inversion.ApiException;
import io.inversion.Chain;
import io.inversion.Collection;
import io.inversion.Db;
import io.inversion.Index;
import io.inversion.Property;
import io.inversion.Relationship;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.Results;
import io.inversion.rql.Page;
import io.inversion.rql.Term;
import io.inversion.utils.JSArray;
import io.inversion.utils.JSNode;
import io.inversion.utils.Rows;
import io.inversion.utils.Url;
import io.inversion.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.KeyValue;
import org.apache.commons.collections4.keyvalue.DefaultKeyValue;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;

public class DbGetAction
extends Action<DbGetAction> {
    protected int maxRows = 100;

    protected static boolean exclude(String path, Set<String> includes, Set<String> excludes) {
        boolean exclude = false;
        if (includes.size() > 0 || excludes.size() > 0) {
            path = path.toLowerCase();
            if (!(includes.size() <= 0 || path.endsWith("href") || path.endsWith(".href") || DbGetAction.find(includes, path, true))) {
                exclude = true;
            }
            if (excludes != null && excludes.size() > 0 && DbGetAction.find(excludes, path, false)) {
                exclude = true;
            }
        }
        return exclude;
    }

    protected static String getResourceKey(Object obj) {
        String str;
        int idx;
        if (obj == null) {
            return null;
        }
        if (obj instanceof JSNode) {
            obj = ((JSNode)obj).get("href");
        }
        if ((idx = (str = (String)obj).lastIndexOf(47)) > 0) {
            str = str.substring(idx + 1);
        }
        return str;
    }

    public static String stripTerms(String url, String ... tokens) {
        Url u = new Url(url);
        u.clearParams(tokens);
        return u.toString();
    }

    protected static String stripTerm(String str, String startToken, char ... endingTokens) {
        HashSet<Character> tokens = new HashSet<Character>();
        for (char c : endingTokens) {
            tokens.add(Character.valueOf(c));
        }
        while (true) {
            int end;
            char c;
            int start = str.toLowerCase().indexOf(startToken);
            while (start > 0 && (Character.isAlphabetic(str.charAt(start - 1)) || Character.isDigit(start - 1))) {
                start = str.toLowerCase().indexOf(startToken, start + 1);
            }
            if (start <= -1) break;
            String beginning = str.substring(0, start);
            for (end = start + startToken.length() + 1; end < str.length() && !tokens.contains(Character.valueOf(c = str.charAt(end))); ++end) {
            }
            if (end == str.length()) {
                str = beginning;
                continue;
            }
            str = beginning + str.substring(end + 1);
        }
        return str;
    }

    protected static String expandPath(String path, Object next) {
        if (Utils.empty(path)) {
            return next + "";
        }
        return path + "." + next;
    }

    protected static boolean shouldExpand(Set<String> expands, String path, Relationship rel) {
        boolean expand = false;
        path = path.length() == 0 ? rel.getName() : path + "." + rel.getName();
        path = path.toLowerCase();
        for (String ep : expands) {
            if (!ep.startsWith(path) || ep.length() != path.length() && ep.charAt(path.length()) != '.') continue;
            expand = true;
            break;
        }
        return expand;
    }

    protected static boolean find(java.util.Collection<String> params, String path, boolean matchStart) {
        boolean rtval = false;
        if (params.contains(path)) {
            rtval = true;
        } else {
            for (String param : params) {
                if (matchStart && param.startsWith(path + ".")) {
                    rtval = true;
                    break;
                }
                if (!Utils.wildcardMatch(param, path)) continue;
                rtval = true;
            }
        }
        return rtval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run(Request req, Response res) throws ApiException {
        Results results;
        if (req.getRelationshipKey() != null) {
            StringBuilder newHref;
            String resourceKey = req.getResourceKey();
            Collection collection = req.getCollection();
            Relationship rel = collection.getRelationship(req.getRelationshipKey());
            if (rel == null) {
                throw ApiException.new404NotFound("'{}' is not a valid relationship", req.getRelationshipKey());
            }
            if (rel.isOneToMany()) {
                Collection relatedCollection = rel.getRelated();
                newHref = new StringBuilder(Chain.buildLink(relatedCollection, null, null) + "?");
                Rows.Row resourceKeyRow = collection.decodeResourceKey(req.getResourceKey());
                if (rel.getFkIndex1().size() != collection.getPrimaryIndex().size() && rel.getFkIndex1().size() == 1) {
                    String propName = rel.getFk1Col1().getJsonName();
                    newHref.append(propName).append("=").append(resourceKey);
                } else {
                    Index fkIdx = rel.getFkIndex1();
                    Index pkIdx = collection.getPrimaryIndex();
                    for (int i = 0; i < fkIdx.size(); ++i) {
                        Property fk = fkIdx.getProperty(i);
                        String pkName = pkIdx.getPropertyName(i);
                        Object pkVal = resourceKeyRow.get(pkName);
                        if (pkVal == null) {
                            throw ApiException.new400BadRequest("Missing parameter for foreign key property '{}'", fk.getJsonName());
                        }
                        newHref.append(fk.getJsonName()).append("=").append(pkVal).append("&");
                    }
                    newHref = new StringBuilder(newHref.substring(0, newHref.length() - 1));
                }
            } else {
                if (!rel.isManyToMany()) throw new UnsupportedOperationException("FIX ME IF FOUND...implementation logic error.");
                List<KeyValue<String, String>> rows = this.getRelatedKeys(rel, rel.getFkIndex1(), rel.getFkIndex2(), Collections.singletonList(resourceKey));
                if (rows.size() <= 0) return;
                ArrayList foreignKeys = new ArrayList();
                rows.forEach(k -> foreignKeys.add((String)k.getValue()));
                Collection relatedCollection = rel.getRelated();
                String resourceKeys = Utils.implode(",", foreignKeys.toArray());
                newHref = new StringBuilder(Chain.buildLink(relatedCollection, resourceKeys, null));
            }
            String query = req.getUrl().getQueryString();
            if (query != null) {
                if (!newHref.toString().contains("?")) {
                    newHref.append("?");
                } else {
                    newHref.append("&");
                }
                newHref.append(query);
            }
            Response included = req.getEngine().get(newHref.toString());
            res.withStatus(included.getStatus());
            res.withJson(included.getJson());
            return;
        }
        if (req.getCollection() != null && !Utils.empty(req.getResourceKey())) {
            List<String> resourceKeys = Utils.explode(",", req.getResourceKey());
            Term term = Term.term(null, "_key", req.getCollection().getPrimaryIndex().getName(), resourceKeys.toArray());
            req.getUrl().withParams(term.toString(), null);
        }
        if ((results = this.select(req, req.getCollection(), req.getApi())).size() == 0 && req.getResourceKey() != null && req.getCollectionKey() != null) {
            res.withStatus("404 Not Found");
            return;
        } else {
            res.withRecords(results.getRows());
            Object page = results.getQuery().getPage();
            res.withPageSize(((Page)page).getPageSize());
            res.withPageNum(((Page)page).getPageNum());
            int offest = ((Page)page).getOffset();
            int limit = ((Page)page).getLimit();
            int foundRows = results.getFoundRows();
            if (foundRows < 0 && results.size() >= 0 && offest <= 0 && results.size() < limit) {
                foundRows = results.size();
            }
            if (foundRows >= 0) {
                res.withFoundRows(foundRows);
            }
            if (results.size() <= 0 || req.getCollection() == null || req.getResourceKey() != null) return;
            List<Term> nextTerms = results.getNext();
            if (nextTerms != null && !nextTerms.isEmpty()) {
                String next = req.getUrl().getOriginal();
                for (Term nextTerm : nextTerms) {
                    String toStrip = nextTerm.getToken();
                    if (!(next = DbGetAction.stripTerms(next, toStrip)).contains("?")) {
                        next = next + "?";
                    }
                    if (!next.endsWith("?")) {
                        next = next + "&";
                    }
                    next = next + nextTerm;
                }
                res.withNext(next);
                return;
            } else {
                if (results.size() != limit || foundRows >= 0 && offest + limit >= foundRows) return;
                String next = req.getUrl().getOriginal();
                if (!(next = DbGetAction.stripTerms(next, "offset", "page", "pageNum")).contains("?")) {
                    next = next + "?";
                }
                if (!next.endsWith("?")) {
                    next = next + "&";
                }
                next = next + "pageNum=" + (((Page)page).getPageNum() + 1);
                res.withNext(next);
            }
        }
    }

    protected Results select(Request req, Collection collection, Api api) throws ApiException {
        Results results;
        if (collection == null) {
            Db db = api.getDb((String)Chain.peek().get("db"));
            if (db == null) {
                List<Db> dbs = api.getDbs();
                if (dbs.size() == 1) {
                    db = dbs.get(0);
                } else {
                    for (Db candidate : dbs) {
                        if (candidate.getEndpointPath() == null || !candidate.getEndpointPath().matches(req.getEndpointPath())) continue;
                        db = candidate;
                        break;
                    }
                }
            }
            if (db == null) {
                throw ApiException.new400BadRequest("Unable to find collection for url '{}'", req.getUrl());
            }
            results = db.select(null, req.getUrl().getParams());
        } else {
            results = collection.getDb().select(collection, req.getUrl().getParams());
        }
        if (results.size() > 0) {
            if (collection != null) {
                this.expand(req, collection, results.getRows(), null, null, null);
            }
            this.exclude(results.getRows());
        }
        return results;
    }

    protected void exclude(List<JSNode> nodes) {
        Set<String> includes = Chain.peek().mergeEndpointActionParamsConfig("includes");
        Set<String> excludes = Chain.peek().mergeEndpointActionParamsConfig("excludes");
        if (includes.size() > 0 || excludes.size() > 0) {
            for (JSNode node : nodes) {
                this.exclude(node, includes, excludes, null);
            }
        }
    }

    protected void exclude(JSNode node, Set<String> includes, Set<String> excludes, String path) {
        for (String key : node.keySet()) {
            String attrPath;
            String string = attrPath = path != null ? path + "." + key : key;
            if (DbGetAction.exclude(attrPath, includes, excludes)) {
                node.remove(key);
                continue;
            }
            Object value = node.get(key);
            if (value instanceof JSArray) {
                JSArray arr = (JSArray)value;
                for (int i = 0; i < arr.size(); ++i) {
                    if (!(arr.get(i) instanceof JSNode)) continue;
                    this.exclude((JSNode)arr.get(i), includes, excludes, attrPath);
                }
                continue;
            }
            if (!(value instanceof JSNode)) continue;
            this.exclude((JSNode)value, includes, excludes, attrPath);
        }
    }

    protected void expand(Request request, Collection collection, List<JSNode> parentObjs, Set expands, String expandsPath, MultiKeyMap pkCache) {
        if (parentObjs.size() == 0) {
            return;
        }
        if (expands == null) {
            expands = Chain.peek().mergeEndpointActionParamsConfig("expands");
        }
        if (expandsPath == null) {
            expandsPath = "";
        }
        for (Relationship rel : collection.getRelationships()) {
            Object parentObj22;
            boolean shouldExpand = DbGetAction.shouldExpand(expands, expandsPath, rel);
            if (!shouldExpand) continue;
            if (pkCache == null) {
                pkCache = new MultiKeyMap();
                for (JSNode node : parentObjs) {
                    pkCache.put((Object)collection, (Object)DbGetAction.getResourceKey(node), (Object)node);
                }
            }
            Collection relatedCollection = rel.getRelated();
            Index idxToMatch = null;
            Index idxToRetrieve = null;
            List<Object> relatedEks = null;
            if (rel.isManyToOne()) {
                idxToMatch = collection.getPrimaryIndex();
                idxToRetrieve = rel.getFkIndex1();
                relatedEks = new ArrayList();
                for (JSNode jSNode : parentObjs) {
                    String parentEk = DbGetAction.getResourceKey(jSNode);
                    String string = jSNode.getString(rel.getName());
                    if (string == null) continue;
                    String string2 = DbGetAction.getResourceKey(string);
                    relatedEks.add(new DefaultKeyValue((Object)parentEk, (Object)string2));
                }
            } else if (rel.isOneToMany()) {
                idxToMatch = rel.getFkIndex1();
                idxToRetrieve = rel.getRelated().getPrimaryIndex();
            } else if (rel.isManyToMany()) {
                idxToMatch = rel.getFkIndex1();
                idxToRetrieve = rel.getFkIndex2();
            }
            if (relatedEks == null) {
                ArrayList<String> toMatchEks = new ArrayList<String>();
                for (Object parentObj22 : parentObjs) {
                    String string = DbGetAction.getResourceKey(parentObj22);
                    if (toMatchEks.contains(string)) continue;
                    if (((JSNode)parentObj22).get(rel.getName()) instanceof JSArray) {
                        throw ApiException.new500InternalServerError("Algorithm implementation error...this relationship seems to have already been expanded.", new Object[0]);
                    }
                    toMatchEks.add(string);
                    if (rel.isManyToOne()) {
                        ((JSNode)parentObj22).remove(rel.getName());
                        continue;
                    }
                    ((JSNode)parentObj22).put(rel.getName(), (Object)new JSArray(new Object[0]));
                }
                relatedEks = this.getRelatedKeys(rel, idxToMatch, idxToRetrieve, toMatchEks);
            }
            ArrayList<String> unfetchedChildEks = new ArrayList<String>();
            ArrayListValuedHashMap arrayListValuedHashMap = new ArrayListValuedHashMap();
            parentObj22 = relatedEks.iterator();
            while (parentObj22.hasNext()) {
                KeyValue keyValue = (KeyValue)parentObj22.next();
                String string = (String)keyValue.getKey();
                String relatedEk = (String)keyValue.getValue();
                arrayListValuedHashMap.put((Object)relatedEk, (Object)string);
                if (pkCache.containsKey((Object)relatedCollection, (Object)relatedEk)) continue;
                unfetchedChildEks.add(relatedEk);
            }
            List<JSNode> newChildObjs = this.recursiveGet(pkCache, relatedCollection, unfetchedChildEks, DbGetAction.expandPath(expandsPath, rel.getName()));
            for (KeyValue keyValue : relatedEks) {
                String parentEk = (String)keyValue.getKey();
                String relatedEk = (String)keyValue.getValue();
                JSNode parentObj = (JSNode)pkCache.get((Object)collection, (Object)parentEk);
                JSNode childObj = (JSNode)pkCache.get((Object)relatedCollection, (Object)relatedEk);
                if (rel.isManyToOne()) {
                    parentObj.put(rel.getName(), (Object)childObj);
                    continue;
                }
                if (childObj == null) continue;
                parentObj.getArray(rel.getName()).add(childObj);
            }
            if (newChildObjs.size() <= 0) continue;
            this.expand(request, relatedCollection, newChildObjs, expands, DbGetAction.expandPath(expandsPath, rel.getName()), pkCache);
        }
    }

    protected List<KeyValue<String, String>> getRelatedKeys(Relationship rel, Index idxToMatch, Index idxToRetrieve, List<String> toMatchEks) throws ApiException {
        if (idxToMatch.getCollection() != idxToRetrieve.getCollection()) {
            throw ApiException.new400BadRequest("You can only retrieve related index keys from the same Collection.", new Object[0]);
        }
        ArrayList<KeyValue<String, String>> related = new ArrayList<KeyValue<String, String>>();
        LinkedHashSet<String> columns = new LinkedHashSet<String>();
        columns.addAll(idxToMatch.getColumnNames());
        columns.addAll(idxToRetrieve.getColumnNames());
        Term termKeys = Term.term(null, "_key", idxToMatch.getName(), toMatchEks);
        Term includes = Term.term(null, "includes", columns);
        Term sort = Term.term(null, "sort", columns);
        Term notNull = Term.term(null, "nn", columns);
        String link = Chain.buildLink(idxToRetrieve.getCollection());
        Response res = Chain.peek().getEngine().get(link, Arrays.asList(termKeys, includes, sort, notNull)).assertOk(new String[0]);
        for (JSNode node : res.data().asNodeList()) {
            ArrayList<Object> idxToMatchVals = new ArrayList<Object>();
            for (String string : idxToMatch.getJsonNames()) {
                Object propVal = node.get(string);
                if (propVal instanceof String && ((String)(propVal = Utils.substringAfter(propVal.toString(), "/"))).contains("~")) {
                    idxToMatchVals.addAll(Utils.explode("~", (String)propVal));
                    continue;
                }
                idxToMatchVals.add(propVal);
            }
            ArrayList<Object> idxToRetrieveVals = new ArrayList<Object>();
            for (String property3 : idxToRetrieve.getJsonNames()) {
                Object propVal = node.get(property3);
                if (((String)(propVal = Utils.substringAfter(propVal.toString(), "/"))).contains("~")) {
                    idxToRetrieveVals.addAll(Utils.explode("~", (String)propVal));
                    continue;
                }
                idxToRetrieveVals.add(propVal);
            }
            String string = Collection.encodeResourceKey(idxToMatchVals);
            String relatedEk = Collection.encodeResourceKey(idxToRetrieveVals);
            related.add((KeyValue<String, String>)new DefaultKeyValue((Object)string, (Object)relatedEk));
        }
        return related;
    }

    protected List<JSNode> recursiveGet(MultiKeyMap pkCache, Collection collection, java.util.Collection resourceKeys, String expandsPath) throws ApiException {
        if (resourceKeys.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        String url = Chain.buildLink(collection, Utils.implode(",", resourceKeys), null);
        Response res = Chain.peek().getEngine().get(url);
        int sc = res.getStatusCode();
        if (sc == 401 || sc == 403) {
            return null;
        }
        if (sc == 404) {
            return Collections.EMPTY_LIST;
        }
        if (sc == 500) {
            res.rethrow();
        } else if (sc == 200) {
            List nodes = res.getData().asList();
            for (JSNode node : nodes) {
                String resourceKey = DbGetAction.getResourceKey(node);
                if (pkCache.containsKey((Object)collection, (Object)resourceKey)) {
                    throw ApiException.new500InternalServerError("FIX ME IF FOUND.  Algorithm Implementation Error", new Object[0]);
                }
                pkCache.put((Object)collection, (Object)resourceKey, (Object)node);
            }
            return nodes;
        }
        res.rethrow();
        return null;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public DbGetAction withMaxRows(int maxRows) {
        this.maxRows = maxRows;
        return this;
    }
}

