/*
 * Decompiled with CFR 0.152.
 */
package io.inversion;

import io.inversion.Api;
import io.inversion.ApiException;
import io.inversion.Chain;
import io.inversion.Collection;
import io.inversion.Endpoint;
import io.inversion.Engine;
import io.inversion.Response;
import io.inversion.utils.JSArray;
import io.inversion.utils.JSNode;
import io.inversion.utils.Path;
import io.inversion.utils.Url;
import io.inversion.utils.Utils;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;

public class Request {
    public static final String COLLECTION_KEY = "_collection";
    public static final String RESOURCE_KEY = "_resource";
    public static final String RELATIONSHIP_KEY = "_relationship";
    protected long startAt = System.currentTimeMillis();
    protected long endAt = -1L;
    protected Chain chain = null;
    protected String referrer = null;
    protected String remoteAddr = null;
    protected ArrayListValuedHashMap<String, String> headers = new ArrayListValuedHashMap();
    protected Url url = null;
    protected String method = null;
    protected Engine engine = null;
    protected Api api = null;
    protected Path apiPath = null;
    protected Path apiMatchPath = null;
    protected Endpoint endpoint = null;
    protected Path endpointPath = null;
    protected Path endpointMatchPath = null;
    protected Collection collection = null;
    protected Path collectionPath = null;
    protected Path collectionMatchPath = null;
    protected String body = null;
    protected JSNode json = null;
    protected Uploader uploader = null;
    protected int retryMax = 0;
    int retryCount = 0;
    File retryFile;
    boolean explain = false;

    public Request() {
    }

    public Request(String method, String url) {
        this(method, url, null, null, -1);
    }

    public Request(String method, String url, String body) {
        this.withMethod(method);
        this.withUrl(url);
        this.withBody(body);
    }

    public Request(Engine engine, String method, String url, Object body) {
        this.withEngine(engine);
        this.withMethod(method);
        this.withUrl(url);
        if (body != null) {
            this.withBody(body.toString());
        }
    }

    public Request(String method, String url, Map<String, String> headers, Map<String, String> params, String body) {
        this.withMethod(method);
        this.withUrl(url);
        this.withBody(body);
        if (headers != null) {
            for (String key : headers.keySet()) {
                this.withHeader(key, headers.get(key));
            }
        }
        if (params != null) {
            this.url.withParams(params);
        }
    }

    public Request(String method, String url, String body, ArrayListValuedHashMap<String, String> headers, int retryAttempts) {
        this(method, url, body, null, headers, retryAttempts);
    }

    public Request(String method, String url, String body, Map<String, String> params, ArrayListValuedHashMap<String, String> headers, int retryMax) {
        this.withMethod(method);
        this.withUrl(url);
        this.withBody(body);
        if (params != null) {
            this.url.withParams(params);
        }
        if (headers != null && headers.size() > 0) {
            this.headers = new ArrayListValuedHashMap(headers);
        }
        if (retryMax > -1) {
            this.retryMax = retryMax;
        }
    }

    public Engine getEngine() {
        return this.engine;
    }

    public Request withEngine(Engine service) {
        this.engine = service;
        return this;
    }

    public Request withUrl(String url) {
        Url u = new Url(url);
        String key = u.findKey("explain");
        if (key != null) {
            String explain = u.clearParams(key);
            if (Utils.empty(explain) || "true".equalsIgnoreCase(explain.trim())) {
                this.withExplain(true);
            }
            u = new Url(u.toString());
        }
        this.url = u;
        return this;
    }

    public long getStartAt() {
        return this.startAt;
    }

    public Request withStartAt(long startAt) {
        this.startAt = startAt;
        return this;
    }

    public long getEndAt() {
        return this.endAt;
    }

    public Request withEndAt(long endAt) {
        this.endAt = endAt;
        return this;
    }

    public Request withMethod(String method) {
        this.method = method;
        return this;
    }

    public Request withHeaders(String key, String value) {
        this.headers.put((Object)key, (Object)value);
        return this;
    }

    public Request withHeaders(Map<String, String> headers) {
        this.headers.putAll(headers);
        return this;
    }

    public Collection getCollection() {
        return this.collection;
    }

    public boolean hasCollectionKey(String ... collectionKeys) {
        String collectionKey = this.getCollectionKey();
        if (collectionKey != null) {
            for (int i = 0; collectionKeys != null && i < collectionKeys.length; ++i) {
                String key = collectionKeys[i];
                if (key == null || !key.equalsIgnoreCase(collectionKey)) continue;
                return true;
            }
        }
        return false;
    }

    public Request withCollection(Collection collection) {
        this.collection = collection;
        return this;
    }

    public Request withCollection(Collection collection, Path collectionPath, Path collectionMatchPath) {
        this.collection = collection;
        this.collectionPath = collectionPath;
        this.collectionMatchPath = collectionMatchPath;
        return this;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public Request withEndpoint(Endpoint endpoint, Path endpointPath, Path endpointMatchPath) {
        this.endpoint = endpoint;
        this.endpointPath = endpointPath;
        this.endpointMatchPath = endpointMatchPath;
        return this;
    }

    public boolean isDebug() {
        String url = this.getUrl().toString();
        if (url.indexOf("://localhost/") > 0) {
            return true;
        }
        if (url.indexOf("://127.0.0.1/") > 0) {
            return true;
        }
        if (this.getApi() != null) {
            return this.getApi().isDebug();
        }
        return false;
    }

    public boolean isExplain() {
        return this.explain;
    }

    public Request withExplain(boolean explain) {
        this.explain = explain;
        return this;
    }

    public String getBody() {
        return this.body;
    }

    public Request withBody(String body) {
        this.body = body;
        return this;
    }

    public JSNode getJson() throws ApiException {
        if (this.json != null) {
            return this.json;
        }
        String body = this.getBody();
        if (Utils.empty(body)) {
            return null;
        }
        try {
            this.json = JSNode.parseJsonNode(body);
        }
        catch (Exception ex) {
            throw ApiException.new400BadRequest("Unparsable JSON body", new Object[0]);
        }
        return this.json;
    }

    public JSArray getData() {
        JSNode node = this.getJson();
        if (node != null) {
            if (node instanceof JSArray) {
                return (JSArray)node;
            }
            if (node.get("data") instanceof JSArray) {
                return node.getArray("data");
            }
            return new JSArray(new Object[]{node});
        }
        if (this.getBody() == null) {
            return new JSArray(new Object[0]);
        }
        return null;
    }

    public Request withJson(JSNode json) {
        this.json = json;
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public boolean isMethod(String ... methods) {
        for (String method : methods) {
            if (!this.method.equalsIgnoreCase(method)) continue;
            return true;
        }
        return false;
    }

    public boolean isPut() {
        return "put".equalsIgnoreCase(this.method);
    }

    public boolean isPost() {
        return "post".equalsIgnoreCase(this.method);
    }

    public boolean isPatch() {
        return "patch".equalsIgnoreCase(this.method);
    }

    public boolean isGet() {
        return "get".equalsIgnoreCase(this.method);
    }

    public boolean isDelete() {
        return "delete".equalsIgnoreCase(this.method);
    }

    public String getReferrer() {
        return this.getHeader("referrer");
    }

    public String getHeader(String key) {
        List vals = this.headers.get((Object)(key = key.toLowerCase()));
        if (vals != null && vals.size() > 0) {
            return (String)vals.get(0);
        }
        return null;
    }

    public void removeHeader(String key) {
        key = key.toLowerCase();
        this.headers.remove((Object)key);
    }

    public ArrayListValuedHashMap<String, String> getHeaders() {
        return this.headers;
    }

    public void withHeader(String key, String value) {
        if (!this.headers.containsMapping((Object)(key = key.toLowerCase()), (Object)value)) {
            this.headers.put((Object)key, (Object)value);
        }
    }

    public Api getApi() {
        return this.api;
    }

    public Chain getChain() {
        return this.chain;
    }

    public Request withChain(Chain chain) {
        this.chain = chain;
        return this;
    }

    public Url getUrl() {
        return this.url;
    }

    public Path getPath() {
        Path path = this.url.getPath();
        int startIdx = this.apiPath == null ? 0 : this.apiPath.size();
        path = path.subpath(startIdx, path.size());
        return path;
    }

    public Path getSubpath() {
        Path subpath = this.getPath();
        Path ep = this.endpointPath;
        int startIdx = ep == null ? 0 : ep.size();
        subpath = subpath.subpath(startIdx, subpath.size());
        return subpath;
    }

    public String getCollectionKey() {
        return this.url.getParam(COLLECTION_KEY);
    }

    public String getResourceKey() {
        return this.url.getParam(RESOURCE_KEY);
    }

    public String getRelationshipKey() {
        return this.url.getParam(RELATIONSHIP_KEY);
    }

    public Request withApi(Api api, Path apiPath, Path apiMatchPath) {
        this.api = api;
        this.apiPath = apiPath;
        this.apiMatchPath = apiMatchPath;
        return this;
    }

    public String getApiUrl() {
        return this.url.getProtocol() + "://" + this.url.getHost() + (this.url.getPort() > 0 ? ":" + this.url.getPort() : "") + "/" + this.apiPath;
    }

    public Path getApiPath() {
        return this.apiPath;
    }

    public Path getEndpointPath() {
        return this.endpointPath;
    }

    public Path getApiMatchPath() {
        return this.apiMatchPath;
    }

    public Path getEndpointMatchPath() {
        return this.endpointMatchPath;
    }

    public Path getCollectionPath() {
        return this.collectionPath;
    }

    public Path getCollectionMatchPath() {
        return this.collectionMatchPath;
    }

    public String getRemoteAddr() {
        String remoteAddr = this.getHeader("X-Forwarded-For");
        if (remoteAddr == null || remoteAddr.length() == 0 || "unknown".equalsIgnoreCase(remoteAddr)) {
            remoteAddr = this.getHeader("Proxy-Client-IP");
        }
        if (remoteAddr == null || remoteAddr.length() == 0 || "unknown".equalsIgnoreCase(remoteAddr)) {
            remoteAddr = this.getHeader("WL-Proxy-Client-IP");
        }
        if (remoteAddr == null || remoteAddr.length() == 0 || "unknown".equalsIgnoreCase(remoteAddr)) {
            remoteAddr = this.getHeader("HTTP_CLIENT_IP");
        }
        if (remoteAddr == null || remoteAddr.length() == 0 || "unknown".equalsIgnoreCase(remoteAddr)) {
            remoteAddr = this.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (remoteAddr == null || remoteAddr.length() == 0 || "unknown".equalsIgnoreCase(remoteAddr)) {
            remoteAddr = this.remoteAddr;
        }
        return remoteAddr;
    }

    public Request withRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
        return this;
    }

    public Uploader getUploader() {
        return this.uploader;
    }

    public Request withUploader(Uploader uploader) {
        this.uploader = uploader;
        return this;
    }

    public Validation validate(String propOrJsonPath) {
        return this.validate(propOrJsonPath, null);
    }

    public Validation validate(String propOrJsonPath, String customErrorMessage) {
        return new Validation(this, propOrJsonPath, customErrorMessage);
    }

    public boolean isLocalRequest() {
        String url = this.getUrl().toString();
        return this.chain != null && !url.startsWith("http:") && !url.startsWith("https://");
    }

    public int getRetryMax() {
        return this.retryMax;
    }

    public Request withRetryMax(int retryMax) {
        this.retryMax = retryMax;
        return this;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void incrementRetryCount() {
        ++this.retryCount;
    }

    public File getRetryFile() {
        return this.retryFile;
    }

    public void setRetryFile(File retryFile) {
        this.retryFile = retryFile;
    }

    public List<Upload> getUploads() {
        return this.uploader.getUploads();
    }

    public String buildPath(String path) {
        StringBuffer buff = new StringBuffer();
        Pattern p = Pattern.compile("(\\[?+)\\:([\\w\\-\\_]*)(\\]?+)");
        Matcher m = p.matcher(path);
        boolean optional = false;
        while (m.find()) {
            String key = m.group(2);
            String param = this.getUrl().getParam(key);
            if (param == null) {
                if ("[".equals(m.group(1)) && "]".equals(m.group(3))) {
                    optional = true;
                    break;
                }
                param = ":" + key;
            }
            String value = Matcher.quoteReplacement(param);
            m.appendReplacement(buff, value);
        }
        if (!optional) {
            m.appendTail(buff);
        }
        return buff.toString();
    }

    public static interface Uploader {
        public List<Upload> getUploads();
    }

    public static class Validation {
        final String customErrorMessage;
        final String propOrPath;
        Object value;

        public Validation(Request req, String propOrPath, String customErrorMessage) {
            this.value = req.getUrl().getParam(propOrPath);
            if (this.value == null && req.getJson() != null) {
                this.value = req.getJson().find(propOrPath);
            }
            this.propOrPath = null;
            this.customErrorMessage = customErrorMessage;
        }

        public Validation(Response res, String jsonPath, String customErrorMessage) {
            this.value = res.find(jsonPath);
            this.propOrPath = null;
            this.customErrorMessage = customErrorMessage;
        }

        public Validation required(String ... childProps) {
            if (Utils.empty(this.value)) {
                this.fail("Required field '" + this.propOrPath + "' is missing.");
            }
            if (childProps != null && this.value instanceof JSNode && !((JSNode)this.value).isArray()) {
                for (String childProp : childProps) {
                    if (!Utils.empty(((JSNode)this.value).get(childProp))) continue;
                    this.fail("Required field '" + this.propOrPath + "." + childProp + "' is missing.");
                }
            }
            return this;
        }

        public Validation matches(String regex) {
            if (this.value == null) {
                return this;
            }
            if (!this.value.toString().matches(regex)) {
                this.fail("Field '" + this.propOrPath + "' does not match the required pattern.");
            }
            return this;
        }

        public Validation in(Object ... possibleValues) {
            if (this.value == null) {
                return this;
            }
            if (!Utils.in(this.value, possibleValues)) {
                this.fail("Field '" + this.propOrPath + "' is not one of the possible values.");
            }
            return this;
        }

        public Validation out(Object ... excludedValues) {
            if (this.value == null) {
                return this;
            }
            if (Utils.in(this.value, excludedValues)) {
                this.fail("Field '" + this.propOrPath + "' has a restricted value.");
            }
            return this;
        }

        protected int compareTo(Object compareTo) {
            Object value = this.value;
            if (compareTo instanceof Number) {
                try {
                    value = Double.parseDouble(value.toString());
                    compareTo = Double.parseDouble(compareTo.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (value instanceof Comparable) {
                return ((Comparable)value).compareTo(compareTo);
            }
            return (value + "").compareTo(compareTo + "");
        }

        public Validation gt(Object compareTo) {
            if (this.value == null) {
                return this;
            }
            if (this.compareTo(compareTo) < 1) {
                this.fail("Field '" + this.propOrPath + "' is less than the required value.");
            }
            return this;
        }

        public Validation ge(Object compareTo) {
            if (this.value == null) {
                return this;
            }
            if (this.compareTo(compareTo) < 0) {
                this.fail("Field '" + this.propOrPath + "' is less than the required value.");
            }
            return this;
        }

        public Validation lt(Object compareTo) {
            if (this.value == null) {
                return this;
            }
            if (this.compareTo(compareTo) > -1) {
                this.fail("Field '" + this.propOrPath + "' is greater than the required value.");
            }
            return this;
        }

        public Validation le(Object compareTo) {
            if (this.value == null) {
                return this;
            }
            if (this.compareTo(compareTo) > 0) {
                this.fail("Field '" + this.propOrPath + "' is greater than the required value.");
            }
            return this;
        }

        public Validation eq(Object compareTo) {
            if (this.value == null) {
                return this;
            }
            if (this.compareTo(compareTo) != 0) {
                this.fail("Field '" + this.propOrPath + "' is not equal to the required value.");
            }
            return this;
        }

        public Validation ne(Object compareTo) {
            if (this.value == null) {
                return this;
            }
            if (this.compareTo(compareTo) != 0) {
                this.fail("Field '" + this.propOrPath + "' is equal to a restricted value.");
            }
            return this;
        }

        public Validation length(int max) {
            if (this.value == null) {
                return this;
            }
            if (this.value.toString().length() > max) {
                this.fail("Field '" + this.propOrPath + "' is longer than the max allowed length of '" + max + "'.");
            }
            return this;
        }

        public Validation length(int min, int max) {
            if (this.value == null) {
                return this;
            }
            int length = this.value.toString().length();
            if (length > max) {
                this.fail("Field '" + this.propOrPath + "' is longer than the maximum allowed length of '" + max + "'.");
            }
            if (length < min) {
                this.fail("Field '" + this.propOrPath + "' is shorter than the minimum allowed length of '" + max + "'.");
            }
            return this;
        }

        public Validation minMax(Number min, Number max) {
            if (this.value == null) {
                return this;
            }
            this.max(max);
            this.min(min);
            return this;
        }

        public Validation max(Number max) {
            if (this.value == null) {
                return this;
            }
            if (Double.parseDouble(max.toString()) < Double.parseDouble(this.value.toString())) {
                this.fail("Field '" + this.propOrPath + "' is greater than the required maximum of '" + max + "'.");
            }
            return this;
        }

        public Validation min(Number min) {
            if (this.value == null) {
                return this;
            }
            if (Double.parseDouble(min.toString()) > Double.parseDouble(this.value.toString())) {
                this.fail("Field '" + this.propOrPath + "' is less than the required minimum of '" + min + "'.");
            }
            return this;
        }

        public Object value() {
            return this.value;
        }

        public JSNode asNode() {
            if (this.value == null) {
                return null;
            }
            if (this.value instanceof String) {
                this.value = JSNode.parseJson(this.value.toString());
            }
            return (JSNode)this.value;
        }

        public JSArray asArray() {
            if (this.value == null) {
                return null;
            }
            if (this.value instanceof String) {
                this.value = JSNode.parseJsonArray(this.value.toString());
            }
            return (JSArray)this.value;
        }

        public String asString() {
            if (this.value == null) {
                return null;
            }
            return this.value.toString();
        }

        public int asInt() {
            if (this.value == null) {
                return -1;
            }
            try {
                return Integer.parseInt(this.value + "");
            }
            catch (Exception ex) {
                this.fail("Field '" + this.propOrPath + "' must be an integer.");
                return -1;
            }
        }

        public double asDouble() {
            if (this.value == null) {
                return -1.0;
            }
            try {
                return Double.parseDouble(this.value + "");
            }
            catch (Exception ex) {
                this.fail("Field '" + this.propOrPath + "' must be an number.");
                return -1.0;
            }
        }

        public boolean asBoolean() {
            try {
                return Boolean.parseBoolean(this.value + "");
            }
            catch (Exception ex) {
                this.fail("Field '" + this.propOrPath + "' must be a boolean.");
                return false;
            }
        }

        protected void fail(String defaultErrorMessage) throws ApiException {
            String message = this.customErrorMessage != null ? this.customErrorMessage : defaultErrorMessage;
            throw ApiException.new400BadRequest(message, new Object[0]);
        }
    }

    public static class Upload {
        String fileName;
        long fileSize;
        String requestPath;
        InputStream inputStream;

        public Upload(String fileName, long fileSize, String requestPath, InputStream inputStream) {
            this.fileName = fileName;
            this.fileSize = fileSize;
            this.requestPath = requestPath;
            this.inputStream = inputStream;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public void setFileSize(long fileSize) {
            this.fileSize = fileSize;
        }

        public String getRequestPath() {
            return this.requestPath;
        }

        public void setRequestPath(String requestPath) {
            this.requestPath = requestPath;
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public void setInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }
    }
}

