/*
 * Decompiled with CFR 0.152.
 */
package io.inversion;

import io.inversion.Api;
import io.inversion.ApiException;
import io.inversion.Chain;
import io.inversion.Collection;
import io.inversion.Index;
import io.inversion.Property;
import io.inversion.Relationship;
import io.inversion.Results;
import io.inversion.rql.RqlParser;
import io.inversion.rql.Term;
import io.inversion.utils.JSNode;
import io.inversion.utils.Path;
import io.inversion.utils.Rows;
import io.inversion.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Db<T extends Db> {
    protected static final Set<String> reservedParams = Collections.unmodifiableSet(new TreeSet<String>(Arrays.asList("select", "insert", "update", "delete", "drop", "union", "truncate", "exec", "explain", "excludes", "expands")));
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final ArrayList<Collection> collections = new ArrayList();
    protected final Map<String, String> includeTables = new HashMap<String, String>();
    protected final Set<String> includeColumns = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    protected final Set<String> excludeColumns = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    final transient Set<Api> runningApis = new HashSet<Api>();
    protected boolean bootstrap = true;
    protected String name = null;
    protected String type = null;
    protected Path endpointPath = null;
    protected boolean dryRun = false;
    transient boolean firstStartup = true;
    transient boolean shutdown = false;

    public Db() {
    }

    public Db(String name) {
        this.name = name;
    }

    public final synchronized T startup(Api api) {
        if (this.runningApis.contains(api)) {
            return (T)this;
        }
        this.runningApis.add(api);
        this.doStartup(api);
        return (T)this;
    }

    protected void doStartup(Api api) {
        try {
            if (this.isBootstrap()) {
                if (this.firstStartup) {
                    this.firstStartup = false;
                    this.configDb();
                }
                this.configApi(api);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Utils.rethrow(ex);
        }
    }

    public synchronized T shutdown() {
        if (!this.shutdown) {
            this.shutdown = true;
            this.runningApis.forEach(this::shutdown);
            this.doShutdown();
        }
        return (T)this;
    }

    protected void doShutdown() {
    }

    public synchronized T shutdown(Api api) {
        if (this.runningApis.contains(api)) {
            this.doShutdown(api);
            this.runningApis.remove(api);
        }
        if (this.runningApis.size() == 0) {
            this.shutdown();
        }
        return (T)this;
    }

    protected void doShutdown(Api api) {
    }

    public boolean isRunning(Api api) {
        return this.runningApis.contains(api);
    }

    public final Results select(Collection collection, Map<String, String> params) throws ApiException {
        ArrayList<Term> terms = new ArrayList<Term>();
        for (String key : params.keySet()) {
            Term term2 = RqlParser.parse(key, params.get(key));
            List illegalTerms = term2.stream().filter(t -> t.isLeaf() && reservedParams.contains(t.getToken())).collect(Collectors.toList());
            if (illegalTerms.size() > 0) {
                Chain.debug("Ignoring RQL terms with reserved tokens: " + illegalTerms);
                continue;
            }
            if (term2.hasToken("eq") && term2.getTerm(0).hasToken("includes")) {
                boolean dottedInclude = false;
                for (int i = 1; i < term2.size(); ++i) {
                    String string = term2.getToken(i);
                    if (!string.contains(".")) continue;
                    dottedInclude = true;
                    break;
                }
                if (dottedInclude) continue;
                for (Term term3 : term2.getTerms()) {
                    if (!term3.hasToken("href") || collection == null) continue;
                    Index pk = collection.getPrimaryIndex();
                    if (pk == null) break;
                    term2.removeTerm(term3);
                    for (int i = 0; i < pk.size(); ++i) {
                        Property c = pk.getProperty(i);
                        boolean includesPkCol = false;
                        for (Term col : term2.getTerms()) {
                            if (!col.hasToken(c.getColumnName())) continue;
                            includesPkCol = true;
                            break;
                        }
                        if (includesPkCol) continue;
                        term2.withTerm(Term.term(term2, c.getColumnName(), new Object[0]));
                    }
                }
            }
            terms.add(term2);
        }
        Collections.sort(terms);
        ArrayList<Term> mappedTerms = new ArrayList<Term>();
        terms.forEach(term -> mappedTerms.addAll(this.mapToColumnNames(collection, term.copy())));
        Results results = this.doSelect(collection, mappedTerms);
        if (results.size() > 0) {
            for (int i = 0; i < results.size(); ++i) {
                JSNode node;
                Object row = results.getRow(i);
                if (collection == null) {
                    node = new JSNode((Map)row);
                    results.setRow(i, node);
                    continue;
                }
                node = new JSNode();
                results.setRow(i, node);
                String resourceKey = collection.encodeResourceKey((Map<String, Object>)row);
                if (!Utils.empty(resourceKey)) {
                    for (Relationship rel : collection.getRelationships()) {
                        String link = null;
                        if (rel.isManyToOne()) {
                            String fkval = null;
                            if (rel.getRelated().getPrimaryIndex().size() != rel.getFkIndex1().size() && rel.getFkIndex1().size() == 1) {
                                Object obj = row.get(rel.getFk1Col1().getColumnName());
                                if (obj != null) {
                                    fkval = obj.toString();
                                }
                            } else {
                                fkval = Collection.encodeResourceKey(row, rel.getFkIndex1());
                            }
                            if (fkval != null) {
                                link = Chain.buildLink(rel.getRelated(), fkval, null);
                            }
                        } else {
                            link = Chain.buildLink(collection, resourceKey, rel.getName());
                        }
                        node.put(rel.getName(), (Object)link);
                    }
                    String string = node.getString("href");
                    if (Utils.empty(string)) {
                        String string2 = Chain.buildLink(collection, resourceKey, null);
                        node.putFirst("href", string2);
                    }
                }
                for (Property attr : collection.getProperties()) {
                    String attrName = attr.getJsonName();
                    String colName = attr.getColumnName();
                    boolean rowHas = row.containsKey(colName);
                    if (!rowHas) continue;
                    Object val = row.remove(colName);
                    if (node.containsKey(attrName)) continue;
                    val = this.castDbOutput(attr, val);
                    node.put(attrName, val);
                }
                for (String key : row.keySet()) {
                    if (key.equalsIgnoreCase("href") || node.containsKey(key)) continue;
                    Object value = row.get(key);
                    node.put(key, value);
                }
            }
        }
        for (Term term3 : results.getNext()) {
            this.mapToJsonNames(collection, term3);
        }
        return results;
    }

    public abstract Results doSelect(Collection var1, List<Term> var2) throws ApiException;

    public final List<String> upsert(Collection collection, List<Map<String, Object>> rows) throws ApiException {
        ArrayList<Map<String, Object>> upsertMaps = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> node : rows) {
            String colName2;
            String href;
            HashMap<String, Object> mapped = new HashMap<String, Object>();
            upsertMaps.add(mapped);
            String string = href = node.get("href") != null ? node.get("href").toString() : null;
            if (href != null) {
                Rows.Row decodedKey = collection.decodeResourceKey(href);
                mapped.putAll(decodedKey);
            }
            HashSet<String> copied = new HashSet<String>();
            for (Property attr : collection.getProperties()) {
                String attrName = attr.getJsonName();
                if (collection.getRelationship(attrName) != null) continue;
                colName2 = attr.getColumnName();
                if (!node.containsKey(attrName)) continue;
                copied.add(attrName.toLowerCase());
                copied.add(colName2.toLowerCase());
                Object attrValue = node.get(attrName);
                Object colValue = collection.getDb().castJsonInput(attr, attrValue);
                mapped.put(colName2, colValue);
            }
            for (Relationship rel : collection.getRelationships()) {
                copied.add(rel.getName().toLowerCase());
                if (!rel.isManyToOne() || node.get(rel.getName()) == null) continue;
                if (rel.getFkIndex1().size() == 1 && rel.getRelated().getPrimaryIndex().size() > 1) {
                    String jsonName = rel.getFkIndex1().getJsonNames().get(0);
                    colName2 = rel.getFkIndex1().getColumnName(0);
                    Object value = node.get(jsonName);
                    if (value == null) continue;
                    value = Utils.substringAfter(value.toString(), "/");
                    mapped.put(colName2, value);
                    copied.add(colName2);
                    continue;
                }
                for (String colName2 : rel.getFkIndex1().getColumnNames()) {
                    copied.add(colName2.toLowerCase());
                }
                Map<String, Object> key = this.getKey(rel.getRelated(), node.get(rel.getName()));
                if (key == null) continue;
                Map<String, Object> foreignKey = this.mapTo(key, rel.getRelated().getPrimaryIndex(), rel.getFkIndex1());
                for (String keyPart : foreignKey.keySet()) {
                    Object keyValue = foreignKey.get(keyPart);
                    if (keyValue == null) continue;
                    mapped.put(keyPart, keyValue);
                }
            }
            for (String key : node.keySet()) {
                if (copied.contains(key.toLowerCase()) || key.equals("href")) continue;
                mapped.put(key, node.get(key));
            }
            for (String key : new ArrayList(mapped.keySet())) {
                if (!this.filterOutJsonProperty(collection, key)) continue;
                mapped.remove(key);
            }
        }
        return this.doUpsert(collection, upsertMaps);
    }

    public String getHref(Object hrefOrNode) {
        if (hrefOrNode instanceof JSNode) {
            hrefOrNode = ((JSNode)hrefOrNode).get("href");
        }
        if (hrefOrNode instanceof String) {
            return (String)hrefOrNode;
        }
        return null;
    }

    public Map<String, Object> getKey(Collection collection, Object node) {
        if (node instanceof JSNode) {
            node = ((JSNode)node).getString("href");
        }
        if (node instanceof String) {
            return collection.decodeResourceKey((String)node);
        }
        return null;
    }

    public Map<String, Object> mapTo(Map<String, Object> srcRow, Index srcCols, Index destCols) {
        if (srcRow == null) {
            throw ApiException.new500InternalServerError("Attempting to a null key to a different index", new Object[0]);
        }
        srcRow = new LinkedHashMap<String, Object>(srcRow);
        if (srcCols.size() != destCols.size() && destCols.size() == 1) {
            String resourceKey = Collection.encodeResourceKey(srcRow, srcCols);
            for (String key : new ArrayList<String>(srcRow.keySet())) {
                srcRow.remove(key);
            }
            srcRow.put(destCols.getProperty(0).getColumnName(), resourceKey);
        } else {
            if (srcCols.size() != destCols.size()) {
                throw ApiException.new500InternalServerError("Unable to map from index '{}' to '{}'", srcCols, destCols);
            }
            if (srcCols != destCols) {
                for (int i = 0; i < srcCols.size(); ++i) {
                    String key = srcCols.getProperty(i).getColumnName();
                    Object value = srcRow.remove(key);
                    srcRow.put(destCols.getProperty(i).getColumnName(), value);
                }
            }
        }
        return srcRow;
    }

    public abstract List<String> doUpsert(Collection var1, List<Map<String, Object>> var2) throws ApiException;

    public List<String> patch(Collection collection, List<Map<String, Object>> records) throws ApiException {
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        ArrayList<String> resourceKeys = new ArrayList<String>();
        for (Map<String, Object> node : records) {
            if (node.size() == 1) continue;
            Rows.Row row = new Rows.Row();
            rows.add(row);
            for (String jsonProp : node.keySet()) {
                Object value = node.get(jsonProp);
                if ("href".equalsIgnoreCase(jsonProp)) {
                    String resourceKey = Utils.substringAfter(value.toString(), "/");
                    resourceKeys.add(resourceKey);
                    row.putAll(collection.decodeResourceKey(resourceKey));
                    continue;
                }
                Property collProp = collection.getProperty(jsonProp);
                if (collProp != null) {
                    value = this.castJsonInput(collProp, value);
                    row.put(collProp.getColumnName(), value);
                    continue;
                }
                Relationship rel = collection.getRelationship(jsonProp);
                if (rel != null) {
                    if (rel.isManyToOne()) {
                        if (value != null) {
                            Rows.Row fk = rel.getRelated().decodeResourceKey(value.toString());
                            this.mapTo(fk, rel.getFkIndex1(), rel.getRelated().getPrimaryIndex());
                            row.putAll(fk);
                            continue;
                        }
                        for (Property fkProp : rel.getFkIndex1().getProperties()) {
                            row.put(fkProp.getColumnName(), (Object)null);
                        }
                        continue;
                    }
                    throw ApiException.new400BadRequest("You can't patch ONE_TO_MANY or MANY_TO_MANY properties.  You can patch the related resource.", new Object[0]);
                }
                row.put(jsonProp, value);
            }
            for (String columnName : row.keySet()) {
                if (!this.filterOutJsonProperty(collection, columnName)) continue;
                row.remove(columnName);
            }
        }
        this.doPatch(collection, rows);
        return resourceKeys;
    }

    public void doPatch(Collection collection, List<Map<String, Object>> rows) throws ApiException {
        this.doUpsert(collection, rows);
    }

    public abstract void delete(Collection var1, List<Map<String, Object>> var2) throws ApiException;

    protected void configApi(Api api) {
        for (Collection coll : this.getCollections()) {
            if (coll.isExclude()) continue;
            api.withCollection(coll);
        }
    }

    protected void configDb() throws ApiException {
        if (this.collections.size() == 0) {
            this.buildCollections();
            this.buildRelationships();
        }
    }

    protected void buildCollections() {
        for (String tableName : this.includeTables.keySet()) {
            Collection collection = this.getCollectionByTableName(tableName);
            if (collection != null) continue;
            this.withCollection(new Collection(tableName));
        }
        for (Collection coll : this.getCollections()) {
            if (coll.getName().equals(coll.getTableName())) {
                String prettyName = this.beautifyCollectionName(coll.getTableName());
                coll.withName(prettyName);
            }
            for (Property prop : coll.getProperties()) {
                if (!prop.getColumnName().equals(prop.getJsonName())) continue;
                String prettyName = this.beautifyName(prop.getColumnName());
                prop.withJsonName(prettyName);
            }
        }
    }

    protected void buildRelationships() {
        for (Collection coll : this.getCollections()) {
            if (coll.isLinkTbl()) {
                ArrayList<Index> indexes = coll.getIndexes();
                for (int i = 0; i < indexes.size(); ++i) {
                    for (int j = 0; j < indexes.size(); ++j) {
                        Index idx1 = (Index)indexes.get(i);
                        Index idx2 = (Index)indexes.get(j);
                        if (i == j || !idx1.getType().equals("FOREIGN_KEY") || !idx2.getType().equals("FOREIGN_KEY")) continue;
                        Collection resource1 = idx1.getProperty(0).getPk().getCollection();
                        Collection resource2 = idx2.getProperty(0).getPk().getCollection();
                        Relationship r = new Relationship();
                        r.withType("MANY_TO_MANY");
                        r.withRelated(resource2);
                        r.withFkIndex1(idx1);
                        r.withFkIndex2(idx2);
                        r.withName(this.makeRelationshipName(resource1, r));
                        r.withCollection(resource1);
                    }
                }
                continue;
            }
            for (Index fkIdx : coll.getIndexes()) {
                try {
                    if (!fkIdx.getType().equals("FOREIGN_KEY") || fkIdx.getProperty(0).getPk() == null) continue;
                    Collection pkResource = fkIdx.getProperty(0).getPk().getCollection();
                    Collection fkResource = fkIdx.getProperty(0).getCollection();
                    Relationship r = new Relationship();
                    r.withType("ONE_TO_MANY");
                    r.withFkIndex1(fkIdx);
                    r.withRelated(fkResource);
                    r.withName(this.makeRelationshipName(pkResource, r));
                    r.withCollection(pkResource);
                    r = new Relationship();
                    r.withType("MANY_TO_ONE");
                    r.withFkIndex1(fkIdx);
                    r.withRelated(pkResource);
                    r.withName(this.makeRelationshipName(fkResource, r));
                    r.withCollection(fkResource);
                }
                catch (Exception ex) {
                    throw ApiException.new500InternalServerError(ex, "Error creating relationship for index: {}", fkIdx);
                }
            }
        }
    }

    protected String beautifyCollectionName(String tableName) {
        if (this.includeTables.containsKey(tableName)) {
            return this.includeTables.get(tableName);
        }
        String collectionName = this.beautifyName(tableName);
        if (!collectionName.endsWith("s") && !collectionName.endsWith("S")) {
            collectionName = Pluralizer.plural(collectionName);
        }
        return collectionName;
    }

    protected String beautifyName(String name) {
        if (name.toUpperCase().equals(name)) {
            name = name.toLowerCase();
        }
        StringBuilder buff = new StringBuilder();
        boolean nextUpper = false;
        for (int i = 0; i < name.length(); ++i) {
            char next = name.charAt(i);
            if (next == ' ' || next == '_') {
                nextUpper = true;
                continue;
            }
            if (buff.length() == 0 && !Character.isAlphabetic(next) && next != '$') {
                next = 'x';
            }
            if (nextUpper) {
                next = Character.toUpperCase(next);
                nextUpper = false;
            }
            if (buff.length() == 0) {
                next = Character.toLowerCase(next);
            }
            buff.append(next);
        }
        return buff.toString();
    }

    protected String makeRelationshipName(Collection collection, Relationship relationship) {
        String name = null;
        String type = relationship.getType();
        String fkColName = relationship.getFk1Col1().getColumnName();
        if (fkColName.toLowerCase().endsWith("id") && fkColName.length() > 2) {
            fkColName = fkColName.substring(0, fkColName.length() - 2);
            while (fkColName.endsWith("_")) {
                fkColName = fkColName.substring(0, fkColName.length() - 1);
            }
        }
        fkColName = fkColName.trim();
        fkColName = this.beautifyName(fkColName);
        block5 : switch (type) {
            case "MANY_TO_ONE": {
                name = fkColName;
                break;
            }
            case "ONE_TO_MANY": {
                name = relationship.getRelated().getName();
                for (Relationship aRel : collection.getRelationships()) {
                    if (relationship == aRel || relationship.getRelated() != aRel.getRelated()) continue;
                    if (fkColName.equals(name)) break block5;
                    name = fkColName + Character.toUpperCase(name.charAt(0)) + name.substring(1);
                    break block5;
                }
                break;
            }
            case "MANY_TO_MANY": {
                name = relationship.getFk2Col1().getPk().getCollection().getName();
            }
        }
        return name;
    }

    public Object castDbOutput(Property property, Object value) {
        return Utils.castDbOutput(property != null ? property.getType() : null, value);
    }

    public Object castJsonInput(Property property, Object value) {
        return Utils.castJsonInput(property != null ? property.getType() : null, value);
    }

    public Object castJsonInput(String type, Object value) {
        return Utils.castJsonInput(type, value);
    }

    protected void mapToJsonNames(Collection collection, Term term) {
        if (collection == null) {
            return;
        }
        if (term.isLeaf() && !term.isQuoted()) {
            String token = term.getToken();
            Property attr = collection.findProperty(token);
            if (attr != null) {
                term.withToken(attr.getJsonName());
            }
        } else {
            for (Term child : term.getTerms()) {
                this.mapToJsonNames(collection, child);
            }
        }
    }

    protected Set<Term> mapToColumnNames(Collection collection, Term term) {
        HashSet<Term> terms = new HashSet<Term>();
        if (term.getParent() == null) {
            terms.add(term);
        }
        if (collection == null) {
            return terms;
        }
        if (term.isLeaf() && !term.isQuoted()) {
            String token = term.getToken();
            while (token.startsWith("-") || token.startsWith("+")) {
                token = token.substring(1);
            }
            StringBuilder name = new StringBuilder();
            String[] parts = token.split("\\.");
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i];
                if (i == parts.length - 1) {
                    Property attr = collection.findProperty(parts[i]);
                    if (attr != null) {
                        name.append(attr.getColumnName());
                        continue;
                    }
                    name.append(parts[i]);
                    continue;
                }
                Relationship rel = collection.getRelationship(part);
                if (rel != null) {
                    name.append(rel.getName()).append(".");
                    collection = rel.getRelated();
                    continue;
                }
                name.append(parts[i]).append(".");
            }
            if (!Utils.empty(name.toString())) {
                if (term.getToken().startsWith("-")) {
                    name.insert(0, "-");
                }
                term.withToken(name.toString());
            }
        } else {
            for (Term child : term.getTerms()) {
                terms.addAll(this.mapToColumnNames(collection, child));
            }
        }
        return terms;
    }

    protected Property getProperty(String tableName, String columnName) {
        Collection collection = this.getCollectionByTableName(tableName);
        if (collection != null) {
            return collection.getPropertyByColumnName(columnName);
        }
        return null;
    }

    public Collection getCollectionByTableName(String tableName) {
        for (Collection t : this.collections) {
            if (!tableName.equalsIgnoreCase(t.getTableName())) continue;
            return t;
        }
        return null;
    }

    public void removeCollection(Collection table) {
        this.collections.remove(table);
    }

    public List<Collection> getCollections() {
        return new ArrayList<Collection>(this.collections);
    }

    public T withIncludeTables(String includeTables) {
        for (String pair : Utils.explode(",", includeTables)) {
            String tableName = pair.indexOf(124) < 0 ? pair : pair.substring(0, pair.indexOf("|"));
            String collectionName = pair.indexOf(124) < 0 ? pair : pair.substring(pair.indexOf("|") + 1);
            this.withIncludeTable(tableName, collectionName);
        }
        return (T)this;
    }

    public T withIncludeTable(String tableName, String collectionName) {
        this.includeTables.put(tableName, collectionName);
        return (T)this;
    }

    public T withCollections(Collection ... collections) {
        for (Collection collection : collections) {
            this.withCollection(collection);
        }
        return (T)this;
    }

    public T withCollection(Collection collection) {
        if (collection != null) {
            if (collection.getDb() != this) {
                collection.withDb(this);
            }
            if (!this.collections.contains(collection)) {
                this.collections.add(collection);
            }
        }
        return (T)this;
    }

    public boolean filterOutJsonProperty(Collection collection, String name) {
        String[] guesses = new String[]{name, collection.getName() + "." + name, collection.getTableName() + "." + name, collection.getTableName() + collection.getColumnName(name)};
        if (this.includeColumns.size() > 0 || this.excludeColumns.size() > 0) {
            boolean included = false;
            for (String guess : guesses) {
                if (this.excludeColumns.contains(guess)) {
                    return true;
                }
                if (!this.includeColumns.contains(guess)) continue;
                included = true;
            }
            if (!included && this.includeColumns.size() > 0) {
                return true;
            }
        }
        return reservedParams.contains(name) || name.startsWith("_");
    }

    public T withIncludeColumns(String ... columnNames) {
        this.includeColumns.addAll(Utils.explode(",", columnNames));
        return (T)this;
    }

    public T withExcludeColumns(String ... columnNames) {
        this.excludeColumns.addAll(Utils.explode(",", columnNames));
        return (T)this;
    }

    public String getName() {
        return this.name;
    }

    public T withName(String name) {
        this.name = name;
        return (T)this;
    }

    public boolean isType(String ... types) {
        String type = this.getType();
        if (type == null) {
            return false;
        }
        for (String t : types) {
            if (!type.equalsIgnoreCase(t)) continue;
            return true;
        }
        return false;
    }

    public String getType() {
        return this.type;
    }

    public T withType(String type) {
        this.type = type;
        return (T)this;
    }

    public boolean isBootstrap() {
        return this.bootstrap;
    }

    public T withBootstrap(boolean bootstrap) {
        this.bootstrap = bootstrap;
        return (T)this;
    }

    public Path getEndpointPath() {
        return this.endpointPath;
    }

    public T withEndpointPath(Path endpointPath) {
        this.endpointPath = endpointPath;
        return (T)this;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public T withDryRun(boolean dryRun) {
        this.dryRun = dryRun;
        return (T)this;
    }

    static class Pluralizer {
        private static final String[] CATEGORY_EX_ICES = new String[]{"codex", "murex", "silex"};
        private static final String[] CATEGORY_IX_ICES = new String[]{"radix", "helix"};
        private static final String[] CATEGORY_UM_A = new String[]{"bacterium", "agendum", "desideratum", "erratum", "stratum", "datum", "ovum", "extremum", "candelabrum"};
        private static final String[] CATEGORY_US_I = new String[]{"alumnus", "alveolus", "bacillus", "bronchus", "locus", "nucleus", "stimulus", "meniscus", "thesaurus"};
        private static final String[] CATEGORY_ON_A = new String[]{"criterion", "perihelion", "aphelion", "phenomenon", "prolegomenon", "noumenon", "organon", "asyndeton", "hyperbaton"};
        private static final String[] CATEGORY_A_AE = new String[]{"alumna", "alga", "vertebra", "persona"};
        private static final String[] CATEGORY_O_OS = new String[]{"albino", "archipelago", "armadillo", "commando", "crescendo", "fiasco", "ditto", "dynamo", "embryo", "ghetto", "guano", "inferno", "jumbo", "lumbago", "magneto", "manifesto", "medico", "octavo", "photo", "pro", "quarto", "canto", "lingo", "generalissimo", "stylo", "rhino", "casino", "auto", "macro", "zero", "todo"};
        private static final String[] CATEGORY_O_I = new String[]{"solo", "soprano", "basso", "alto", "contralto", "tempo", "piano", "virtuoso"};
        private static final String[] CATEGORY_EN_INA = new String[]{"stamen", "foramen", "lumen"};
        private static final String[] CATEGORY_A_ATA = new String[]{"anathema", "enema", "oedema", "bema", "enigma", "sarcoma", "carcinoma", "gumma", "schema", "charisma", "lemma", "soma", "diploma", "lymphoma", "stigma", "dogma", "magma", "stoma", "drama", "melisma", "trauma", "edema", "miasma"};
        private static final String[] CATEGORY_IS_IDES = new String[]{"iris", "clitoris"};
        private static final String[] CATEGORY_US_US = new String[]{"apparatus", "impetus", "prospectus", "cantus", "nexus", "sinus", "coitus", "plexus", "status", "hiatus"};
        private static final String[] CATEGORY_NONE_I = new String[]{"afreet", "afrit", "efreet"};
        private static final String[] CATEGORY_NONE_IM = new String[]{"cherub", "goy", "seraph"};
        private static final String[] CATEGORY_EX_EXES = new String[]{"apex", "latex", "vertex", "cortex", "pontifex", "vortex", "index", "simplex"};
        private static final String[] CATEGORY_IX_IXES = new String[]{"appendix"};
        private static final String[] CATEGORY_S_ES = new String[]{"acropolis", "chaos", "lens", "aegis", "cosmos", "mantis", "alias", "dais", "marquis", "asbestos", "digitalis", "metropolis", "atlas", "epidermis", "pathos", "bathos", "ethos", "pelvis", "bias", "gas", "polis", "caddis", "glottis", "rhinoceros", "cannabis", "glottis", "sassafras", "canvas", "ibis", "trellis"};
        private static final String[] CATEGORY_MAN_MANS = new String[]{"human", "Alabaman", "Bahaman", "Burman", "German", "Hiroshiman", "Liman", "Nakayaman", "Oklahoman", "Panaman", "Selman", "Sonaman", "Tacoman", "Yakiman", "Yokohaman", "Yuman"};
        private static Pluralizer inflector = new Pluralizer();
        private final List<Rule> rules = new ArrayList<Rule>();

        public Pluralizer() {
            this(MODE.ENGLISH_ANGLICIZED);
        }

        public Pluralizer(MODE mode) {
            this.uncountable(new String[]{"fish", "ois", "sheep", "deer", "pox", "itis", "bison", "flounder", "pliers", "bream", "gallows", "proceedings", "breeches", "graffiti", "rabies", "britches", "headquarters", "salmon", "carp", "herpes", "scissors", "chassis", "high-jinks", "sea-bass", "clippers", "homework", "series", "cod", "innings", "shears", "contretemps", "jackanapes", "species", "corps", "mackerel", "swine", "debris", "measles", "trout", "diabetes", "mews", "tuna", "djinn", "mumps", "whiting", "eland", "news", "wildebeest", "elk", "pincers", "sugar"});
            this.irregular(new String[][]{{"child", "children"}, {"ephemeris", "ephemerides"}, {"mongoose", "mongoose"}, {"mythos", "mythoi"}, {"soliloquy", "soliloquies"}, {"trilby", "trilbys"}, {"genus", "genera"}, {"quiz", "quizzes"}});
            if (mode == MODE.ENGLISH_ANGLICIZED) {
                this.irregular(new String[][]{{"beef", "beefs"}, {"brother", "brothers"}, {"cow", "cows"}, {"genie", "genies"}, {"money", "moneys"}, {"octopus", "octopuses"}, {"opus", "opuses"}});
            } else if (mode == MODE.ENGLISH_CLASSICAL) {
                this.irregular(new String[][]{{"beef", "beeves"}, {"brother", "brethren"}, {"cos", "kine"}, {"genie", "genii"}, {"money", "monies"}, {"octopus", "octopodes"}, {"opus", "opera"}});
            }
            this.categoryRule(CATEGORY_MAN_MANS, "", "s");
            this.rule(new String[][]{{"man$", "men"}, {"([lm])ouse$", "$1ice"}, {"tooth$", "teeth"}, {"goose$", "geese"}, {"foot$", "feet"}, {"zoon$", "zoa"}, {"([csx])is$", "$1es"}});
            this.categoryRule(CATEGORY_EX_ICES, "ex", "ices");
            this.categoryRule(CATEGORY_IX_ICES, "ix", "ices");
            this.categoryRule(CATEGORY_UM_A, "um", "a");
            this.categoryRule(CATEGORY_ON_A, "on", "a");
            this.categoryRule(CATEGORY_A_AE, "a", "ae");
            if (mode == MODE.ENGLISH_CLASSICAL) {
                this.rule(new String[][]{{"trix$", "trices"}, {"eau$", "eaux"}, {"ieu$", "ieux"}, {"(..[iay])nx$", "$1nges"}});
                this.categoryRule(CATEGORY_EN_INA, "en", "ina");
                this.categoryRule(CATEGORY_A_ATA, "a", "ata");
                this.categoryRule(CATEGORY_IS_IDES, "is", "ides");
                this.categoryRule(CATEGORY_US_US, "", "");
                this.categoryRule(CATEGORY_O_I, "o", "i");
                this.categoryRule(CATEGORY_NONE_I, "", "i");
                this.categoryRule(CATEGORY_NONE_IM, "", "im");
                this.categoryRule(CATEGORY_EX_EXES, "ex", "ices");
                this.categoryRule(CATEGORY_IX_IXES, "ix", "ices");
            }
            this.categoryRule(CATEGORY_US_I, "us", "i");
            this.rule("([cs]h|[zx])$", "$1es");
            this.categoryRule(CATEGORY_S_ES, "", "es");
            this.categoryRule(CATEGORY_IS_IDES, "", "es");
            this.categoryRule(CATEGORY_US_US, "", "es");
            this.rule("(us)$", "$1es");
            this.categoryRule(CATEGORY_A_ATA, "", "s");
            this.rule(new String[][]{{"([cs])h$", "$1hes"}, {"ss$", "sses"}});
            this.rule(new String[][]{{"([aeo]l)f$", "$1ves"}, {"([^d]ea)f$", "$1ves"}, {"(ar)f$", "$1ves"}, {"([nlw]i)fe$", "$1ves"}});
            this.rule(new String[][]{{"([aeiou])y$", "$1ys"}, {"y$", "ies"}});
            this.categoryRule(CATEGORY_O_I, "o", "os");
            this.categoryRule(CATEGORY_O_OS, "o", "os");
            this.rule("([aeiou])o$", "$1os");
            this.rule("o$", "oes");
            this.rule("ulum", "ula");
            this.categoryRule(CATEGORY_A_ATA, "", "es");
            this.rule("s$", "ses");
            this.rule("$", "s");
        }

        public static String plural(String word) {
            if (word.endsWith("s") || word.endsWith("S")) {
                return word;
            }
            word = inflector.getPlural(word);
            return word;
        }

        public static String plural(String word, int count) {
            return inflector.getPlural(word, count);
        }

        public static void setMode(MODE mode) {
            Pluralizer newInflector;
            inflector = newInflector = new Pluralizer(mode);
        }

        public String getPlural(String word, int count) {
            if (count == 1) {
                return word;
            }
            return this.getPlural(word);
        }

        protected String getPlural(String word) {
            for (Rule rule : this.rules) {
                String result = rule.getPlural(word);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        protected void uncountable(String[] list) {
            this.rules.add(new CategoryRule(list, "", ""));
        }

        protected void irregular(String singular, String plural) {
            if (singular.charAt(0) == plural.charAt(0)) {
                this.rules.add(new RegExpRule(Pattern.compile("(?i)(" + singular.charAt(0) + ")" + singular.substring(1) + "$"), "$1" + plural.substring(1)));
            } else {
                this.rules.add(new RegExpRule(Pattern.compile(Character.toUpperCase(singular.charAt(0)) + "(?i)" + singular.substring(1) + "$"), Character.toUpperCase(plural.charAt(0)) + plural.substring(1)));
                this.rules.add(new RegExpRule(Pattern.compile(Character.toLowerCase(singular.charAt(0)) + "(?i)" + singular.substring(1) + "$"), Character.toLowerCase(plural.charAt(0)) + plural.substring(1)));
            }
        }

        protected void irregular(String[][] list) {
            for (String[] pair : list) {
                this.irregular(pair[0], pair[1]);
            }
        }

        protected void rule(String singular, String plural) {
            this.rules.add(new RegExpRule(Pattern.compile(singular, 2), plural));
        }

        protected void rule(String[][] list) {
            for (String[] pair : list) {
                this.rules.add(new RegExpRule(Pattern.compile(pair[0], 2), pair[1]));
            }
        }

        protected void categoryRule(String[] list, String singular, String plural) {
            this.rules.add(new CategoryRule(list, singular, plural));
        }

        static enum MODE {
            ENGLISH_ANGLICIZED,
            ENGLISH_CLASSICAL;

        }

        private static interface Rule {
            public String getPlural(String var1);
        }

        private static class CategoryRule
        implements Rule {
            private final String[] list;
            private final String singular;
            private final String plural;

            public CategoryRule(String[] list, String singular, String plural) {
                this.list = list;
                this.singular = singular;
                this.plural = plural;
            }

            @Override
            public String getPlural(String word) {
                String lowerWord = word.toLowerCase();
                for (String suffix : this.list) {
                    if (!lowerWord.endsWith(suffix)) continue;
                    if (!lowerWord.endsWith(this.singular)) {
                        throw new RuntimeException("Internal error");
                    }
                    return word.substring(0, word.length() - this.singular.length()) + this.plural;
                }
                return null;
            }
        }

        private static class RegExpRule
        implements Rule {
            private final Pattern singular;
            private final String plural;

            private RegExpRule(Pattern singular, String plural) {
                this.singular = singular;
                this.plural = plural;
            }

            @Override
            public String getPlural(String word) {
                StringBuffer buffer = new StringBuffer();
                Matcher matcher = this.singular.matcher(word);
                if (matcher.find()) {
                    matcher.appendReplacement(buffer, this.plural);
                    matcher.appendTail(buffer);
                    return buffer.toString();
                }
                return null;
            }
        }
    }
}

