/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.utils;

import io.inversion.utils.JSNode;
import io.inversion.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JSArray
extends JSNode
implements Iterable {
    protected List objects = new ArrayList();

    public JSArray(Object ... objects) {
        if (objects != null && objects.length == 1 && objects[0].getClass().isArray()) {
            objects = (Object[])objects[0];
        } else if (objects != null && objects.length == 1 && Collection.class.isAssignableFrom(objects[0].getClass())) {
            objects = ((Collection)objects[0]).toArray();
        }
        for (int i = 0; objects != null && i < objects.length; ++i) {
            this.add(objects[i]);
        }
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public Object put(String index, Object value) {
        return this.set(Integer.parseInt(index.trim()), value);
    }

    @Override
    public Object put(int index, Object value) {
        return this.set(index, value);
    }

    public Object set(int index, Object value) throws ArrayIndexOutOfBoundsException {
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException("You can't set index '" + index + "' on a list");
        }
        while (this.objects.size() < index + 1) {
            this.objects.add(null);
        }
        return this.objects.set(index, value);
    }

    public void add(int index, Object value) {
        this.objects.add(index, value);
    }

    public void add(Object value) {
        this.objects.add(value);
    }

    public void addAll(JSArray array) {
        this.objects.addAll(array.asList());
    }

    @Override
    public Object remove(Object index) {
        return this.remove(Integer.parseInt(index.toString().trim()));
    }

    public Object remove(int index) {
        if (index < 0 || index >= this.objects.size()) {
            return null;
        }
        return this.objects.remove(index);
    }

    @Override
    public Object get(Object index) {
        return this.get(Integer.parseInt(index.toString().trim()));
    }

    public Object get(int index) {
        if (index > -1 && index >= this.objects.size()) {
            return null;
        }
        return this.objects.get(index);
    }

    public JSNode getNode(int index) throws ClassCastException {
        return (JSNode)this.get(index);
    }

    public JSArray getArray(int index) {
        return (JSArray)this.get(index);
    }

    public String getString(int index) {
        Object value = this.get(index);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public int getInt(int index) {
        Object found = this.get(index);
        if (found != null) {
            return Utils.atoi(found);
        }
        return -1;
    }

    public double getDouble(int index) {
        Object found = this.get(index);
        if (found != null) {
            return Utils.atod(found);
        }
        return -1.0;
    }

    public boolean getBoolean(int index) {
        Object found = this.get(index);
        if (found != null) {
            return Utils.atob(found);
        }
        return false;
    }

    @Override
    public Set<String> keySet() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (int i = 0; i < this.objects.size(); ++i) {
            set.add(i + "");
        }
        return set;
    }

    @Override
    public List asList() {
        return new ArrayList(this.objects);
    }

    @Override
    public JSArray asArray() {
        return this;
    }

    public Map asMap() {
        LinkedHashMap map = new LinkedHashMap();
        for (int i = 0; i < this.objects.size(); ++i) {
            map.put(i + "", this.objects.get(i));
        }
        return map;
    }

    public boolean contains(Object object) {
        return this.objects.contains(object);
    }

    @Override
    public boolean isEmpty() {
        return this.objects.isEmpty();
    }

    @Override
    public void clear() {
        this.objects.clear();
        super.clear();
    }

    @Override
    public int size() {
        return this.objects.size();
    }

    public int length() {
        return this.objects.size();
    }

    public Iterator iterator() {
        return this.asList().iterator();
    }

    @Override
    public Collection values() {
        return this.asList();
    }
}

