/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.rql;

import io.inversion.ApiException;
import io.inversion.rql.Builder;
import io.inversion.rql.Query;
import io.inversion.rql.Term;
import io.inversion.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.util.LinkedCaseInsensitiveMap;

public class Select<T extends Select, P extends Query>
extends Builder<T, P> {
    static final Set<String> NON_AGGREGATE_FUNCTIONS = Collections.unmodifiableSet((Set)Utils.add(new LinkedHashSet(), (Object[])new Object[]{"include", "as", "distinct"}));
    static final Set<String> AGGREGATE_FUNCTIONS = Collections.unmodifiableSet((Set)Utils.add(new LinkedHashSet(), (Object[])new Object[]{"count", "sum", "min", "max"}));

    public Select(P query) {
        super(query);
        this.withFunctions(NON_AGGREGATE_FUNCTIONS);
        this.withFunctions(AGGREGATE_FUNCTIONS);
    }

    @Override
    protected boolean addTerm(String token, Term term) {
        if (AGGREGATE_FUNCTIONS.contains(token)) {
            String asName = "$$$ANON_" + (this.getTerms().size() + 1);
            if (term.size() > 1) {
                Term asT = term.getTerm(1);
                term.removeTerm(asT);
                asName = asT.getToken();
            }
            Term as = Term.term(null, "as", term, asName);
            this.withTerm(as);
            return true;
        }
        return super.addTerm(token, term);
    }

    public boolean isDistinct() {
        Term distinct = this.find("distinct");
        return distinct != null;
    }

    public List<Term> findAggregateTerms() {
        List<Term> aggregates = this.findAll(AGGREGATE_FUNCTIONS);
        aggregates.removeIf(p -> p.isLeaf());
        return aggregates;
    }

    public List<String> getIncludeColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        for (Term include : this.findAll("include")) {
            for (Term child : include.getTerms()) {
                columns.add(child.getToken());
            }
        }
        return columns;
    }

    public LinkedCaseInsensitiveMap<Term> getProjection() {
        LinkedCaseInsensitiveMap projection = new LinkedCaseInsensitiveMap();
        for (Term include : this.findAll("include")) {
            for (Term column : include.getTerms()) {
                if (!column.isLeaf()) {
                    throw ApiException.new400BadRequest("An include RQL param may not contain nested functions.", new Object[0]);
                }
                if (projection.containsKey((Object)column.getToken())) continue;
                projection.put(column.getToken(), (Object)column);
            }
        }
        if (projection.size() == 0) {
            projection.put("*", (Object)Term.term(null, "*", new Object[0]));
        }
        for (Term as : this.findAll("as")) {
            String name = as.getToken(1);
            projection.put(name, (Object)as);
        }
        return projection;
    }
}

