/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.rql;

import io.inversion.rql.RqlTokenizer;
import io.inversion.rql.Term;
import io.inversion.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public class Rql {
    public static Term parse(String paramName, String paramValue) {
        String termStr;
        if (Utils.empty((Object[])new Object[]{paramValue}) && paramName.contains("(")) {
            termStr = paramName;
        } else {
            if (Utils.empty((Object[])new Object[]{paramValue})) {
                paramValue = "true";
            }
            termStr = "eq(" + paramName + "," + paramValue + ")";
        }
        Term term = Rql.parse(termStr);
        return term;
    }

    public static Term parse(String clause) {
        String token;
        TermStack tb = new TermStack();
        RqlTokenizer t = new RqlTokenizer(clause);
        while ((token = t.next()) != null) {
            String func;
            String lc = token.toLowerCase();
            String string = func = lc.endsWith("(") ? lc.substring(0, lc.length() - 1) : null;
            if (func != null) {
                tb.push(Term.term(null, func, new Object[0]));
                continue;
            }
            if (")".equals(lc)) {
                tb.pop();
                continue;
            }
            if ("=".equals(lc)) {
                Term top = tb.top();
                List<Term> children = top.getTerms();
                if ("eq".equalsIgnoreCase(top.getToken()) && children.size() == 2) {
                    top.withToken(children.get(1).getToken());
                    top.removeTerm(children.get(1));
                    continue;
                }
                tb.top().withToken("eq");
                continue;
            }
            tb.top().withTerm(Term.term(null, token, new Object[0]));
        }
        Term root = tb.root();
        if ("NULL".equals(root.getToken())) {
            Term child = root.getTerm(0);
            child.withParent(null);
            root = child;
        }
        return root;
    }

    static Term func(String function, Object ... terms) {
        Term or = new Term(function);
        for (Object term : terms) {
            if (!(term instanceof Term)) {
                String token = term == null ? "null" : term.toString();
                term = new Term(token);
            }
            or.withTerm((Term)term);
        }
        return or;
    }

    public static Term eq(Object term1, Object term2) {
        return Rql.func("eq", term1, term2);
    }

    public static Term ne(Object term1, Object term2) {
        return Rql.func("ne", term1, term2);
    }

    public static Term gt(Object term1, Object term2) {
        return Rql.func("gt", term1, term2);
    }

    public static Term ge(Object term1, Object term2) {
        return Rql.func("ge", term1, term2);
    }

    public static Term lt(Object term1, Object term2) {
        return Rql.func("lt", term1, term2);
    }

    public static Term le(Object term1, Object term2) {
        return Rql.func("le", term1, term2);
    }

    public static Term w(Object term1, Object term2) {
        return Rql.func("w", term1, term2);
    }

    public static Term sw(Object term1, Object term2) {
        return Rql.func("sw", term1, term2);
    }

    public static Term ew(Object term1, Object term2) {
        return Rql.func("ew", term1, term2);
    }

    public static Term in(Object ... terms) {
        return Rql.func("in", terms);
    }

    public static Term out(Object ... terms) {
        return Rql.func("out", terms);
    }

    public static Term emp(Object term1, Object term2) {
        return Rql.func("emp", term1, term2);
    }

    public static Term nemp(Object term1, Object term2) {
        return Rql.func("nemp", term1, term2);
    }

    public static Term n(Object term) {
        return Rql.func("n", term);
    }

    public static Term nn(Object term) {
        return Rql.func("nn", term);
    }

    public static Term and(Object ... terms) {
        return Rql.func("and", terms);
    }

    public static Term or(Object ... terms) {
        return Rql.func("or", terms);
    }

    public static Term not(Object term) {
        return Rql.func("not", term);
    }

    static class TermStack {
        final List<Term> terms = new ArrayList<Term>();
        Term root = null;

        TermStack() {
        }

        public Term top() {
            if (this.terms.size() == 0) {
                if (this.root == null) {
                    this.root = Term.term(null, null, new Object[0]);
                }
                this.terms.add(this.root);
            }
            return this.terms.get(this.terms.size() - 1);
        }

        public void push(Term term) {
            if (this.root == null) {
                this.root = term;
            } else {
                this.top().withTerm(term);
            }
            this.terms.add(term);
        }

        public void pop() {
            if (this.terms.size() > 0) {
                this.terms.remove(this.terms.size() - 1);
            }
        }

        public Term root() {
            return this.root;
        }
    }
}

