/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.rql;

import io.inversion.ApiException;
import io.inversion.Collection;
import io.inversion.Db;
import io.inversion.Property;
import io.inversion.Relationship;
import io.inversion.Results;
import io.inversion.rql.Builder;
import io.inversion.rql.From;
import io.inversion.rql.Group;
import io.inversion.rql.Order;
import io.inversion.rql.Page;
import io.inversion.rql.Select;
import io.inversion.rql.Term;
import io.inversion.rql.Where;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.KeyValue;
import org.apache.commons.collections4.keyvalue.DefaultKeyValue;

public class Query<T extends Query, D extends Db, S extends Select, F extends From, W extends Where, R extends Group, O extends Order, G extends Page>
extends Builder<T, T> {
    protected final List<KeyValue> castValues = new ArrayList<KeyValue>();
    protected final List<KeyValue> originalValues = new ArrayList<KeyValue>();
    protected D db = null;
    protected Collection collection = null;
    protected S select = null;
    protected F from = null;
    protected W where = null;
    protected R group = null;
    protected O order = null;
    protected G page = null;
    protected boolean dryRun = false;

    public Query() {
    }

    public Query(D db, Collection coll) {
        this(db, coll, null, new String[0]);
    }

    public Query(D db, Collection coll, Object terms, String ... functions) {
        super(null);
        this.withDb(db);
        this.withCollection(coll);
        this.withFunctions(functions);
        if (terms != null) {
            this.withTerms(terms);
        }
    }

    protected S createSelect() {
        return (S)new Select(this);
    }

    protected F createFrom() {
        return (F)new From(this);
    }

    protected W createWhere() {
        return (W)new Where(this);
    }

    protected R createGroup() {
        return (R)new Group(this);
    }

    protected O createOrder() {
        return (O)new Order(this);
    }

    protected G createPage() {
        return (G)new Page(this);
    }

    @Override
    public T withTerm(Term term) {
        return (T)((Query)super.withTerm(term));
    }

    public Results doSelect() throws ApiException {
        return null;
    }

    @Override
    public List<Builder> getBuilders() {
        if (this.builders == null) {
            this.builders = new ArrayList();
            this.getFrom();
            this.getWhere();
            this.getPage();
            this.getOrder();
            this.getGroup();
            this.getSelect();
        }
        return this.builders;
    }

    public S getSelect() {
        if (this.select == null) {
            this.select = this.createSelect();
            this.withBuilder((Builder)this.select);
        }
        return this.select;
    }

    public F getFrom() {
        if (this.from == null) {
            this.from = this.createFrom();
            this.withBuilder((Builder)this.from);
        }
        return this.from;
    }

    public W getWhere() {
        if (this.where == null) {
            this.where = this.createWhere();
            this.withBuilder((Builder)this.where);
        }
        return this.where;
    }

    public R getGroup() {
        if (this.group == null) {
            this.group = this.createGroup();
            this.withBuilder((Builder)this.group);
        }
        return this.group;
    }

    public O getOrder() {
        if (this.order == null) {
            this.order = this.createOrder();
            this.withBuilder((Builder)this.order);
        }
        return this.order;
    }

    public G getPage() {
        if (this.page == null) {
            this.page = this.createPage();
            this.withBuilder((Builder)this.page);
        }
        return this.page;
    }

    public Collection getCollection() {
        return this.collection;
    }

    public D getDb() {
        return this.db;
    }

    public T withDb(D db) {
        this.db = db;
        return (T)((Query)this.r());
    }

    public T withCollection(Collection coll) {
        this.collection = coll;
        if (coll != null && coll.getDb() != null) {
            this.withDb(coll.getDb());
        }
        return (T)((Query)this.r());
    }

    public int getNumValues() {
        return this.castValues.size();
    }

    protected T clearValues() {
        this.castValues.clear();
        this.originalValues.clear();
        return (T)((Query)this.r());
    }

    protected T withColValue(String columnName, Object value) {
        this.originalValues.add((KeyValue)new DefaultKeyValue((Object)columnName, value));
        Collection coll = this.collection;
        if (columnName != null) {
            if (columnName.contains(".")) {
                String collectionName = columnName.substring(0, columnName.indexOf("."));
                if (columnName.startsWith("~~relTbl_")) {
                    columnName = columnName.substring(columnName.indexOf("_") + 1);
                    collectionName = collectionName.substring(collectionName.indexOf("_") + 1);
                    Relationship rel = this.getCollection().getRelationship(collectionName);
                    if (rel != null) {
                        collectionName = rel.getRelated().getName();
                    }
                }
                coll = coll.getDb().getCollectionByTableName(collectionName);
            }
            if (coll != null) {
                String shortName = columnName.substring(columnName.indexOf(".") + 1);
                Property col = coll.getProperty(shortName);
                if (col == null) {
                    throw ApiException.new500InternalServerError("Unable to find column '{}' on table '{}'", columnName, coll.getTableName());
                }
                value = ((Db)this.db).castJsonInput(col, value);
            }
        }
        this.castValues.add((KeyValue)new DefaultKeyValue((Object)columnName, value));
        return (T)((Query)this.r());
    }

    public List<String> getColValueKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        for (KeyValue kv : this.castValues) {
            keys.add((String)kv.getKey());
        }
        return keys;
    }

    public List<Object> getColValues() {
        ArrayList<Object> keys = new ArrayList<Object>();
        for (KeyValue kv : this.castValues) {
            keys.add(kv.getValue());
        }
        return keys;
    }

    public List<Object> getOriginalValues() {
        ArrayList<Object> keys = new ArrayList<Object>();
        for (KeyValue kv : this.originalValues) {
            keys.add(kv.getValue());
        }
        return keys;
    }

    public KeyValue<String, String> getColValue(int index) {
        return this.castValues.get(index);
    }

    public List<KeyValue> getValues() {
        return this.castValues;
    }

    public boolean isDryRun() {
        return this.dryRun || this.db != null && ((Db)this.db).isDryRun();
    }

    public T withDryRun(boolean dryRun) {
        this.dryRun = dryRun;
        return (T)((Query)this.r());
    }
}

