/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.action.openapi;

import io.inversion.Collection;
import io.inversion.Index;
import io.inversion.Op;
import io.inversion.Param;
import io.inversion.Property;
import io.inversion.Relationship;
import io.inversion.utils.Path;
import io.inversion.utils.Task;
import io.inversion.utils.Utils;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public interface OpenAPIWriter<T extends OpenAPIWriter> {
    default public Operation hook_documentOp(Task docChain, OpenAPI openApi, List<Op> ops, Op op, Map<Object, Schema> schemas) {
        Operation operation = null;
        switch (op.getFunction()) {
            case GET: {
                operation = this.documentOpGet(docChain, openApi, ops, op, schemas);
                break;
            }
            case FIND: {
                operation = this.documentOpFind(docChain, openApi, ops, op, schemas);
                break;
            }
            case POST: {
                operation = this.documentOpPost(docChain, openApi, ops, op, schemas);
                break;
            }
            case PUT: {
                operation = this.documentOpPut(docChain, openApi, ops, op, schemas);
                break;
            }
            case DELETE: {
                operation = this.documentOpDelete(docChain, openApi, ops, op, schemas);
            }
        }
        if (operation != null) {
            String tag = null;
            if (op.getCollection() != null) {
                tag = op.getCollection().getSingularDisplayName();
            } else {
                Path p = op.getPath();
                for (int i = p.size() - 1; i >= 0; --i) {
                    if (p.isVar(i) || p.isWildcard(i)) continue;
                    tag = Utils.capitalize((String)p.get(i));
                    break;
                }
                tag = this.beautifyTag(tag);
                List tags = operation.getTags();
                if (tags == null || !tags.contains(tag)) {
                    operation.addTagsItem(tag);
                }
            }
        }
        return operation;
    }

    default public Operation documentOpGet(Task docChain, OpenAPI openApi, List<Op> ops, Op op, Map<Object, Schema> schemas) {
        Operation operation = ((PathItem)openApi.getPaths().get((Object)op.getOperationPath())).getGet();
        if (operation == null) {
            String description = this.getDescription(op);
            String schemaName = this.documentResponseSchema(docChain, openApi, ops, op, schemas);
            operation = this.buildOperation(op, description, null, "200", schemaName, "404", null);
            ((PathItem)openApi.getPaths().get((Object)op.getOperationPath())).setGet(operation);
        }
        this.documentQueryParams(docChain, openApi, operation, op);
        return operation;
    }

    default public Operation documentOpFind(Task docChain, OpenAPI openApi, List<Op> ops, Op op, Map<Object, Schema> schemas) {
        Operation operation = ((PathItem)openApi.getPaths().get((Object)op.getOperationPath())).getGet();
        if (operation == null) {
            String description = this.getDescription(op);
            String responseSchema = this.documentResponseSchema(docChain, openApi, ops, op, schemas);
            operation = this.buildOperation(op, description, null, "200", responseSchema);
            ((PathItem)openApi.getPaths().get((Object)op.getOperationPath())).setGet(operation);
        }
        this.documentQueryParams(docChain, openApi, operation, op);
        return operation;
    }

    default public Operation documentOpRelated(Task docChain, OpenAPI openApi, List<Op> ops, Op op, Map<Object, Schema> schemas) {
        Operation operation = ((PathItem)openApi.getPaths().get((Object)op.getOperationPath())).getGet();
        if (operation == null) {
            String description = this.getDescription(op);
            String responseSchema = this.documentResponseSchema(docChain, openApi, ops, op, schemas);
            operation = this.buildOperation(op, description, null, "200", responseSchema);
            ((PathItem)openApi.getPaths().get((Object)op.getOperationPath())).setGet(operation);
        }
        this.documentQueryParams(docChain, openApi, operation, op);
        return operation;
    }

    default public void removeReadOnlyProperties(OpenAPI openApi, Collection coll, String schemaName) {
    }

    default public Operation documentOpPost(Task docChain, OpenAPI openApi, List<Op> ops, Op op, Map<Object, Schema> schemas) {
        Operation operation = ((PathItem)openApi.getPaths().get((Object)op.getOperationPath())).getPost();
        if (operation == null) {
            String description = this.getDescription(op);
            String requestSchema = this.documentRequestSchema(docChain, openApi, ops, op, schemas);
            Collection coll = op.getRelationship() != null ? op.getRelationship().getRelated() : op.getCollection();
            this.removeReadOnlyProperties(openApi, coll, requestSchema);
            String responseSchema = this.documentResponseSchema(docChain, openApi, ops, op, schemas);
            operation = this.buildOperation(op, description, requestSchema, "201", responseSchema);
            ((PathItem)openApi.getPaths().get((Object)op.getOperationPath())).setPost(operation);
        }
        this.documentQueryParams(docChain, openApi, operation, op);
        return operation;
    }

    default public Operation documentOpPut(Task docChain, OpenAPI openApi, List<Op> ops, Op op, Map<Object, Schema> schemas) {
        Operation operation = ((PathItem)openApi.getPaths().get((Object)op.getOperationPath())).getPost();
        if (operation == null) {
            String description = this.getDescription(op);
            String requestSchema = this.documentRequestSchema(docChain, openApi, ops, op, schemas);
            String responseSchema = this.documentResponseSchema(docChain, openApi, ops, op, schemas);
            operation = this.buildOperation(op, description, requestSchema, "201", responseSchema, "404", null);
            ((PathItem)openApi.getPaths().get((Object)op.getOperationPath())).setPut(operation);
        }
        this.documentQueryParams(docChain, openApi, operation, op);
        return operation;
    }

    default public Operation documentOpPatch(Task docChain, OpenAPI openApi, List<Op> ops, Op op, Map<Object, Schema> schemas) {
        return null;
    }

    default public Operation documentOpDelete(Task docChain, OpenAPI openApi, List<Op> ops, Op op, Map<Object, Schema> schemas) {
        Operation operation = ((PathItem)openApi.getPaths().get((Object)op.getOperationPath())).getPost();
        if (operation == null) {
            String description = this.getDescription(op);
            operation = this.buildOperation(op, description, null, "204", null);
            ((PathItem)openApi.getPaths().get((Object)op.getOperationPath())).setDelete(operation);
            this.addResponse(operation, op, "404");
        }
        return operation;
    }

    default public String documentRequestSchema(Task docChain, OpenAPI openApi, List<Op> ops, Op op, Map<Object, Schema> schemas) {
        return this.documentOperationSchema(docChain, openApi, ops, op, true, schemas);
    }

    default public String documentResponseSchema(Task docChain, OpenAPI openApi, List<Op> ops, Op op, Map<Object, Schema> schemas) {
        return this.documentOperationSchema(docChain, openApi, ops, op, false, schemas);
    }

    default public String documentOperationSchema(Task docChain, OpenAPI openApi, List<Op> ops, Op op, boolean request, Map<Object, Schema> schemas) {
        if (op.getCollection() == null) {
            System.out.println("NO COLLECTION: " + op.getName());
            return "unknown";
        }
        boolean arrayWrap = false;
        if (!request && op.getFunction().toString().toLowerCase().startsWith("find")) {
            arrayWrap = true;
        } else if (!request && op.getFunction().toString().toLowerCase().startsWith("batch")) {
            arrayWrap = true;
        }
        String collSchema = this.documentResourceSchema(docChain, openApi, ops, op, schemas);
        if (arrayWrap) {
            String schemaName = op.getName() + (request ? "Request" : "Response");
            Schema schema = (Schema)openApi.getComponents().getSchemas().get(schemaName);
            if (schema == null) {
                ArraySchema arr = new ArraySchema();
                arr.setItems(this.newComponentRefSchema(collSchema));
                openApi.getComponents().addSchemas(schemaName, (Schema)arr);
                schemas.put(schemaName, (Schema)arr);
                schemas.put(op, (Schema)arr);
            } else {
                schemas.put(op, schema);
                schemas.put(collSchema, schema);
            }
            return schemaName;
        }
        return collSchema;
    }

    default public String documentResourceSchema(Task docChain, OpenAPI openApi, List<Op> ops, Op op, Map<Object, Schema> schemas) {
        if (op.getCollection() == null) {
            System.out.println("NO COLLECTION: " + op.getName());
            return "unknown";
        }
        Collection coll = op.getCollection();
        String schemaName = coll.getSingularDisplayName();
        Schema schema = (Schema)openApi.getComponents().getSchemas().get(schemaName);
        if (schema != null) {
            return schemaName;
        }
        if (coll.getSchemaRef() != null) {
            schema = this.newComponentRefSchema(coll.getSchemaRef());
            openApi.getComponents().addSchemas(schemaName, schema);
        } else {
            Index pk;
            schema = new Schema();
            schema.setNullable(Boolean.valueOf(true));
            openApi.getComponents().addSchemas(schemaName, schema);
            if (coll.getDescription() != null) {
                schema.setDescription(coll.getDescription());
            }
            schema.setType("object");
            ArrayList requiredProps = new ArrayList();
            LinkedHashMap<String, Serializable> toDoc = new LinkedHashMap<String, Serializable>();
            HashMap<Relationship, Op> relOps = new HashMap<Relationship, Op>();
            Index index = pk = coll.getResourceIndex() != null ? coll.getResourceIndex() : null;
            if (pk != null) {
                for (Property prop : pk.getProperties()) {
                    if (!prop.isDocumented()) continue;
                    toDoc.put(prop.getJsonName(), prop);
                }
            }
            for (Property prop : coll.getProperties()) {
                if (!prop.isDocumented()) continue;
                toDoc.put(prop.getJsonName(), prop);
            }
            block2: for (Relationship rel : coll.getRelationships()) {
                for (Op candiateOp : ops) {
                    if (candiateOp.getCollection() != rel.getRelated()) continue;
                    boolean found = false;
                    if (rel.isManyToOne() && candiateOp.getFunction() == Op.OpFunction.GET) {
                        found = true;
                    } else if (candiateOp.getFunction() == Op.OpFunction.FIND) {
                        found = true;
                    }
                    if (!found) continue;
                    String name = rel.getName();
                    while (toDoc.containsKey(name)) {
                        name = name + "Rel";
                    }
                    toDoc.put(name, rel);
                    relOps.put(rel, candiateOp);
                    continue block2;
                }
            }
            for (String name : toDoc.keySet()) {
                Object propOrRel = toDoc.get(name);
                if (propOrRel instanceof Property) {
                    Property prop = (Property)propOrRel;
                    String type = prop.getJsonType();
                    Schema propSchema = this.newTypeSchema(type, null);
                    if (prop.getDescription() != null) {
                        propSchema.setDescription(prop.getDescription());
                    }
                    schema.addProperties(name, propSchema);
                    continue;
                }
                Relationship rel = (Relationship)propOrRel;
                Op targetOp = (Op)relOps.get(rel);
                String childSchema = this.documentResourceSchema(docChain, openApi, ops, targetOp, schemas);
                if (rel.isManyToOne() || rel.isOneToOneParent() || rel.isOneToOneChild()) {
                    schema.addProperties(name, this.newComponentRefSchema(childSchema));
                    continue;
                }
                ArraySchema arr = new ArraySchema();
                arr.setItems(this.newComponentRefSchema(childSchema));
                schema.addProperties(name, (Schema)arr);
            }
        }
        return schemaName;
    }

    default public Operation buildOperation(Op op, String description, String requestSchema, String ... statusAndSchema) {
        Operation operation = new Operation().responses(new ApiResponses());
        operation.setOperationId(op.getName());
        if (requestSchema != null) {
            RequestBody body = new RequestBody();
            operation.setRequestBody(body);
            Content content = new Content();
            body.setContent(content);
            MediaType json = new MediaType();
            json.setSchema(this.newComponentRefSchema(requestSchema));
            content.addMediaType("application/json", json);
        }
        for (int i = 0; statusAndSchema != null && i < statusAndSchema.length - 1; i += 2) {
            String status = statusAndSchema[i];
            String schemaName = statusAndSchema[i + 1];
            this.addResponse(operation, op, status, null, schemaName);
        }
        Collection collection = op.getCollection();
        if (collection != null) {
            operation.addTagsItem(this.beautifyTag(collection.getSingularDisplayName()));
        }
        return operation;
    }

    default public String getDescription(Op op) {
        String desc = op.getDescription();
        if (desc != null) {
            return desc;
        }
        if (op.getCollection() == null) {
            return "";
        }
        Collection coll = op.getCollection();
        switch (op.getFunction()) {
            case GET: {
                return "Retrieve a specific " + coll.getSingularDisplayName() + " object. (" + op.getName() + ")";
            }
            case FIND: {
                return "A pageable list of all " + coll.getSingularDisplayName() + " resources the user has access to and also match any query parameters.  The list may be empty. (" + op.getName() + ")";
            }
            case RELATED: {
                return "Retrieves all of the " + op.getRelationship().getRelated().getPluralDisplayName() + " related to the " + op.getRelationship().getRelated().getSingularDisplayName() + ". (" + op.getName() + ")";
            }
            case POST: {
                return "Creates a new " + coll.getSingularDisplayName() + " resource. (" + op.getName() + ")";
            }
            case PUT: {
                return "Updates an existing " + coll.getSingularDisplayName() + " resource.  Properties of the existing resource that are not supplied in the request body will not be updated. (" + op.getName() + ")";
            }
            case PATCH: {
                return "";
            }
            case DELETE: {
                return "";
            }
            case BATCH_POST: {
                return "";
            }
            case BATCH_PUT: {
                return "";
            }
            case BATCH_PATCH: {
                return "";
            }
            case BATCH_DELETE: {
                return op.getName() + ": Deletes an existing " + coll.getSingularDisplayName() + " resource. (" + op.getName() + ")";
            }
        }
        return "";
    }

    default public OpenAPIWriter addResponse(Operation operation, Op op, String status) {
        String description = null;
        String schemaName = null;
        return this.addResponse(operation, op, status, description, schemaName);
    }

    default public OpenAPIWriter addResponse(Operation operation, Op op, String status, String description, String schemaName) {
        if (description == null) {
            switch (status) {
                case "200": {
                    description = "OK";
                    break;
                }
                case "201": {
                    description = "Created";
                    break;
                }
                case "204": {
                    description = "No Content";
                    break;
                }
                case "400": {
                    description = "Bad Request";
                    break;
                }
                case "401": {
                    description = "Unauthorized";
                    break;
                }
                case "403": {
                    description = "Forbidden";
                    break;
                }
                case "404": {
                    description = "Not Found";
                    break;
                }
                case "500": {
                    description = "Internal Server Error";
                }
            }
        }
        if (schemaName == null && status != null && "399".compareTo(status) < 0) {
            schemaName = "error";
        }
        if (operation.getResponses() == null) {
            operation.setResponses(new ApiResponses());
        }
        ApiResponse response = new ApiResponse();
        if (description != null) {
            response.setDescription(description);
        }
        if (schemaName != null) {
            response.content(new Content().addMediaType("application/json", new MediaType().schema(this.newComponentRefSchema(schemaName))));
        }
        operation.getResponses().addApiResponse(status, response);
        return this;
    }

    default public void documentQueryParams(Task docChain, OpenAPI openApi, Operation operation, Op op) {
        for (Param param : op.getParams()) {
            if (param.getIn() != Param.In.QUERY || (param.getMethods().size() != 0 || !op.getMethod().equalsIgnoreCase("GET")) && !param.hasMethod(op.getMethod())) continue;
            this.documentParam(docChain, openApi, operation, op, param);
        }
    }

    default public void documentParam(Task docTask, OpenAPI openApi, Operation operation, Op op, Param param) {
        PathItem pi = (PathItem)openApi.getPaths().get((Object)op.getOperationPath());
        if (pi == null) {
            return;
        }
        Parameter parameter = new Parameter();
        parameter.setSchema(this.newTypeSchema(param.getType(), null));
        parameter.setDescription(param.getDescription());
        parameter.setName(param.getKey());
        parameter.setIn(param.getIn().toString().toLowerCase());
        if (!this.hasParam(operation, parameter)) {
            operation.addParametersItem(parameter);
        }
    }

    default public boolean hasParam(Operation operation, Parameter param) {
        if (operation.getParameters() == null) {
            return false;
        }
        for (Parameter existing : operation.getParameters()) {
            if (!param.getName().equalsIgnoreCase(existing.getName()) || !param.getIn().equalsIgnoreCase(existing.getIn())) continue;
            return true;
        }
        return false;
    }

    default public Schema newTypeSchema(String type, String description) {
        Schema schema = new Schema();
        schema.setType(type);
        if (!Utils.empty((Object[])new Object[]{description})) {
            schema.setDescription(description);
        }
        return schema;
    }

    default public Schema newHrefSchema() {
        Schema schema = new Schema();
        schema.addProperties("href", this.newTypeSchema("string", null));
        return schema;
    }

    default public Schema newComponentRefSchema(String nameOrRef) {
        Schema schema = new Schema();
        nameOrRef = this.getSchemaRef(nameOrRef);
        schema.set$ref(nameOrRef);
        return schema;
    }

    default public String getSchemaRef(String nameOrRef) {
        if (!nameOrRef.contains("/")) {
            nameOrRef = "#/components/schemas/" + nameOrRef;
        }
        return nameOrRef;
    }

    default public String beautifyTag(String str) {
        str = str.replace("_", " ");
        StringBuffer buff = new StringBuffer();
        boolean wasLower = !Character.isUpperCase(str.charAt(0));
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            boolean isUpper = Character.isUpperCase(c);
            if (c == ' ') {
                wasLower = true;
                buff.append(" ");
            } else if (wasLower && isUpper) {
                buff.append(" ");
                buff.append(c);
            } else {
                buff.append(c);
            }
            wasLower = !isUpper;
        }
        return buff.toString();
    }

    default public Op findOp(List<Op> ops, Op.OpFunction fun, Collection collection) {
        for (Op op : ops) {
            if (op.getFunction() != fun || op.getCollection() != collection) continue;
            return op;
        }
        return null;
    }
}

