/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.action.misc;

import io.inversion.Action;
import io.inversion.ApiException;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.json.JSList;
import io.inversion.json.JSMap;
import io.inversion.json.JSNode;
import io.inversion.json.JSParser;
import io.inversion.utils.Utils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.List;

public class MockAction
extends Action<MockAction> {
    protected JSNode json = null;
    protected String jsonUrl = null;
    protected int statusCode = -1;
    protected String status = null;
    protected boolean cancelRequest = true;

    public MockAction() {
    }

    public MockAction(JSNode json) {
        this.withJson(json);
    }

    public MockAction(String status, JSNode json) {
        this.withStatus(status);
        this.withJson(json);
    }

    public MockAction(String name) {
        this(null, name, null);
    }

    public MockAction(String ruleMatcherSpec, String name, JSNode json) {
        if (name != null && json == null) {
            json = new JSMap(new Object[]{"name", name});
        }
        this.withName(name);
        this.withIncludeOn(ruleMatcherSpec);
        this.withJson(json);
    }

    @Override
    public void run(Request req, Response res) throws ApiException {
        if (this.statusCode > 0) {
            res.withStatus(this.status);
        }
        if (this.status != null) {
            res.withStatus(this.status);
        } else if (this.statusCode < 0) {
            this.withStatus("200 OK");
        }
        JSNode json = this.getJson();
        if (json != null) {
            if (json instanceof JSList) {
                res.withRecords((List)json.asList());
            } else {
                res.withJson(json);
            }
        }
        if (this.cancelRequest) {
            req.getChain().cancel();
        }
    }

    public MockAction withJson(JSNode json) {
        this.json = json;
        return this;
    }

    public String getJsonUrl() {
        return this.jsonUrl;
    }

    public MockAction withJsonUrl(String jsonUrl) {
        this.jsonUrl = jsonUrl;
        return this;
    }

    public JSNode getJson() {
        if (this.json == null && this.jsonUrl != null) {
            InputStream stream = null;
            try {
                stream = new URL(this.jsonUrl).openStream();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (stream == null) {
                stream = this.getClass().getResourceAsStream(this.jsonUrl);
            }
            if (stream == null) {
                stream = this.getClass().getClassLoader().getResourceAsStream(this.jsonUrl);
            }
            if (stream == null) {
                try {
                    File f = new File(this.jsonUrl);
                    if (f.exists()) {
                        stream = new BufferedInputStream(new FileInputStream(this.jsonUrl));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (stream != null) {
                this.json = JSParser.asJSNode((String)Utils.read((InputStream)stream));
            } else {
                throw ApiException.new500InternalServerError("Unable to locate jsonUrl '{}'. Please check your configuration", this.jsonUrl);
            }
        }
        return this.json;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public MockAction wihtStatusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public MockAction withStatus(String status) {
        this.status = status;
        return this;
    }

    public boolean isCancelRequest() {
        return this.cancelRequest;
    }

    public MockAction withCancelRequest(boolean cancelRequest) {
        this.cancelRequest = cancelRequest;
        return this;
    }
}

