/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.action.hateoas;

import io.inversion.ApiException;
import io.inversion.Chain;
import io.inversion.Collection;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.action.hateoas.HATEOASFilter;
import io.inversion.json.JSList;
import io.inversion.json.JSMap;
import io.inversion.json.JSNode;

public class HALFilter
extends HATEOASFilter<HALFilter> {
    @Override
    public void run(Request req, Response res) throws ApiException {
        req.getChain().go();
        if (res.isSuccess()) {
            JSNode node = res.getJson();
            if (!(node instanceof JSMap)) {
                return;
            }
            JSMap json = (JSMap)node;
            if (json != null) {
                if (json.containsKey((Object)"_links")) {
                    return;
                }
                if (req.getCollection() != null) {
                    JSMap meta = res.findMap("meta");
                    if (meta != null) {
                        int page = res.getPageNum();
                        int size = res.getPageSize();
                        int pages = res.getPageCount();
                        int total = res.getFoundRows();
                        json.put("page", (Object)page);
                        json.put("size", (Object)size);
                        json.put("pages", (Object)pages);
                        json.put("total", (Object)total);
                        meta.remove(new Object[]{"pageSize", "pageNum", "foundRows", "pageCount"});
                        JSMap links = new JSMap();
                        for (String key : meta.keySet()) {
                            String value = meta.get((Object)key) + "";
                            if (value == null) continue;
                            if (value.startsWith("http://") || value.startsWith("https://")) {
                                links.put((Object)key, (Object)new JSMap(new Object[]{"href", value}));
                                continue;
                            }
                            json.put(key, (Object)value);
                        }
                        json.remove((Object)"meta");
                        if (links.size() > 0) {
                            json.putFirst("_links", (Object)links);
                        }
                    }
                    if (json.find("data") instanceof JSList) {
                        JSList data = (JSList)json.remove((Object)"data");
                        json.put("_embedded", (Object)data);
                    }
                    if (Chain.getDepth() == 1) {
                        JSMap links;
                        JSList array;
                        if (req.getResourceKey() != null && req.getRelationshipKey() == null && (array = res.data()) != null && array.size() == 1 && array.get(0) instanceof JSNode) {
                            json = array.getMap((Object)0);
                            res.withJson((JSNode)json);
                        }
                        if ((links = json.getMap((Object)"_links")) == null) {
                            links = new JSMap();
                            json.putFirst("_links", (Object)links);
                        }
                        if (!links.containsKey((Object)"self")) {
                            links.putFirst("self", (Object)new JSMap(new Object[]{"href", req.getUrl().getOriginal()}));
                        }
                    }
                }
                if (res.isSuccess() && res.getJson() != null) {
                    Collection coll = req.getRelationship() != null ? req.getRelationship().getRelated() : req.getCollection();
                    res.data().stream().filter(n -> n instanceof JSMap).forEach(n -> this.addLinks(coll, (JSMap)n));
                }
            }
        }
    }

    @Override
    public void addLink(JSMap entityNode, String name, String link) {
        JSMap links = entityNode.getMap((Object)"_links");
        if (links == null) {
            links = new JSMap();
            entityNode.putFirst("_links", (Object)links);
        }
        links.putFirst(name, (Object)new JSMap(new Object[]{"href", link}));
    }

    @Override
    public void addSelfLink(JSMap entityNode, String link) {
        this.addLink(entityNode, "self", link);
    }
}

