/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.action.db;

import io.inversion.Action;
import io.inversion.ApiException;
import io.inversion.Collection;
import io.inversion.Engine;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.Rule;
import io.inversion.Url;
import io.inversion.json.JSMap;
import io.inversion.utils.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DbDeleteAction<A extends DbDeleteAction>
extends Action<A> {
    @Override
    protected List<Rule.RuleMatcher> getDefaultIncludeMatchers() {
        return Utils.asList((Object[])new Object[]{new Rule.RuleMatcher("DELETE", "{_collection}/[{_resource}]")});
    }

    @Override
    public void run(Request req, Response res) throws ApiException {
        String resourceKey = req.getResourceKey();
        String relationshipKey = req.getRelationshipKey();
        if (Utils.empty((Object[])new Object[]{resourceKey})) {
            throw ApiException.new400BadRequest("An resource key must be included in the url path for a DELETE request.", new Object[0]);
        }
        if (!Utils.empty((Object[])new Object[]{relationshipKey})) {
            throw ApiException.new400BadRequest("A relationship key in the url path is not valid for a DELETE request", new Object[0]);
        }
        if (req.getJson() != null) {
            throw ApiException.new501NotImplemented("A JSON body can not be included with a DELETE.  Batch delete is not supported.", new Object[0]);
        }
        int deleted = this.delete(req.getEngine(), req.getCollection(), req.getUrl());
        if (deleted < 1) {
            throw ApiException.new404NotFound("The requested resource '{}' could not be found.", resourceKey);
        }
        res.withStatus("204 No Content");
    }

    protected int delete(Engine engine, Collection collection, Url url) throws ApiException {
        int deleted = 0;
        HashSet<String> alreadyDeleted = new HashSet<String>();
        for (int i = 0; i < 1000; ++i) {
            Url query = new Url(url.getOriginal());
            query.withParam("include", Utils.implode((String)",", (Object[])new Object[]{collection.getResourceIndex().getJsonNames()}));
            String urlStr = query.toString();
            Response res = engine.get(urlStr).assertStatus(200, 404);
            if (res.hasStatus(404)) break;
            ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
            for (JSMap node : res.data().asMapList()) {
                String key = collection.encodeKeyFromJsonNames((Map<String, Object>)node);
                if (alreadyDeleted.contains(key)) {
                    throw ApiException.new500InternalServerError("Deletion of '{}' was not successful.", key);
                }
                alreadyDeleted.add(key);
                rows.add((Map<String, Object>)node);
            }
            collection.getDb().delete(collection, rows);
            deleted += res.data().size();
        }
        return deleted;
    }
}

