/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.action.db;

import io.inversion.Action;
import io.inversion.Api;
import io.inversion.ApiException;
import io.inversion.Collection;
import io.inversion.Db;
import io.inversion.Index;
import io.inversion.Op;
import io.inversion.Relationship;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.Rule;
import io.inversion.action.db.DbDeleteAction;
import io.inversion.action.db.DbGetAction;
import io.inversion.action.db.DbPatchAction;
import io.inversion.action.db.DbPostAction;
import io.inversion.action.db.DbPutAction;
import io.inversion.action.openapi.OpenAPIWriter;
import io.inversion.utils.Path;
import io.inversion.utils.Task;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class DbAction
extends Action<DbAction>
implements OpenAPIWriter<DbAction> {
    private DbGetAction getAction = new DbGetAction();
    private DbPostAction postAction = new DbPostAction();
    private DbPutAction putAction = new DbPutAction();
    private DbPatchAction patchAction = new DbPatchAction();
    private DbDeleteAction deleteAction = new DbDeleteAction();

    @Override
    protected List<Rule.RuleMatcher> getDefaultIncludeMatchers() {
        ArrayList<Rule.RuleMatcher> matchers = new ArrayList<Rule.RuleMatcher>();
        if (this.getAction != null) {
            matchers.addAll(this.getAction.getIncludeMatchers());
        }
        if (this.postAction != null) {
            matchers.addAll(this.postAction.getIncludeMatchers());
        }
        if (this.putAction != null) {
            matchers.addAll(this.putAction.getIncludeMatchers());
        }
        if (this.patchAction != null) {
            matchers.addAll(this.patchAction.getIncludeMatchers());
        }
        if (this.deleteAction != null) {
            matchers.addAll(this.deleteAction.getIncludeMatchers());
        }
        return matchers;
    }

    @Override
    protected LinkedHashSet<Path> getIncludePaths(Api api, Db db, String method) {
        LinkedHashSet<Path> includePaths = new LinkedHashSet<Path>();
        for (Path actionPath : super.getIncludePaths(api, db, method)) {
            int collectionIdx = actionPath.getVarIndex("_collection");
            int resourceIdx = actionPath.getVarIndex("_resource");
            int relationshipIdx = actionPath.getVarIndex("_relationship");
            if (collectionIdx > -1) {
                for (Collection c : db.getCollections()) {
                    Path collPath = actionPath.copy();
                    collPath.set(collectionIdx, c.getName());
                    if (resourceIdx > -1) {
                        String resourceKey = "{" + this.getResourceKeyParamName(c) + "}";
                        collPath.set(resourceIdx, resourceKey);
                        if (relationshipIdx > -1) {
                            for (Relationship relationship : c.getRelationships()) {
                                Path relPath = collPath.copy();
                                relPath.set(relationshipIdx, relationship.getName());
                                includePaths.add(relPath);
                            }
                            continue;
                        }
                        includePaths.add(collPath);
                        continue;
                    }
                    includePaths.add(collPath);
                }
                continue;
            }
            if (collectionIdx >= 0 || resourceIdx >= 0 || relationshipIdx >= 0) continue;
            includePaths.add(actionPath);
        }
        return includePaths;
    }

    @Override
    public void configureOp(Task task, Op op) {
        Collection coll;
        super.configureOp(task, op);
        String method = op.getMethod();
        Path path = op.getPath();
        Db db = op.getApi().matchDb(method, path);
        if (db == null) {
            return;
        }
        String collName = op.getPathParamValue("_collection");
        if (collName != null && (coll = db.getCollection(collName)) != null) {
            op.withCollection(coll);
            String relName = op.getPathParamValue("_relationship");
            if (relName != null) {
                op.withRelationship(coll.getRelationship(relName));
            }
        }
        switch (op.getMethod().toUpperCase()) {
            case "GET": {
                this.getAction.configureOp(task, op);
                break;
            }
            case "POST": {
                this.postAction.configureOp(task, op);
                break;
            }
            case "PUT": {
                this.putAction.configureOp(task, op);
                break;
            }
            case "PATCH": {
                this.patchAction.configureOp(task, op);
                break;
            }
            case "DELETE": {
                this.deleteAction.configureOp(task, op);
            }
        }
    }

    @Override
    public Operation hook_documentOp(Task docChain, OpenAPI openApi, List<Op> ops, Op op, Map<Object, Schema> schemas) {
        switch (op.getMethod().toUpperCase()) {
            case "GET": {
                return this.getAction.hook_documentOp(docChain, openApi, ops, op, schemas);
            }
            case "POST": {
                return this.postAction.hook_documentOp(docChain, openApi, ops, op, schemas);
            }
            case "PUT": {
                return this.putAction.hook_documentOp(docChain, openApi, ops, op, schemas);
            }
            case "PATCH": {
                return this.patchAction.hook_documentOp(docChain, openApi, ops, op, schemas);
            }
            case "DELETE": {
                return this.deleteAction.hook_documentOp(docChain, openApi, ops, op, schemas);
            }
        }
        return null;
    }

    @Override
    public void run(Request req, Response res) throws ApiException {
        if (req.isMethod("GET")) {
            this.getAction.run(req, res);
        } else if (req.isMethod("POST")) {
            this.postAction.run(req, res);
        } else if (req.isMethod("PUT")) {
            this.putAction.run(req, res);
        } else if (req.isMethod("PATCH")) {
            this.patchAction.run(req, res);
        } else if (req.isMethod("DELETE")) {
            this.deleteAction.run(req, res);
        }
    }

    protected String getResourceKeyParamName(Collection c) {
        String name = null;
        Index idx = c.getResourceIndex();
        if (idx != null && idx.size() == 1) {
            name = idx.getJsonNames().get(0);
        } else {
            name = c.getSingularDisplayName() + "Id";
            if (c.getProperty(name = Character.toLowerCase(name.charAt(0)) + name.substring(1)) != null) {
                name = name.substring(0, name.length() - 2) + "Key";
            }
            if (c.getProperty(name) != null) {
                name = "id";
            }
            if (c.getProperty(name) != null) {
                name = "key";
            }
            while (c.getProperty(name) != null) {
                name = name + "Id";
            }
        }
        return name;
    }

    public DbGetAction getGetAction() {
        return this.getAction;
    }

    public DbAction withGetAction(DbGetAction getAction) {
        this.getAction = getAction;
        return this;
    }

    public DbPostAction getPostAction() {
        return this.postAction;
    }

    public DbAction withPostAction(DbPostAction postAction) {
        this.postAction = postAction;
        return this;
    }

    public DbPutAction getPutAction() {
        return this.putAction;
    }

    public DbAction withPutAction(DbPutAction putAction) {
        this.putAction = putAction;
        return this;
    }

    public DbPatchAction getPatchAction() {
        return this.patchAction;
    }

    public DbAction withPatchAction(DbPatchAction patchAction) {
        this.patchAction = patchAction;
        return this;
    }

    public DbDeleteAction getDeleteAction() {
        return this.deleteAction;
    }

    public DbAction withDeleteAction(DbDeleteAction deleteAction) {
        this.deleteAction = deleteAction;
        return this;
    }
}

