/*
 * Decompiled with CFR 0.152.
 */
package io.inversion;

import io.inversion.ApiException;
import io.inversion.Chain;
import io.inversion.Change;
import io.inversion.Engine;
import io.inversion.Op;
import io.inversion.Request;
import io.inversion.json.JSFind;
import io.inversion.json.JSList;
import io.inversion.json.JSMap;
import io.inversion.json.JSNode;
import io.inversion.json.JSParser;
import io.inversion.utils.MimeTypes;
import io.inversion.utils.StreamBuffer;
import io.inversion.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;

public class Response
implements JSFind {
    protected Chain chain = null;
    protected Request request = null;
    protected int statusCode = 200;
    protected String statusMesg = "OK";
    protected String url = null;
    protected String fileName = null;
    protected final ArrayListValuedHashMap<String, String> headers = new ArrayListValuedHashMap();
    protected JSNode json = new JSMap(new Object[]{"meta", new JSMap(), "data", new JSList(new Object[0])});
    protected String text = null;
    protected StreamBuffer stream = null;
    protected Throwable error = null;
    protected final StringBuilder debug = new StringBuilder();
    protected final List<Change> changes = new ArrayList<Change>();
    protected long startAt = System.currentTimeMillis();
    protected long endAt = -1L;

    public Response() {
    }

    public Response(String url) {
        this.withUrl(url);
    }

    public Response withJson(JSNode json) {
        this.json = json;
        this.text = null;
        this.stream = null;
        return this;
    }

    public Response withJson(String json) {
        if (json == null) {
            this.withJson((JSNode)null);
        } else {
            this.withJson((JSNode)JSParser.parseJson((String)json));
        }
        return this;
    }

    public Response withText(String text) {
        this.text = text;
        this.json = null;
        this.stream = null;
        return this;
    }

    public Response withBody(StreamBuffer stream, String fileName) {
        this.withBody(stream);
        this.withFileName(fileName);
        return this;
    }

    public Response withBody(StreamBuffer stream) {
        this.text = null;
        this.json = null;
        this.stream = stream;
        if (this.getContentType() == null && stream.getContentType() != null) {
            this.withContentType(stream.getContentType());
        }
        return this;
    }

    public JSNode getJson() {
        if (this.stream != null) {
            if (!"application/json".equalsIgnoreCase(this.getContentType())) {
                return null;
            }
            try {
                this.json = (JSNode)JSParser.parseJson((InputStream)this.stream.getInputStream());
            }
            catch (Exception e) {
                throw new ApiException(e);
            }
            finally {
                this.stream = null;
            }
        }
        if (this.json == null && this.text != null) {
            try {
                this.json = (JSNode)JSParser.parseJson((String)this.text);
                this.text = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.json;
    }

    public String getText() {
        if (this.stream != null) {
            try {
                this.text = Utils.read((InputStream)this.stream.getInputStream());
            }
            catch (Exception e) {
                throw new ApiException(e);
            }
            finally {
                this.stream = null;
            }
        }
        if (this.text == null && this.json != null) {
            return this.json.toString();
        }
        return this.text;
    }

    public StreamBuffer getBody() {
        boolean explain = false;
        Request req = this.getRequest();
        if (req == null && Chain.getDepth() > 0) {
            req = Chain.peek().getRequest();
        }
        if (req != null) {
            explain = req.isDebug() && req.isExplain();
        }
        return this.getBody(explain);
    }

    public StreamBuffer getBody(boolean explain) {
        StreamBuffer output = this.stream;
        try {
            if (output == null) {
                if (this.json != null) {
                    output = new StreamBuffer();
                    output.write(this.json.toString().getBytes(StandardCharsets.UTF_8));
                    output.withContentType("application/json");
                } else if (this.text != null) {
                    output = new StreamBuffer();
                    output.write(this.text.getBytes(StandardCharsets.UTF_8));
                    String contentType = this.getContentType();
                    if (contentType == null) {
                        contentType = "text/plain";
                    }
                    output.withContentType(contentType);
                }
            }
            if (explain) {
                StringBuilder buff = new StringBuilder("");
                buff.append(this.debug.toString());
                if (this.error != null) {
                    buff.append("\r\n<< error ----------------");
                    buff.append("\r\n").append(Utils.getShortCause((Throwable)this.error));
                }
                buff.append("\r\n<< response -------------");
                buff.append("\r\n").append(this.getStatus());
                buff.append("\r\n");
                for (String key : this.getHeaders().keySet()) {
                    buff.append("\r\n").append(key).append(" ").append(this.getHeader(key));
                }
                buff.append("\r\n");
                if (output != null) {
                    String text = Utils.read((InputStream)output.getInputStream());
                    buff.append(text);
                }
                output = new StreamBuffer();
                output.withContentType("text/plain");
                output.write(buff.toString().getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        return output;
    }

    public Response debug(String format, Object ... args) {
        this.debug.append(Utils.format((String)format, (Object[])args)).append("\r\n");
        return this;
    }

    public String getDebug() {
        try {
            return Utils.read((InputStream)this.getBody(true).getInputStream());
        }
        catch (IOException ex) {
            throw new ApiException(ex);
        }
    }

    public Response dump() {
        System.out.println(this.getDebug());
        return this;
    }

    public long getStartAt() {
        return this.startAt;
    }

    public Response withStartAt(long startAt) {
        this.startAt = startAt;
        return this;
    }

    public long getEndAt() {
        return this.endAt;
    }

    public Response withEndAt(long endAt) {
        this.endAt = endAt;
        return this;
    }

    public Response withUrl(String url) {
        if (!Utils.empty((Object[])new Object[]{url})) {
            url = url.trim();
            url = url.replaceAll(" ", "%20");
        }
        this.url = url;
        if (Utils.empty((Object[])new Object[]{this.fileName})) {
            try {
                String fileName = new URL(url).getFile();
                this.withFileName(fileName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this;
    }

    public Response withFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public String getUrl() {
        if (this.url == null && this.request != null) {
            return this.request.getUrl().toString();
        }
        return this.url;
    }

    public Response withRequest(Request request) {
        this.request = request;
        return this;
    }

    public Request getRequest() {
        return this.request;
    }

    public Op getOp() {
        return this.request != null ? this.request.getOp() : null;
    }

    public Chain getChain() {
        if (this.chain == null && this.request != null) {
            return this.request.getChain();
        }
        return this.chain;
    }

    public Response withChain(Chain chain) {
        this.chain = chain;
        return this;
    }

    public Engine getEngine() {
        return this.getChain() != null ? this.getChain().getEngine() : null;
    }

    public String toString() {
        return this.debug.toString();
    }

    public Response withError(Throwable ex) {
        this.error = ex;
        return this;
    }

    public Throwable getError() {
        return this.error;
    }

    public Response withMeta(String key, Object value) {
        JSNode json = this.getJson();
        JSMap meta = json.getMap((Object)"meta");
        if (meta == null) {
            meta = json;
        }
        meta.put((Object)key, value);
        return this;
    }

    public JSNode getMeta() {
        JSNode json = this.getJson();
        JSMap meta = json.getMap((Object)"meta");
        if (meta == null) {
            meta = json;
        }
        return meta;
    }

    public Response withFoundRows(int foundRows) {
        this.withMeta("foundRows", foundRows);
        this.updatePageCount();
        return this;
    }

    public int getFoundRows() {
        return this.getMeta().findInt("foundRows");
    }

    public Response withLastKey(String lastKey) {
        this.withMeta("lastKey", lastKey);
        return this;
    }

    public String getLastKey() {
        return this.getMeta().findString("lastKey");
    }

    public Response withPageSize(int pageSize) {
        this.withMeta("pageSize", pageSize);
        return this;
    }

    public int getPageSize() {
        return this.getMeta().findInt("pageSize");
    }

    public Response withPageNum(int pageNum) {
        this.withMeta("pageNum", pageNum);
        this.updatePageCount();
        return this;
    }

    public int getPageNum() {
        return this.getMeta().findInt("pageNum");
    }

    public Response withPageCount(int pageCount) {
        this.withMeta("pageCount", pageCount);
        return this;
    }

    public int getPageCount() {
        return this.getMeta().findInt("pageCount");
    }

    protected void updatePageCount() {
        int ps = this.getPageSize();
        int fr = this.getFoundRows();
        if (ps > 0 && fr > 0) {
            int pageCount = fr / ps + (fr % ps == 0 ? 0 : 1);
            this.withPageCount(pageCount);
        }
    }

    public Response withLink(String name, String url) {
        JSMap links = this.getJson().findMap("_links");
        if (links != null) {
            links.put((Object)name, (Object)new JSMap(new Object[]{"href", url}));
        } else {
            this.getMeta().put((Object)name, (Object)url);
        }
        return this;
    }

    public String getLink(String name) {
        JSMap links = this.getJson().findMap("_links");
        if (links != null) {
            JSNode link = links.getNode((Object)name);
            if (link != null) {
                return link.getString((Object)"href");
            }
        } else {
            Object link = this.getMeta().get((Object)name);
            if (link instanceof String) {
                return (String)link;
            }
        }
        return null;
    }

    public String getSelf() {
        return this.getLink("self");
    }

    public Response withSelf(String url) {
        this.withLink("self", url);
        return this;
    }

    public String getNext() {
        return this.getLink("next");
    }

    public Response withNext(String url) {
        this.withLink("next", url);
        return this;
    }

    public String getPrev() {
        return this.getLink("prev");
    }

    public Response withPrev(String url) {
        this.withLink("prev", url);
        return this;
    }

    public String getFirst() {
        return this.getLink("first");
    }

    public Response withFirst(String url) {
        this.withLink("first", url);
        return this;
    }

    public String getLast() {
        return this.getLink("last");
    }

    public Response withLast(String url) {
        this.withLink("last", url);
        return this;
    }

    public JSList data() {
        JSNode json = this.getJson();
        if (json == null) {
            return null;
        }
        if (json instanceof JSList) {
            return (JSList)json;
        }
        if (json.get((Object)"data") instanceof JSList) {
            return json.getList((Object)"data");
        }
        if (json.get((Object)"_embedded") instanceof JSList) {
            return json.getList((Object)"_embedded");
        }
        if (json.get((Object)"items") instanceof JSList) {
            return json.getList((Object)"items");
        }
        return new JSList(new Object[]{json});
    }

    public JSMap getFirstRecordAsMap() {
        JSList data = this.data();
        if (data == null || data.size() == 0) {
            return null;
        }
        return data.getMap((Object)0);
    }

    public Response withRecord(Object record) {
        JSList data = this.data();
        if (data == null) {
            data = new JSList(new Object[0]);
            this.getJson().put((Object)"data", (Object)data);
        }
        data.add(record);
        return this;
    }

    public Response withRecords(List records) {
        for (Object record : records) {
            this.withRecord(record);
        }
        return this;
    }

    public boolean isSuccess() {
        return this.statusCode >= 200 && this.statusCode <= 300 && this.error == null;
    }

    public Response withStatus(String status) {
        this.statusMesg = status;
        try {
            this.statusCode = Integer.parseInt(status.substring(0, 3));
            if (this.statusMesg.length() > 4) {
                this.statusMesg = status.substring(4);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public boolean hasStatus(int ... statusCodes) {
        for (int statusCode : statusCodes) {
            if (this.statusCode != statusCode) continue;
            return true;
        }
        return false;
    }

    public String getStatus() {
        return this.statusCode + " " + this.statusMesg;
    }

    public Response withStatusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMesg() {
        return this.statusMesg;
    }

    public Response withStatusMesg(String statusMesg) {
        this.statusMesg = statusMesg;
        return this;
    }

    public ArrayListValuedHashMap<String, String> getHeaders() {
        return this.headers;
    }

    public void withHeaders(ArrayListValuedHashMap headers) {
        this.headers.putAll((MultiValuedMap)headers);
    }

    public String getHeader(String key) {
        List vals = this.headers.get((Object)key);
        if (vals != null && vals.size() > 0) {
            return Utils.implode((String)",", (Object[])new Object[]{vals});
        }
        return null;
    }

    public void withHeader(String key, String value) {
        if (!this.headers.containsMapping((Object)key, (Object)value)) {
            this.headers.put((Object)key, (Object)value);
        }
    }

    public void clearHeaders() {
        this.headers.clear();
    }

    public String getRedirect() {
        return this.getHeader("Location");
    }

    public Response withRedirect(String redirect) {
        if (redirect == null) {
            this.headers.remove((Object)"Location");
            if (308 == this.getStatusCode()) {
                this.withStatus("200 OK");
            }
        } else {
            this.withHeader("Location", redirect);
            this.withStatus("308 Permanent Redirect");
        }
        return this;
    }

    public Response withContentType(String contentType) {
        this.headers.remove((Object)"Content-Type");
        this.withHeader("Content-Type", contentType);
        return this;
    }

    public String getContentType() {
        String ext;
        int dot;
        String contentType = this.getHeader("Content-Type");
        if (contentType != null) {
            return contentType;
        }
        if (this.json != null) {
            return "application/json";
        }
        if (this.fileName != null && (dot = this.fileName.lastIndexOf(46)) > 0 && (contentType = MimeTypes.getMimeType((String)(ext = this.fileName.substring(dot + 1)))) != null) {
            return contentType;
        }
        if (this.stream != null) {
            return this.stream.getContentType();
        }
        return contentType;
    }

    public long getContentLength() {
        String length = this.getHeader("Content-Length");
        if (length != null) {
            return Long.parseLong(length);
        }
        return 0L;
    }

    public List<Change> getChanges() {
        return this.changes;
    }

    public Response withChanges(Collection<Change> changes) {
        this.changes.addAll(changes);
        return this;
    }

    public Response withChange(String method, String collectionKey, Object resourceKey) {
        if (resourceKey instanceof List) {
            List deletedIds = (List)resourceKey;
            for (Object id : deletedIds) {
                this.changes.add(new Change(method, collectionKey, id));
            }
        } else {
            this.changes.add(new Change(method, collectionKey, resourceKey));
        }
        return this;
    }

    public Response withChange(String method, String collectionKey, String ... resourceKeys) {
        for (int i = 0; resourceKeys != null && i < resourceKeys.length; ++i) {
            this.withChange(method, collectionKey, (Object)resourceKeys[i]);
        }
        return this;
    }

    public Response assertOk(String ... messages) {
        if (this.statusCode < 200 || this.statusCode > 299) {
            this.rethrow(this.statusCode, messages);
        }
        return this;
    }

    public void rethrow() {
        this.rethrow(this.statusCode);
    }

    public void rethrow(int statusCode) {
        this.rethrow(statusCode, (String[])null);
    }

    public void rethrow(String ... messages) {
        this.rethrow(this.statusCode, messages);
    }

    public void rethrow(int statusCode, String ... messages) {
        if (this.error != null) {
            Utils.rethrow((Throwable)this.error);
        }
        statusCode = statusCode > 399 ? statusCode : 500;
        StringBuilder msg = new StringBuilder();
        for (int i = 0; messages != null && i < messages.length; ++i) {
            msg.append(messages[i]).append("\r\n ");
        }
        String message = this.getText();
        try {
            while (message != null && message.startsWith("{") && message.contains("\\\"message\\\"")) {
                message = JSParser.asJSNode((String)message).getString((Object)"message");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (message != null) {
            msg.append(" ").append(message.trim());
        }
        throw new ApiException(statusCode + "", msg != null ? msg.toString() : null);
    }

    public Response assertStatus(int ... statusCodes) {
        return this.assertStatus(null, statusCodes);
    }

    public Response assertStatus(String message, int ... statusCodes) {
        boolean matched = false;
        for (int statusCode : statusCodes) {
            if (statusCode != this.statusCode) continue;
            matched = true;
            break;
        }
        if (!matched) {
            Object[] args = null;
            if (message == null) {
                message = "The returned status '{}' was not in the approved list '{}'";
                ArrayList<Integer> debugList = new ArrayList<Integer>();
                for (int code : statusCodes) {
                    debugList.add(code);
                }
                args = new Object[]{this.statusCode, debugList};
            }
            throw ApiException.new500InternalServerError(message, args);
        }
        return this;
    }

    public Response assertDebug(String lineMatch, String ... matches) {
        if (matches == null || matches.length == 0) {
            matches = new String[]{lineMatch.substring(lineMatch.indexOf(" ") + 1)};
            lineMatch = lineMatch.substring(0, lineMatch.indexOf(" "));
        }
        String debug = this.getDebug();
        int idx = (debug = debug.substring(0, debug.indexOf("<< response"))).indexOf(" " + lineMatch + " ");
        if (idx < 0) {
            System.err.println("SKIPPING DEBUG MATCH: " + lineMatch + " " + Arrays.asList(matches));
            return this;
        }
        String debugLine = debug.substring(idx, debug.indexOf("\n", idx)).trim();
        for (String match : matches) {
            List matchTokens = Utils.split((String)match, (char)' ', (char[])new char[]{'\'', '\"', '{', '}'});
            for (String matchToken : matchTokens) {
                if (debugLine.contains(matchToken)) continue;
                String msg = "ERROR: Can't find match token in debug line";
                msg = msg + "\r\n  - debug line    : " + debugLine;
                msg = msg + "\r\n  - missing token : " + matchToken;
                msg = msg + "\r\n" + debug;
                System.err.println(msg);
                Utils.error((String)msg);
            }
        }
        return this;
    }
}

