/*
 * Decompiled with CFR 0.152.
 */
package io.inversion;

import io.inversion.Collection;
import io.inversion.utils.Utils;
import java.io.Serializable;

public final class Property
implements Serializable {
    protected String name = null;
    protected String columnName = null;
    protected String description = null;
    protected String type = "string";
    protected boolean nullable = false;
    protected boolean readOnly = false;
    protected boolean autoGenerated = false;
    protected boolean required = false;
    protected String jsonType = null;
    protected String regex = null;
    protected boolean documented = true;
    protected boolean revisionColumn = false;
    protected boolean timestampColumn = false;
    protected String hint = null;
    protected boolean exclude = false;
    protected Property pk = null;
    protected Collection collection = null;

    public void setCollection(Collection collection) {
        this.collection = collection;
    }

    public Property() {
    }

    public Property(String name) {
        this(name, "string", true);
    }

    public Property(String name, String type) {
        this(name, type, true);
    }

    public Property(String name, String type, boolean nullable) {
        this.withColumnName(name);
        this.withJsonName(name);
        this.withType(type);
        this.withNullable(nullable);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Property) {
            Property column = (Property)object;
            return (this.collection == null || this.collection == column.collection) && Utils.equal((Object)this.columnName, (Object)column.columnName);
        }
        return false;
    }

    public String toString() {
        return this.hint == null ? this.getJsonName() : this.hint;
    }

    public Property withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Property getPk() {
        return this.pk;
    }

    public Property withPk(Property primaryKey) {
        this.pk = primaryKey;
        return this;
    }

    public boolean isFk() {
        return this.pk != null;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Property withColumnName(String name) {
        this.columnName = name;
        return this;
    }

    public String getJsonName() {
        return this.name;
    }

    public String getName() {
        return this.name != null ? this.name : this.columnName;
    }

    public Property withJsonName(String name) {
        this.name = name;
        return this;
    }

    public Property withName(String name) {
        this.name = name;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public Property withType(String type) {
        if (!Utils.empty((Object[])new Object[]{type}) && !"null".equalsIgnoreCase(type)) {
            this.type = type;
        }
        return this;
    }

    public Collection getCollection() {
        return this.collection;
    }

    public Property withCollection(Collection collection) {
        if (this.collection != collection) {
            this.collection = collection;
            collection.withProperties(this);
        }
        return this;
    }

    public String getHint() {
        return this.hint;
    }

    public Property withHint(String hint) {
        this.hint = hint;
        return this;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public Property withNullable(boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    public boolean isExclude() {
        return this.exclude;
    }

    public Property withExclude(boolean exclude) {
        this.exclude = exclude;
        return this;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public Property withReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public boolean isAutoGenerated() {
        return this.autoGenerated;
    }

    public Property withAutoGenerated(boolean autoGenerated) {
        this.autoGenerated = autoGenerated;
        return this;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Property withRequired(boolean required) {
        this.required = required;
        return this;
    }

    public Property withRegex(String regex) {
        this.regex = regex;
        return this;
    }

    public boolean isDocumented() {
        return this.documented;
    }

    public Property withDocumented(boolean documented) {
        this.documented = documented;
        return this;
    }

    public String getRegex() {
        if (this.regex != null) {
            return this.regex;
        }
        String type = this.getJsonType();
        if ("number".equalsIgnoreCase(type)) {
            return "[+-]?([0-9]*[.])?[0-9]+";
        }
        return null;
    }

    public boolean isRevisionColumn() {
        return this.revisionColumn;
    }

    public Property withRevisionColumn(boolean revisionColumn) {
        this.revisionColumn = revisionColumn;
        return this;
    }

    public boolean isTimestampColumn() {
        return this.timestampColumn;
    }

    public Property withTimestampColumn(boolean timestampColumn) {
        this.timestampColumn = timestampColumn;
        return this;
    }

    public Property withJsonType(String jsonType) {
        this.jsonType = jsonType;
        return this;
    }

    public String getJsonType() {
        if (this.jsonType != null) {
            return this.jsonType;
        }
        if (this.type == null) {
            return "string";
        }
        switch (this.type.toLowerCase()) {
            case "n": 
            case "number": 
            case "numeric": 
            case "decimal": 
            case "tinyint": 
            case "smallint": 
            case "integer": 
            case "bigint": 
            case "float": 
            case "real": 
            case "double": {
                return "number";
            }
            case "bool": 
            case "boolean": 
            case "bit": {
                return "boolean";
            }
            case "array": {
                return "array";
            }
            case "json": 
            case "object": {
                return "object";
            }
        }
        return "string";
    }
}

