/*
 * Decompiled with CFR 0.152.
 */
package io.inversion;

import io.inversion.ApiException;
import io.inversion.Engine;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.Upload;
import io.inversion.json.JSNode;
import io.inversion.utils.StreamBuffer;
import io.inversion.utils.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;

public class EngineServlet
extends HttpServlet {
    Engine engine = null;

    public static String readBody(HttpServletRequest request) throws ApiException {
        if (request == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            Object inputStream = request.getInputStream();
            if (inputStream != null) {
                int bytesRead;
                if ("gzip".equalsIgnoreCase(request.getHeader("Content-Encoding"))) {
                    inputStream = new GZIPInputStream((InputStream)inputStream, 1024);
                }
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream));
                char[] charBuffer = new char[128];
                while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                    stringBuilder.append(charBuffer, 0, bytesRead);
                }
            }
        }
        catch (Exception ex) {
            throw ApiException.new400BadRequest(ex, "Unable to read request body", new Object[0]);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return stringBuilder.toString();
    }

    public void destroy() {
        this.engine.shutdown();
    }

    public void init(ServletConfig config) {
        this.engine.startup();
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public void service(HttpServletRequest httpReq, HttpServletResponse httpResp) throws ServletException, IOException {
        EngineServletLocal.set(httpReq, httpResp);
        try {
            String lower;
            String query;
            String method = httpReq.getMethod();
            String urlstr = httpReq.getRequestURL().toString();
            if (!urlstr.endsWith("/")) {
                urlstr = urlstr + "/";
            }
            if (!Utils.empty((Object[])new Object[]{query = httpReq.getQueryString()})) {
                urlstr = urlstr + "?" + query;
            }
            if ((lower = urlstr).equals("http://localhost") || lower.startsWith("http://localhost/") || lower.startsWith("http://localhost:") || lower.equals("https://localhost") || lower.startsWith("https://localhost/") || lower.startsWith("https://localhost:")) {
                urlstr = Pattern.compile("localhost", 2).matcher(urlstr).replaceFirst("127.0.0.1");
                httpResp.sendRedirect(urlstr);
                return;
            }
            ArrayListValuedHashMap headers = new ArrayListValuedHashMap();
            Enumeration headerEnum = httpReq.getHeaderNames();
            while (headerEnum.hasMoreElements()) {
                String key = (String)headerEnum.nextElement();
                Enumeration values = httpReq.getHeaders(key);
                while (values.hasMoreElements()) {
                    String val = (String)values.nextElement();
                    headers.put((Object)key, (Object)val);
                }
            }
            HashMap<String, String> params = new HashMap<String, String>();
            Enumeration paramsEnumer = httpReq.getParameterNames();
            while (paramsEnumer.hasMoreElements()) {
                String key = (String)paramsEnumer.nextElement();
                Object[] values = httpReq.getParameterValues(key);
                String value = values == null ? null : (values.length == 1 ? values[0] : Utils.implode((String)",", (Object[])values));
                params.put(key, value);
            }
            String body = EngineServlet.readBody(httpReq);
            if (body != null && body.startsWith("--") && body.indexOf("Content-Disposition") > 0) {
                throw ApiException.new400BadRequest("Received invalid multipart content.", new Object[0]);
            }
            Request req = new Request(method, urlstr, body, params, (ArrayListValuedHashMap<String, String>)headers);
            req.withRemoteAddr(httpReq.getRemoteAddr());
            req.withUploader(() -> {
                try {
                    ArrayList<Upload> uploads = new ArrayList<Upload>();
                    for (Part part : httpReq.getParts()) {
                        String partName = part.getName();
                        String fileName = part.getSubmittedFileName();
                        InputStream inputStream = part.getInputStream();
                        long fileSize = part.getSize();
                        String fileType = part.getContentType();
                        if (fileName == null || inputStream == null) continue;
                        uploads.add(new Upload(partName, fileName, fileSize, fileType, inputStream));
                    }
                    return uploads;
                }
                catch (Exception ex) {
                    Utils.rethrow((Throwable)ex);
                    return null;
                }
            });
            Response res = new Response();
            this.engine.service(req, res);
            this.writeResponse(req, res, httpResp);
        }
        catch (Throwable ex) {
            JSNode json = Engine.buildErrorJson(ex);
            ServletOutputStream out = httpResp.getOutputStream();
            byte[] bytes = json.toString().getBytes(StandardCharsets.UTF_8);
            out.write(bytes);
            out.flush();
            out.close();
        }
    }

    void writeResponse(Request req, Response res, HttpServletResponse http) throws Exception {
        http.setStatus(res.getStatusCode());
        ServletOutputStream out = http.getOutputStream();
        ArrayListValuedHashMap<String, String> headers = res.getHeaders();
        headers.keySet().forEach(key -> http.setHeader(key, Utils.implode((String)",", (Object[])new Object[]{res.getHeaders().get(key)})));
        if (!req.isMethod("OPTIONS")) {
            String contentType = res.getContentType();
            http.setContentType(contentType);
            StreamBuffer buffer = res.getBody();
            if (buffer != null) {
                http.setContentLength(buffer.getLength());
                Utils.pipe((InputStream)buffer.getInputStream(), (OutputStream)out, (boolean)true, (boolean)false);
            }
        }
        out.flush();
        out.close();
    }

    static class EngineServletLocal {
        static final ThreadLocal<HttpServletRequest> request = new ThreadLocal();
        static final ThreadLocal<HttpServletResponse> response = new ThreadLocal();

        EngineServletLocal() {
        }

        public static void set(HttpServletRequest req, HttpServletResponse res) {
            request.set(req);
            response.set(res);
        }

        public static HttpServletRequest getRequest() {
            return request.get();
        }

        public static void setRequest(HttpServletRequest req) {
            request.set(req);
        }

        public static HttpServletResponse getResponse() {
            return response.get();
        }

        public static void setResponse(HttpServletResponse res) {
            response.set(res);
        }
    }
}

