/*
 * Decompiled with CFR 0.152.
 */
package io.inversion;

import io.inversion.Status;
import io.inversion.utils.Utils;

public class ApiException
extends RuntimeException
implements Status {
    protected String status = "500 Internal Server Error";

    public ApiException() throws ApiException {
        this((Throwable)null, "500 Internal Server Error", null, new Object[0]);
    }

    public ApiException(Throwable cause) throws ApiException {
        this(cause, "500 Internal Server Error", null, new Object[0]);
    }

    public ApiException(String messageFormat, Object ... args) throws ApiException {
        this((Throwable)null, "500 Internal Server Error", messageFormat, args);
    }

    public ApiException(Throwable cause, String httpStatus, String messageFormat, Object ... args) throws ApiException {
        super(ApiException.getMessage(cause, httpStatus, messageFormat, args), cause != null ? Utils.getCause((Throwable)cause) : null);
        if (httpStatus == null && messageFormat != null && messageFormat.matches("\\d\\d\\d .*")) {
            httpStatus = messageFormat;
        }
        if (httpStatus == null) {
            httpStatus = "500 Internal Server Error";
        }
        if (!httpStatus.matches("\\d\\d\\d .*")) {
            httpStatus = "500 Internal Server Error - " + httpStatus;
        }
        this.withStatus(httpStatus);
    }

    public String getStatus() {
        return this.status;
    }

    public ApiException withStatus(String status) {
        this.status = status;
        return this;
    }

    public boolean hasStatus(int ... statusCodes) {
        for (int statusCode : statusCodes) {
            if (!this.status.startsWith(statusCode + " ")) continue;
            return true;
        }
        return false;
    }

    public int getStatusCode() {
        return Integer.parseInt(this.status.substring(0, 3));
    }

    public static String getMessage(Throwable cause, String httpStatus, String messageFormat, Object ... args) {
        if (httpStatus == null && messageFormat != null && messageFormat.matches("\\d\\d\\d .*")) {
            httpStatus = messageFormat;
        }
        if (httpStatus == null) {
            httpStatus = "500 Internal Server Error";
        }
        if (!httpStatus.matches("\\d\\d\\d .*")) {
            httpStatus = "500 Internal Server Error - " + httpStatus;
        }
        String msg = httpStatus;
        if (messageFormat != null || args != null && args.length > 0) {
            msg = msg + " - " + Utils.format((String)messageFormat, (Object[])args);
        }
        if (cause != null) {
            String causeStr = Utils.getShortCause((Throwable)cause);
            msg = msg.length() > 0 ? msg + "\r\n" + causeStr : causeStr;
        }
        return msg;
    }

    public static void throwEx(Throwable cause) throws ApiException {
        throw new ApiException(cause);
    }

    public static void throwEx(String messageFormat, Object ... args) throws ApiException {
        ApiException.throwEx(null, "500 Internal Server Error", messageFormat, args);
    }

    public static void throwEx(Throwable cause, String status, String messageFormat, Object ... args) throws ApiException {
        throw new ApiException(cause, status, messageFormat, args);
    }

    public static ApiException new400BadRequest() throws ApiException {
        return new ApiException((Throwable)null, "400 Bad Request", null, new Object[0]);
    }

    public static ApiException new400BadRequest(Throwable cause) throws ApiException {
        return new ApiException(cause, "400 Bad Request", null, new Object[0]);
    }

    public static ApiException new400BadRequest(String messageFormat, Object ... args) throws ApiException {
        return new ApiException(null, "400 Bad Request", messageFormat, args);
    }

    public static ApiException new400BadRequest(Throwable cause, String messageFormat, Object ... args) throws ApiException {
        return new ApiException(cause, "400 Bad Request", messageFormat, args);
    }

    public static ApiException new401Unauthroized() throws ApiException {
        return new ApiException((Throwable)null, "401 Unauthorized", null, new Object[0]);
    }

    public static ApiException new401Unauthroized(Throwable cause) throws ApiException {
        return new ApiException(cause, "401 Unauthorized", null, new Object[0]);
    }

    public static ApiException new401Unauthroized(String messageFormat, Object ... args) throws ApiException {
        return new ApiException(null, "401 Unauthorized", messageFormat, args);
    }

    public static ApiException new401Unauthroized(Throwable cause, String messageFormat, Object ... args) throws ApiException {
        return new ApiException(cause, "401 Unauthorized", messageFormat, args);
    }

    public static ApiException new403Forbidden() throws ApiException {
        return new ApiException((Throwable)null, "403 Forbidden", null, new Object[0]);
    }

    public static ApiException new403Forbidden(Throwable cause) throws ApiException {
        return new ApiException(cause, "403 Forbidden", null, new Object[0]);
    }

    public static ApiException new403Forbidden(String messageFormat, Object ... args) throws ApiException {
        return new ApiException(null, "403 Forbidden", messageFormat, args);
    }

    public static ApiException new403Forbidden(Throwable cause, String messageFormat, Object ... args) throws ApiException {
        return new ApiException(cause, "403 Forbidden", messageFormat, args);
    }

    public static ApiException new404NotFound() throws ApiException {
        return new ApiException((Throwable)null, "404 Not Found", null, new Object[0]);
    }

    public static ApiException new404NotFound(Throwable cause) throws ApiException {
        return new ApiException(cause, "404 Not Found", null, new Object[0]);
    }

    public static ApiException new404NotFound(String messageFormat, Object ... args) throws ApiException {
        return new ApiException(null, "404 Not Found", messageFormat, args);
    }

    public static ApiException new404NotFound(Throwable cause, String messageFormat, Object ... args) throws ApiException {
        return new ApiException(cause, "404 Not Found", messageFormat, args);
    }

    public static ApiException new429TooManyRequests() throws ApiException {
        return new ApiException((Throwable)null, "429 Too Many Requests", null, new Object[0]);
    }

    public static ApiException new429TooManyRequests(Throwable cause) throws ApiException {
        return new ApiException(cause, "429 Too Many Requests", null, new Object[0]);
    }

    public static ApiException new429TooManyRequests(String messageFormat, Object ... args) throws ApiException {
        return new ApiException(null, "429 Too Many Requests", messageFormat, args);
    }

    public static ApiException new429TooManyRequests(Throwable cause, String messageFormat, Object ... args) throws ApiException {
        return new ApiException(cause, "429 Too Many Requests", messageFormat, args);
    }

    public static ApiException new500InternalServerError() throws ApiException {
        return new ApiException((Throwable)null, "500 Internal Server Error", null, new Object[0]);
    }

    public static ApiException new500InternalServerError(Throwable cause) throws ApiException {
        return new ApiException(cause, "500 Internal Server Error", null, new Object[0]);
    }

    public static ApiException new500InternalServerError(String messageFormat, Object ... args) throws ApiException {
        return new ApiException(null, "500 Internal Server Error", messageFormat, args);
    }

    public static ApiException new500InternalServerError(Throwable cause, String messageFormat, Object ... args) throws ApiException {
        return new ApiException(cause, "500 Internal Server Error", messageFormat, args);
    }

    public static ApiException new501NotImplemented() throws ApiException {
        return new ApiException((Throwable)null, "501 Not Implemented", null, new Object[0]);
    }

    public static ApiException new501NotImplemented(Throwable cause) throws ApiException {
        return new ApiException(cause, "501 Not Implemented", null, new Object[0]);
    }

    public static ApiException new501NotImplemented(String messageFormat, Object ... args) throws ApiException {
        return new ApiException(null, "501 Not Implemented", messageFormat, args);
    }

    public static ApiException new501NotImplemented(Throwable cause, String messageFormat, Object ... args) throws ApiException {
        return new ApiException(cause, "501 Not Implemented", messageFormat, args);
    }
}

